/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.TimestampModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.CachingDateFormatter;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import com.squareup.javapoet.MethodSpec;

public class TimestampModelHandler
extends ModelHandlerBase {
    boolean inError = false;
    static final String TIMESTAMP_METHOD_NAME = "timestamp";

    public TimestampModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new TimestampModelHandler(context);
    }

    protected Class<TimestampModel> getSupportedModelClass() {
        return TimestampModel.class;
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        String datePatternStr;
        TimestampModel timestampModel = (TimestampModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        String keyStr = timestampModel.getKey();
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)keyStr)) {
            this.addError("Attribute named [key] cannot be empty");
            this.inError = true;
        }
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)(datePatternStr = timestampModel.getDatePattern()))) {
            this.addError("Attribute named [datePattern] cannot be empty");
            this.inError = true;
        }
        if (this.inError) {
            this.addError("Skipping method generation for timestamp. Line " + model.getLineNumber());
            return;
        }
        this.addJavaStatement(tmic, timestampModel);
    }

    void addJavaStatement(TylerModelInterpretationContext tmic, TimestampModel timestampModel) {
        String scopeStr = timestampModel.getScopeStr();
        if (scopeStr == null) {
            scopeStr = "";
        }
        String keyStr = timestampModel.getKey();
        String scopeVarName = "scope";
        String datePatternStr = timestampModel.getDatePattern();
        String cdfVarName = "cdf";
        String timevalVarName = "timeValue";
        String timeReferenceVarName = "timeReference";
        String timeReferenceStr = timestampModel.getTimeReference();
        MethodSpec.Builder timestampMethodSpecBuilder = MethodSpec.methodBuilder((String)this.toMethodName(keyStr)).returns(Void.TYPE).addStatement("$T $N = $T.stringToScope($S)", new Object[]{ActionUtil.Scope.class, "scope", ActionUtil.class, scopeStr}).addStatement("$1T $2N = new $1T($3S)", new Object[]{CachingDateFormatter.class, "cdf", datePatternStr});
        if ("contextBirth".equalsIgnoreCase(timeReferenceStr)) {
            timestampMethodSpecBuilder.addStatement("addInfo(\"Using context birth as time reference.\"", new Object[0]);
            timestampMethodSpecBuilder.addStatement("long $N = $N.getBirthTime()", new Object[]{timeReferenceVarName, tmic.getContextFieldSpec()});
        } else {
            timestampMethodSpecBuilder.addStatement("long $N = System.currentTimeMillis()", new Object[]{timeReferenceVarName});
            timestampMethodSpecBuilder.addStatement("addInfo(\"Using current interpretation time, i.e. now, as time reference.\")", new Object[0]);
        }
        timestampMethodSpecBuilder.addStatement("String $N = $N.format($N)", new Object[]{"timeValue", "cdf", timeReferenceVarName});
        timestampMethodSpecBuilder.addStatement("addInfo(\"Adding property to the context with key='\"+$S+\"' and value=\"+$N+\" to the \"+$N+\" scope\")", new Object[]{keyStr, "timeValue", "scope"});
        timestampMethodSpecBuilder.addStatement("$T.setProperty(this, $S, $N, $N)", new Object[]{ActionUtil.class, keyStr, "timeValue", "scope"});
        MethodSpec timestampMethodSpec = timestampMethodSpecBuilder.build();
        tmic.tylerConfiguratorTSB.addMethod(timestampMethodSpec);
        tmic.configureMethodSpecBuilder.addStatement("$N()", new Object[]{timestampMethodSpec});
    }

    String toMethodName(String k) {
        return "timestamp_" + k;
    }
}

