/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.StatusListenerModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandlerData;
import ch.qos.logback.tyler.base.util.ClassUtil;
import ch.qos.logback.tyler.base.util.VariableNameUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;

public class StatusListenerModelHandler
extends ModelHandlerBase {
    static final String EFFECTIVELY_ADDED_VARIABLE_NAME = "effectivelyAdded";
    boolean inError = false;
    ImplicitModelHandlerData implicitModelHandlerData;

    public StatusListenerModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new StatusListenerModelHandler(context);
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        StatusListenerModel slModel = (StatusListenerModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        String statusListenerClassName = slModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)statusListenerClassName)) {
            this.addError("Empty class name for StatusListener");
            this.inError = true;
            return;
        }
        statusListenerClassName = mic.getImport(statusListenerClassName);
        MethodSpec.Builder methodSpec = this.addJavaStatement(tmic, statusListenerClassName);
        this.implicitModelHandlerData = ImplicitModelHandlerData.makeInstance((ContextAware)this, methodSpec, statusListenerClassName);
        if (this.implicitModelHandlerData != null) {
            mic.pushObject((Object)this.implicitModelHandlerData);
        } else {
            this.addError("Could not make implicitModelHandlerData for [" + statusListenerClassName + "]");
            model.markAsSkipped();
            this.inError = true;
        }
    }

    MethodSpec.Builder addJavaStatement(TylerModelInterpretationContext tmic, String statusListenerFQCN) {
        String simpleName = ClassUtil.extractSimpleClassName(statusListenerFQCN);
        ClassName desiredStatusListenerCN = ClassName.get((String)ClassUtil.extractPackageName(statusListenerFQCN), (String)simpleName, (String[])new String[0]);
        String variableName = VariableNameUtil.fullyQualifiedClassNameToVariableName(statusListenerFQCN);
        MethodSpec.Builder statusListenerSetupMethodSpec = MethodSpec.methodBuilder((String)("setup" + simpleName)).returns(Void.TYPE).addStatement("$1T $2N = new $1T()", new Object[]{desiredStatusListenerCN, variableName}).addStatement("$N.setContext($N)", new Object[]{variableName, tmic.getContextFieldSpec()}).addStatement("boolean $N = $N.getStatusManager().add($N)", new Object[]{EFFECTIVELY_ADDED_VARIABLE_NAME, tmic.getContextFieldSpec(), variableName});
        return statusListenerSetupMethodSpec;
    }

    public void postHandle(ModelInterpretationContext mic, Model model) {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.implicitModelHandlerData) {
            this.addWarn("The object at the of the stack is not the Implcit pushed earlier.");
        } else {
            TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
            tmic.popObject();
            MethodSpec.Builder statusListenerMethodBuilder = this.implicitModelHandlerData.methodSpecBuilder;
            String variableName = this.implicitModelHandlerData.getVariableName();
            statusListenerMethodBuilder.addCode("\n", new Object[0]);
            statusListenerMethodBuilder.beginControlFlow("if($N && ($N instanceof $T))", new Object[]{EFFECTIVELY_ADDED_VARIABLE_NAME, variableName, LifeCycle.class});
            statusListenerMethodBuilder.addStatement("(($T)$N).start()", new Object[]{LifeCycle.class, variableName});
            statusListenerMethodBuilder.endControlFlow();
            MethodSpec statusListenerMethodSpec = statusListenerMethodBuilder.build();
            tmic.tylerConfiguratorTSB.addMethod(statusListenerMethodSpec);
            tmic.configureMethodSpecBuilder.addStatement("$N()", new Object[]{statusListenerMethodSpec});
        }
    }
}

