/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.tyler.base.handler;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.hook.DefaultShutdownHook;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ShutdownHookModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StringUtil;
import ch.qos.logback.tyler.base.TylerModelInterpretationContext;
import ch.qos.logback.tyler.base.handler.ImplicitModelHandlerData;
import ch.qos.logback.tyler.base.util.ClassUtil;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;

public class ShutdownHookModelHandler
extends ModelHandlerBase {
    static final String DEFAULT_SHUTDOWN_HOOK_CLASSNAME = DefaultShutdownHook.class.getName();
    static final String OLD_SHUTDOWN_HOOK_CLASSNAME = "ch.qos.logback.core.hook.DelayingShutdownHook";
    public static final String RENAME_WARNING = "ch.qos.logback.core.hook.DelayingShutdownHook was renamed as " + DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
    ImplicitModelHandlerData implicitModelHandlerData;
    boolean inError = false;

    public ShutdownHookModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new ShutdownHookModelHandler(context);
    }

    protected Class<ShutdownHookModel> getSupportedModelClass() {
        return ShutdownHookModel.class;
    }

    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        ShutdownHookModel shutdownHookModel = (ShutdownHookModel)model;
        TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
        String className = shutdownHookModel.getClassName();
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)className)) {
            className = DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
            this.addInfo("Assuming className [" + className + "]");
        } else if ((className = mic.getImport(className)).equals(OLD_SHUTDOWN_HOOK_CLASSNAME)) {
            className = DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
            this.addWarn(RENAME_WARNING);
            this.addWarn("Please use the new class name");
        }
        this.addInfo("About to instantiate shutdown hook of type [" + className + "]");
        MethodSpec.Builder methodSpec = this.addJavaStatement(tmic, className);
        this.implicitModelHandlerData = ImplicitModelHandlerData.makeInstance((ContextAware)this, methodSpec, className);
        if (this.implicitModelHandlerData != null) {
            mic.pushObject((Object)this.implicitModelHandlerData);
        } else {
            this.addError("Could not make implicitModelHandlerData for [" + className + "]");
            model.markAsSkipped();
            this.inError = true;
        }
    }

    MethodSpec.Builder addJavaStatement(TylerModelInterpretationContext tmic, String fqcnStr) {
        String simpleName = ClassUtil.extractSimpleClassName(fqcnStr);
        ClassName desiredCN = ClassName.get((String)ClassUtil.extractPackageName(fqcnStr), (String)simpleName, (String[])new String[0]);
        String variableName = StringUtil.lowercaseFirstLetter((String)simpleName);
        String hookTreadVariableName = "hookThread";
        FieldSpec contextFieldSpec = tmic.getContextFieldSpec();
        MethodSpec.Builder setupMethodSpec = MethodSpec.methodBuilder((String)("setup" + simpleName)).returns(Void.TYPE);
        setupMethodSpec.addStatement("$1T $2N = new $1T()", new Object[]{desiredCN, variableName});
        setupMethodSpec.addStatement("$N.setContext($N)", new Object[]{variableName, contextFieldSpec});
        setupMethodSpec.addCode("\n", new Object[0]);
        setupMethodSpec.addStatement("Thread $N = new Thread($N, \"Logback shutdown hook [\" + $N.getName() + \"]\")", new Object[]{"hookThread", variableName, contextFieldSpec});
        setupMethodSpec.addStatement("addInfo(\"Registering shutdown hook with JVM runtime.\")", new Object[0]);
        setupMethodSpec.addStatement("$N.putObject($T.SHUTDOWN_HOOK_THREAD, $N)", new Object[]{contextFieldSpec, CoreConstants.class, "hookThread"});
        setupMethodSpec.addStatement("Runtime.getRuntime().addShutdownHook($N)", new Object[]{"hookThread"});
        return setupMethodSpec;
    }

    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        if (this.inError) {
            return;
        }
        Object o = mic.peekObject();
        if (o != this.implicitModelHandlerData) {
            this.addWarn("The object at the of the stack is not the ImplicitModelHandlerData pushed earlier.");
        } else {
            TylerModelInterpretationContext tmic = (TylerModelInterpretationContext)mic;
            tmic.popObject();
            MethodSpec.Builder mMethodBuilder = this.implicitModelHandlerData.methodSpecBuilder;
            MethodSpec methodSpec = mMethodBuilder.build();
            tmic.tylerConfiguratorTSB.addMethod(methodSpec);
            tmic.configureMethodSpecBuilder.addStatement("$N()", new Object[]{methodSpec});
        }
    }
}

