/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.transport;

import ch.ethz.ssh2.util.StringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ClientServerHello {
    String client_line;
    String server_line;

    private ClientServerHello(String client_line, String server_line) {
        this.client_line = client_line;
        this.server_line = server_line;
    }

    public static final int readLineRN(InputStream is, byte[] buffer) throws IOException {
        int len;
        block4: {
            int pos = 0;
            boolean need10 = false;
            len = 0;
            while (true) {
                int c;
                if ((c = is.read()) == -1) {
                    throw new IOException("Premature connection close");
                }
                buffer[pos++] = (byte)c;
                if (c == 13) {
                    need10 = true;
                    continue;
                }
                if (c == 10) break block4;
                if (need10) {
                    throw new IOException("Malformed line received, the line does not end correctly.");
                }
                ++len;
                if (pos >= buffer.length) break;
            }
            throw new IOException("The other party sent a too long line.");
        }
        return len;
    }

    public static ClientServerHello clientHello(String softwareversion, InputStream bi, OutputStream bo) throws IOException {
        return ClientServerHello.exchange(softwareversion, bi, bo, true);
    }

    public static ClientServerHello serverHello(String softwareversion, InputStream bi, OutputStream bo) throws IOException {
        return ClientServerHello.exchange(softwareversion, bi, bo, false);
    }

    private static ClientServerHello exchange(String softwareversion, InputStream bi, OutputStream bo, boolean clientMode) throws IOException {
        int len;
        String localIdentifier = "SSH-2.0-" + softwareversion;
        String remoteIdentifier = null;
        bo.write(StringEncoder.GetBytes(localIdentifier + "\r\n"));
        bo.flush();
        byte[] remoteData = new byte[1024];
        for (int i = 0; i < 50 && !(remoteIdentifier = StringEncoder.GetString(remoteData, 0, len = ClientServerHello.readLineRN(bi, remoteData))).startsWith("SSH-"); ++i) {
        }
        if (!remoteIdentifier.startsWith("SSH-")) {
            throw new IOException("Malformed SSH identification string. There was no line starting with 'SSH-' amongst the first 50 lines.");
        }
        if (!remoteIdentifier.startsWith("SSH-1.99-") && !remoteIdentifier.startsWith("SSH-2.0-")) {
            throw new IOException("Remote party uses incompatible protocol, it is not SSH-2 compatible.");
        }
        if (clientMode) {
            return new ClientServerHello(localIdentifier, remoteIdentifier);
        }
        return new ClientServerHello(remoteIdentifier, localIdentifier);
    }

    public byte[] getClientString() {
        return StringEncoder.GetBytes(this.client_line);
    }

    public byte[] getServerString() {
        return StringEncoder.GetBytes(this.server_line);
    }
}

