/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.PtySettings;
import ch.ethz.ssh2.ServerConnectionCallback;
import ch.ethz.ssh2.ServerSessionCallback;
import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelClosedException;
import ch.ethz.ssh2.channel.IChannelWorkerThread;
import ch.ethz.ssh2.channel.RemoteAcceptThread;
import ch.ethz.ssh2.channel.RemoteForwardingData;
import ch.ethz.ssh2.channel.RemoteX11AcceptThread;
import ch.ethz.ssh2.channel.ServerSessionImpl;
import ch.ethz.ssh2.channel.X11ServerData;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.packets.PacketChannelFailure;
import ch.ethz.ssh2.packets.PacketChannelOpenConfirmation;
import ch.ethz.ssh2.packets.PacketChannelOpenFailure;
import ch.ethz.ssh2.packets.PacketChannelSuccess;
import ch.ethz.ssh2.packets.PacketGlobalCancelForwardRequest;
import ch.ethz.ssh2.packets.PacketGlobalForwardRequest;
import ch.ethz.ssh2.packets.PacketOpenDirectTCPIPChannel;
import ch.ethz.ssh2.packets.PacketOpenSessionChannel;
import ch.ethz.ssh2.packets.PacketSessionExecCommand;
import ch.ethz.ssh2.packets.PacketSessionPtyRequest;
import ch.ethz.ssh2.packets.PacketSessionStartShell;
import ch.ethz.ssh2.packets.PacketSessionSubsystemRequest;
import ch.ethz.ssh2.packets.PacketSessionX11Request;
import ch.ethz.ssh2.packets.TypesReader;
import ch.ethz.ssh2.server.ServerConnectionState;
import ch.ethz.ssh2.transport.MessageHandler;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ChannelManager
implements MessageHandler {
    private static final Logger log = Logger.getLogger(ChannelManager.class);
    private final ServerConnectionState server_state;
    private final TransportManager tm;
    private final HashMap<String, X11ServerData> x11_magic_cookies = new HashMap();
    private final List<Channel> channels = new Vector<Channel>();
    private int nextLocalChannel = 100;
    private boolean shutdown = false;
    private int globalSuccessCounter = 0;
    private int globalFailedCounter = 0;
    private final HashMap<Integer, RemoteForwardingData> remoteForwardings = new HashMap();
    private final List<IChannelWorkerThread> listenerThreads = new Vector<IChannelWorkerThread>();
    private boolean listenerThreadsAllowed = true;

    public ChannelManager(TransportManager tm) {
        this.server_state = null;
        this.tm = tm;
        tm.registerMessageHandler(this, 80, 100);
    }

    public ChannelManager(ServerConnectionState state) {
        this.server_state = state;
        this.tm = state.tm;
        this.tm.registerMessageHandler(this, 80, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(int id) {
        List<Channel> list = this.channels;
        synchronized (list) {
            for (Channel c : this.channels) {
                if (c.localID != id) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(int id) {
        List<Channel> list = this.channels;
        synchronized (list) {
            for (Channel c : this.channels) {
                if (c.localID != id) continue;
                this.channels.remove(c);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addChannel(Channel c) {
        List<Channel> list = this.channels;
        synchronized (list) {
            this.channels.add(c);
            return this.nextLocalChannel++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilChannelOpen(Channel c) throws IOException {
        boolean wasInterrupted = false;
        Channel channel = c;
        synchronized (channel) {
            while (c.state == 1) {
                try {
                    c.wait();
                }
                catch (InterruptedException ignore) {
                    wasInterrupted = true;
                }
            }
            if (c.state != 2) {
                this.removeChannel(c.localID);
                String detail = c.getReasonClosed();
                if (detail == null) {
                    detail = "state: " + c.state;
                }
                throw new IOException("Could not open channel (" + detail + ")");
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForGlobalSuccessOrFailure() throws IOException {
        boolean wasInterrupted = false;
        try {
            List<Channel> list = this.channels;
            synchronized (list) {
                while (this.globalSuccessCounter == 0 && this.globalFailedCounter == 0) {
                    if (this.shutdown) {
                        throw new IOException("The connection is being shutdown");
                    }
                    try {
                        this.channels.wait();
                    }
                    catch (InterruptedException ignore) {
                        wasInterrupted = true;
                    }
                }
                if (this.globalFailedCounter != 0) {
                    throw new IOException("The server denied the request (did you enable port forwarding?)");
                }
                if (this.globalSuccessCounter == 0) {
                    throw new IOException("Illegal state.");
                }
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForChannelSuccessOrFailure(Channel c) throws IOException {
        boolean wasInterrupted = false;
        try {
            Channel channel = c;
            synchronized (channel) {
                while (c.successCounter == 0 && c.failedCounter == 0) {
                    if (c.state != 2) {
                        String detail = c.getReasonClosed();
                        if (detail == null) {
                            detail = "state: " + c.state;
                        }
                        throw new IOException("This SSH2 channel is not open (" + detail + ")");
                    }
                    try {
                        c.wait();
                    }
                    catch (InterruptedException ignore) {
                        wasInterrupted = true;
                    }
                }
                if (c.failedCounter != 0) {
                    throw new IOException("The server denied the request.");
                }
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerX11Cookie(String hexFakeCookie, X11ServerData data) {
        HashMap<String, X11ServerData> hashMap = this.x11_magic_cookies;
        synchronized (hashMap) {
            this.x11_magic_cookies.put(hexFakeCookie, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterX11Cookie(String hexFakeCookie, boolean killChannels) {
        if (hexFakeCookie == null) {
            throw new IllegalStateException("hexFakeCookie may not be null");
        }
        HashMap<String, X11ServerData> hashMap = this.x11_magic_cookies;
        synchronized (hashMap) {
            this.x11_magic_cookies.remove(hexFakeCookie);
        }
        if (!killChannels) {
            return;
        }
        log.debug("Closing all X11 channels for the given fake cookie");
        Vector<Channel> channel_copy = new Vector<Channel>();
        List<Channel> list = this.channels;
        synchronized (list) {
            channel_copy.addAll(this.channels);
        }
        Iterator i$ = channel_copy.iterator();
        while (i$.hasNext()) {
            Channel c;
            Channel channel = c = (Channel)i$.next();
            synchronized (channel) {
                if (!hexFakeCookie.equals(c.hexX11FakeCookie)) {
                    continue;
                }
            }
            try {
                this.closeChannel(c, "Closing X11 channel since the corresponding session is closing", true);
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X11ServerData checkX11Cookie(String hexFakeCookie) {
        HashMap<String, X11ServerData> hashMap = this.x11_magic_cookies;
        synchronized (hashMap) {
            if (hexFakeCookie != null) {
                return this.x11_magic_cookies.get(hexFakeCookie);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllChannels() {
        log.debug("Closing all channels");
        Vector<Channel> channel_copy = new Vector<Channel>();
        List<Channel> list = this.channels;
        synchronized (list) {
            channel_copy.addAll(this.channels);
        }
        for (Channel c : channel_copy) {
            try {
                this.closeChannel(c, "Closing all channels", true);
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel c, String reason, boolean force) throws IOException {
        byte[] msg = new byte[5];
        Object object = c;
        synchronized (object) {
            if (force) {
                c.state = 4;
                c.EOF = true;
            }
            c.setReasonClosed(reason);
            msg[0] = 97;
            msg[1] = (byte)(c.remoteID >> 24);
            msg[2] = (byte)(c.remoteID >> 16);
            msg[3] = (byte)(c.remoteID >> 8);
            msg[4] = (byte)c.remoteID;
            c.notifyAll();
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(msg);
            c.closeMessageSent = true;
        }
        log.debug("Sent SSH_MSG_CHANNEL_CLOSE (channel " + c.localID + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEOF(Channel c) throws IOException {
        byte[] msg = new byte[5];
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                return;
            }
            msg[0] = 96;
            msg[1] = (byte)(c.remoteID >> 24);
            msg[2] = (byte)(c.remoteID >> 16);
            msg[3] = (byte)(c.remoteID >> 8);
            msg[4] = (byte)c.remoteID;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(msg);
        }
        log.debug("Sent EOF (Channel " + c.localID + "/" + c.remoteID + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOpenConfirmation(Channel c) throws IOException {
        PacketChannelOpenConfirmation pcoc = null;
        Object object = c;
        synchronized (object) {
            if (c.state != 1) {
                return;
            }
            c.state = 2;
            pcoc = new PacketChannelOpenConfirmation(c.remoteID, c.localID, c.localWindow, c.localMaxPacketSize);
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(pcoc.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(Channel c, byte[] buffer, int pos, int len) throws IOException {
        boolean wasInterrupted = false;
        try {
            while (len > 0) {
                byte[] msg;
                int thislen = 0;
                Object object = c;
                synchronized (object) {
                    while (true) {
                        if (c.state == 4) {
                            throw new ChannelClosedException("SSH channel is closed. (" + c.getReasonClosed() + ")");
                        }
                        if (c.state != 2) {
                            throw new ChannelClosedException("SSH channel in strange state. (" + c.state + ")");
                        }
                        if (c.remoteWindow != 0L) break;
                        try {
                            c.wait();
                        }
                        catch (InterruptedException ignore) {
                            wasInterrupted = true;
                        }
                    }
                    thislen = c.remoteWindow >= (long)len ? len : (int)c.remoteWindow;
                    int estimatedMaxDataLen = c.remoteMaxPacketSize - (this.tm.getPacketOverheadEstimate() + 9);
                    if (estimatedMaxDataLen <= 0) {
                        estimatedMaxDataLen = 1;
                    }
                    if (thislen > estimatedMaxDataLen) {
                        thislen = estimatedMaxDataLen;
                    }
                    c.remoteWindow -= (long)thislen;
                    msg = new byte[9 + thislen];
                    msg[0] = 94;
                    msg[1] = (byte)(c.remoteID >> 24);
                    msg[2] = (byte)(c.remoteID >> 16);
                    msg[3] = (byte)(c.remoteID >> 8);
                    msg[4] = (byte)c.remoteID;
                    msg[5] = (byte)(thislen >> 24);
                    msg[6] = (byte)(thislen >> 16);
                    msg[7] = (byte)(thislen >> 8);
                    msg[8] = (byte)thislen;
                    System.arraycopy(buffer, pos, msg, 9, thislen);
                }
                object = c.channelSendLock;
                synchronized (object) {
                    if (c.closeMessageSent) {
                        throw new ChannelClosedException("SSH channel is closed. (" + c.getReasonClosed() + ")");
                    }
                    this.tm.sendMessage(msg);
                }
                pos += thislen;
                len -= thislen;
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestGlobalForward(String bindAddress, int bindPort, String targetAddress, int targetPort) throws IOException {
        RemoteForwardingData rfd = new RemoteForwardingData();
        rfd.bindAddress = bindAddress;
        rfd.bindPort = bindPort;
        rfd.targetAddress = targetAddress;
        rfd.targetPort = targetPort;
        Object object = this.remoteForwardings;
        synchronized (object) {
            Integer key = new Integer(bindPort);
            if (this.remoteForwardings.get(key) != null) {
                throw new IOException("There is already a forwarding for remote port " + bindPort);
            }
            this.remoteForwardings.put(key, rfd);
        }
        object = this.channels;
        synchronized (object) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        PacketGlobalForwardRequest pgf = new PacketGlobalForwardRequest(true, bindAddress, bindPort);
        this.tm.sendMessage(pgf.getPayload());
        log.debug("Requesting a remote forwarding ('" + bindAddress + "', " + bindPort + ")");
        try {
            this.waitForGlobalSuccessOrFailure();
        }
        catch (IOException e) {
            HashMap<Integer, RemoteForwardingData> hashMap = this.remoteForwardings;
            synchronized (hashMap) {
                this.remoteForwardings.remove(rfd);
            }
            throw e;
        }
        return bindPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancelGlobalForward(int bindPort) throws IOException {
        RemoteForwardingData rfd = null;
        Object object = this.remoteForwardings;
        synchronized (object) {
            rfd = this.remoteForwardings.get(new Integer(bindPort));
            if (rfd == null) {
                throw new IOException("Sorry, there is no known remote forwarding for remote port " + bindPort);
            }
        }
        object = this.channels;
        synchronized (object) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        PacketGlobalCancelForwardRequest pgcf = new PacketGlobalCancelForwardRequest(true, rfd.bindAddress, rfd.bindPort);
        this.tm.sendMessage(pgcf.getPayload());
        log.debug("Requesting cancelation of remote forward ('" + rfd.bindAddress + "', " + rfd.bindPort + ")");
        this.waitForGlobalSuccessOrFailure();
        HashMap<Integer, RemoteForwardingData> hashMap = this.remoteForwardings;
        synchronized (hashMap) {
            this.remoteForwardings.remove(rfd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(IChannelWorkerThread thr) throws IOException {
        List<IChannelWorkerThread> list = this.listenerThreads;
        synchronized (list) {
            if (!this.listenerThreadsAllowed) {
                throw new IOException("Too late, this connection is closed.");
            }
            this.listenerThreads.add(thr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel openDirectTCPIPChannel(String host_to_connect, int port_to_connect, String originator_IP_address, int originator_port) throws IOException {
        Channel c;
        Channel channel = c = new Channel(this);
        synchronized (channel) {
            c.localID = this.addChannel(c);
        }
        PacketOpenDirectTCPIPChannel dtc = new PacketOpenDirectTCPIPChannel(c.localID, c.localWindow, c.localMaxPacketSize, host_to_connect, port_to_connect, originator_IP_address, originator_port);
        this.tm.sendMessage(dtc.getPayload());
        this.waitUntilChannelOpen(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel openSessionChannel() throws IOException {
        Channel c;
        Channel channel = c = new Channel(this);
        synchronized (channel) {
            c.localID = this.addChannel(c);
        }
        log.debug("Sending SSH_MSG_CHANNEL_OPEN (Channel " + c.localID + ")");
        PacketOpenSessionChannel smo = new PacketOpenSessionChannel(c.localID, c.localWindow, c.localMaxPacketSize);
        this.tm.sendMessage(smo.getPayload());
        this.waitUntilChannelOpen(c);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPTY(Channel c, String term, int term_width_characters, int term_height_characters, int term_width_pixels, int term_height_pixels, byte[] terminal_modes) throws IOException {
        PacketSessionPtyRequest spr;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot request PTY on this channel (" + c.getReasonClosed() + ")");
            }
            spr = new PacketSessionPtyRequest(c.remoteID, true, term, term_width_characters, term_height_characters, term_width_pixels, term_height_pixels, terminal_modes);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot request PTY on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(spr.getPayload());
        }
        try {
            this.waitForChannelSuccessOrFailure(c);
        }
        catch (IOException e) {
            throw (IOException)new IOException("PTY request failed").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestX11(Channel c, boolean singleConnection, String x11AuthenticationProtocol, String x11AuthenticationCookie, int x11ScreenNumber) throws IOException {
        PacketSessionX11Request psr;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot request X11 on this channel (" + c.getReasonClosed() + ")");
            }
            psr = new PacketSessionX11Request(c.remoteID, true, singleConnection, x11AuthenticationProtocol, x11AuthenticationCookie, x11ScreenNumber);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot request X11 on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(psr.getPayload());
        }
        log.debug("Requesting X11 forwarding (Channel " + c.localID + "/" + c.remoteID + ")");
        try {
            this.waitForChannelSuccessOrFailure(c);
        }
        catch (IOException e) {
            throw (IOException)new IOException("The X11 request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSubSystem(Channel c, String subSystemName) throws IOException {
        PacketSessionSubsystemRequest ssr;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot request subsystem on this channel (" + c.getReasonClosed() + ")");
            }
            ssr = new PacketSessionSubsystemRequest(c.remoteID, true, subSystemName);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot request subsystem on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(ssr.getPayload());
        }
        try {
            this.waitForChannelSuccessOrFailure(c);
        }
        catch (IOException e) {
            throw (IOException)new IOException("The subsystem request failed.").initCause(e);
        }
    }

    public void requestExecCommand(Channel c, String cmd) throws IOException {
        this.requestExecCommand(c, cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestExecCommand(Channel c, String cmd, String charsetName) throws IOException {
        PacketSessionExecCommand sm;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot execute command on this channel (" + c.getReasonClosed() + ")");
            }
            sm = new PacketSessionExecCommand(c.remoteID, true, cmd);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot execute command on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(sm.getPayload(charsetName));
        }
        log.debug("Executing command (channel " + c.localID + ", '" + cmd + "')");
        try {
            this.waitForChannelSuccessOrFailure(c);
        }
        catch (IOException e) {
            throw (IOException)new IOException("The execute request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestShell(Channel c) throws IOException {
        PacketSessionStartShell sm;
        Object object = c;
        synchronized (object) {
            if (c.state != 2) {
                throw new IOException("Cannot start shell on this channel (" + c.getReasonClosed() + ")");
            }
            sm = new PacketSessionStartShell(c.remoteID, true);
            c.failedCounter = 0;
            c.successCounter = 0;
        }
        object = c.channelSendLock;
        synchronized (object) {
            if (c.closeMessageSent) {
                throw new IOException("Cannot start shell on this channel (" + c.getReasonClosed() + ")");
            }
            this.tm.sendMessage(sm.getPayload());
        }
        try {
            this.waitForChannelSuccessOrFailure(c);
        }
        catch (IOException e) {
            throw (IOException)new IOException("The shell request failed.").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelExtendedData(byte[] msg, int msglen) throws IOException {
        if (msglen <= 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int dataType = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        int len = (msg[9] & 0xFF) << 24 | (msg[10] & 0xFF) << 16 | (msg[11] & 0xFF) << 8 | msg[12] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EXTENDED_DATA message for non-existent channel " + id);
        }
        if (dataType != 1) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has unknown type (" + dataType + ")");
        }
        if (len != msglen - 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong len (calculated " + (msglen - 13) + ", got " + len + ")");
        }
        log.debug("Got SSH_MSG_CHANNEL_EXTENDED_DATA (channel " + id + ", " + len + ")");
        Channel channel = c;
        synchronized (channel) {
            if (c.state == 4) {
                return;
            }
            if (c.state != 2) {
                throw new IOException("Got SSH_MSG_CHANNEL_EXTENDED_DATA, but channel is not in correct state (" + c.state + ")");
            }
            if (c.localWindow < len) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            c.localWindow -= len;
            System.arraycopy(msg, 13, c.stderrBuffer, c.stderrWritepos, len);
            c.stderrWritepos += len;
            c.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int waitForCondition(Channel c, long timeout, int condition_mask) {
        int n;
        int current_cond;
        boolean end_time_set;
        long end_time;
        boolean wasInterrupted = false;
        try {
            end_time = 0L;
            end_time_set = false;
            Channel channel = c;
            // MONITORENTER : channel
            while (true) {
                current_cond = 0;
                int stdoutAvail = c.stdoutWritepos - c.stdoutReadpos;
                int stderrAvail = c.stderrWritepos - c.stderrReadpos;
                if (stdoutAvail > 0) {
                    current_cond |= 4;
                }
                if (stderrAvail > 0) {
                    current_cond |= 8;
                }
                if (c.EOF) {
                    current_cond |= 0x10;
                }
                if (c.getExitStatus() != null) {
                    current_cond |= 0x20;
                }
                if (c.getExitSignal() != null) {
                    current_cond |= 0x40;
                }
                if (c.state == 4) {
                    int n2 = current_cond | 2 | 0x10;
                    // MONITOREXIT : channel
                    if (!wasInterrupted) return n2;
                    Thread.currentThread().interrupt();
                    return n2;
                }
                if ((current_cond & condition_mask) == 0) break block22;
                n = current_cond;
                break;
            }
        }
        catch (Throwable throwable) {
            if (!wasInterrupted) throw throwable;
            Thread.currentThread().interrupt();
            throw throwable;
        }
        {
            block22: {
                // MONITOREXIT : channel
                if (!wasInterrupted) return n;
                Thread.currentThread().interrupt();
                return n;
            }
            if (timeout > 0L) {
                if (!end_time_set) {
                    end_time = System.currentTimeMillis() + timeout;
                    end_time_set = true;
                } else {
                    timeout = end_time - System.currentTimeMillis();
                    if (timeout <= 0L) {
                        int n3 = current_cond | 1;
                        // MONITOREXIT : channel
                        if (!wasInterrupted) return n3;
                        Thread.currentThread().interrupt();
                        return n3;
                    }
                }
            }
            try {
                if (timeout > 0L) {
                    c.wait(timeout);
                    continue;
                }
                c.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable(Channel c, boolean extended) throws IOException {
        Channel channel = c;
        synchronized (channel) {
            int avail = extended ? c.stderrWritepos - c.stderrReadpos : c.stdoutWritepos - c.stdoutReadpos;
            return avail > 0 ? avail : (c.EOF ? -1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getChannelData(Channel c, boolean extended, byte[] target, int off, int len) throws IOException {
        wasInterrupted = false;
        copylen = 0;
        increment = 0;
        remoteID = 0;
        localID = 0;
        var11_11 = c;
        synchronized (var11_11) {
            stdoutAvail = 0;
            stderrAvail = 0;
        }
        {
            while (true) {
                stdoutAvail = c.stdoutWritepos - c.stdoutReadpos;
                stderrAvail = c.stderrWritepos - c.stderrReadpos;
                if (!extended && stdoutAvail != 0 || extended && stderrAvail != 0) break;
                if (c.EOF || c.state != 2) {
                    var14_17 = -1;
                    // MONITOREXIT @DISABLED, blocks:[20, 7, 12] lbl20 : MonitorExitStatement: MONITOREXIT : var11_11
                    if (wasInterrupted == false) return var14_17;
                    Thread.currentThread().interrupt();
                    return var14_17;
                }
                try {
                    c.wait();
                }
                catch (InterruptedException ignore) {
                    wasInterrupted = true;
                }
            }
            if (!extended) {
                copylen = stdoutAvail > len ? len : stdoutAvail;
                System.arraycopy(c.stdoutBuffer, c.stdoutReadpos, target, off, copylen);
                c.stdoutReadpos += copylen;
                if (c.stdoutReadpos != c.stdoutWritepos) {
                    System.arraycopy(c.stdoutBuffer, c.stdoutReadpos, c.stdoutBuffer, 0, c.stdoutWritepos - c.stdoutReadpos);
                }
                c.stdoutWritepos -= c.stdoutReadpos;
                c.stdoutReadpos = 0;
            } else {
                copylen = stderrAvail > len ? len : stderrAvail;
                System.arraycopy(c.stderrBuffer, c.stderrReadpos, target, off, copylen);
                c.stderrReadpos += copylen;
                if (c.stderrReadpos != c.stderrWritepos) {
                    System.arraycopy(c.stderrBuffer, c.stderrReadpos, c.stderrBuffer, 0, c.stderrWritepos - c.stderrReadpos);
                }
                c.stderrWritepos -= c.stderrReadpos;
                c.stderrReadpos = 0;
            }
            if (c.state != 2) {
                ignore = copylen;
                // MONITOREXIT @DISABLED, blocks:[7, 15] lbl48 : MonitorExitStatement: MONITOREXIT : var11_11
                if (wasInterrupted == false) return ignore;
                Thread.currentThread().interrupt();
                return ignore;
            }
            ** try [egrp 4[TRYBLOCK] [9 : 352->598)] { 
lbl53:
            // 1 sources

            if (c.localWindow < 98304) {
                minFreeSpace = Math.min(196608 - c.stdoutWritepos, 196608 - c.stderrWritepos);
                increment = minFreeSpace - c.localWindow;
                c.localWindow = minFreeSpace;
            }
            remoteID = c.remoteID;
            localID = c.localID;
        }
        if (increment <= 0) return copylen;
        ChannelManager.log.debug("Sending SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + localID + ", " + increment + ")");
        var11_11 = c.channelSendLock;
        synchronized (var11_11) {
            msg = c.msgWindowAdjust;
            msg[0] = 93;
            msg[1] = (byte)(remoteID >> 24);
            msg[2] = (byte)(remoteID >> 16);
            msg[3] = (byte)(remoteID >> 8);
            msg[4] = (byte)remoteID;
            msg[5] = (byte)(increment >> 24);
            msg[6] = (byte)(increment >> 16);
            msg[7] = (byte)(increment >> 8);
            msg[8] = (byte)increment;
            if (c.closeMessageSent != false) return copylen;
            this.tm.sendMessage(msg);
            return copylen;
        }
lbl-1000:
        // 1 sources

        {
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelData(byte[] msg, int msglen) throws IOException {
        if (msglen <= 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int len = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_DATA message for non-existent channel " + id);
        }
        if (len != msglen - 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong len (calculated " + (msglen - 9) + ", got " + len + ")");
        }
        log.debug("Got SSH_MSG_CHANNEL_DATA (channel " + id + ", " + len + ")");
        Channel channel = c;
        synchronized (channel) {
            if (c.state == 4) {
                return;
            }
            if (c.state != 2) {
                throw new IOException("Got SSH_MSG_CHANNEL_DATA, but channel is not in correct state (" + c.state + ")");
            }
            if (c.localWindow < len) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            c.localWindow -= len;
            System.arraycopy(msg, 9, c.stdoutBuffer, c.stdoutWritepos, len);
            c.stdoutWritepos += len;
            c.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelWindowAdjust(byte[] msg, int msglen) throws IOException {
        if (msglen != 9) {
            throw new IOException("SSH_MSG_CHANNEL_WINDOW_ADJUST message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        int windowChange = (msg[5] & 0xFF) << 24 | (msg[6] & 0xFF) << 16 | (msg[7] & 0xFF) << 8 | msg[8] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_WINDOW_ADJUST message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            long huge = 0xFFFFFFFFL;
            c.remoteWindow += (long)windowChange & 0xFFFFFFFFL;
            if (c.remoteWindow > 0xFFFFFFFFL) {
                c.remoteWindow = 0xFFFFFFFFL;
            }
            c.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + id + ", " + windowChange + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpen(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        String channelType = tr.readString();
        int remoteID = tr.readUINT32();
        int remoteWindow = tr.readUINT32();
        int remoteMaxPacketSize = tr.readUINT32();
        if ("x11".equals(channelType)) {
            Channel c;
            HashMap<String, X11ServerData> hashMap = this.x11_magic_cookies;
            synchronized (hashMap) {
                if (this.x11_magic_cookies.size() == 0) {
                    PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 1, "X11 forwarding not activated", "");
                    this.tm.sendAsynchronousMessage(pcof.getPayload());
                    log.warning("Unexpected X11 request, denying it!");
                    return;
                }
            }
            String remoteOriginatorAddress = tr.readString();
            int remoteOriginatorPort = tr.readUINT32();
            Channel channel = c = new Channel(this);
            synchronized (channel) {
                c.remoteID = remoteID;
                c.remoteWindow = (long)remoteWindow & 0xFFFFFFFFL;
                c.remoteMaxPacketSize = remoteMaxPacketSize;
                c.localID = this.addChannel(c);
            }
            RemoteX11AcceptThread rxat = new RemoteX11AcceptThread(c, remoteOriginatorAddress, remoteOriginatorPort);
            rxat.setDaemon(true);
            rxat.start();
            return;
        }
        if ("forwarded-tcpip".equals(channelType)) {
            Channel c;
            String remoteConnectedAddress = tr.readString();
            int remoteConnectedPort = tr.readUINT32();
            String remoteOriginatorAddress = tr.readString();
            int remoteOriginatorPort = tr.readUINT32();
            RemoteForwardingData rfd = null;
            HashMap<Integer, RemoteForwardingData> hashMap = this.remoteForwardings;
            synchronized (hashMap) {
                rfd = this.remoteForwardings.get(new Integer(remoteConnectedPort));
            }
            if (rfd == null) {
                PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 1, "No thanks, unknown port in forwarded-tcpip request", "");
                this.tm.sendAsynchronousMessage(pcof.getPayload());
                log.debug("Unexpected forwarded-tcpip request, denying it!");
                return;
            }
            Channel channel = c = new Channel(this);
            synchronized (channel) {
                c.remoteID = remoteID;
                c.remoteWindow = (long)remoteWindow & 0xFFFFFFFFL;
                c.remoteMaxPacketSize = remoteMaxPacketSize;
                c.localID = this.addChannel(c);
            }
            RemoteAcceptThread rat = new RemoteAcceptThread(c, remoteConnectedAddress, remoteConnectedPort, remoteOriginatorAddress, remoteOriginatorPort, rfd.targetAddress, rfd.targetPort);
            rat.setDaemon(true);
            rat.start();
            return;
        }
        if (this.server_state != null && "session".equals(channelType)) {
            Channel c;
            ServerConnectionCallback cb = null;
            ServerConnectionState remoteConnectedPort = this.server_state;
            synchronized (remoteConnectedPort) {
                cb = this.server_state.cb_conn;
            }
            if (cb == null) {
                this.tm.sendAsynchronousMessage(new PacketChannelOpenFailure(remoteID, 1, "Sessions are currently not enabled", "en").getPayload());
                return;
            }
            Channel remoteOriginatorAddress = c = new Channel(this);
            synchronized (remoteOriginatorAddress) {
                c.remoteID = remoteID;
                c.remoteWindow = (long)remoteWindow & 0xFFFFFFFFL;
                c.remoteMaxPacketSize = remoteMaxPacketSize;
                c.localID = this.addChannel(c);
                c.state = 2;
                c.ss = new ServerSessionImpl(c);
            }
            PacketChannelOpenConfirmation pcoc = new PacketChannelOpenConfirmation(c.remoteID, c.localID, c.localWindow, c.localMaxPacketSize);
            this.tm.sendAsynchronousMessage(pcoc.getPayload());
            c.ss.sscb = cb.acceptSession(c.ss);
            return;
        }
        PacketChannelOpenFailure pcof = new PacketChannelOpenFailure(remoteID, 3, "Unknown channel type", "");
        this.tm.sendAsynchronousMessage(pcof.getPayload());
        log.warning("The peer tried to open an unsupported channel type (" + channelType + ")");
    }

    private void runAsync(Runnable r) {
        Thread t = new Thread(r);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelRequest(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        int id = tr.readUINT32();
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_REQUEST message for non-existent channel " + id);
        }
        ServerSessionImpl server_session = null;
        if (this.server_state != null) {
            Channel channel = c;
            synchronized (channel) {
                server_session = c.ss;
            }
        }
        String type = tr.readString("US-ASCII");
        boolean wantReply = tr.readBoolean();
        log.debug("Got SSH_MSG_CHANNEL_REQUEST (channel " + id + ", '" + type + "')");
        if (type.equals("exit-status")) {
            if (wantReply) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST exit-status message, 'want reply' is true");
            }
            int exit_status = tr.readUINT32();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Channel channel = c;
            synchronized (channel) {
                c.exit_status = new Integer(exit_status);
                c.notifyAll();
            }
            log.debug("Got EXIT STATUS (channel " + id + ", status " + exit_status + ")");
            return;
        }
        if (this.server_state == null && type.equals("exit-signal")) {
            if (wantReply) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST exit-signal message, 'want reply' is true");
            }
            String signame = tr.readString("US-ASCII");
            tr.readBoolean();
            tr.readString();
            tr.readString();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Channel channel = c;
            synchronized (channel) {
                c.exit_signal = signame;
                c.notifyAll();
            }
            log.debug("Got EXIT SIGNAL (channel " + id + ", signal " + signame + ")");
            return;
        }
        if (server_session != null && type.equals("pty-req")) {
            PtySettings pty = new PtySettings();
            pty.term = tr.readString();
            pty.term_width_characters = tr.readUINT32();
            pty.term_height_characters = tr.readUINT32();
            pty.term_width_pixels = tr.readUINT32();
            pty.term_height_pixels = tr.readUINT32();
            pty.terminal_modes = tr.readByteString();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Runnable run_after_sending_success = null;
            ServerSessionCallback sscb = server_session.getServerSessionCallback();
            if (sscb != null) {
                run_after_sending_success = sscb.requestPtyReq(server_session, pty);
            }
            if (wantReply) {
                if (run_after_sending_success != null) {
                    this.tm.sendAsynchronousMessage(new PacketChannelSuccess(c.remoteID).getPayload());
                } else {
                    this.tm.sendAsynchronousMessage(new PacketChannelFailure(c.remoteID).getPayload());
                }
            }
            if (run_after_sending_success != null) {
                this.runAsync(run_after_sending_success);
            }
            return;
        }
        if (server_session != null && type.equals("shell")) {
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Runnable run_after_sending_success = null;
            ServerSessionCallback sscb = server_session.getServerSessionCallback();
            if (sscb != null) {
                run_after_sending_success = sscb.requestShell(server_session);
            }
            if (wantReply) {
                if (run_after_sending_success != null) {
                    this.tm.sendAsynchronousMessage(new PacketChannelSuccess(c.remoteID).getPayload());
                } else {
                    this.tm.sendAsynchronousMessage(new PacketChannelFailure(c.remoteID).getPayload());
                }
            }
            if (run_after_sending_success != null) {
                this.runAsync(run_after_sending_success);
            }
            return;
        }
        if (server_session != null && type.equals("exec")) {
            String command = tr.readString();
            if (tr.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Runnable run_after_sending_success = null;
            ServerSessionCallback sscb = server_session.getServerSessionCallback();
            if (sscb != null) {
                run_after_sending_success = sscb.requestExec(server_session, command);
            }
            if (wantReply) {
                if (run_after_sending_success != null) {
                    this.tm.sendAsynchronousMessage(new PacketChannelSuccess(c.remoteID).getPayload());
                } else {
                    this.tm.sendAsynchronousMessage(new PacketChannelFailure(c.remoteID).getPayload());
                }
            }
            if (run_after_sending_success != null) {
                this.runAsync(run_after_sending_success);
            }
            return;
        }
        if (wantReply) {
            this.tm.sendAsynchronousMessage(new PacketChannelFailure(c.remoteID).getPayload());
        }
        log.debug("Channel request '" + type + "' is not known, ignoring it");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelEOF(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_EOF message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EOF message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            c.EOF = true;
            c.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_EOF (channel " + id + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelClose(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_CLOSE message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_CLOSE message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            c.EOF = true;
            c.state = 4;
            c.setReasonClosed("Close requested by remote");
            c.closeMessageRecv = true;
            this.removeChannel(c.localID);
            c.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_CLOSE (channel " + id + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelSuccess(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_SUCCESS message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_SUCCESS message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            ++c.successCounter;
            c.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_SUCCESS (channel " + id + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelFailure(byte[] msg, int msglen) throws IOException {
        if (msglen != 5) {
            throw new IOException("SSH_MSG_CHANNEL_FAILURE message has wrong size (" + msglen + ")");
        }
        int id = (msg[1] & 0xFF) << 24 | (msg[2] & 0xFF) << 16 | (msg[3] & 0xFF) << 8 | msg[4] & 0xFF;
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_FAILURE message for non-existent channel " + id);
        }
        Channel channel = c;
        synchronized (channel) {
            ++c.failedCounter;
            c.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_FAILURE (channel " + id + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenConfirmation(byte[] msg, int msglen) throws IOException {
        PacketChannelOpenConfirmation sm = new PacketChannelOpenConfirmation(msg, 0, msglen);
        Channel c = this.getChannel(sm.recipientChannelID);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for non-existent channel " + sm.recipientChannelID);
        }
        Channel channel = c;
        synchronized (channel) {
            if (c.state != 1) {
                throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for channel " + sm.recipientChannelID);
            }
            c.remoteID = sm.senderChannelID;
            c.remoteWindow = (long)sm.initialWindowSize & 0xFFFFFFFFL;
            c.remoteMaxPacketSize = sm.maxPacketSize;
            c.state = 2;
            c.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_OPEN_CONFIRMATION (channel " + sm.recipientChannelID + " / remote: " + sm.senderChannelID + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenFailure(byte[] msg, int msglen) throws IOException {
        if (msglen < 5) {
            throw new IOException("SSH_MSG_CHANNEL_OPEN_FAILURE message has wrong size (" + msglen + ")");
        }
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        int id = tr.readUINT32();
        Channel c = this.getChannel(id);
        if (c == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_FAILURE message for non-existent channel " + id);
        }
        int reasonCode = tr.readUINT32();
        String description = tr.readString("UTF-8");
        String reasonCodeSymbolicName = null;
        switch (reasonCode) {
            case 1: {
                reasonCodeSymbolicName = "SSH_OPEN_ADMINISTRATIVELY_PROHIBITED";
                break;
            }
            case 2: {
                reasonCodeSymbolicName = "SSH_OPEN_CONNECT_FAILED";
                break;
            }
            case 3: {
                reasonCodeSymbolicName = "SSH_OPEN_UNKNOWN_CHANNEL_TYPE";
                break;
            }
            case 4: {
                reasonCodeSymbolicName = "SSH_OPEN_RESOURCE_SHORTAGE";
                break;
            }
            default: {
                reasonCodeSymbolicName = "UNKNOWN REASON CODE (" + reasonCode + ")";
            }
        }
        StringBuilder descriptionBuffer = new StringBuilder();
        descriptionBuffer.append(description);
        for (int i = 0; i < descriptionBuffer.length(); ++i) {
            char cc = descriptionBuffer.charAt(i);
            if (cc >= ' ' && cc <= '~') continue;
            descriptionBuffer.setCharAt(i, '\ufffd');
        }
        Channel channel = c;
        synchronized (channel) {
            c.EOF = true;
            c.state = 4;
            c.setReasonClosed("The server refused to open the channel (" + reasonCodeSymbolicName + ", '" + descriptionBuffer.toString() + "')");
            c.notifyAll();
        }
        log.debug("Got SSH_MSG_CHANNEL_OPEN_FAILURE (channel " + id + ")");
    }

    public void msgGlobalRequest(byte[] msg, int msglen) throws IOException {
        TypesReader tr = new TypesReader(msg, 0, msglen);
        tr.readByte();
        String requestName = tr.readString();
        boolean wantReply = tr.readBoolean();
        if (wantReply) {
            byte[] reply_failure = new byte[]{82};
            this.tm.sendAsynchronousMessage(reply_failure);
        }
        log.debug("Got SSH_MSG_GLOBAL_REQUEST (" + requestName + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgGlobalSuccess() throws IOException {
        List<Channel> list = this.channels;
        synchronized (list) {
            ++this.globalSuccessCounter;
            this.channels.notifyAll();
        }
        log.debug("Got SSH_MSG_REQUEST_SUCCESS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgGlobalFailure() throws IOException {
        List<Channel> list = this.channels;
        synchronized (list) {
            ++this.globalFailedCounter;
            this.channels.notifyAll();
        }
        log.debug("Got SSH_MSG_REQUEST_FAILURE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        if (msg == null) {
            log.debug("HandleMessage: got shutdown");
            List<Object> list = this.listenerThreads;
            synchronized (list) {
                for (IChannelWorkerThread lat : this.listenerThreads) {
                    lat.stopWorking();
                }
                this.listenerThreadsAllowed = false;
            }
            list = this.channels;
            synchronized (list) {
                this.shutdown = true;
                Iterator<Object> i$ = this.channels.iterator();
                while (i$.hasNext()) {
                    Channel c;
                    Channel channel = c = (Channel)i$.next();
                    synchronized (channel) {
                        c.EOF = true;
                        c.state = 4;
                        c.setReasonClosed("The connection is being shutdown");
                        c.closeMessageRecv = true;
                        c.notifyAll();
                    }
                }
                this.channels.clear();
                this.channels.notifyAll();
                return;
            }
        }
        switch (msg[0]) {
            case 91: {
                this.msgChannelOpenConfirmation(msg, msglen);
                break;
            }
            case 93: {
                this.msgChannelWindowAdjust(msg, msglen);
                break;
            }
            case 94: {
                this.msgChannelData(msg, msglen);
                break;
            }
            case 95: {
                this.msgChannelExtendedData(msg, msglen);
                break;
            }
            case 98: {
                this.msgChannelRequest(msg, msglen);
                break;
            }
            case 96: {
                this.msgChannelEOF(msg, msglen);
                break;
            }
            case 90: {
                this.msgChannelOpen(msg, msglen);
                break;
            }
            case 97: {
                this.msgChannelClose(msg, msglen);
                break;
            }
            case 99: {
                this.msgChannelSuccess(msg, msglen);
                break;
            }
            case 100: {
                this.msgChannelFailure(msg, msglen);
                break;
            }
            case 92: {
                this.msgChannelOpenFailure(msg, msglen);
                break;
            }
            case 80: {
                this.msgGlobalRequest(msg, msglen);
                break;
            }
            case 81: {
                this.msgGlobalSuccess();
                break;
            }
            case 82: {
                this.msgGlobalFailure();
                break;
            }
            default: {
                throw new IOException("Cannot handle unknown channel message " + (msg[0] & 0xFF));
            }
        }
    }
}

