/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.ConnectionInfo;
import ch.ethz.ssh2.ServerAuthenticationCallback;
import ch.ethz.ssh2.ServerConnectionCallback;
import ch.ethz.ssh2.Version;
import ch.ethz.ssh2.crypto.CryptoWishList;
import ch.ethz.ssh2.crypto.PEMDecoder;
import ch.ethz.ssh2.server.ServerConnectionState;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.transport.TransportManager;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.Socket;

public class ServerConnection {
    private String softwareversion = String.format("Ganymed_SSHD_%s", Version.getSpecification());
    private final ServerConnectionState state = new ServerConnectionState(this);

    public ServerConnection(Socket s) {
        this(s, null, null);
    }

    public ServerConnection(Socket s, String softwareversion) {
        this(s, null, null);
        this.softwareversion = softwareversion;
    }

    public ServerConnection(Socket s, DSAPrivateKey dsa_key, RSAPrivateKey rsa_key) {
        this.state.s = s;
        this.state.softwareversion = this.softwareversion;
        this.state.next_dsa_key = dsa_key;
        this.state.next_rsa_key = rsa_key;
        this.fixCryptoWishList(this.state.next_cryptoWishList, this.state.next_dsa_key, this.state.next_rsa_key);
    }

    public synchronized void connect() throws IOException {
        this.connect(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(int timeout_milliseconds) throws IOException {
        ServerConnectionState serverConnectionState = this.state;
        synchronized (serverConnectionState) {
            if (this.state.cb_conn == null) {
                throw new IllegalStateException("The callback for connection events has not been set.");
            }
            if (this.state.cb_auth == null) {
                throw new IllegalStateException("The callback for authentication events has not been set.");
            }
            if (this.state.tm != null) {
                throw new IllegalStateException("The initial handshake has already been started.");
            }
            if (this.state.next_dsa_key == null && this.state.next_rsa_key == null) {
                throw new IllegalStateException("Neither a RSA nor a DSA host key has been specified!");
            }
            this.state.tm = new TransportManager();
        }
        this.state.tm.setTcpNoDelay(true);
        this.state.tm.serverInit(this.state);
        this.state.tm.getConnectionInfo(1);
    }

    public Socket getSocket() {
        return this.state.s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forceKeyExchange() throws IOException {
        ServerConnectionState serverConnectionState = this.state;
        synchronized (serverConnectionState) {
            if (this.state.tm == null) {
                throw new IllegalStateException("Cannot force another key exchange, you need to start the key exchange first.");
            }
            this.state.tm.forceKeyExchange(this.state.next_cryptoWishList, null, this.state.next_dsa_key, this.state.next_rsa_key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConnectionInfo getConnectionInfo() throws IOException {
        ServerConnectionState serverConnectionState = this.state;
        synchronized (serverConnectionState) {
            if (this.state.tm == null) {
                throw new IllegalStateException("Cannot get details of connection, you need to start the key exchange first.");
            }
        }
        return this.state.tm.getConnectionInfo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDsaHostKey(DSAPrivateKey dsa_hostkey) {
        ServerConnectionState serverConnectionState = this.state;
        synchronized (serverConnectionState) {
            if (dsa_hostkey == null && this.state.next_dsa_key != null && this.state.tm != null) {
                throw new IllegalStateException("Cannot remove DSA hostkey after first key exchange.");
            }
            this.state.next_dsa_key = dsa_hostkey;
            this.fixCryptoWishList(this.state.next_cryptoWishList, this.state.next_dsa_key, this.state.next_rsa_key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRsaHostKey(RSAPrivateKey rsa_hostkey) {
        ServerConnectionState serverConnectionState = this.state;
        synchronized (serverConnectionState) {
            if (rsa_hostkey == null && this.state.next_rsa_key != null && this.state.tm != null) {
                throw new IllegalStateException("Cannot remove RSA hostkey after first key exchange.");
            }
            this.state.next_rsa_key = rsa_hostkey;
            this.fixCryptoWishList(this.state.next_cryptoWishList, this.state.next_dsa_key, this.state.next_rsa_key);
        }
    }

    public void setPEMHostKey(char[] pemdata, String password) throws IOException {
        Object key = PEMDecoder.decode(pemdata, password);
        if (key instanceof DSAPrivateKey) {
            this.setDsaHostKey((DSAPrivateKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            this.setRsaHostKey((RSAPrivateKey)key);
        }
    }

    public void setPEMHostKey(File pemFile, String password) throws IOException {
        int len;
        if (pemFile == null) {
            throw new IllegalArgumentException("pemfile argument is null");
        }
        char[] buff = new char[256];
        CharArrayWriter cw = new CharArrayWriter();
        FileReader fr = new FileReader(pemFile);
        while ((len = fr.read(buff)) >= 0) {
            cw.write(buff, 0, len);
        }
        fr.close();
        this.setPEMHostKey(cw.toCharArray(), password);
    }

    private void fixCryptoWishList(CryptoWishList next_cryptoWishList, DSAPrivateKey next_dsa_key, RSAPrivateKey next_rsa_key) {
        next_cryptoWishList.serverHostKeyAlgorithms = next_dsa_key != null && next_rsa_key != null ? new String[]{"ssh-rsa", "ssh-dss"} : (next_dsa_key != null ? new String[]{"ssh-dss"} : (next_rsa_key != null ? new String[]{"ssh-rsa"} : new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setServerConnectionCallback(ServerConnectionCallback cb) {
        ServerConnectionState serverConnectionState = this.state;
        synchronized (serverConnectionState) {
            this.state.cb_conn = cb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAuthenticationCallback(ServerAuthenticationCallback cb) {
        ServerConnectionState serverConnectionState = this.state;
        synchronized (serverConnectionState) {
            this.state.cb_auth = cb;
        }
    }

    public void close() {
        Throwable t = new Throwable("Closed due to user request.");
        this.close(t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable t, boolean hard) {
        ServerConnectionState serverConnectionState = this.state;
        synchronized (serverConnectionState) {
            if (this.state.cm != null) {
                this.state.cm.closeAllChannels();
            }
            if (this.state.tm != null) {
                this.state.tm.close(t, !hard);
            }
        }
    }
}

