/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.cactus.ServletTestCase;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractTestSuite
implements Test {
    private Vector tests = new Vector(10);
    private String name;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public AbstractTestSuite() {
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractTestSuite(Class theClass) {
        Class clazz;
        Constructor constructor;
        this.setName(theClass.getName());
        try {
            constructor = AbstractTestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.addTest(AbstractTestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name)"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(AbstractTestSuite.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Method[] methods = superClass.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    this.addTestMethod(methods[i], names, constructor);
                    ++i;
                }
                superClass = superClass.getSuperclass();
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("junit.framework.Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(superClass));
        if (this.tests.size() == 0) {
            this.addTest(AbstractTestSuite.warning("No tests found in " + theClass.getName()));
        }
    }

    public AbstractTestSuite(String theName) {
        this.setName(theName);
    }

    protected void addTest(Test theTest) {
        this.tests.addElement(theTest);
    }

    protected void addTestSuite(Class theTestClass) {
        this.addTest(this.createTestSuite(theTestClass));
    }

    private void addTestMethod(Method theMethod, Vector theNames, Constructor theConstructor) {
        String name = theMethod.getName();
        if (theNames.contains(name)) {
            return;
        }
        if (this.isPublicTestMethod(theMethod)) {
            theNames.addElement(name);
            try {
                Object constructorInstance;
                if (theConstructor.getParameterTypes().length == 0) {
                    constructorInstance = theConstructor.newInstance(new Object[0]);
                    if (constructorInstance instanceof TestCase) {
                        ((TestCase)constructorInstance).setName(name);
                    }
                } else {
                    constructorInstance = theConstructor.newInstance(name);
                }
                this.addTest((Test)new ServletTestCase(name, (Test)constructorInstance));
            }
            catch (InstantiationException e) {
                this.addTest(AbstractTestSuite.warning("Cannot instantiate test case: " + name + " (" + this.exceptionToString(e) + ")"));
            }
            catch (InvocationTargetException e) {
                this.addTest(AbstractTestSuite.warning("Exception in constructor: " + name + " (" + this.exceptionToString(e.getTargetException()) + ")"));
            }
            catch (IllegalAccessException e) {
                this.addTest(AbstractTestSuite.warning("Cannot access test case: " + name + " (" + this.exceptionToString(e) + ")"));
            }
        } else if (this.isTestMethod(theMethod)) {
            this.addTest(AbstractTestSuite.warning("Test method isn't public: " + theMethod.getName()));
        }
    }

    private String exceptionToString(Throwable theThrowable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        theThrowable.printStackTrace(writer);
        return stringWriter.toString();
    }

    public int countTestCases() {
        int count = 0;
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            Test test = (Test)e.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    private boolean isPublicTestMethod(Method theMethod) {
        return this.isTestMethod(theMethod) && Modifier.isPublic(theMethod.getModifiers());
    }

    private boolean isTestMethod(Method theMethod) {
        String name = theMethod.getName();
        Class<?>[] parameters = theMethod.getParameterTypes();
        Class<?> returnType = theMethod.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    public void run(TestResult testResult) {
        TestResult testResult2 = testResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)testResult2);
        AbstractTestSuite.run_aroundBody1$advice(this, testResult2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    protected void runTest(Test theTest, TestResult theResult) {
        theTest.run(theResult);
    }

    protected Test testAt(int theIndex) {
        return (Test)this.tests.elementAt(theIndex);
    }

    protected static Constructor getTestConstructor(Class theClass) throws NoSuchMethodException {
        Constructor result;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            result = theClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            result = theClass.getConstructor(new Class[0]);
        }
        return result;
    }

    protected int testCount() {
        return this.tests.size();
    }

    protected Enumeration tests() {
        return this.tests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    protected void setName(String theName) {
        this.name = theName;
    }

    protected String getName() {
        return this.name;
    }

    private static Test warning(final String theMessage) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)theMessage);
            }
        };
    }

    protected abstract Test createTestSuite(Class var1);

    protected abstract Test createCactusTestCase(String var1, Test var2);

    static {
        Factory factory = new Factory("AbstractTestSuite.java", Class.forName("org.apache.cactus.internal.AbstractTestSuite"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.apache.cactus.internal.AbstractTestSuite-junit.framework.TestResult:-theResult:--void-"), 253);
    }

    private static final /* synthetic */ void run_aroundBody0(AbstractTestSuite this_, TestResult theResult, JoinPoint joinPoint) {
        Enumeration e = this_.tests();
        while (e.hasMoreElements()) {
            if (theResult.shouldStop()) break;
            Test test = (Test)e.nextElement();
            this_.runTest(test, theResult);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object run_aroundBody1$advice(AbstractTestSuite this_, TestResult ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AbstractTestSuite.run_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AbstractTestSuite.run_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

