/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import javax.servlet.http.HttpServletRequest;
import org.apache.cactus.WebRequest;
import org.apache.cactus.internal.server.ServletUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ServletURL {
    public static final String URL_PROTOCOL_PARAM = "Cactus_URL_Protocol";
    public static final String URL_SERVER_NAME_PARAM = "Cactus_URL_Server";
    public static final String URL_CONTEXT_PATH_PARAM = "Cactus_URL_ContextPath";
    public static final String URL_SERVLET_PATH_PARAM = "Cactus_URL_ServletPath";
    public static final String URL_PATH_INFO_PARAM = "Cactus_URL_PathInfo";
    public static final String URL_QUERY_STRING_PARAM = "Cactus_URL_QueryString";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    private static final int DEFAULT_PORT_HTTP = 80;
    private static final int DEFAULT_PORT_HTTPS = 443;
    private static final Log LOGGER;
    private String serverName;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String protocol = "http";
    static /* synthetic */ Class class$0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("ServletURL.java", Class.forName("org.apache.cactus.ServletURL"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setProtocol-org.apache.cactus.ServletURL-java.lang.String:-theProtocol:--void-"), 272);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setServerName-org.apache.cactus.ServletURL-java.lang.String:-theServerName:--void-"), 306);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setContextPath-org.apache.cactus.ServletURL-java.lang.String:-theContextPath:--void-"), 407);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setServletPath-org.apache.cactus.ServletURL-java.lang.String:-theServletPath:--void-"), 442);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setPathInfo-org.apache.cactus.ServletURL-java.lang.String:-thePathInfo:--void-"), 473);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setQueryString-org.apache.cactus.ServletURL-java.lang.String:-theQueryString:--void-"), 509);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-saveToRequest-org.apache.cactus.ServletURL-org.apache.cactus.WebRequest:-theRequest:--void-"), 539);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-loadFromRequest-org.apache.cactus.ServletURL-javax.servlet.http.HttpServletRequest:-theRequest:--org.apache.cactus.ServletURL-"), 586);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.cactus.ServletURL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = LogFactory.getLog((Class)clazz);
    }

    public ServletURL() {
    }

    public ServletURL(String theProtocol, String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        this.setProtocol(theProtocol);
        this.setServerName(theServerName);
        this.setContextPath(theContextPath);
        this.setServletPath(theServletPath);
        this.setPathInfo(thePathInfo);
        this.setQueryString(theQueryString);
    }

    public ServletURL(String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        this(PROTOCOL_HTTP, theServerName, theContextPath, theServletPath, thePathInfo, theQueryString);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
        ServletURL.setProtocol_aroundBody1$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        ServletURL.setServerName_aroundBody3$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getHost() {
        int pos;
        String host = this.getServerName();
        if (host != null && (pos = host.indexOf(":")) > 0) {
            host = host.substring(0, pos);
        }
        return host;
    }

    public int getPort() {
        int port = -1;
        if (this.getServerName() != null) {
            int pos = this.getServerName().indexOf(":");
            if (pos < 0) {
                port = this.getDefaultPort();
            } else {
                try {
                    port = Integer.parseInt(this.getServerName().substring(pos + 1));
                    if (port < 0) {
                        port = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    port = -1;
                }
            }
        }
        return port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
        ServletURL.setContextPath_aroundBody5$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string2);
        ServletURL.setServletPath_aroundBody7$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string2);
        ServletURL.setPathInfo_aroundBody9$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string2);
        ServletURL.setQueryString_aroundBody11$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getPath() {
        String path = this.getContextPath() == null ? "" : this.getContextPath();
        path = String.valueOf(path) + (this.getServletPath() == null ? "" : this.getServletPath());
        if ((path = String.valueOf(path) + (this.getPathInfo() == null ? "" : this.getPathInfo())).length() == 0) {
            path = null;
        }
        return path;
    }

    public void saveToRequest(WebRequest webRequest) {
        WebRequest webRequest2 = webRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)webRequest2);
        ServletURL.saveToRequest_aroundBody13$advice(this, webRequest2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public static ServletURL loadFromRequest(HttpServletRequest httpServletRequest) {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)httpServletRequest2);
        return (ServletURL)ServletURL.loadFromRequest_aroundBody15$advice(httpServletRequest2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("protocol = [" + this.getProtocol() + "], ");
        buffer.append("host name = [" + this.getHost() + "], ");
        buffer.append("port = [" + this.getPort() + "], ");
        buffer.append("context path = [" + this.getContextPath() + "], ");
        buffer.append("servlet path = [" + this.getServletPath() + "], ");
        buffer.append("path info = [" + this.getPathInfo() + "], ");
        buffer.append("query string = [" + this.getQueryString() + "]");
        return buffer.toString();
    }

    private int getDefaultPort() {
        if (PROTOCOL_HTTPS.equals(this.getProtocol())) {
            return 443;
        }
        return 80;
    }

    private static final /* synthetic */ void setProtocol_aroundBody0(ServletURL this_, String theProtocol, JoinPoint joinPoint) {
        if (!theProtocol.equals(PROTOCOL_HTTP) && !theProtocol.equals(PROTOCOL_HTTPS)) {
            throw new RuntimeException("Invalid protocol [" + theProtocol + "]. Currently supported protocols are [" + PROTOCOL_HTTP + "] and [" + PROTOCOL_HTTPS + "].");
        }
        this_.protocol = theProtocol;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setProtocol_aroundBody1$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setProtocol_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setProtocol_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setServerName_aroundBody3$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            this_.serverName = ajc_aroundClosure;
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        this_.serverName = ajc_aroundClosure;
        return null;
    }

    private static final /* synthetic */ void setContextPath_aroundBody4(ServletURL this_, String theContextPath, JoinPoint joinPoint) {
        if (theContextPath != null && theContextPath.length() > 0) {
            if (!theContextPath.startsWith("/")) {
                throw new IllegalArgumentException("The Context Path must start with a \"/\" character.");
            }
            if (theContextPath.endsWith("/")) {
                throw new IllegalArgumentException("The Context Path must not end with a \"/\" character.");
            }
        }
        this_.contextPath = theContextPath;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setContextPath_aroundBody5$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setContextPath_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setContextPath_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final /* synthetic */ void setServletPath_aroundBody6(ServletURL this_, String theServletPath, JoinPoint joinPoint) {
        if (theServletPath != null && theServletPath.length() > 0 && !theServletPath.startsWith("/")) {
            throw new IllegalArgumentException("The Servlet Path must start with a \"/\" character.");
        }
        this_.servletPath = theServletPath;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setServletPath_aroundBody7$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setServletPath_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setServletPath_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final /* synthetic */ void setPathInfo_aroundBody8(ServletURL this_, String thePathInfo, JoinPoint joinPoint) {
        if (thePathInfo != null && thePathInfo.length() == 0) {
            throw new IllegalArgumentException("The Path Info must not be an empty string. Use null if you don't want to have a path info.");
        }
        if (thePathInfo != null && !thePathInfo.startsWith("/")) {
            throw new IllegalArgumentException("The Path Info must start with a \"/\" character.");
        }
        this_.pathInfo = thePathInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setPathInfo_aroundBody9$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setPathInfo_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setPathInfo_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object setQueryString_aroundBody11$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            this_.queryString = ajc_aroundClosure;
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        this_.queryString = ajc_aroundClosure;
        return null;
    }

    private static final /* synthetic */ void saveToRequest_aroundBody12(ServletURL this_, WebRequest theRequest, JoinPoint joinPoint) {
        theRequest.addParameter(URL_PROTOCOL_PARAM, this_.getProtocol(), "GET");
        if (this_.getServerName() != null) {
            theRequest.addParameter(URL_SERVER_NAME_PARAM, this_.getServerName(), "GET");
        }
        if (this_.getContextPath() != null) {
            theRequest.addParameter(URL_CONTEXT_PATH_PARAM, this_.getContextPath(), "GET");
        }
        if (this_.getServletPath() != null) {
            theRequest.addParameter(URL_SERVLET_PATH_PARAM, this_.getServletPath(), "GET");
        }
        if (this_.getPathInfo() != null) {
            theRequest.addParameter(URL_PATH_INFO_PARAM, this_.getPathInfo(), "GET");
        }
        if (this_.getQueryString() != null) {
            theRequest.addParameter(URL_QUERY_STRING_PARAM, this_.getQueryString(), "GET");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object saveToRequest_aroundBody13$advice(ServletURL this_, WebRequest ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.saveToRequest_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.saveToRequest_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final /* synthetic */ ServletURL loadFromRequest_aroundBody14(HttpServletRequest theRequest, JoinPoint joinPoint) {
        String queryString;
        String pathInfo;
        String servletPath;
        String contextPath;
        String serverName;
        String qString = theRequest.getQueryString();
        boolean isDefined = false;
        ServletURL url = new ServletURL();
        String protocol = ServletUtil.getQueryStringParameter(qString, URL_PROTOCOL_PARAM);
        if (protocol != null) {
            isDefined = true;
            url.setProtocol(protocol);
        }
        if ((serverName = ServletUtil.getQueryStringParameter(qString, URL_SERVER_NAME_PARAM)) != null) {
            isDefined = true;
            url.setServerName(serverName);
        }
        if ((contextPath = ServletUtil.getQueryStringParameter(qString, URL_CONTEXT_PATH_PARAM)) != null) {
            isDefined = true;
            url.setContextPath(contextPath);
        }
        if ((servletPath = ServletUtil.getQueryStringParameter(qString, URL_SERVLET_PATH_PARAM)) != null) {
            isDefined = true;
            url.setServletPath(servletPath);
        }
        if ((pathInfo = ServletUtil.getQueryStringParameter(qString, URL_PATH_INFO_PARAM)) != null) {
            isDefined = true;
            url.setPathInfo(pathInfo);
        }
        if ((queryString = ServletUtil.getQueryStringParameter(qString, URL_QUERY_STRING_PARAM)) != null) {
            isDefined = true;
            url.setQueryString(queryString);
        }
        if (!isDefined) {
            LOGGER.debug((Object)"Undefined simulation URL");
            url = null;
        } else {
            LOGGER.debug((Object)("Simulation URL = [" + url + "]"));
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Object loadFromRequest_aroundBody15$advice(HttpServletRequest this_, JoinPoint ajc_aroundClosure, LogAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Log log = LogFactory.getLog((Class)joinPoint.getSignature().getDeclaringType());
        if (log.isDebugEnabled()) {
            void exitString;
            void result;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(thisJoinPoint, joinPoint)));
            void var8_6 = logger;
            ServletURL servletURL = ServletURL.loadFromRequest_aroundBody14(this_, ajc_aroundClosure);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(servletURL);
            stringBuffer.append(']');
            exitString.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return servletURL;
        }
        void var9_9 = logger;
        return ServletURL.loadFromRequest_aroundBody14(this_, ajc_aroundClosure);
    }
}

