/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class CactusScanner {
    private Log log = LogFactory.getLog((Class)(class$org$apache$cactus$integration$maven$CactusScanner == null ? (class$org$apache$cactus$integration$maven$CactusScanner = CactusScanner.class$("org.apache.cactus.integration.maven.CactusScanner")) : class$org$apache$cactus$integration$maven$CactusScanner));
    private Project project;
    private List cactusTests = new ArrayList();
    static /* synthetic */ Class class$org$apache$cactus$integration$maven$CactusScanner;
    static /* synthetic */ Class class$junit$framework$TestCase;

    public void setProject(Project theProject) {
        this.project = theProject;
    }

    public void clear() {
        this.cactusTests.clear();
    }

    public Iterator iterator() {
        return this.cactusTests.iterator();
    }

    public void processFileSet(FileSet theFileset, Path theClasspath) {
        DirectoryScanner ds = theFileset.getDirectoryScanner(this.project);
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith(".class")) continue;
            String fqn = files[i].substring(0, files[i].length() - ".class".length()).replace(File.separatorChar, '.');
            this.log.debug((Object)("Found candidate class: [" + fqn + "]"));
            if (!this.isJUnitTestCase(fqn, theClasspath)) continue;
            this.log.debug((Object)("Found Cactus test case: [" + fqn + "]"));
            this.cactusTests.add(fqn);
        }
    }

    private boolean isJUnitTestCase(String theClassName, Path theClasspath) {
        Class clazz = this.loadClass(theClassName, theClasspath);
        if (clazz == null) {
            return false;
        }
        Class<?> testCaseClass = null;
        try {
            testCaseClass = clazz.getClassLoader().loadClass((class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = CactusScanner.class$("junit.framework.TestCase")) : class$junit$framework$TestCase).getName());
        }
        catch (ClassNotFoundException e) {
            this.log.debug((Object)"Cannot load class", (Throwable)e);
            return false;
        }
        if (!testCaseClass.isAssignableFrom(clazz)) {
            this.log.debug((Object)("Not a JUnit test as class [" + theClassName + "] does " + "not inherit from [" + (class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = CactusScanner.class$("junit.framework.TestCase")) : class$junit$framework$TestCase).getName() + "]"));
            return false;
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            this.log.debug((Object)("Not a JUnit test as class [" + theClassName + "] is " + "abstract"));
            return false;
        }
        boolean hasTestMethod = false;
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("test") || methods[i].getReturnType() != Void.TYPE || methods[i].getParameterTypes().length != 0) continue;
            hasTestMethod = true;
            break;
        }
        if (!hasTestMethod) {
            this.log.debug((Object)("Not a JUnit test as class [" + theClassName + "] has " + "no method that start with \"test\", returns void and has " + "no parameters"));
            return false;
        }
        return true;
    }

    private Class loadClass(String theClassName, Path theClasspath) {
        Class<?> clazz = null;
        try {
            clazz = this.createClassLoader(theClasspath).loadClass(theClassName);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Failed to load class [" + theClassName + "]"), (Throwable)e);
        }
        return clazz;
    }

    private ClassLoader createClassLoader(Path theClasspath) {
        URL[] urls = new URL[theClasspath.size()];
        try {
            for (int i = 0; i < theClasspath.size(); ++i) {
                this.log.debug((Object)("Adding [" + new File(theClasspath.list()[i]).toURL() + "] " + "to class loader classpath"));
                urls[i] = new File(theClasspath.list()[i]).toURL();
            }
        }
        catch (MalformedURLException e) {
            this.log.debug((Object)"Invalid URL", (Throwable)e);
        }
        return new URLClassLoader(urls);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

