/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.maven.plugins.provisio;

import ca.vanzyl.maven.plugins.provisio.BaseMojo;
import ca.vanzyl.provisio.MavenProvisioner;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningRequest;
import ca.vanzyl.provisio.model.Runtime;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="validateDependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ValidatorMojo
extends BaseMojo {
    @Parameter(required=true, property="pomFile", defaultValue="${basedir}/pom.xml")
    private File pomFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProvisioner provisioner = new MavenProvisioner(this.repositorySystem, this.repositorySystemSession, this.project.getRemoteProjectRepositories());
        ArrayList<ProvisioArtifact> artifacts = new ArrayList<ProvisioArtifact>();
        for (Runtime runtime : this.provisio.findDescriptors(this.descriptorDirectory, this.project)) {
            runtime.addArtifactSetReference("runtime.classpath", this.getRuntimeClasspathAsArtifactSet());
            ProvisioningRequest request = this.getRequest(runtime);
            try {
                artifacts.addAll(provisioner.getArtifacts(request));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error resolving artifacts.", e);
            }
        }
        this.checkDuplicates(artifacts);
        Model model = this.project.getModel().clone();
        Set<String> dependencies = this.flattenDependencies(this.getDependencies(artifacts));
        Set<String> modelDependencies = this.flattenDependencies(model.getDependencies().stream().filter(d -> d.getScope() == null || d.getScope().equals("compile")).collect(Collectors.toList()));
        this.checkDependencies(modelDependencies, dependencies);
    }

    private Set<String> flattenDependencies(List<Dependency> dependencies) {
        return dependencies.stream().map(d -> String.valueOf(d.getGroupId()) + ":" + d.getArtifactId() + this.prefixed(d.getType(), ":jar") + this.prefixed(d.getClassifier()) + ":" + d.getVersion()).collect(Collectors.toSet());
    }

    private String prefixed(String value) {
        return this.prefixed(value, "");
    }

    private String prefixed(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return ":" + value;
    }

    private void checkDependencies(Set<String> actual, Set<String> expected) throws MojoFailureException {
        HashSet<String> missing = new HashSet<String>(expected);
        missing.removeAll(actual);
        actual.removeAll(expected);
        if (!missing.isEmpty()) {
            throw new MojoFailureException("Missing dependencies: " + String.join((CharSequence)", ", missing));
        }
        if (!actual.isEmpty()) {
            throw new MojoFailureException("Extra dependencies: " + String.join((CharSequence)", ", actual));
        }
    }
}

