/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.maven.plugins.provisio;

import ca.vanzyl.maven.plugins.provisio.BaseMojo;
import ca.vanzyl.provisio.MavenProvisioner;
import ca.vanzyl.provisio.model.ArtifactSet;
import ca.vanzyl.provisio.model.ProvisioArchive;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningRequest;
import ca.vanzyl.provisio.model.ProvisioningResult;
import ca.vanzyl.provisio.model.Runtime;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="provision", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ProvisioningMojo
extends BaseMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}")
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        MavenProvisioner provisioner = new MavenProvisioner(this.repositorySystem, this.repositorySystemSession, this.project.getRemoteProjectRepositories());
        for (Runtime runtime : this.provisio.findDescriptors(this.descriptorDirectory, this.project)) {
            ProvisioningResult result;
            ArtifactSet runtimeArtifacts = this.getRuntimeClasspathAsArtifactSet();
            ProvisioArtifact projectArtifact = this.projectArtifact();
            if (projectArtifact != null) {
                runtime.addArtifactReference("projectArtifact", projectArtifact);
                runtimeArtifacts.addArtifact(projectArtifact);
                if (!this.project.getPackaging().equals("jar")) {
                    this.projectHelper.attachArtifact(this.project, "jar", projectArtifact.getFile());
                }
            }
            runtime.addArtifactSetReference("runtime.classpath", runtimeArtifacts);
            ProvisioningRequest request = this.getRequest(runtime);
            request.setOutputDirectory(this.outputDirectory);
            try {
                result = provisioner.provision(request);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error provisioning assembly.", e);
            }
            if (result.getArchives() == null || result.getArchives().size() != 1) continue;
            ProvisioArchive provisioArchive = (ProvisioArchive)result.getArchives().get(0);
            if (this.project.getPackaging().equals("jar") || this.project.getPackaging().equals("takari-jar")) {
                this.projectHelper.attachArtifact(this.project, provisioArchive.extension(), provisioArchive.file());
                continue;
            }
            this.project.getArtifact().setFile(provisioArchive.file());
        }
    }
}

