/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.maven.plugins.provisio;

import ca.vanzyl.maven.plugins.provisio.Provisio;
import ca.vanzyl.provisio.model.ArtifactSet;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningRequest;
import ca.vanzyl.provisio.model.Runtime;
import io.takari.incrementalbuild.Incremental;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMojo
extends AbstractMojo {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    protected RepositorySystem repositorySystem;
    @Inject
    protected Provisio provisio;
    @Inject
    protected MavenProjectHelper projectHelper;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected RepositorySystemSession repositorySystemSession;
    @Parameter(required=true, defaultValue="${basedir}/src/main/provisio")
    protected File descriptorDirectory;
    @Parameter(defaultValue="${session}")
    protected MavenSession session;

    protected ProvisioArtifact projectArtifact() {
        ProvisioArtifact jarArtifact = null;
        File jar = new File(this.project.getBuild().getDirectory(), String.valueOf(this.project.getArtifactId()) + "-" + this.project.getVersion() + ".jar");
        if (jar.exists()) {
            jarArtifact = new ProvisioArtifact(String.valueOf(this.project.getGroupId()) + ":" + this.project.getArtifactId() + ":" + this.project.getVersion());
            jarArtifact.setFile(jar);
        }
        return jarArtifact;
    }

    protected ArtifactSet getRuntimeClasspathAsArtifactSet() {
        ArtifactSet artifactSet = new ArtifactSet();
        for (org.apache.maven.artifact.Artifact mavenArtifact : this.project.getArtifacts()) {
            if (mavenArtifact.getScope().equals("system") || mavenArtifact.getScope().equals("provided")) continue;
            artifactSet.addArtifact(new ProvisioArtifact(BaseMojo.toArtifact(mavenArtifact)));
        }
        return artifactSet;
    }

    private static Artifact toArtifact(org.apache.maven.artifact.Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String version = artifact.getVersion();
        if (version == null && artifact.getVersionRange() != null) {
            version = artifact.getVersionRange().toString();
        }
        Map<String, String> props = null;
        if ("system".equals(artifact.getScope())) {
            String localPath = artifact.getFile() != null ? artifact.getFile().getPath() : "";
            props = Collections.singletonMap("localPath", localPath);
        }
        DefaultArtifact result = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getArtifactHandler().getExtension(), version, props, BaseMojo.newArtifactType(artifact.getType(), artifact.getArtifactHandler()));
        result = result.setFile(artifact.getFile());
        return result;
    }

    private static ArtifactType newArtifactType(String id, ArtifactHandler handler) {
        return new DefaultArtifactType(id, handler.getExtension(), handler.getClassifier(), handler.getLanguage(), handler.isAddedToClasspath(), handler.isIncludesDependencies());
    }

    protected ProvisioningRequest getRequest(Runtime runtime) {
        ProvisioningRequest request = new ProvisioningRequest();
        request.setRuntimeDescriptor(runtime);
        request.setVariables(runtime.getVariables());
        request.setManagedDependencies(this.provisio.getManagedDependencies(this.project));
        return request;
    }

    protected void checkDuplicates(List<ProvisioArtifact> artifacts) throws MojoFailureException {
        HashMap grouped = new HashMap();
        for (ProvisioArtifact artifact : artifacts) {
            String key = artifact.toVersionlessCoordinate();
            if (!grouped.containsKey(key)) {
                grouped.put(key, new HashSet());
            }
            ((Set)grouped.get(key)).add(String.valueOf(key) + ":" + artifact.getVersion());
        }
        List duplicates = grouped.values().stream().filter(strings -> strings.size() > 1).map(strings -> String.join((CharSequence)", ", strings)).collect(Collectors.toList());
        if (duplicates.size() != 0) {
            throw new MojoFailureException("Found different versions of the same dependency: " + String.join((CharSequence)", ", duplicates));
        }
    }

    protected List<Dependency> getDependencies(List<ProvisioArtifact> artifacts) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (ProvisioArtifact artifact : artifacts) {
            Dependency dependency = new Dependency();
            dependency.setGroupId(artifact.getGroupId());
            dependency.setArtifactId(artifact.getArtifactId());
            dependency.setVersion(artifact.getVersion());
            if (artifact.getClassifier() != null && artifact.getClassifier().length() != 0) {
                dependency.setClassifier(artifact.getClassifier());
            }
            if (artifact.getExtension() != null && artifact.getExtension().length() != 0 && !artifact.getExtension().equals("jar")) {
                dependency.setType(artifact.getExtension());
            }
            dependencies.add(dependency);
        }
        return dependencies;
    }

    protected void mergeDependencies(Model model, List<Dependency> dependencies) {
        for (Dependency dependency : model.getDependencies()) {
            if (dependency.getScope() == null || dependency.getScope().equals("compile")) continue;
            dependencies.add(dependency);
        }
        ArrayList<Dependency> sorted = new ArrayList<Dependency>(dependencies);
        sorted.sort(Comparator.comparing(Dependency::getScope, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Dependency::getGroupId).thenComparing(Dependency::getArtifactId).thenComparing(Dependency::getVersion, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Dependency::getClassifier, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Dependency::getType, Comparator.nullsFirst(Comparator.naturalOrder())));
        model.setDependencies(sorted);
    }
}

