/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XhtmlParser {
    public static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private static final char END_OF_CHARS = '\uffff';
    private Set<String> elements = new HashSet<String>();
    private Set<String> attributes = new HashSet<String>();
    private Map<String, String> definedEntities = new HashMap<String, String>();
    private Map<String, String> declaredEntities = new HashMap<String, String>();
    private ParserSecurityPolicy policy;
    private boolean trimWhitespace;
    private boolean mustBeWellFormed = true;
    private List<StringPair> validationIssues = new ArrayList<StringPair>();
    private Reader rdr;
    private String cache = "";
    private XhtmlNode unwindPoint;
    private String lastText = "";
    private int line = 1;
    private int col = 0;
    private char lastChar;
    private XhtmlNode.Location lastLoc;
    private boolean xmlMode;

    public XhtmlParser() {
        this.policy = ParserSecurityPolicy.Accept;
        this.elements.add("p");
        this.elements.add("br");
        this.elements.add("div");
        this.elements.add("h1");
        this.elements.add("h2");
        this.elements.add("h3");
        this.elements.add("h4");
        this.elements.add("h5");
        this.elements.add("h6");
        this.elements.add("a");
        this.elements.add("span");
        this.elements.add("b");
        this.elements.add("em");
        this.elements.add("i");
        this.elements.add("strong");
        this.elements.add("small");
        this.elements.add("big");
        this.elements.add("tt");
        this.elements.add("small");
        this.elements.add("dfn");
        this.elements.add("q");
        this.elements.add("var");
        this.elements.add("abbr");
        this.elements.add("acronym");
        this.elements.add("cite");
        this.elements.add("blockquote");
        this.elements.add("hr");
        this.elements.add("address");
        this.elements.add("bdo");
        this.elements.add("kbd");
        this.elements.add("q");
        this.elements.add("sub");
        this.elements.add("sup");
        this.elements.add("ul");
        this.elements.add("ol");
        this.elements.add("li");
        this.elements.add("dl");
        this.elements.add("dt");
        this.elements.add("dd");
        this.elements.add("pre");
        this.elements.add("table");
        this.elements.add("caption");
        this.elements.add("colgroup");
        this.elements.add("col");
        this.elements.add("thead");
        this.elements.add("tr");
        this.elements.add("tfoot");
        this.elements.add("tbody");
        this.elements.add("th");
        this.elements.add("td");
        this.elements.add("code");
        this.elements.add("samp");
        this.elements.add("img");
        this.elements.add("map");
        this.elements.add("area");
        this.attributes.add("title");
        this.attributes.add("style");
        this.attributes.add("class");
        this.attributes.add("id");
        this.attributes.add("lang");
        this.attributes.add("xml:lang");
        this.attributes.add("dir");
        this.attributes.add("accesskey");
        this.attributes.add("tabindex");
        this.attributes.add("span");
        this.attributes.add("width");
        this.attributes.add("align");
        this.attributes.add("valign");
        this.attributes.add("char");
        this.attributes.add("charoff");
        this.attributes.add("abbr");
        this.attributes.add("axis");
        this.attributes.add("headers");
        this.attributes.add("scope");
        this.attributes.add("rowspan");
        this.attributes.add("colspan");
        this.attributes.add("a.href");
        this.attributes.add("a.name");
        this.attributes.add("img.src");
        this.attributes.add("img.border");
        this.attributes.add("div.xmlns");
        this.attributes.add("blockquote.cite");
        this.attributes.add("q.cite");
        this.attributes.add("a.charset");
        this.attributes.add("a.type");
        this.attributes.add("a.name");
        this.attributes.add("a.href");
        this.attributes.add("a.hreflang");
        this.attributes.add("a.rel");
        this.attributes.add("a.rev");
        this.attributes.add("a.shape");
        this.attributes.add("a.coords");
        this.attributes.add("img.src");
        this.attributes.add("img.alt");
        this.attributes.add("img.longdesc");
        this.attributes.add("img.height");
        this.attributes.add("img.width");
        this.attributes.add("img.usemap");
        this.attributes.add("img.ismap");
        this.attributes.add("map.name");
        this.attributes.add("area.shape");
        this.attributes.add("area.coords");
        this.attributes.add("area.href");
        this.attributes.add("area.nohref");
        this.attributes.add("area.alt");
        this.attributes.add("table.summary");
        this.attributes.add("table.width");
        this.attributes.add("table.border");
        this.attributes.add("table.frame");
        this.attributes.add("table.rules");
        this.attributes.add("table.cellspacing");
        this.attributes.add("table.cellpadding");
        this.defineEntities();
    }

    public boolean isTrimWhitespace() {
        return this.trimWhitespace;
    }

    public void setTrimWhitespace(boolean trimWhitespace) {
        this.trimWhitespace = trimWhitespace;
    }

    public boolean isMustBeWellFormed() {
        return this.mustBeWellFormed;
    }

    public XhtmlParser setMustBeWellFormed(boolean mustBeWellFormed) {
        this.mustBeWellFormed = mustBeWellFormed;
        return this;
    }

    public boolean isXmlMode() {
        return this.xmlMode;
    }

    public XhtmlParser setXmlMode(boolean xmlMode) {
        this.xmlMode = xmlMode;
        return this;
    }

    public ParserSecurityPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ParserSecurityPolicy policy) {
        this.policy = policy;
    }

    public List<StringPair> getValidationIssues() {
        return this.validationIssues;
    }

    public XhtmlNode parseHtmlNode(Element node) throws FHIRFormatError {
        return this.parseHtmlNode(node, null);
    }

    public XhtmlNode parseHtmlNode(Element node, String defaultNS) throws FHIRFormatError {
        XhtmlNode res = this.parseNode(node, defaultNS);
        if (res.getNsDecl() == null) {
            res.getAttributes().put("xmlns", XHTML_NS);
        }
        return res;
    }

    private XhtmlNode parseNode(Element node, String defaultNS) throws FHIRFormatError {
        XhtmlNode res = new XhtmlNode(NodeType.Element);
        res.setName(node.getLocalName());
        defaultNS = this.checkNS(res, node, defaultNS);
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Attr attr = (Attr)node.getAttributes().item(i);
            if (!this.attributeIsOk(res.getName(), attr.getName(), attr.getValue()) || attr.getLocalName().startsWith("xmlns")) continue;
            res.getAttributes().put(attr.getName(), attr.getValue());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3) {
                res.addText(child.getTextContent());
                continue;
            }
            if (child.getNodeType() == 8) {
                res.addComment(child.getTextContent());
                continue;
            }
            if (child.getNodeType() == 1) {
                if (!this.elementIsOk(child.getLocalName())) continue;
                res.getChildNodes().add(this.parseNode((Element)child, defaultNS));
                continue;
            }
            throw new FHIRFormatError("Unhandled XHTML feature: " + Integer.toString(child.getNodeType()) + this.descLoc());
        }
        return res;
    }

    private String checkNS(XhtmlNode res, Element node, String defaultNS) {
        String ns = node.getNamespaceURI();
        if (ns == null) {
            return null;
        }
        if (!ns.equals(defaultNS)) {
            res.getAttributes().put("xmlns", ns);
            return ns;
        }
        return defaultNS;
    }

    public XhtmlNode parseHtmlNode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        XhtmlNode res = this.parseNode(xpp);
        if (res.getNsDecl() == null) {
            res.getAttributes().put("xmlns", XHTML_NS);
        }
        return res;
    }

    private XhtmlNode parseNode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        XhtmlNode res = new XhtmlNode(NodeType.Element);
        res.setName(xpp.getName());
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            Object an = "xml".equals(xpp.getAttributePrefix(i)) ? "xml:" + xpp.getAttributeName(i) : xpp.getAttributeName(i);
            String av = xpp.getAttributeValue(i);
            if (!this.attributeIsOk(xpp.getName(), (String)an, av)) continue;
            res.getAttributes().put((String)an, av);
        }
        int eventType = xpp.next();
        while (eventType != 3) {
            if (eventType == 4) {
                res.addText(xpp.getText());
                xpp.next();
            } else if (eventType == 9) {
                res.addComment(xpp.getText());
                xpp.next();
            } else if (eventType == 2) {
                if (this.elementIsOk(xpp.getName())) {
                    res.getChildNodes().add(this.parseNode(xpp));
                }
            } else {
                throw new FHIRFormatError("Unhandled XHTML feature: " + Integer.toString(eventType) + this.descLoc());
            }
            eventType = xpp.getEventType();
        }
        xpp.next();
        return res;
    }

    private boolean attributeIsOk(String elem, String attr, String value) throws FHIRFormatError {
        boolean ok;
        boolean bl = ok = this.attributes.contains(attr) || this.attributes.contains(elem + "." + attr);
        if (ok) {
            return true;
        }
        switch (this.policy) {
            case Accept: {
                return true;
            }
            case Drop: {
                return false;
            }
            case Reject: {
                return this.error("XHTML_XHTML_Attribute_Illegal", elem + "." + attr);
            }
        }
        if ((elem + "." + attr).equals("img.src") && !value.startsWith("#") && !value.startsWith("http:") && !value.startsWith("https:")) {
            switch (this.policy) {
                case Accept: {
                    return true;
                }
                case Drop: {
                    return false;
                }
                case Reject: {
                    return this.error("XHTML_XHTML_Image_Reference_Illegal", value);
                }
            }
        }
        return false;
    }

    private boolean error(String msg, String param) {
        this.validationIssues.add(new StringPair(msg, param));
        return false;
    }

    private boolean elementIsOk(String name) throws FHIRFormatError {
        boolean ok = this.elements.contains(name);
        if (ok) {
            return true;
        }
        switch (this.policy) {
            case Accept: {
                return true;
            }
            case Drop: {
                return false;
            }
            case Reject: {
                return this.error("XHTML_XHTML_Element_Illegal", name);
            }
        }
        return false;
    }

    private String descLoc() {
        return " at line " + Integer.toString(this.line) + " column " + Integer.toString(this.col);
    }

    public XhtmlDocument parse(String source, String entryName) throws FHIRFormatError, IOException {
        this.rdr = new StringReader(source);
        return this.parse(entryName);
    }

    public XhtmlDocument parse(InputStream input, String entryName) throws FHIRFormatError, IOException {
        this.rdr = new InputStreamReader(input, StandardCharsets.UTF_8);
        return this.parse(entryName);
    }

    private XhtmlDocument parse(String entryName) throws FHIRFormatError, IOException {
        XhtmlDocument result = new XhtmlDocument();
        this.skipWhiteSpaceAndComments(result);
        if (this.peekChar() != '<') {
            throw new FHIRFormatError("Unable to Parse HTML - does not start with tag. Found " + this.peekChar() + this.descLoc());
        }
        this.readChar();
        this.markLocation();
        ElementName n = new ElementName(this.readName().toLowerCase());
        if (entryName != null && !n.getName().equals(entryName)) {
            throw new FHIRFormatError("Unable to Parse HTML - starts with '" + n + "' not '" + entryName + "'" + this.descLoc());
        }
        XhtmlNode root = result.addTag(n.getName());
        root.setLocation(this.markLocation());
        this.parseAttributes(root);
        this.markLocation();
        NamespaceNormalizationMap nsm = this.normalizeNamespaces(n, root, null, true);
        if (this.readChar() == '/') {
            if (this.peekChar() != '>') {
                throw new FHIRFormatError("unexpected non-end of element " + n + " " + this.descLoc());
            }
            this.readChar();
            root.setEmptyExpanded(false);
        } else {
            this.unwindPoint = null;
            ArrayList<XhtmlNode> p = new ArrayList<XhtmlNode>();
            this.parseElementInner(root, p, nsm, true);
            root.setEmptyExpanded(true);
        }
        return result;
    }

    private XhtmlNode.Location markLocation() {
        XhtmlNode.Location res = this.lastLoc;
        this.lastLoc = new XhtmlNode.Location(this.line, this.col);
        return res;
    }

    private NamespaceNormalizationMap normalizeNamespaces(ElementName elementName, XhtmlNode node, NamespaceNormalizationMap parentNamespaceMap, boolean nodeIsRoot) {
        String elementNamespace;
        NamespaceNormalizationMap nodeNamespaceMap = new NamespaceNormalizationMap(parentNamespaceMap);
        ArrayList<String> namespaceAttributes = new ArrayList<String>();
        for (String string : node.getAttributes().keySet()) {
            if (string.equals("xmlns")) {
                nodeNamespaceMap.setDefaultNamespace(node.getAttribute(string));
                namespaceAttributes.add(string);
            }
            if (!string.startsWith("xmlns:")) continue;
            nodeNamespaceMap.putNamespacePrefix(string.substring(6), node.getAttribute(string));
            namespaceAttributes.add(string);
        }
        for (String string : namespaceAttributes) {
            node.getAttributes().remove(string);
        }
        if (elementName.hasNamespace() && !(elementNamespace = nodeNamespaceMap.getNamespaceForPrefix(elementName.getNamespace())).equals(nodeNamespaceMap.getDefaultNamespace())) {
            node.getAttributes().put("xmlns", elementNamespace);
            nodeNamespaceMap.setDefaultNamespace(elementNamespace);
            nodeNamespaceMap.setOriginalNamespacePrefix(elementName.getNamespace());
            nodeNamespaceMap.map.remove(elementName.getNamespace());
        }
        if (XhtmlParser.shouldAddXmlnsNamespaceAttribute(parentNamespaceMap, nodeIsRoot, nodeNamespaceMap)) {
            node.getAttributes().put("xmlns", nodeNamespaceMap.getDefaultNamespace());
        }
        for (Map.Entry entry : nodeNamespaceMap.getPrefixNamespaceEntrySet()) {
            if (!XhtmlParser.shouldAddXmlnsNamespacePrefixAttribute(parentNamespaceMap, nodeIsRoot, (String)entry.getKey())) continue;
            node.getAttributes().put("xmlns:" + (String)entry.getKey(), (String)entry.getValue());
        }
        return nodeNamespaceMap;
    }

    private static boolean shouldAddXmlnsNamespacePrefixAttribute(NamespaceNormalizationMap parentNamespaceMap, boolean nodeIsRoot, String attributeKey) {
        if (nodeIsRoot) {
            return true;
        }
        return !parentNamespaceMap.map.containsKey(attributeKey);
    }

    private static boolean shouldAddXmlnsNamespaceAttribute(NamespaceNormalizationMap parentNamespaceMap, boolean nodeIsRoot, NamespaceNormalizationMap nodeNamespaceMap) {
        if (nodeIsRoot) {
            return nodeNamespaceMap.hasDefaultNamespace();
        }
        return nodeNamespaceMap.hasDefaultNamespace() && (parentNamespaceMap == null || !nodeNamespaceMap.getDefaultNamespace().equals(parentNamespaceMap.getDefaultNamespace()));
    }

    private void addTextNode(XhtmlNode node, StringBuilder s) {
        String t;
        String string = t = this.isTrimWhitespace() ? s.toString().trim() : s.toString();
        if (t.length() > 0) {
            this.lastText = t;
            node.addText(t).setLocation(this.markLocation());
            s.setLength(0);
        }
    }

    private void parseElementInner(XhtmlNode node, List<XhtmlNode> parents, NamespaceNormalizationMap nsm, boolean escaping) throws FHIRFormatError, IOException {
        StringBuilder s = new StringBuilder();
        while (this.peekChar() != '\uffff' && !parents.contains(this.unwindPoint) && node != this.unwindPoint) {
            if (this.peekChar() == '<') {
                this.addTextNode(node, s);
                this.readChar();
                if (this.peekChar() == '!') {
                    String sc = this.readToCommentEnd();
                    node.addComment(sc).setLocation(this.markLocation());
                    continue;
                }
                if (this.peekChar() == '?') {
                    node.addComment(this.readToTagEnd()).setLocation(this.markLocation());
                    continue;
                }
                if (this.peekChar() == '/') {
                    int i;
                    this.readChar();
                    ElementName n = new ElementName(this.readToTagEnd());
                    if (node.getName().equals(n.getName())) {
                        return;
                    }
                    if (this.mustBeWellFormed) {
                        throw new FHIRFormatError("Malformed XHTML: Found \"</" + n.getName() + ">\" expecting \"</" + node.getName() + ">\"" + this.descLoc());
                    }
                    for (i = parents.size() - 1; i >= 0; --i) {
                        if (!parents.get(i).getName().equals(n)) continue;
                        this.unwindPoint = parents.get(i);
                    }
                    if (this.unwindPoint == null) continue;
                    for (i = parents.size(); i > 0; --i) {
                        if (i < parents.size() && parents.get(i) == this.unwindPoint) {
                            return;
                        }
                        if (i == parents.size()) {
                            parents.get(i - 1).getChildNodes().addAll(node.getChildNodes());
                            node.getChildNodes().clear();
                            continue;
                        }
                        parents.get(i - 1).getChildNodes().addAll(parents.get(i).getChildNodes());
                        parents.get(i).getChildNodes().clear();
                    }
                    continue;
                }
                if (Character.isLetterOrDigit(this.peekChar())) {
                    this.parseElement(node, parents, nsm);
                    continue;
                }
                throw new FHIRFormatError("Unable to Parse HTML - node '" + node.getName() + "' has unexpected content '" + this.peekChar() + "' (last text = '" + this.lastText + "'" + this.descLoc());
            }
            if (this.peekChar() == '&') {
                this.parseLiteral(s);
                continue;
            }
            s.append(this.readChar());
        }
        this.addTextNode(node, s);
    }

    private void parseElement(XhtmlNode parent, List<XhtmlNode> parents, NamespaceNormalizationMap namespaceMap) throws IOException, FHIRFormatError {
        this.markLocation();
        ElementName name = new ElementName(this.readName());
        XhtmlNode node = parent.addTag(name.getName());
        node.setLocation(this.markLocation());
        ArrayList<XhtmlNode> newParents = new ArrayList<XhtmlNode>();
        newParents.addAll(parents);
        newParents.add(parent);
        this.parseAttributes(node);
        this.markLocation();
        namespaceMap = this.normalizeNamespaces(name, node, namespaceMap, false);
        if (this.readChar() == '/') {
            if (this.peekChar() != '>') {
                throw new FHIRFormatError("unexpected non-end of element " + name + " " + this.descLoc());
            }
            this.readChar();
            node.setEmptyExpanded(false);
        } else {
            node.setEmptyExpanded(true);
            this.parseElementInner(node, newParents, namespaceMap, "script".equals(name.getName()));
        }
    }

    private void parseAttributes(XhtmlNode node) throws FHIRFormatError, IOException {
        while (Character.isWhitespace(this.peekChar())) {
            this.readChar();
        }
        while (this.peekChar() != '>' && this.peekChar() != '/' && this.peekChar() != '\uffff') {
            String name = this.readName();
            if (name.length() == 0) {
                throw new FHIRFormatError("Unable to read attribute on <" + node.getName() + ">" + this.descLoc());
            }
            while (Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
            if (this.isNameChar(this.peekChar()) || this.peekChar() == '>' || this.peekChar() == '/') {
                node.getAttributes().put(name, null);
            } else {
                if (this.peekChar() != '=') {
                    throw new FHIRFormatError("Unable to read attribute '" + name + "' value on <" + node.getName() + ">" + this.descLoc());
                }
                this.readChar();
                while (Character.isWhitespace(this.peekChar())) {
                    this.readChar();
                }
                if (this.peekChar() == '\"' || this.peekChar() == '\'') {
                    node.getAttributes().put(name, this.parseAttributeValue(this.readChar()));
                } else {
                    node.getAttributes().put(name, this.parseAttributeValue('\uffff'));
                }
            }
            while (Character.isWhitespace(this.peekChar())) {
                this.readChar();
            }
        }
    }

    private String parseAttributeValue(char term) throws IOException, FHIRFormatError {
        StringBuilder b = new StringBuilder();
        while (this.peekChar() != '\uffff' && this.peekChar() != '>' && (term != '\uffff' || this.peekChar() != '/') && this.peekChar() != term) {
            if (this.peekChar() == '&') {
                this.parseLiteral(b);
                continue;
            }
            b.append(this.readChar());
        }
        if (this.peekChar() == term) {
            this.readChar();
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void skipWhiteSpaceAndComments(XhtmlNode focus) throws IOException, FHIRFormatError {
        while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
            this.readChar();
        }
        if (this.peekChar() != '<') return;
        char ch = this.readChar();
        if (this.peekChar() == '!') {
            this.readChar();
            if (this.peekChar() == '-') {
                this.readChar();
                if (this.peekChar() != '-') throw new FHIRFormatError("unrecognised element type <!" + this.peekChar() + this.descLoc());
                this.readChar();
                if (this.peekChar() == ' ') {
                    this.readChar();
                }
                focus.addComment(this.readToCommentEnd());
            } else {
                focus.addDocType(this.readToDocTypeEnd());
            }
            this.skipWhiteSpaceAndComments(focus);
            return;
        } else if (this.peekChar() == '?') {
            String r = this.readToTagEnd();
            focus.addInstruction(r.substring(1, r.length() - 1));
            this.skipWhiteSpaceAndComments(focus);
            return;
        } else {
            this.pushChar(ch);
        }
    }

    private void skipWhiteSpace() throws IOException {
        if (this.trimWhitespace) {
            while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
                this.readChar();
            }
        }
    }

    private void skipWhiteSpaceInternal() throws IOException {
        while (Character.isWhitespace(this.peekChar()) || this.peekChar() == '\ufeff') {
            this.readChar();
        }
    }

    private void pushChar(char ch) {
        this.cache = Character.toString(ch) + this.cache;
    }

    private char peekChar() throws IOException {
        if (this.cache.length() > 0) {
            return this.cache.charAt(0);
        }
        if (!this.rdr.ready()) {
            return '\uffff';
        }
        int i = this.rdr.read();
        if (i == -1) {
            this.cache = "";
            return '\uffff';
        }
        char c = (char)i;
        this.cache = Character.toString(c);
        return c;
    }

    private char readChar() throws IOException {
        char c;
        if (this.cache.length() > 0) {
            c = this.cache.charAt(0);
            this.cache = this.cache.length() == 1 ? "" : this.cache.substring(1);
        } else {
            c = !this.rdr.ready() ? (char)'\uffff' : (char)((char)this.rdr.read());
        }
        if (c == '\r' || c == '\n') {
            if (c == '\r' || this.lastChar != '\r') {
                ++this.line;
                this.col = 0;
            }
            this.lastChar = c;
        }
        ++this.col;
        return c;
    }

    private String readToTagEnd() throws IOException, FHIRFormatError {
        StringBuilder s = new StringBuilder();
        while (this.peekChar() != '>' && this.peekChar() != '\uffff') {
            s.append(this.readChar());
        }
        if (this.peekChar() != '\uffff') {
            this.readChar();
            this.skipWhiteSpace();
        } else if (this.mustBeWellFormed) {
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        return s.toString();
    }

    private String readToDocTypeEnd() throws IOException, FHIRFormatError {
        StringBuilder s = new StringBuilder();
        boolean done = false;
        while (!done) {
            char c = this.peekChar();
            if (c == '>') {
                done = true;
                this.readChar();
                continue;
            }
            if (c != '\uffff') {
                s.append(this.readChar());
                continue;
            }
            if (!this.mustBeWellFormed) continue;
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        return s.toString();
    }

    private String readToCommentEnd() throws IOException, FHIRFormatError {
        if (this.peekChar() == '!') {
            this.readChar();
        }
        StringBuilder s = new StringBuilder();
        boolean simple = true;
        if (this.peekChar() == '-') {
            this.readChar();
            boolean bl = simple = this.peekChar() != '-';
            if (simple) {
                s.append('-');
            } else {
                this.readChar();
            }
        }
        boolean doctypeEntities = false;
        boolean done = false;
        while (!done) {
            char c = this.peekChar();
            if (c == '-') {
                this.readChar();
                if (this.peekChar() == '-') {
                    this.readChar();
                    if (this.peekChar() == '>') {
                        done = true;
                        continue;
                    }
                    this.pushChar('-');
                    s.append("-");
                    continue;
                }
                s.append('-');
                continue;
            }
            if (doctypeEntities && c == ']') {
                s.append(this.readChar());
                if (this.peekChar() != '>') continue;
                done = true;
                continue;
            }
            if (simple && this.peekChar() == '>' && !doctypeEntities) {
                done = true;
                continue;
            }
            if (c == '[' && s.toString().startsWith("DOCTYPE ")) {
                doctypeEntities = true;
                s.append(this.readChar());
                continue;
            }
            if (c != '\uffff') {
                s.append(this.readChar());
                continue;
            }
            if (!this.mustBeWellFormed) continue;
            throw new FHIRFormatError("Unexpected termination of html source" + this.descLoc());
        }
        if (this.peekChar() != '\uffff') {
            this.readChar();
            this.skipWhiteSpace();
        }
        if (doctypeEntities) {
            this.parseDoctypeEntities(s.toString());
        }
        return s.toString();
    }

    private void parseDoctypeEntities(String s) {
        while (s.contains("<!ENTITY")) {
            s = s.substring(s.indexOf("<!ENTITY"));
            int e = s.indexOf(">");
            String ed = s.substring(0, e + 1);
            s = s.substring(e + 1);
            ed = ed.substring(8).trim();
            e = ed.indexOf(" ");
            String n = ed.substring(0, e).trim();
            ed = ed.substring(e).trim();
            e = ed.indexOf(" ");
            ed = ed.substring(e).trim();
            String v = ed.substring(0, ed.length() - 1);
            this.declaredEntities.put(n, v);
        }
    }

    private boolean isNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '-' || ch == ':';
    }

    private String readName() throws IOException {
        StringBuilder s = new StringBuilder();
        while (this.isNameChar(this.peekChar())) {
            s.append(this.readChar());
        }
        return s.toString();
    }

    private String readUntil(char ch) throws IOException {
        StringBuilder s = new StringBuilder();
        while (this.peekChar() != '\u0000' && this.peekChar() != ch) {
            s.append(this.readChar());
        }
        this.readChar();
        return s.toString();
    }

    private String readUntil(String sc) throws IOException {
        StringBuilder s = new StringBuilder();
        while (this.peekChar() != '\u0000' && sc.indexOf(this.peekChar()) == -1) {
            s.append(this.readChar());
        }
        this.readChar();
        return s.toString();
    }

    private void parseLiteral(StringBuilder s) throws IOException, FHIRFormatError {
        this.readChar();
        String c = this.readUntil(";&'\"><");
        if (c.isEmpty()) {
            throw new FHIRFormatError("Invalid literal declaration following text: " + s);
        }
        if (c.charAt(0) == '#') {
            if (this.isInteger(c.substring(1), 10)) {
                s.append((char)Integer.parseInt(c.substring(1)));
            } else if (c.charAt(1) == 'x' && this.isInteger(c.substring(2), 16)) {
                s.append((char)Integer.parseInt(c.substring(2), 16));
            }
        } else if (this.declaredEntities.containsKey(c)) {
            s.append(this.declaredEntities.get(c));
        } else {
            if (this.xmlMode && !Utilities.existsInList(c, "quot", "amp", "apos", "lt", "gt")) {
                this.error("XHTML_XHTML_Entity_Illegal", "&" + c + ";");
            }
            if (this.definedEntities.containsKey(c)) {
                s.append(this.definedEntities.get(c));
            } else if (c.equals("apos")) {
                s.append('\'');
            } else if (c.equals("quot")) {
                s.append('\"');
            } else if (c.equals("nbsp")) {
                s.append(XhtmlNode.NBSP);
            } else if (c.equals("amp")) {
                s.append('&');
            } else if (c.equals("lsquo")) {
                s.append('\u2018');
            } else if (c.equals("rsquo")) {
                s.append('\u2019');
            } else if (c.equals("gt")) {
                s.append('>');
            } else if (c.equals("lt")) {
                s.append('<');
            } else if (c.equals("copy")) {
                s.append('\u00a9');
            } else if (c.equals("reg")) {
                s.append('\u00ae');
            } else if (c.equals("sect")) {
                s.append('\u00a7');
            } else if (c.equals("fnof")) {
                s.append('\u0192');
            } else if (c.equals("Alpha")) {
                s.append('\u0391');
            } else if (c.equals("Beta")) {
                s.append('\u0392');
            } else if (c.equals("Gamma")) {
                s.append('\u0393');
            } else if (c.equals("Delta")) {
                s.append('\u0394');
            } else if (c.equals("Epsilon")) {
                s.append('\u0395');
            } else if (c.equals("Zeta")) {
                s.append('\u0396');
            } else if (c.equals("Eta")) {
                s.append('\u0397');
            } else if (c.equals("Theta")) {
                s.append('\u0398');
            } else if (c.equals("Iota")) {
                s.append('\u0399');
            } else if (c.equals("Kappa")) {
                s.append('\u039a');
            } else if (c.equals("Lambda")) {
                s.append('\u039b');
            } else if (c.equals("Mu")) {
                s.append('\u039c');
            } else if (c.equals("Nu")) {
                s.append('\u039d');
            } else if (c.equals("Xi")) {
                s.append('\u039e');
            } else if (c.equals("Omicron")) {
                s.append('\u039f');
            } else if (c.equals("Pi")) {
                s.append('\u03a0');
            } else if (c.equals("Rho")) {
                s.append('\u03a1');
            } else if (c.equals("Sigma")) {
                s.append('\u03a3');
            } else if (c.equals("Tau")) {
                s.append('\u03a4');
            } else if (c.equals("Upsilon")) {
                s.append('\u03a5');
            } else if (c.equals("Phi")) {
                s.append('\u03a6');
            } else if (c.equals("Chi")) {
                s.append('\u03a7');
            } else if (c.equals("Psi")) {
                s.append('\u03a8');
            } else if (c.equals("Omega")) {
                s.append('\u03a9');
            } else if (c.equals("alpha")) {
                s.append('\u03b1');
            } else if (c.equals("beta")) {
                s.append('\u03b2');
            } else if (c.equals("gamma")) {
                s.append('\u03b3');
            } else if (c.equals("delta")) {
                s.append('\u03b4');
            } else if (c.equals("epsilon")) {
                s.append('\u03b5');
            } else if (c.equals("zeta")) {
                s.append('\u03b6');
            } else if (c.equals("eta")) {
                s.append('\u03b7');
            } else if (c.equals("theta")) {
                s.append('\u03b8');
            } else if (c.equals("iota")) {
                s.append('\u03b9');
            } else if (c.equals("kappa")) {
                s.append('\u03ba');
            } else if (c.equals("lambda")) {
                s.append('\u03bb');
            } else if (c.equals("mu")) {
                s.append('\u03bc');
            } else if (c.equals("nu")) {
                s.append('\u03bd');
            } else if (c.equals("xi")) {
                s.append('\u03be');
            } else if (c.equals("omicron")) {
                s.append('\u03bf');
            } else if (c.equals("pi")) {
                s.append('\u03c0');
            } else if (c.equals("rho")) {
                s.append('\u03c1');
            } else if (c.equals("sigmaf")) {
                s.append('\u03c2');
            } else if (c.equals("sigma")) {
                s.append('\u03c3');
            } else if (c.equals("tau")) {
                s.append('\u03c4');
            } else if (c.equals("upsilon")) {
                s.append('\u03c5');
            } else if (c.equals("phi")) {
                s.append('\u03c6');
            } else if (c.equals("chi")) {
                s.append('\u03c7');
            } else if (c.equals("psi")) {
                s.append('\u03c8');
            } else if (c.equals("omega")) {
                s.append('\u03c9');
            } else if (c.equals("thetasym")) {
                s.append('\u03d1');
            } else if (c.equals("upsih")) {
                s.append('\u03d2');
            } else if (c.equals("piv")) {
                s.append('\u03d6');
            } else if (c.equals("bull")) {
                s.append('\u2022');
            } else if (c.equals("hellip")) {
                s.append('\u2026');
            } else if (c.equals("prime")) {
                s.append('\u2032');
            } else if (c.equals("Prime")) {
                s.append('\u2033');
            } else if (c.equals("oline")) {
                s.append('\u203e');
            } else if (c.equals("frasl")) {
                s.append('\u2044');
            } else if (c.equals("weierp")) {
                s.append('\u2118');
            } else if (c.equals("image")) {
                s.append('\u2111');
            } else if (c.equals("real")) {
                s.append('\u211c');
            } else if (c.equals("trade")) {
                s.append('\u2122');
            } else if (c.equals("alefsym")) {
                s.append('\u2135');
            } else if (c.equals("larr")) {
                s.append('\u2190');
            } else if (c.equals("uarr")) {
                s.append('\u2191');
            } else if (c.equals("rarr")) {
                s.append('\u2192');
            } else if (c.equals("darr")) {
                s.append('\u2193');
            } else if (c.equals("harr")) {
                s.append('\u2194');
            } else if (c.equals("crarr")) {
                s.append('\u21b5');
            } else if (c.equals("lArr")) {
                s.append('\u21d0');
            } else if (c.equals("uArr")) {
                s.append('\u21d1');
            } else if (c.equals("rArr")) {
                s.append('\u21d2');
            } else if (c.equals("dArr")) {
                s.append('\u21d3');
            } else if (c.equals("hArr")) {
                s.append('\u21d4');
            } else if (c.equals("forall")) {
                s.append('\u2200');
            } else if (c.equals("part")) {
                s.append('\u2202');
            } else if (c.equals("exist")) {
                s.append('\u2203');
            } else if (c.equals("empty")) {
                s.append('\u2205');
            } else if (c.equals("nabla")) {
                s.append('\u2207');
            } else if (c.equals("isin")) {
                s.append('\u2208');
            } else if (c.equals("notin")) {
                s.append('\u2209');
            } else if (c.equals("ni")) {
                s.append('\u220b');
            } else if (c.equals("prod")) {
                s.append('\u220f');
            } else if (c.equals("sum")) {
                s.append('\u2211');
            } else if (c.equals("minus")) {
                s.append('\u2212');
            } else if (c.equals("lowast")) {
                s.append('\u2217');
            } else if (c.equals("radic")) {
                s.append('\u221a');
            } else if (c.equals("prop")) {
                s.append('\u221d');
            } else if (c.equals("infin")) {
                s.append('\u221e');
            } else if (c.equals("ang")) {
                s.append('\u2220');
            } else if (c.equals("and")) {
                s.append('\u2227');
            } else if (c.equals("or")) {
                s.append('\u2228');
            } else if (c.equals("cap")) {
                s.append('\u2229');
            } else if (c.equals("cup")) {
                s.append('\u222a');
            } else if (c.equals("int")) {
                s.append('\u222b');
            } else if (c.equals("there4")) {
                s.append('\u2234');
            } else if (c.equals("sim")) {
                s.append('\u223c');
            } else if (c.equals("cong")) {
                s.append('\u2245');
            } else if (c.equals("asymp")) {
                s.append('\u2248');
            } else if (c.equals("ne")) {
                s.append('\u2260');
            } else if (c.equals("equiv")) {
                s.append('\u2261');
            } else if (c.equals("le")) {
                s.append('\u2264');
            } else if (c.equals("ge")) {
                s.append('\u2265');
            } else if (c.equals("sub")) {
                s.append('\u2282');
            } else if (c.equals("sup")) {
                s.append('\u2283');
            } else if (c.equals("nsub")) {
                s.append('\u2284');
            } else if (c.equals("sube")) {
                s.append('\u2286');
            } else if (c.equals("supe")) {
                s.append('\u2287');
            } else if (c.equals("oplus")) {
                s.append('\u2295');
            } else if (c.equals("otimes")) {
                s.append('\u2297');
            } else if (c.equals("perp")) {
                s.append('\u22a5');
            } else if (c.equals("sdot")) {
                s.append('\u22c5');
            } else if (c.equals("lceil")) {
                s.append('\u2308');
            } else if (c.equals("rceil")) {
                s.append('\u2309');
            } else if (c.equals("lfloor")) {
                s.append('\u230a');
            } else if (c.equals("rfloor")) {
                s.append('\u230b');
            } else if (c.equals("lang")) {
                s.append('\u2329');
            } else if (c.equals("rang")) {
                s.append('\u232a');
            } else if (c.equals("loz")) {
                s.append('\u25ca');
            } else if (c.equals("spades")) {
                s.append('\u2660');
            } else if (c.equals("clubs")) {
                s.append('\u2663');
            } else if (c.equals("hearts")) {
                s.append('\u2665');
            } else if (c.equals("diams")) {
                s.append('\u2666');
            } else if (c.equals("ndash")) {
                s.append('\u2013');
            } else if (c.equals("mdash")) {
                s.append('\u2014');
            } else if (c.equals("ldquo")) {
                s.append('\u201d');
            } else if (c.equals("rdquo")) {
                s.append('\u00c9');
            } else if (c.equals("frac14")) {
                s.append('\u00bc');
            } else if (!this.mustBeWellFormed) {
                s.append("&" + c);
            } else {
                throw new FHIRFormatError("unable to parse character reference '" + c + "'' (last text = '" + this.lastText + "'" + this.descLoc());
            }
        }
    }

    private boolean isInteger(String s, int base) {
        try {
            Integer.parseInt(s, base);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public XhtmlNode parseFragment(String source) throws IOException, FHIRException {
        this.rdr = new StringReader(source);
        return this.parseFragment();
    }

    public XhtmlNode parseFragment(InputStream input) throws IOException, FHIRException {
        this.rdr = new InputStreamReader(input);
        return this.parseFragment();
    }

    private XhtmlNode parseFragment() throws IOException, FHIRException {
        this.skipWhiteSpace();
        if (this.peekChar() != '<') {
            throw new FHIRException("Unable to Parse HTML - does not start with tag. Found " + this.peekChar() + this.descLoc());
        }
        this.readChar();
        if (this.peekChar() == '?') {
            this.readToTagEnd();
            this.skipWhiteSpaceInternal();
            if (this.peekChar() != '<') {
                throw new FHIRException("Unable to Parse HTML - does not start with tag after processing instruction. Found " + this.peekChar() + this.descLoc());
            }
            this.readChar();
        }
        String n = this.readName().toLowerCase();
        this.readToTagEnd();
        XhtmlNode result = new XhtmlNode(NodeType.Element);
        int colonIndex = n.indexOf(58);
        if (colonIndex != -1) {
            n = n.substring(colonIndex + 1);
        }
        result.setName(n);
        this.unwindPoint = null;
        ArrayList<XhtmlNode> p = new ArrayList<XhtmlNode>();
        this.parseElementInner(result, p, null, true);
        return result;
    }

    private void defineEntities() {
        this.definedEntities.put("&AElig;", "\u00c6");
        this.definedEntities.put("&AMP;", "&");
        this.definedEntities.put("&Aacute;", "\u00c1");
        this.definedEntities.put("&Abreve;", "\u0102");
        this.definedEntities.put("&Acirc;", "\u00c2");
        this.definedEntities.put("&Acy;", "\u0410");
        this.definedEntities.put("&Afr;", "\ud835\udd04");
        this.definedEntities.put("&Agrave;", "\u00c0");
        this.definedEntities.put("&Alpha;", "\u0391");
        this.definedEntities.put("&Amacr;", "\u0100");
        this.definedEntities.put("&And;", "\u2a53");
        this.definedEntities.put("&Aogon;", "\u0104");
        this.definedEntities.put("&Aopf;", "\ud835\udd38");
        this.definedEntities.put("&ApplyFunction;", "\u2061");
        this.definedEntities.put("&Aring;", "\u00c5");
        this.definedEntities.put("&Ascr;", "\ud835\udc9c");
        this.definedEntities.put("&Assign;", "\u2254");
        this.definedEntities.put("&Atilde;", "\u00c3");
        this.definedEntities.put("&Auml;", "\u00c4");
        this.definedEntities.put("&Backslash;", "\u2216");
        this.definedEntities.put("&Barv;", "\u2ae7");
        this.definedEntities.put("&Barwed;", "\u2306");
        this.definedEntities.put("&Bcy;", "\u0411");
        this.definedEntities.put("&Because;", "\u2235");
        this.definedEntities.put("&Bernoullis;", "\u212c");
        this.definedEntities.put("&Beta;", "\u0392");
        this.definedEntities.put("&Bfr;", "\ud835\udd05");
        this.definedEntities.put("&Bopf;", "\ud835\udd39");
        this.definedEntities.put("&Breve;", "\u02d8");
        this.definedEntities.put("&Bscr;", "\u212c");
        this.definedEntities.put("&Bumpeq;", "\u224e");
        this.definedEntities.put("&CHcy;", "\u0427");
        this.definedEntities.put("&COPY;", "\u00a9");
        this.definedEntities.put("&Cacute;", "\u0106");
        this.definedEntities.put("&Cap;", "\u22d2");
        this.definedEntities.put("&CapitalDifferentialD;", "\u2145");
        this.definedEntities.put("&Cayleys;", "\u212d");
        this.definedEntities.put("&Ccaron;", "\u010c");
        this.definedEntities.put("&Ccedil;", "\u00c7");
        this.definedEntities.put("&Ccirc;", "\u0108");
        this.definedEntities.put("&Cconint;", "\u2230");
        this.definedEntities.put("&Cdot;", "\u010a");
        this.definedEntities.put("&Cedilla;", "\u00b8");
        this.definedEntities.put("&CenterDot;", "\u00b7");
        this.definedEntities.put("&Cfr;", "\u212d");
        this.definedEntities.put("&Chi;", "\u03a7");
        this.definedEntities.put("&CircleDot;", "\u2299");
        this.definedEntities.put("&CircleMinus;", "\u2296");
        this.definedEntities.put("&CirclePlus;", "\u2295");
        this.definedEntities.put("&CircleTimes;", "\u2297");
        this.definedEntities.put("&ClockwiseContourIntegral;", "\u2232");
        this.definedEntities.put("&CloseCurlyDoubleQuote;", "\u201d");
        this.definedEntities.put("&CloseCurlyQuote;", "\u2019");
        this.definedEntities.put("&Colon;", "\u2237");
        this.definedEntities.put("&Colone;", "\u2a74");
        this.definedEntities.put("&Congruent;", "\u2261");
        this.definedEntities.put("&Conint;", "\u222f");
        this.definedEntities.put("&ContourIntegral;", "\u222e");
        this.definedEntities.put("&Copf;", "\u2102");
        this.definedEntities.put("&Coproduct;", "\u2210");
        this.definedEntities.put("&CounterClockwiseContourIntegral;", "\u2233");
        this.definedEntities.put("&Cross;", "\u2a2f");
        this.definedEntities.put("&Cscr;", "\ud835\udc9e");
        this.definedEntities.put("&Cup;", "\u22d3");
        this.definedEntities.put("&CupCap;", "\u224d");
        this.definedEntities.put("&DD;", "\u2145");
        this.definedEntities.put("&DDotrahd;", "\u2911");
        this.definedEntities.put("&DJcy;", "\u0402");
        this.definedEntities.put("&DScy;", "\u0405");
        this.definedEntities.put("&DZcy;", "\u040f");
        this.definedEntities.put("&Dagger;", "\u2021");
        this.definedEntities.put("&Darr;", "\u21a1");
        this.definedEntities.put("&Dashv;", "\u2ae4");
        this.definedEntities.put("&Dcaron;", "\u010e");
        this.definedEntities.put("&Dcy;", "\u0414");
        this.definedEntities.put("&Del;", "\u2207");
        this.definedEntities.put("&Delta;", "\u0394");
        this.definedEntities.put("&Dfr;", "\ud835\udd07");
        this.definedEntities.put("&DiacriticalAcute;", "\u00b4");
        this.definedEntities.put("&DiacriticalDot;", "\u02d9");
        this.definedEntities.put("&DiacriticalDoubleAcute;", "\u02dd");
        this.definedEntities.put("&DiacriticalGrave;", "`");
        this.definedEntities.put("&DiacriticalTilde;", "\u02dc");
        this.definedEntities.put("&Diamond;", "\u22c4");
        this.definedEntities.put("&DifferentialD;", "\u2146");
        this.definedEntities.put("&Dopf;", "\ud835\udd3b");
        this.definedEntities.put("&Dot;", "\u00a8");
        this.definedEntities.put("&DotDot;", "\u20dc");
        this.definedEntities.put("&DotEqual;", "\u2250");
        this.definedEntities.put("&DoubleContourIntegral;", "\u222f");
        this.definedEntities.put("&DoubleDot;", "\u00a8");
        this.definedEntities.put("&DoubleDownArrow;", "\u21d3");
        this.definedEntities.put("&DoubleLeftArrow;", "\u21d0");
        this.definedEntities.put("&DoubleLeftRightArrow;", "\u21d4");
        this.definedEntities.put("&DoubleLeftTee;", "\u2ae4");
        this.definedEntities.put("&DoubleLongLeftArrow;", "\u27f8");
        this.definedEntities.put("&DoubleLongLeftRightArrow;", "\u27fa");
        this.definedEntities.put("&DoubleLongRightArrow;", "\u27f9");
        this.definedEntities.put("&DoubleRightArrow;", "\u21d2");
        this.definedEntities.put("&DoubleRightTee;", "\u22a8");
        this.definedEntities.put("&DoubleUpArrow;", "\u21d1");
        this.definedEntities.put("&DoubleUpDownArrow;", "\u21d5");
        this.definedEntities.put("&DoubleVerticalBar;", "\u2225");
        this.definedEntities.put("&DownArrow;", "\u2193");
        this.definedEntities.put("&DownArrowBar;", "\u2913");
        this.definedEntities.put("&DownArrowUpArrow;", "\u21f5");
        this.definedEntities.put("&DownBreve;", "\u0311");
        this.definedEntities.put("&DownLeftRightVector;", "\u2950");
        this.definedEntities.put("&DownLeftTeeVector;", "\u295e");
        this.definedEntities.put("&DownLeftVector;", "\u21bd");
        this.definedEntities.put("&DownLeftVectorBar;", "\u2956");
        this.definedEntities.put("&DownRightTeeVector;", "\u295f");
        this.definedEntities.put("&DownRightVector;", "\u21c1");
        this.definedEntities.put("&DownRightVectorBar;", "\u2957");
        this.definedEntities.put("&DownTee;", "\u22a4");
        this.definedEntities.put("&DownTeeArrow;", "\u21a7");
        this.definedEntities.put("&Downarrow;", "\u21d3");
        this.definedEntities.put("&Dscr;", "\ud835\udc9f");
        this.definedEntities.put("&Dstrok;", "\u0110");
        this.definedEntities.put("&ENG;", "\u014a");
        this.definedEntities.put("&ETH;", "\u00d0");
        this.definedEntities.put("&Eacute;", "\u00c9");
        this.definedEntities.put("&Ecaron;", "\u011a");
        this.definedEntities.put("&Ecirc;", "\u00ca");
        this.definedEntities.put("&Ecy;", "\u042d");
        this.definedEntities.put("&Edot;", "\u0116");
        this.definedEntities.put("&Efr;", "\ud835\udd08");
        this.definedEntities.put("&Egrave;", "\u00c8");
        this.definedEntities.put("&Element;", "\u2208");
        this.definedEntities.put("&Emacr;", "\u0112");
        this.definedEntities.put("&EmptySmallSquare;", "\u25fb");
        this.definedEntities.put("&EmptyVerySmallSquare;", "\u25ab");
        this.definedEntities.put("&Eogon;", "\u0118");
        this.definedEntities.put("&Eopf;", "\ud835\udd3c");
        this.definedEntities.put("&Epsilon;", "\u0395");
        this.definedEntities.put("&Equal;", "\u2a75");
        this.definedEntities.put("&EqualTilde;", "\u2242");
        this.definedEntities.put("&Equilibrium;", "\u21cc");
        this.definedEntities.put("&Escr;", "\u2130");
        this.definedEntities.put("&Esim;", "\u2a73");
        this.definedEntities.put("&Eta;", "\u0397");
        this.definedEntities.put("&Euml;", "\u00cb");
        this.definedEntities.put("&Exists;", "\u2203");
        this.definedEntities.put("&ExponentialE;", "\u2147");
        this.definedEntities.put("&Fcy;", "\u0424");
        this.definedEntities.put("&Ffr;", "\ud835\udd09");
        this.definedEntities.put("&FilledSmallSquare;", "\u25fc");
        this.definedEntities.put("&FilledVerySmallSquare;", "\u25aa");
        this.definedEntities.put("&Fopf;", "\ud835\udd3d");
        this.definedEntities.put("&ForAll;", "\u2200");
        this.definedEntities.put("&Fouriertrf;", "\u2131");
        this.definedEntities.put("&Fscr;", "\u2131");
        this.definedEntities.put("&GJcy;", "\u0403");
        this.definedEntities.put("&GT;", ">");
        this.definedEntities.put("&Gamma;", "\u0393");
        this.definedEntities.put("&Gammad;", "\u03dc");
        this.definedEntities.put("&Gbreve;", "\u011e");
        this.definedEntities.put("&Gcedil;", "\u0122");
        this.definedEntities.put("&Gcirc;", "\u011c");
        this.definedEntities.put("&Gcy;", "\u0413");
        this.definedEntities.put("&Gdot;", "\u0120");
        this.definedEntities.put("&Gfr;", "\ud835\udd0a");
        this.definedEntities.put("&Gg;", "\u22d9");
        this.definedEntities.put("&Gopf;", "\ud835\udd3e");
        this.definedEntities.put("&GreaterEqual;", "\u2265");
        this.definedEntities.put("&GreaterEqualLess;", "\u22db");
        this.definedEntities.put("&GreaterFullEqual;", "\u2267");
        this.definedEntities.put("&GreaterGreater;", "\u2aa2");
        this.definedEntities.put("&GreaterLess;", "\u2277");
        this.definedEntities.put("&GreaterSlantEqual;", "\u2a7e");
        this.definedEntities.put("&GreaterTilde;", "\u2273");
        this.definedEntities.put("&Gscr;", "\ud835\udca2");
        this.definedEntities.put("&Gt;", "\u226b");
        this.definedEntities.put("&HARDcy;", "\u042a");
        this.definedEntities.put("&Hacek;", "\u02c7");
        this.definedEntities.put("&Hat;", "^");
        this.definedEntities.put("&Hcirc;", "\u0124");
        this.definedEntities.put("&Hfr;", "\u210c");
        this.definedEntities.put("&HilbertSpace;", "\u210b");
        this.definedEntities.put("&Hopf;", "\u210d");
        this.definedEntities.put("&HorizontalLine;", "\u2500");
        this.definedEntities.put("&Hscr;", "\u210b");
        this.definedEntities.put("&Hstrok;", "\u0126");
        this.definedEntities.put("&HumpDownHump;", "\u224e");
        this.definedEntities.put("&HumpEqual;", "\u224f");
        this.definedEntities.put("&IEcy;", "\u0415");
        this.definedEntities.put("&IJlig;", "\u0132");
        this.definedEntities.put("&IOcy;", "\u0401");
        this.definedEntities.put("&Iacute;", "\u00cd");
        this.definedEntities.put("&Icirc;", "\u00ce");
        this.definedEntities.put("&Icy;", "\u0418");
        this.definedEntities.put("&Idot;", "\u0130");
        this.definedEntities.put("&Ifr;", "\u2111");
        this.definedEntities.put("&Igrave;", "\u00cc");
        this.definedEntities.put("&Im;", "\u2111");
        this.definedEntities.put("&Imacr;", "\u012a");
        this.definedEntities.put("&ImaginaryI;", "\u2148");
        this.definedEntities.put("&Implies;", "\u21d2");
        this.definedEntities.put("&Int;", "\u222c");
        this.definedEntities.put("&Integral;", "\u222b");
        this.definedEntities.put("&Intersection;", "\u22c2");
        this.definedEntities.put("&InvisibleComma;", "\u2063");
        this.definedEntities.put("&InvisibleTimes;", "\u2062");
        this.definedEntities.put("&Iogon;", "\u012e");
        this.definedEntities.put("&Iopf;", "\ud835\udd40");
        this.definedEntities.put("&Iota;", "\u0399");
        this.definedEntities.put("&Iscr;", "\u2110");
        this.definedEntities.put("&Itilde;", "\u0128");
        this.definedEntities.put("&Iukcy;", "\u0406");
        this.definedEntities.put("&Iuml;", "\u00cf");
        this.definedEntities.put("&Jcirc;", "\u0134");
        this.definedEntities.put("&Jcy;", "\u0419");
        this.definedEntities.put("&Jfr;", "\ud835\udd0d");
        this.definedEntities.put("&Jopf;", "\ud835\udd41");
        this.definedEntities.put("&Jscr;", "\ud835\udca5");
        this.definedEntities.put("&Jsercy;", "\u0408");
        this.definedEntities.put("&Jukcy;", "\u0404");
        this.definedEntities.put("&KHcy;", "\u0425");
        this.definedEntities.put("&KJcy;", "\u040c");
        this.definedEntities.put("&Kappa;", "\u039a");
        this.definedEntities.put("&Kcedil;", "\u0136");
        this.definedEntities.put("&Kcy;", "\u041a");
        this.definedEntities.put("&Kfr;", "\ud835\udd0e");
        this.definedEntities.put("&Kopf;", "\ud835\udd42");
        this.definedEntities.put("&Kscr;", "\ud835\udca6");
        this.definedEntities.put("&LJcy;", "\u0409");
        this.definedEntities.put("&LT;", "<");
        this.definedEntities.put("&Lacute;", "\u0139");
        this.definedEntities.put("&Lambda;", "\u039b");
        this.definedEntities.put("&Lang;", "\u27ea");
        this.definedEntities.put("&Laplacetrf;", "\u2112");
        this.definedEntities.put("&Larr;", "\u219e");
        this.definedEntities.put("&Lcaron;", "\u013d");
        this.definedEntities.put("&Lcedil;", "\u013b");
        this.definedEntities.put("&Lcy;", "\u041b");
        this.definedEntities.put("&LeftAngleBracket;", "\u27e8");
        this.definedEntities.put("&LeftArrow;", "\u2190");
        this.definedEntities.put("&LeftArrowBar;", "\u21e4");
        this.definedEntities.put("&LeftArrowRightArrow;", "\u21c6");
        this.definedEntities.put("&LeftCeiling;", "\u2308");
        this.definedEntities.put("&LeftDoubleBracket;", "\u27e6");
        this.definedEntities.put("&LeftDownTeeVector;", "\u2961");
        this.definedEntities.put("&LeftDownVector;", "\u21c3");
        this.definedEntities.put("&LeftDownVectorBar;", "\u2959");
        this.definedEntities.put("&LeftFloor;", "\u230a");
        this.definedEntities.put("&LeftRightArrow;", "\u2194");
        this.definedEntities.put("&LeftRightVector;", "\u294e");
        this.definedEntities.put("&LeftTee;", "\u22a3");
        this.definedEntities.put("&LeftTeeArrow;", "\u21a4");
        this.definedEntities.put("&LeftTeeVector;", "\u295a");
        this.definedEntities.put("&LeftTriangle;", "\u22b2");
        this.definedEntities.put("&LeftTriangleBar;", "\u29cf");
        this.definedEntities.put("&LeftTriangleEqual;", "\u22b4");
        this.definedEntities.put("&LeftUpDownVector;", "\u2951");
        this.definedEntities.put("&LeftUpTeeVector;", "\u2960");
        this.definedEntities.put("&LeftUpVector;", "\u21bf");
        this.definedEntities.put("&LeftUpVectorBar;", "\u2958");
        this.definedEntities.put("&LeftVector;", "\u21bc");
        this.definedEntities.put("&LeftVectorBar;", "\u2952");
        this.definedEntities.put("&Leftarrow;", "\u21d0");
        this.definedEntities.put("&Leftrightarrow;", "\u21d4");
        this.definedEntities.put("&LessEqualGreater;", "\u22da");
        this.definedEntities.put("&LessFullEqual;", "\u2266");
        this.definedEntities.put("&LessGreater;", "\u2276");
        this.definedEntities.put("&LessLess;", "\u2aa1");
        this.definedEntities.put("&LessSlantEqual;", "\u2a7d");
        this.definedEntities.put("&LessTilde;", "\u2272");
        this.definedEntities.put("&Lfr;", "\ud835\udd0f");
        this.definedEntities.put("&Ll;", "\u22d8");
        this.definedEntities.put("&Lleftarrow;", "\u21da");
        this.definedEntities.put("&Lmidot;", "\u013f");
        this.definedEntities.put("&LongLeftArrow;", "\u27f5");
        this.definedEntities.put("&LongLeftRightArrow;", "\u27f7");
        this.definedEntities.put("&LongRightArrow;", "\u27f6");
        this.definedEntities.put("&Longleftarrow;", "\u27f8");
        this.definedEntities.put("&Longleftrightarrow;", "\u27fa");
        this.definedEntities.put("&Longrightarrow;", "\u27f9");
        this.definedEntities.put("&Lopf;", "\ud835\udd43");
        this.definedEntities.put("&LowerLeftArrow;", "\u2199");
        this.definedEntities.put("&LowerRightArrow;", "\u2198");
        this.definedEntities.put("&Lscr;", "\u2112");
        this.definedEntities.put("&Lsh;", "\u21b0");
        this.definedEntities.put("&Lstrok;", "\u0141");
        this.definedEntities.put("&Lt;", "\u226a");
        this.definedEntities.put("&Map;", "\u2905");
        this.definedEntities.put("&Mcy;", "\u041c");
        this.definedEntities.put("&MediumSpace;", "\u205f");
        this.definedEntities.put("&Mellintrf;", "\u2133");
        this.definedEntities.put("&Mfr;", "\ud835\udd10");
        this.definedEntities.put("&MinusPlus;", "\u2213");
        this.definedEntities.put("&Mopf;", "\ud835\udd44");
        this.definedEntities.put("&Mscr;", "\u2133");
        this.definedEntities.put("&Mu;", "\u039c");
        this.definedEntities.put("&NJcy;", "\u040a");
        this.definedEntities.put("&Nacute;", "\u0143");
        this.definedEntities.put("&Ncaron;", "\u0147");
        this.definedEntities.put("&Ncedil;", "\u0145");
        this.definedEntities.put("&Ncy;", "\u041d");
        this.definedEntities.put("&NegativeMediumSpace;", "\u200b");
        this.definedEntities.put("&NegativeThickSpace;", "\u200b");
        this.definedEntities.put("&NegativeThinSpace;", "\u200b");
        this.definedEntities.put("&NegativeVeryThinSpace;", "\u200b");
        this.definedEntities.put("&NestedGreaterGreater;", "\u226b");
        this.definedEntities.put("&NestedLessLess;", "\u226a");
        this.definedEntities.put("&NewLine;", "\n");
        this.definedEntities.put("&Nfr;", "\ud835\udd11");
        this.definedEntities.put("&NoBreak;", "\u2060");
        this.definedEntities.put("&NonBreakingSpace;", "\u00a0");
        this.definedEntities.put("&Nopf;", "\u2115");
        this.definedEntities.put("&Not;", "\u2aec");
        this.definedEntities.put("&NotCongruent;", "\u2262");
        this.definedEntities.put("&NotCupCap;", "\u226d");
        this.definedEntities.put("&NotDoubleVerticalBar;", "\u2226");
        this.definedEntities.put("&NotElement;", "\u2209");
        this.definedEntities.put("&NotEqual;", "\u2260");
        this.definedEntities.put("&NotEqualTilde;", "\u2242\u0338");
        this.definedEntities.put("&NotExists;", "\u2204");
        this.definedEntities.put("&NotGreater;", "\u226f");
        this.definedEntities.put("&NotGreaterEqual;", "\u2271");
        this.definedEntities.put("&NotGreaterFullEqual;", "\u22673");
        this.definedEntities.put("&NotGreaterGreater;", "\u226b3");
        this.definedEntities.put("&NotGreaterLess;", "\u2279");
        this.definedEntities.put("&NotGreaterSlantEqual;", "\u2a7e\u0338");
        this.definedEntities.put("&NotGreaterTilde;", "\u2275");
        this.definedEntities.put("&NotHumpDownHump;", "\u224e\u0338");
        this.definedEntities.put("&NotHumpEqual;", "\u224f\u0338");
        this.definedEntities.put("&NotLeftTriangle;", "\u22ea");
        this.definedEntities.put("&NotLeftTriangleBar;", "\u29cf\u0338");
        this.definedEntities.put("&NotLeftTriangleEqual;", "\u22ec");
        this.definedEntities.put("&NotLess;", "\u226e");
        this.definedEntities.put("&NotLessEqual;", "\u2270");
        this.definedEntities.put("&NotLessGreater;", "\u2278");
        this.definedEntities.put("&NotLessLess;", "\u226a\u0338");
        this.definedEntities.put("&NotLessSlantEqual;", "\u2a7d\u0338");
        this.definedEntities.put("&NotLessTilde;", "\u2274");
        this.definedEntities.put("&NotNestedGreaterGreater;", "\u2aa2\u0338");
        this.definedEntities.put("&NotNestedLessLess;", "\u2aa1\u0338");
        this.definedEntities.put("&NotPrecedes;", "\u2280");
        this.definedEntities.put("&NotPrecedesEqual;", "\u2aaf\u0338");
        this.definedEntities.put("&NotPrecedesSlantEqual;", "\u22e0");
        this.definedEntities.put("&NotReverseElement;", "\u220c");
        this.definedEntities.put("&NotRightTriangle;", "\u22eb");
        this.definedEntities.put("&NotRightTriangleBar;", "\u29d0\u0338");
        this.definedEntities.put("&NotRightTriangleEqual;", "\u22ed");
        this.definedEntities.put("&NotSquareSubset;", "\u228f\u0338");
        this.definedEntities.put("&NotSquareSubsetEqual;", "\u22e2");
        this.definedEntities.put("&NotSquareSuperset;", "\u2290\u0338");
        this.definedEntities.put("&NotSquareSupersetEqual;", "\u22e3");
        this.definedEntities.put("&NotSubset;", "\u2282\u20d2");
        this.definedEntities.put("&NotSubsetEqual;", "\u2288");
        this.definedEntities.put("&NotSucceeds;", "\u2281");
        this.definedEntities.put("&NotSucceedsEqual;", "\u2ab0\u0338");
        this.definedEntities.put("&NotSucceedsSlantEqual;", "\u22e1");
        this.definedEntities.put("&NotSucceedsTilde;", "\u227f\u0338");
        this.definedEntities.put("&NotSuperset;", "\u2283\u20d2");
        this.definedEntities.put("&NotSupersetEqual;", "\u2289");
        this.definedEntities.put("&NotTilde;", "\u2241");
        this.definedEntities.put("&NotTildeEqual;", "\u2244");
        this.definedEntities.put("&NotTildeFullEqual;", "\u2247");
        this.definedEntities.put("&NotTildeTilde;", "\u2249");
        this.definedEntities.put("&NotVerticalBar;", "\u2224");
        this.definedEntities.put("&Nscr;", "\ud835\udca9");
        this.definedEntities.put("&Ntilde;", "\u00d1");
        this.definedEntities.put("&Nu;", "\u039d");
        this.definedEntities.put("&OElig;", "\u0152");
        this.definedEntities.put("&Oacute;", "\u00d3");
        this.definedEntities.put("&Ocirc;", "\u00d4");
        this.definedEntities.put("&Ocy;", "\u041e");
        this.definedEntities.put("&Odblac;", "\u0150");
        this.definedEntities.put("&Ofr;", "\ud835\udd12");
        this.definedEntities.put("&Ograve;", "\u00d2");
        this.definedEntities.put("&Omacr;", "\u014c");
        this.definedEntities.put("&Omega;", "\u03a9");
        this.definedEntities.put("&Omicron;", "\u039f");
        this.definedEntities.put("&Oopf;", "\ud835\udd46");
        this.definedEntities.put("&OpenCurlyDoubleQuote;", "\u201c");
        this.definedEntities.put("&OpenCurlyQuote;", "\u2018");
        this.definedEntities.put("&Or;", "\u2a54");
        this.definedEntities.put("&Oscr;", "\ud835\udcaa");
        this.definedEntities.put("&Oslash;", "\u00d8");
        this.definedEntities.put("&Otilde;", "\u00d5");
        this.definedEntities.put("&Otimes;", "\u2a37");
        this.definedEntities.put("&Ouml;", "\u00d6");
        this.definedEntities.put("&OverBar;", "\u203e");
        this.definedEntities.put("&OverBrace;", "\u23de");
        this.definedEntities.put("&OverBracket;", "\u23b4");
        this.definedEntities.put("&OverParenthesis;", "\u23dc");
        this.definedEntities.put("&PartialD;", "\u2202");
        this.definedEntities.put("&Pcy;", "\u041f");
        this.definedEntities.put("&Pfr;", "\ud835\udd13");
        this.definedEntities.put("&Phi;", "\u03a6");
        this.definedEntities.put("&Pi;", "\u03a0");
        this.definedEntities.put("&PlusMinus;", "\u00b1");
        this.definedEntities.put("&Poincareplane;", "\u210c");
        this.definedEntities.put("&Popf;", "\u2119");
        this.definedEntities.put("&Pr;", "\u2abb");
        this.definedEntities.put("&Precedes;", "\u227a");
        this.definedEntities.put("&PrecedesEqual;", "\u2aaf");
        this.definedEntities.put("&PrecedesSlantEqual;", "\u227c");
        this.definedEntities.put("&PrecedesTilde;", "\u227e");
        this.definedEntities.put("&Prime;", "\u2033");
        this.definedEntities.put("&Product;", "\u220f");
        this.definedEntities.put("&Proportion;", "\u2237");
        this.definedEntities.put("&Proportional;", "\u221d");
        this.definedEntities.put("&Pscr;", "\ud835\udcab");
        this.definedEntities.put("&Psi;", "\u03a8");
        this.definedEntities.put("&QUOT;", "\\u0022");
        this.definedEntities.put("&Qfr;", "\ud835\udd14");
        this.definedEntities.put("&Qopf;", "\u211a");
        this.definedEntities.put("&Qscr;", "\ud835\udcac");
        this.definedEntities.put("&RBarr;", "\u2910");
        this.definedEntities.put("&REG;", "\u00ae");
        this.definedEntities.put("&Racute;", "\u0154");
        this.definedEntities.put("&Rang;", "\u27eb");
        this.definedEntities.put("&Rarr;", "\u21a0");
        this.definedEntities.put("&Rarrtl;", "\u2916");
        this.definedEntities.put("&Rcaron;", "\u0158");
        this.definedEntities.put("&Rcedil;", "\u0156");
        this.definedEntities.put("&Rcy;", "\u0420");
        this.definedEntities.put("&Re;", "\u211c");
        this.definedEntities.put("&ReverseElement;", "\u220b");
        this.definedEntities.put("&ReverseEquilibrium;", "\u21cb");
        this.definedEntities.put("&ReverseUpEquilibrium;", "\u296f");
        this.definedEntities.put("&Rfr;", "\u211c");
        this.definedEntities.put("&Rho;", "\u03a1");
        this.definedEntities.put("&RightAngleBracket;", "\u27e9");
        this.definedEntities.put("&RightArrow;", "\u2192");
        this.definedEntities.put("&RightArrowBar;", "\u21e5");
        this.definedEntities.put("&RightArrowLeftArrow;", "\u21c4");
        this.definedEntities.put("&RightCeiling;", "\u2309");
        this.definedEntities.put("&RightDoubleBracket;", "\u27e7");
        this.definedEntities.put("&RightDownTeeVector;", "\u295d");
        this.definedEntities.put("&RightDownVector;", "\u21c2");
        this.definedEntities.put("&RightDownVectorBar;", "\u2955");
        this.definedEntities.put("&RightFloor;", "\u230b");
        this.definedEntities.put("&RightTee;", "\u22a2");
        this.definedEntities.put("&RightTeeArrow;", "\u21a6");
        this.definedEntities.put("&RightTeeVector;", "\u295b");
        this.definedEntities.put("&RightTriangle;", "\u22b3");
        this.definedEntities.put("&RightTriangleBar;", "\u29d0");
        this.definedEntities.put("&RightTriangleEqual;", "\u22b5");
        this.definedEntities.put("&RightUpDownVector;", "\u294f");
        this.definedEntities.put("&RightUpTeeVector;", "\u295c");
        this.definedEntities.put("&RightUpVector;", "\u21be");
        this.definedEntities.put("&RightUpVectorBar;", "\u2954");
        this.definedEntities.put("&RightVector;", "\u21c0");
        this.definedEntities.put("&RightVectorBar;", "\u2953");
        this.definedEntities.put("&Rightarrow;", "\u21d2");
        this.definedEntities.put("&Ropf;", "\u211d");
        this.definedEntities.put("&RoundImplies;", "\u2970");
        this.definedEntities.put("&Rrightarrow;", "\u21db");
        this.definedEntities.put("&Rscr;", "\u211b");
        this.definedEntities.put("&Rsh;", "\u21b1");
        this.definedEntities.put("&RuleDelayed;", "\u29f4");
        this.definedEntities.put("&SHCHcy;", "\u0429");
        this.definedEntities.put("&SHcy;", "\u0428");
        this.definedEntities.put("&SOFTcy;", "\u042c");
        this.definedEntities.put("&Sacute;", "\u015a");
        this.definedEntities.put("&Sc;", "\u2abc");
        this.definedEntities.put("&Scaron;", "\u0160");
        this.definedEntities.put("&Scedil;", "\u015e");
        this.definedEntities.put("&Scirc;", "\u015c");
        this.definedEntities.put("&Scy;", "\u0421");
        this.definedEntities.put("&Sfr;", "\ud835\udd16");
        this.definedEntities.put("&ShortDownArrow;", "\u2193");
        this.definedEntities.put("&ShortLeftArrow;", "\u2190");
        this.definedEntities.put("&ShortRightArrow;", "\u2192");
        this.definedEntities.put("&ShortUpArrow;", "\u2191");
        this.definedEntities.put("&Sigma;", "\u03a3");
        this.definedEntities.put("&SmallCircle;", "\u2218");
        this.definedEntities.put("&Sopf;", "\ud835\udd4a");
        this.definedEntities.put("&Sqrt;", "\u221a");
        this.definedEntities.put("&Square;", "\u25a1");
        this.definedEntities.put("&SquareIntersection;", "\u2293");
        this.definedEntities.put("&SquareSubset;", "\u228f");
        this.definedEntities.put("&SquareSubsetEqual;", "\u2291");
        this.definedEntities.put("&SquareSuperset;", "\u2290");
        this.definedEntities.put("&SquareSupersetEqual;", "\u2292");
        this.definedEntities.put("&SquareUnion;", "\u2294");
        this.definedEntities.put("&Sscr;", "\ud835\udcae");
        this.definedEntities.put("&Star;", "\u22c6");
        this.definedEntities.put("&Sub;", "\u22d0");
        this.definedEntities.put("&Subset;", "\u22d0");
        this.definedEntities.put("&SubsetEqual;", "\u2286");
        this.definedEntities.put("&Succeeds;", "\u227b");
        this.definedEntities.put("&SucceedsEqual;", "\u2ab0");
        this.definedEntities.put("&SucceedsSlantEqual;", "\u227d");
        this.definedEntities.put("&SucceedsTilde;", "\u227f");
        this.definedEntities.put("&SuchThat;", "\u220b");
        this.definedEntities.put("&Sum;", "\u2211");
        this.definedEntities.put("&Sup;", "\u22d1");
        this.definedEntities.put("&Superset;", "\u2283");
        this.definedEntities.put("&SupersetEqual;", "\u2287");
        this.definedEntities.put("&Supset;", "\u22d1");
        this.definedEntities.put("&THORN;", "\u00de");
        this.definedEntities.put("&TRADE;", "\u2122");
        this.definedEntities.put("&TSHcy;", "\u040b");
        this.definedEntities.put("&TScy;", "\u0426");
        this.definedEntities.put("&Tab;", "\t");
        this.definedEntities.put("&Tau;", "\u03a4");
        this.definedEntities.put("&Tcaron;", "\u0164");
        this.definedEntities.put("&Tcedil;", "\u0162");
        this.definedEntities.put("&Tcy;", "\u0422");
        this.definedEntities.put("&Tfr;", "\ud835\udd17");
        this.definedEntities.put("&Therefore;", "\u2234");
        this.definedEntities.put("&Theta;", "\u0398");
        this.definedEntities.put("&ThickSpace;", "\u205f\u200a");
        this.definedEntities.put("&ThinSpace;", "\u2009");
        this.definedEntities.put("&Tilde;", "\u223c");
        this.definedEntities.put("&TildeEqual;", "\u2243");
        this.definedEntities.put("&TildeFullEqual;", "\u2245");
        this.definedEntities.put("&TildeTilde;", "\u2248");
        this.definedEntities.put("&Topf;", "\ud835\udd4b");
        this.definedEntities.put("&TripleDot;", "\u20db");
        this.definedEntities.put("&Tscr;", "\ud835\udcaf");
        this.definedEntities.put("&Tstrok;", "\u0166");
        this.definedEntities.put("&Uacute;", "\u00da");
        this.definedEntities.put("&Uarr;", "\u219f");
        this.definedEntities.put("&Uarrocir;", "\u2949");
        this.definedEntities.put("&Ubrcy;", "\u040e");
        this.definedEntities.put("&Ubreve;", "\u016c");
        this.definedEntities.put("&Ucirc;", "\u00db");
        this.definedEntities.put("&Ucy;", "\u0423");
        this.definedEntities.put("&Udblac;", "\u0170");
        this.definedEntities.put("&Ufr;", "\ud835\udd18");
        this.definedEntities.put("&Ugrave;", "\u00d9");
        this.definedEntities.put("&Umacr;", "\u016a");
        this.definedEntities.put("&UnderBar;", "_");
        this.definedEntities.put("&UnderBrace;", "\u23df");
        this.definedEntities.put("&UnderBracket;", "\u23b5");
        this.definedEntities.put("&UnderParenthesis;", "\u23dd");
        this.definedEntities.put("&Union;", "\u22c3");
        this.definedEntities.put("&UnionPlus;", "\u228e");
        this.definedEntities.put("&Uogon;", "\u0172");
        this.definedEntities.put("&Uopf;", "\ud835\udd4c");
        this.definedEntities.put("&UpArrow;", "\u2191");
        this.definedEntities.put("&UpArrowBar;", "\u2912");
        this.definedEntities.put("&UpArrowDownArrow;", "\u21c5");
        this.definedEntities.put("&UpDownArrow;", "\u2195");
        this.definedEntities.put("&UpEquilibrium;", "\u296e");
        this.definedEntities.put("&UpTee;", "\u22a5");
        this.definedEntities.put("&UpTeeArrow;", "\u21a5");
        this.definedEntities.put("&Uparrow;", "\u21d1");
        this.definedEntities.put("&Updownarrow;", "\u21d5");
        this.definedEntities.put("&UpperLeftArrow;", "\u2196");
        this.definedEntities.put("&UpperRightArrow;", "\u2197");
        this.definedEntities.put("&Upsi;", "\u03d2");
        this.definedEntities.put("&Upsilon;", "\u03a5");
        this.definedEntities.put("&Uring;", "\u016e");
        this.definedEntities.put("&Uscr;", "\ud835\udcb0");
        this.definedEntities.put("&Utilde;", "\u0168");
        this.definedEntities.put("&Uuml;", "\u00dc");
        this.definedEntities.put("&VDash;", "\u22ab");
        this.definedEntities.put("&Vbar;", "\u2aeb");
        this.definedEntities.put("&Vcy;", "\u0412");
        this.definedEntities.put("&Vdash;", "\u22a9");
        this.definedEntities.put("&Vdashl;", "\u2ae6");
        this.definedEntities.put("&Vee;", "\u22c1");
        this.definedEntities.put("&Verbar;", "\u2016");
        this.definedEntities.put("&Vert;", "\u2016");
        this.definedEntities.put("&VerticalBar;", "\u2223");
        this.definedEntities.put("&VerticalLine;", "|");
        this.definedEntities.put("&VerticalSeparator;", "\u2758");
        this.definedEntities.put("&VerticalTilde;", "\u2240");
        this.definedEntities.put("&VeryThinSpace;", "\u200a");
        this.definedEntities.put("&Vfr;", "\ud835\udd19");
        this.definedEntities.put("&Vopf;", "\ud835\udd4d");
        this.definedEntities.put("&Vscr;", "\ud835\udcb1");
        this.definedEntities.put("&Vvdash;", "\u22aa");
        this.definedEntities.put("&Wcirc;", "\u0174");
        this.definedEntities.put("&Wedge;", "\u22c0");
        this.definedEntities.put("&Wfr;", "\ud835\udd1a");
        this.definedEntities.put("&Wopf;", "\ud835\udd4e");
        this.definedEntities.put("&Wscr;", "\ud835\udcb2");
        this.definedEntities.put("&Xfr;", "\ud835\udd1b");
        this.definedEntities.put("&Xi;", "\u039e");
        this.definedEntities.put("&Xopf;", "\ud835\udd4f");
        this.definedEntities.put("&Xscr;", "\ud835\udcb3");
        this.definedEntities.put("&YAcy;", "\u042f");
        this.definedEntities.put("&YIcy;", "\u0407");
        this.definedEntities.put("&YUcy;", "\u042e");
        this.definedEntities.put("&Yacute;", "\u00dd");
        this.definedEntities.put("&Ycirc;", "\u0176");
        this.definedEntities.put("&Ycy;", "\u042b");
        this.definedEntities.put("&Yfr;", "\ud835\udd1c");
        this.definedEntities.put("&Yopf;", "\ud835\udd50");
        this.definedEntities.put("&Yscr;", "\ud835\udcb4");
        this.definedEntities.put("&Yuml;", "\u0178");
        this.definedEntities.put("&ZHcy;", "\u0416");
        this.definedEntities.put("&Zacute;", "\u0179");
        this.definedEntities.put("&Zcaron;", "\u017d");
        this.definedEntities.put("&Zcy;", "\u0417");
        this.definedEntities.put("&Zdot;", "\u017b");
        this.definedEntities.put("&ZeroWidthSpace;", "\u200b");
        this.definedEntities.put("&Zeta;", "\u0396");
        this.definedEntities.put("&Zfr;", "\u2128");
        this.definedEntities.put("&Zopf;", "\u2124");
        this.definedEntities.put("&Zscr;", "\ud835\udcb5");
        this.definedEntities.put("&aacute;", "\u00e1");
        this.definedEntities.put("&abreve;", "\u0103");
        this.definedEntities.put("&ac;", "\u223e");
        this.definedEntities.put("&acE;", "\u223e\u0333");
        this.definedEntities.put("&acd;", "\u223f");
        this.definedEntities.put("&acirc;", "\u00e2");
        this.definedEntities.put("&acute;", "\u00b4");
        this.definedEntities.put("&acy;", "\u0430");
        this.definedEntities.put("&aelig;", "\u00e6");
        this.definedEntities.put("&af;", "\u2061");
        this.definedEntities.put("&afr;", "\ud835\udd1e");
        this.definedEntities.put("&agrave;", "\u00e0");
        this.definedEntities.put("&alefsym;", "\u2135");
        this.definedEntities.put("&aleph;", "\u2135");
        this.definedEntities.put("&alpha;", "\u03b1");
        this.definedEntities.put("&amacr;", "\u0101");
        this.definedEntities.put("&amalg;", "\u2a3f");
        this.definedEntities.put("&amp;", "&");
        this.definedEntities.put("&and;", "\u2227");
        this.definedEntities.put("&andand;", "\u2a55");
        this.definedEntities.put("&andd;", "\u2a5c");
        this.definedEntities.put("&andslope;", "\u2a58");
        this.definedEntities.put("&andv;", "\u2a5a");
        this.definedEntities.put("&ang;", "\u2220");
        this.definedEntities.put("&ange;", "\u29a4");
        this.definedEntities.put("&angle;", "\u2220");
        this.definedEntities.put("&angmsd;", "\u2221");
        this.definedEntities.put("&angmsdaa;", "\u29a8");
        this.definedEntities.put("&angmsdab;", "\u29a9");
        this.definedEntities.put("&angmsdac;", "\u29aa");
        this.definedEntities.put("&angmsdad;", "\u29ab");
        this.definedEntities.put("&angmsdae;", "\u29ac");
        this.definedEntities.put("&angmsdaf;", "\u29ad");
        this.definedEntities.put("&angmsdag;", "\u29ae");
        this.definedEntities.put("&angmsdah;", "\u29af");
        this.definedEntities.put("&angrt;", "\u221f");
        this.definedEntities.put("&angrtvb;", "\u22be");
        this.definedEntities.put("&angrtvbd;", "\u299d");
        this.definedEntities.put("&angsph;", "\u2222");
        this.definedEntities.put("&angst;", "\u00c5");
        this.definedEntities.put("&angzarr;", "\u237c");
        this.definedEntities.put("&aogon;", "\u0105");
        this.definedEntities.put("&aopf;", "\ud835\udd52");
        this.definedEntities.put("&ap;", "\u2248");
        this.definedEntities.put("&apE;", "\u2a70");
        this.definedEntities.put("&apacir;", "\u2a6f");
        this.definedEntities.put("&ape;", "\u224a");
        this.definedEntities.put("&apid;", "\u224b");
        this.definedEntities.put("&apos;", "'");
        this.definedEntities.put("&approx;", "\u2248");
        this.definedEntities.put("&approxeq;", "\u224a");
        this.definedEntities.put("&aring;", "\u00e5");
        this.definedEntities.put("&ascr;", "\ud835\udcb6");
        this.definedEntities.put("&ast;", "*");
        this.definedEntities.put("&asymp;", "\u2248");
        this.definedEntities.put("&asympeq;", "\u224d");
        this.definedEntities.put("&atilde;", "\u00e3");
        this.definedEntities.put("&auml;", "\u00e4");
        this.definedEntities.put("&awconint;", "\u2233");
        this.definedEntities.put("&awint;", "\u2a11");
        this.definedEntities.put("&bNot;", "\u2aed");
        this.definedEntities.put("&backcong;", "\u224c");
        this.definedEntities.put("&backepsilon;", "\u03f6");
        this.definedEntities.put("&backprime;", "\u2035");
        this.definedEntities.put("&backsim;", "\u223d");
        this.definedEntities.put("&backsimeq;", "\u22cd");
        this.definedEntities.put("&barvee;", "\u22bd");
        this.definedEntities.put("&barwed;", "\u2305");
        this.definedEntities.put("&barwedge;", "\u2305");
        this.definedEntities.put("&bbrk;", "\u23b5");
        this.definedEntities.put("&bbrktbrk;", "\u23b6");
        this.definedEntities.put("&bcong;", "\u224c");
        this.definedEntities.put("&bcy;", "\u0431");
        this.definedEntities.put("&bdquo;", "\u201e");
        this.definedEntities.put("&becaus;", "\u2235");
        this.definedEntities.put("&because;", "\u2235");
        this.definedEntities.put("&bemptyv;", "\u29b0");
        this.definedEntities.put("&bepsi;", "\u03f6");
        this.definedEntities.put("&bernou;", "\u212c");
        this.definedEntities.put("&beta;", "\u03b2");
        this.definedEntities.put("&beth;", "\u2136");
        this.definedEntities.put("&between;", "\u226c");
        this.definedEntities.put("&bfr;", "\ud835\udd1f");
        this.definedEntities.put("&bigcap;", "\u22c2");
        this.definedEntities.put("&bigcirc;", "\u25ef");
        this.definedEntities.put("&bigcup;", "\u22c3");
        this.definedEntities.put("&bigodot;", "\u2a00");
        this.definedEntities.put("&bigoplus;", "\u2a01");
        this.definedEntities.put("&bigotimes;", "\u2a02");
        this.definedEntities.put("&bigsqcup;", "\u2a06");
        this.definedEntities.put("&bigstar;", "\u2605");
        this.definedEntities.put("&bigtriangledown;", "\u25bd");
        this.definedEntities.put("&bigtriangleup;", "\u25b3");
        this.definedEntities.put("&biguplus;", "\u2a04");
        this.definedEntities.put("&bigvee;", "\u22c1");
        this.definedEntities.put("&bigwedge;", "\u22c0");
        this.definedEntities.put("&bkarow;", "\u290d");
        this.definedEntities.put("&blacklozenge;", "\u29eb");
        this.definedEntities.put("&blacksquare;", "\u25aa");
        this.definedEntities.put("&blacktriangle;", "\u25b4");
        this.definedEntities.put("&blacktriangledown;", "\u25be");
        this.definedEntities.put("&blacktriangleleft;", "\u25c2");
        this.definedEntities.put("&blacktriangleright;", "\u25b8");
        this.definedEntities.put("&blank;", "\u2423");
        this.definedEntities.put("&blk12;", "\u2592");
        this.definedEntities.put("&blk14;", "\u2591");
        this.definedEntities.put("&blk34;", "\u2593");
        this.definedEntities.put("&block;", "\u2588");
        this.definedEntities.put("&bne;", "=\u20e5");
        this.definedEntities.put("&bnequiv;", "\u2261\u20e5");
        this.definedEntities.put("&bnot;", "\u2310");
        this.definedEntities.put("&bopf;", "\ud835\udd53");
        this.definedEntities.put("&bot;", "\u22a5");
        this.definedEntities.put("&bottom;", "\u22a5");
        this.definedEntities.put("&bowtie;", "\u22c8");
        this.definedEntities.put("&boxDL;", "\u2557");
        this.definedEntities.put("&boxDR;", "\u2554");
        this.definedEntities.put("&boxDl;", "\u2556");
        this.definedEntities.put("&boxDr;", "\u2553");
        this.definedEntities.put("&boxH;", "\u2550");
        this.definedEntities.put("&boxHD;", "\u2566");
        this.definedEntities.put("&boxHU;", "\u2569");
        this.definedEntities.put("&boxHd;", "\u2564");
        this.definedEntities.put("&boxHu;", "\u2567");
        this.definedEntities.put("&boxUL;", "\u255d");
        this.definedEntities.put("&boxUR;", "\u255a");
        this.definedEntities.put("&boxUl;", "\u255c");
        this.definedEntities.put("&boxUr;", "\u2559");
        this.definedEntities.put("&boxV;", "\u2551");
        this.definedEntities.put("&boxVH;", "\u256c");
        this.definedEntities.put("&boxVL;", "\u2563");
        this.definedEntities.put("&boxVR;", "\u2560");
        this.definedEntities.put("&boxVh;", "\u256b");
        this.definedEntities.put("&boxVl;", "\u2562");
        this.definedEntities.put("&boxVr;", "\u255f");
        this.definedEntities.put("&boxbox;", "\u29c9");
        this.definedEntities.put("&boxdL;", "\u2555");
        this.definedEntities.put("&boxdR;", "\u2552");
        this.definedEntities.put("&boxdl;", "\u2510");
        this.definedEntities.put("&boxdr;", "\u250c");
        this.definedEntities.put("&boxh;", "\u2500");
        this.definedEntities.put("&boxhD;", "\u2565");
        this.definedEntities.put("&boxhU;", "\u2568");
        this.definedEntities.put("&boxhd;", "\u252c");
        this.definedEntities.put("&boxhu;", "\u2534");
        this.definedEntities.put("&boxminus;", "\u229f");
        this.definedEntities.put("&boxplus;", "\u229e");
        this.definedEntities.put("&boxtimes;", "\u22a0");
        this.definedEntities.put("&boxuL;", "\u255b");
        this.definedEntities.put("&boxuR;", "\u2558");
        this.definedEntities.put("&boxul;", "\u2518");
        this.definedEntities.put("&boxur;", "\u2514");
        this.definedEntities.put("&boxv;", "\u2502");
        this.definedEntities.put("&boxvH;", "\u256a");
        this.definedEntities.put("&boxvL;", "\u2561");
        this.definedEntities.put("&boxvR;", "\u255e");
        this.definedEntities.put("&boxvh;", "\u253c");
        this.definedEntities.put("&boxvl;", "\u2524");
        this.definedEntities.put("&boxvr;", "\u251c");
        this.definedEntities.put("&bprime;", "\u2035");
        this.definedEntities.put("&breve;", "\u02d8");
        this.definedEntities.put("&brvbar;", "\u00a6");
        this.definedEntities.put("&bscr;", "\ud835\udcb7");
        this.definedEntities.put("&bsemi;", "\u204f");
        this.definedEntities.put("&bsim;", "\u223d");
        this.definedEntities.put("&bsime;", "\u22cd");
        this.definedEntities.put("&bsol;", "\\u005C");
        this.definedEntities.put("&bsolb;", "\u29c5");
        this.definedEntities.put("&bsolhsub;", "\u27c8");
        this.definedEntities.put("&bull;", "\u2022");
        this.definedEntities.put("&bullet;", "\u2022");
        this.definedEntities.put("&bump;", "\u224e");
        this.definedEntities.put("&bumpE;", "\u2aae");
        this.definedEntities.put("&bumpe;", "\u224f");
        this.definedEntities.put("&bumpeq;", "\u224f");
        this.definedEntities.put("&cacute;", "\u0107");
        this.definedEntities.put("&cap;", "\u2229");
        this.definedEntities.put("&capand;", "\u2a44");
        this.definedEntities.put("&capbrcup;", "\u2a49");
        this.definedEntities.put("&capcap;", "\u2a4b");
        this.definedEntities.put("&capcup;", "\u2a47");
        this.definedEntities.put("&capdot;", "\u2a40");
        this.definedEntities.put("&caps;", "\u2229\ufe00");
        this.definedEntities.put("&caret;", "\u2041");
        this.definedEntities.put("&caron;", "\u02c7");
        this.definedEntities.put("&ccaps;", "\u2a4d");
        this.definedEntities.put("&ccaron;", "\u010d");
        this.definedEntities.put("&ccedil;", "\u00e7");
        this.definedEntities.put("&ccirc;", "\u0109");
        this.definedEntities.put("&ccups;", "\u2a4c");
        this.definedEntities.put("&ccupssm;", "\u2a50");
        this.definedEntities.put("&cdot;", "\u010b");
        this.definedEntities.put("&cedil;", "\u00b8");
        this.definedEntities.put("&cemptyv;", "\u29b2");
        this.definedEntities.put("&cent;", "\u00a2");
        this.definedEntities.put("&centerdot;", "\u00b7");
        this.definedEntities.put("&cfr;", "\ud835\udd20");
        this.definedEntities.put("&chcy;", "\u0447");
        this.definedEntities.put("&check;", "\u2713");
        this.definedEntities.put("&checkmark;", "\u2713");
        this.definedEntities.put("&chi;", "\u03c7");
        this.definedEntities.put("&cir;", "\u25cb");
        this.definedEntities.put("&cirE;", "\u29c3");
        this.definedEntities.put("&circ;", "\u02c6");
        this.definedEntities.put("&circeq;", "\u2257");
        this.definedEntities.put("&circlearrowleft;", "\u21ba");
        this.definedEntities.put("&circlearrowright;", "\u21bb");
        this.definedEntities.put("&circledR;", "\u00ae");
        this.definedEntities.put("&circledS;", "\u24c8");
        this.definedEntities.put("&circledast;", "\u229b");
        this.definedEntities.put("&circledcirc;", "\u229a");
        this.definedEntities.put("&circleddash;", "\u229d");
        this.definedEntities.put("&cire;", "\u2257");
        this.definedEntities.put("&cirfnint;", "\u2a10");
        this.definedEntities.put("&cirmid;", "\u2aef");
        this.definedEntities.put("&cirscir;", "\u29c2");
        this.definedEntities.put("&clubs;", "\u2663");
        this.definedEntities.put("&clubsuit;", "\u2663");
        this.definedEntities.put("&colon;", ":");
        this.definedEntities.put("&colone;", "\u2254");
        this.definedEntities.put("&coloneq;", "\u2254");
        this.definedEntities.put("&comma;", ",");
        this.definedEntities.put("&commat;", "@");
        this.definedEntities.put("&comp;", "\u2201");
        this.definedEntities.put("&compfn;", "\u2218");
        this.definedEntities.put("&complement;", "\u2201");
        this.definedEntities.put("&complexes;", "\u2102");
        this.definedEntities.put("&cong;", "\u2245");
        this.definedEntities.put("&congdot;", "\u2a6d");
        this.definedEntities.put("&conint;", "\u222e");
        this.definedEntities.put("&copf;", "\ud835\udd54");
        this.definedEntities.put("&coprod;", "\u2210");
        this.definedEntities.put("&copy;", "\u00a9");
        this.definedEntities.put("&copysr;", "\u2117");
        this.definedEntities.put("&crarr;", "\u21b5");
        this.definedEntities.put("&cross;", "\u2717");
        this.definedEntities.put("&cscr;", "\ud835\udcb8");
        this.definedEntities.put("&csub;", "\u2acf");
        this.definedEntities.put("&csube;", "\u2ad1");
        this.definedEntities.put("&csup;", "\u2ad0");
        this.definedEntities.put("&csupe;", "\u2ad2");
        this.definedEntities.put("&ctdot;", "\u22ef");
        this.definedEntities.put("&cudarrl;", "\u2938");
        this.definedEntities.put("&cudarrr;", "\u2935");
        this.definedEntities.put("&cuepr;", "\u22de");
        this.definedEntities.put("&cuesc;", "\u22df");
        this.definedEntities.put("&cularr;", "\u21b6");
        this.definedEntities.put("&cularrp;", "\u293d");
        this.definedEntities.put("&cup;", "\u222a");
        this.definedEntities.put("&cupbrcap;", "\u2a48");
        this.definedEntities.put("&cupcap;", "\u2a46");
        this.definedEntities.put("&cupcup;", "\u2a4a");
        this.definedEntities.put("&cupdot;", "\u228d");
        this.definedEntities.put("&cupor;", "\u2a45");
        this.definedEntities.put("&cups;", "\u222a\ufe00");
        this.definedEntities.put("&curarr;", "\u21b7");
        this.definedEntities.put("&curarrm;", "\u293c");
        this.definedEntities.put("&curlyeqprec;", "\u22de");
        this.definedEntities.put("&curlyeqsucc;", "\u22df");
        this.definedEntities.put("&curlyvee;", "\u22ce");
        this.definedEntities.put("&curlywedge;", "\u22cf");
        this.definedEntities.put("&curren;", "\u00a4");
        this.definedEntities.put("&curvearrowleft;", "\u21b6");
        this.definedEntities.put("&curvearrowright;", "\u21b7");
        this.definedEntities.put("&cuvee;", "\u22ce");
        this.definedEntities.put("&cuwed;", "\u22cf");
        this.definedEntities.put("&cwconint;", "\u2232");
        this.definedEntities.put("&cwint;", "\u2231");
        this.definedEntities.put("&cylcty;", "\u232d");
        this.definedEntities.put("&dArr;", "\u21d3");
        this.definedEntities.put("&dHar;", "\u2965");
        this.definedEntities.put("&dagger;", "\u2020");
        this.definedEntities.put("&daleth;", "\u2138");
        this.definedEntities.put("&darr;", "\u2193");
        this.definedEntities.put("&dash;", "\u2010");
        this.definedEntities.put("&dashv;", "\u22a3");
        this.definedEntities.put("&dbkarow;", "\u290f");
        this.definedEntities.put("&dblac;", "\u02dd");
        this.definedEntities.put("&dcaron;", "\u010f");
        this.definedEntities.put("&dcy;", "\u0434");
        this.definedEntities.put("&dd;", "\u2146");
        this.definedEntities.put("&ddagger;", "\u2021");
        this.definedEntities.put("&ddarr;", "\u21ca");
        this.definedEntities.put("&ddotseq;", "\u2a77");
        this.definedEntities.put("&deg;", "\u00b0");
        this.definedEntities.put("&delta;", "\u03b4");
        this.definedEntities.put("&demptyv;", "\u29b1");
        this.definedEntities.put("&dfisht;", "\u297f");
        this.definedEntities.put("&dfr;", "\ud835\udd21");
        this.definedEntities.put("&dharl;", "\u21c3");
        this.definedEntities.put("&dharr;", "\u21c2");
        this.definedEntities.put("&diam;", "\u22c4");
        this.definedEntities.put("&diamond;", "\u22c4");
        this.definedEntities.put("&diamondsuit;", "\u2666");
        this.definedEntities.put("&diams;", "\u2666");
        this.definedEntities.put("&die;", "\u00a8");
        this.definedEntities.put("&digamma;", "\u03dd");
        this.definedEntities.put("&disin;", "\u22f2");
        this.definedEntities.put("&div;", "\u00f7");
        this.definedEntities.put("&divide;", "\u00f7");
        this.definedEntities.put("&divideontimes;", "\u22c7");
        this.definedEntities.put("&divonx;", "\u22c7");
        this.definedEntities.put("&djcy;", "\u0452");
        this.definedEntities.put("&dlcorn;", "\u231e");
        this.definedEntities.put("&dlcrop;", "\u230d");
        this.definedEntities.put("&dollar;", "$");
        this.definedEntities.put("&dopf;", "\ud835\udd55");
        this.definedEntities.put("&dot;", "\u02d9");
        this.definedEntities.put("&doteq;", "\u2250");
        this.definedEntities.put("&doteqdot;", "\u2251");
        this.definedEntities.put("&dotminus;", "\u2238");
        this.definedEntities.put("&dotplus;", "\u2214");
        this.definedEntities.put("&dotsquare;", "\u22a1");
        this.definedEntities.put("&doublebarwedge;", "\u2306");
        this.definedEntities.put("&downarrow;", "\u2193");
        this.definedEntities.put("&downdownarrows;", "\u21ca");
        this.definedEntities.put("&downharpoonleft;", "\u21c3");
        this.definedEntities.put("&downharpoonright;", "\u21c2");
        this.definedEntities.put("&drbkarow;", "\u2910");
        this.definedEntities.put("&drcorn;", "\u231f");
        this.definedEntities.put("&drcrop;", "\u230c");
        this.definedEntities.put("&dscr;", "\ud835\udcb9");
        this.definedEntities.put("&dscy;", "\u0455");
        this.definedEntities.put("&dsol;", "\u29f6");
        this.definedEntities.put("&dstrok;", "\u0111");
        this.definedEntities.put("&dtdot;", "\u22f1");
        this.definedEntities.put("&dtri;", "\u25bf");
        this.definedEntities.put("&dtrif;", "\u25be");
        this.definedEntities.put("&duarr;", "\u21f5");
        this.definedEntities.put("&duhar;", "\u296f");
        this.definedEntities.put("&dwangle;", "\u29a6");
        this.definedEntities.put("&dzcy;", "\u045f");
        this.definedEntities.put("&dzigrarr;", "\u27ff");
        this.definedEntities.put("&eDDot;", "\u2a77");
        this.definedEntities.put("&eDot;", "\u2251");
        this.definedEntities.put("&eacute;", "\u00e9");
        this.definedEntities.put("&easter;", "\u2a6e");
        this.definedEntities.put("&ecaron;", "\u011b");
        this.definedEntities.put("&ecir;", "\u2256");
        this.definedEntities.put("&ecirc;", "\u00ea");
        this.definedEntities.put("&ecolon;", "\u2255");
        this.definedEntities.put("&ecy;", "\u044d");
        this.definedEntities.put("&edot;", "\u0117");
        this.definedEntities.put("&ee;", "\u2147");
        this.definedEntities.put("&efDot;", "\u2252");
        this.definedEntities.put("&efr;", "\ud835\udd22");
        this.definedEntities.put("&eg;", "\u2a9a");
        this.definedEntities.put("&egrave;", "\u00e8");
        this.definedEntities.put("&egs;", "\u2a96");
        this.definedEntities.put("&egsdot;", "\u2a98");
        this.definedEntities.put("&el;", "\u2a99");
        this.definedEntities.put("&elinters;", "\u23e7");
        this.definedEntities.put("&ell;", "\u2113");
        this.definedEntities.put("&els;", "\u2a95");
        this.definedEntities.put("&elsdot;", "\u2a97");
        this.definedEntities.put("&emacr;", "\u0113");
        this.definedEntities.put("&empty;", "\u2205");
        this.definedEntities.put("&emptyset;", "\u2205");
        this.definedEntities.put("&emptyv;", "\u2205");
        this.definedEntities.put("&emsp13;", "\u2004");
        this.definedEntities.put("&emsp14;", "\u2005");
        this.definedEntities.put("&emsp;", "\u2003");
        this.definedEntities.put("&eng;", "\u014b");
        this.definedEntities.put("&ensp;", "\u2002");
        this.definedEntities.put("&eogon;", "\u0119");
        this.definedEntities.put("&eopf;", "\ud835\udd56");
        this.definedEntities.put("&epar;", "\u22d5");
        this.definedEntities.put("&eparsl;", "\u29e3");
        this.definedEntities.put("&eplus;", "\u2a71");
        this.definedEntities.put("&epsi;", "\u03b5");
        this.definedEntities.put("&epsilon;", "\u03b5");
        this.definedEntities.put("&epsiv;", "\u03f5");
        this.definedEntities.put("&eqcirc;", "\u2256");
        this.definedEntities.put("&eqcolon;", "\u2255");
        this.definedEntities.put("&eqsim;", "\u2242");
        this.definedEntities.put("&eqslantgtr;", "\u2a96");
        this.definedEntities.put("&eqslantless;", "\u2a95");
        this.definedEntities.put("&equals;", "=");
        this.definedEntities.put("&equest;", "\u225f");
        this.definedEntities.put("&equiv;", "\u2261");
        this.definedEntities.put("&equivDD;", "\u2a78");
        this.definedEntities.put("&eqvparsl;", "\u29e5");
        this.definedEntities.put("&erDot;", "\u2253");
        this.definedEntities.put("&erarr;", "\u2971");
        this.definedEntities.put("&escr;", "\u212f");
        this.definedEntities.put("&esdot;", "\u2250");
        this.definedEntities.put("&esim;", "\u2242");
        this.definedEntities.put("&eta;", "\u03b7");
        this.definedEntities.put("&eth;", "\u00f0");
        this.definedEntities.put("&euml;", "\u00eb");
        this.definedEntities.put("&euro;", "\u20ac");
        this.definedEntities.put("&excl;", "!");
        this.definedEntities.put("&exist;", "\u2203");
        this.definedEntities.put("&expectation;", "\u2130");
        this.definedEntities.put("&exponentiale;", "\u2147");
        this.definedEntities.put("&fallingdotseq;", "\u2252");
        this.definedEntities.put("&fcy;", "\u0444");
        this.definedEntities.put("&female;", "\u2640");
        this.definedEntities.put("&ffilig;", "\ufb03");
        this.definedEntities.put("&fflig;", "\ufb00");
        this.definedEntities.put("&ffllig;", "\ufb04");
        this.definedEntities.put("&ffr;", "\ud835\udd23");
        this.definedEntities.put("&filig;", "\ufb01");
        this.definedEntities.put("&fjlig;", "fj");
        this.definedEntities.put("&flat;", "\u266d");
        this.definedEntities.put("&fllig;", "\ufb02");
        this.definedEntities.put("&fltns;", "\u25b1");
        this.definedEntities.put("&fnof;", "\u0192");
        this.definedEntities.put("&fopf;", "\ud835\udd57");
        this.definedEntities.put("&forall;", "\u2200");
        this.definedEntities.put("&fork;", "\u22d4");
        this.definedEntities.put("&forkv;", "\u2ad9");
        this.definedEntities.put("&fpartint;", "\u2a0d");
        this.definedEntities.put("&frac12;", "\u00bd");
        this.definedEntities.put("&frac13;", "\u2153");
        this.definedEntities.put("&frac14;", "\u00bc");
        this.definedEntities.put("&frac15;", "\u2155");
        this.definedEntities.put("&frac16;", "\u2159");
        this.definedEntities.put("&frac18;", "\u215b");
        this.definedEntities.put("&frac23;", "\u2154");
        this.definedEntities.put("&frac25;", "\u2156");
        this.definedEntities.put("&frac34;", "\u00be");
        this.definedEntities.put("&frac35;", "\u2157");
        this.definedEntities.put("&frac38;", "\u215c");
        this.definedEntities.put("&frac45;", "\u2158");
        this.definedEntities.put("&frac56;", "\u215a");
        this.definedEntities.put("&frac58;", "\u215d");
        this.definedEntities.put("&frac78;", "\u215e");
        this.definedEntities.put("&frasl;", "\u2044");
        this.definedEntities.put("&frown;", "\u2322");
        this.definedEntities.put("&fscr;", "\ud835\udcbb");
        this.definedEntities.put("&gE;", "\u2267");
        this.definedEntities.put("&gEl;", "\u2a8c");
        this.definedEntities.put("&gacute;", "\u01f5");
        this.definedEntities.put("&gamma;", "\u03b3");
        this.definedEntities.put("&gammad;", "\u03dd");
        this.definedEntities.put("&gap;", "\u2a86");
        this.definedEntities.put("&gbreve;", "\u011f");
        this.definedEntities.put("&gcirc;", "\u011d");
        this.definedEntities.put("&gcy;", "\u0433");
        this.definedEntities.put("&gdot;", "\u0121");
        this.definedEntities.put("&ge;", "\u2265");
        this.definedEntities.put("&gel;", "\u22db");
        this.definedEntities.put("&geq;", "\u2265");
        this.definedEntities.put("&geqq;", "\u2267");
        this.definedEntities.put("&geqslant;", "\u2a7e");
        this.definedEntities.put("&ges;", "\u2a7e");
        this.definedEntities.put("&gescc;", "\u2aa9");
        this.definedEntities.put("&gesdot;", "\u2a80");
        this.definedEntities.put("&gesdoto;", "\u2a82");
        this.definedEntities.put("&gesdotol;", "\u2a84");
        this.definedEntities.put("&gesl;", "\u22db\ufe00");
        this.definedEntities.put("&gesles;", "\u2a94");
        this.definedEntities.put("&gfr;", "\ud835\udd24");
        this.definedEntities.put("&gg;", "\u226b");
        this.definedEntities.put("&ggg;", "\u22d9");
        this.definedEntities.put("&gimel;", "\u2137");
        this.definedEntities.put("&gjcy;", "\u0453");
        this.definedEntities.put("&gl;", "\u2277");
        this.definedEntities.put("&glE;", "\u2a92");
        this.definedEntities.put("&gla;", "\u2aa5");
        this.definedEntities.put("&glj;", "\u2aa4");
        this.definedEntities.put("&gnE;", "\u2269");
        this.definedEntities.put("&gnap;", "\u2a8a");
        this.definedEntities.put("&gnapprox;", "\u2a8a");
        this.definedEntities.put("&gne;", "\u2a88");
        this.definedEntities.put("&gneq;", "\u2a88");
        this.definedEntities.put("&gneqq;", "\u2269");
        this.definedEntities.put("&gnsim;", "\u22e7");
        this.definedEntities.put("&gopf;", "\ud835\udd58");
        this.definedEntities.put("&grave;", "`");
        this.definedEntities.put("&gscr;", "\u210a");
        this.definedEntities.put("&gsim;", "\u2273");
        this.definedEntities.put("&gsime;", "\u2a8e");
        this.definedEntities.put("&gsiml;", "\u2a90");
        this.definedEntities.put("&gt;", ">");
        this.definedEntities.put("&gtcc;", "\u2aa7");
        this.definedEntities.put("&gtcir;", "\u2a7a");
        this.definedEntities.put("&gtdot;", "\u22d7");
        this.definedEntities.put("&gtlPar;", "\u2995");
        this.definedEntities.put("&gtquest;", "\u2a7c");
        this.definedEntities.put("&gtrapprox;", "\u2a86");
        this.definedEntities.put("&gtrarr;", "\u2978");
        this.definedEntities.put("&gtrdot;", "\u22d7");
        this.definedEntities.put("&gtreqless;", "\u22db");
        this.definedEntities.put("&gtreqqless;", "\u2a8c");
        this.definedEntities.put("&gtrless;", "\u2277");
        this.definedEntities.put("&gtrsim;", "\u2273");
        this.definedEntities.put("&gvertneqq;", "\u2269\ufe00");
        this.definedEntities.put("&gvnE;", "\u2269\ufe00");
        this.definedEntities.put("&hArr;", "\u21d4");
        this.definedEntities.put("&hairsp;", "\u200a");
        this.definedEntities.put("&half;", "\u00bd");
        this.definedEntities.put("&hamilt;", "\u210b");
        this.definedEntities.put("&hardcy;", "\u044a");
        this.definedEntities.put("&harr;", "\u2194");
        this.definedEntities.put("&harrcir;", "\u2948");
        this.definedEntities.put("&harrw;", "\u21ad");
        this.definedEntities.put("&hbar;", "\u210f");
        this.definedEntities.put("&hcirc;", "\u0125");
        this.definedEntities.put("&hearts;", "\u2665");
        this.definedEntities.put("&heartsuit;", "\u2665");
        this.definedEntities.put("&hellip;", "\u2026");
        this.definedEntities.put("&hercon;", "\u22b9");
        this.definedEntities.put("&hfr;", "\ud835\udd25");
        this.definedEntities.put("&hksearow;", "\u2925");
        this.definedEntities.put("&hkswarow;", "\u2926");
        this.definedEntities.put("&hoarr;", "\u21ff");
        this.definedEntities.put("&homtht;", "\u223b");
        this.definedEntities.put("&hookleftarrow;", "\u21a9");
        this.definedEntities.put("&hookrightarrow;", "\u21aa");
        this.definedEntities.put("&hopf;", "\ud835\udd59");
        this.definedEntities.put("&horbar;", "\u2015");
        this.definedEntities.put("&hscr;", "\ud835\udcbd");
        this.definedEntities.put("&hslash;", "\u210f");
        this.definedEntities.put("&hstrok;", "\u0127");
        this.definedEntities.put("&hybull;", "\u2043");
        this.definedEntities.put("&hyphen;", "\u2010");
        this.definedEntities.put("&iacute;", "\u00ed");
        this.definedEntities.put("&ic;", "\u2063");
        this.definedEntities.put("&icirc;", "\u00ee");
        this.definedEntities.put("&icy;", "\u0438");
        this.definedEntities.put("&iecy;", "\u0435");
        this.definedEntities.put("&iexcl;", "\u00a1");
        this.definedEntities.put("&iff;", "\u21d4");
        this.definedEntities.put("&ifr;", "\ud835\udd26");
        this.definedEntities.put("&igrave;", "\u00ec");
        this.definedEntities.put("&ii;", "\u2148");
        this.definedEntities.put("&iiiint;", "\u2a0c");
        this.definedEntities.put("&iiint;", "\u222d");
        this.definedEntities.put("&iinfin;", "\u29dc");
        this.definedEntities.put("&iiota;", "\u2129");
        this.definedEntities.put("&ijlig;", "\u0133");
        this.definedEntities.put("&imacr;", "\u012b");
        this.definedEntities.put("&image;", "\u2111");
        this.definedEntities.put("&imagline;", "\u2110");
        this.definedEntities.put("&imagpart;", "\u2111");
        this.definedEntities.put("&imath;", "\u0131");
        this.definedEntities.put("&imof;", "\u22b7");
        this.definedEntities.put("&imped;", "\u01b5");
        this.definedEntities.put("&in;", "\u2208");
        this.definedEntities.put("&incare;", "\u2105");
        this.definedEntities.put("&infin;", "\u221e");
        this.definedEntities.put("&infintie;", "\u29dd");
        this.definedEntities.put("&inodot;", "\u0131");
        this.definedEntities.put("&int;", "\u222b");
        this.definedEntities.put("&intcal;", "\u22ba");
        this.definedEntities.put("&integers;", "\u2124");
        this.definedEntities.put("&intercal;", "\u22ba");
        this.definedEntities.put("&intlarhk;", "\u2a17");
        this.definedEntities.put("&intprod;", "\u2a3c");
        this.definedEntities.put("&iocy;", "\u0451");
        this.definedEntities.put("&iogon;", "\u012f");
        this.definedEntities.put("&iopf;", "\ud835\udd5a");
        this.definedEntities.put("&iota;", "\u03b9");
        this.definedEntities.put("&iprod;", "\u2a3c");
        this.definedEntities.put("&iquest;", "\u00bf");
        this.definedEntities.put("&iscr;", "\ud835\udcbe");
        this.definedEntities.put("&isin;", "\u2208");
        this.definedEntities.put("&isinE;", "\u22f9");
        this.definedEntities.put("&isindot;", "\u22f5");
        this.definedEntities.put("&isins;", "\u22f4");
        this.definedEntities.put("&isinsv;", "\u22f3");
        this.definedEntities.put("&isinv;", "\u2208");
        this.definedEntities.put("&it;", "\u2062");
        this.definedEntities.put("&itilde;", "\u0129");
        this.definedEntities.put("&iukcy;", "\u0456");
        this.definedEntities.put("&iuml;", "\u00ef");
        this.definedEntities.put("&jcirc;", "\u0135");
        this.definedEntities.put("&jcy;", "\u0439");
        this.definedEntities.put("&jfr;", "\ud835\udd27");
        this.definedEntities.put("&jmath;", "\u0237");
        this.definedEntities.put("&jopf;", "\ud835\udd5b");
        this.definedEntities.put("&jscr;", "\ud835\udcbf");
        this.definedEntities.put("&jsercy;", "\u0458");
        this.definedEntities.put("&jukcy;", "\u0454");
        this.definedEntities.put("&kappa;", "\u03ba");
        this.definedEntities.put("&kappav;", "\u03f0");
        this.definedEntities.put("&kcedil;", "\u0137");
        this.definedEntities.put("&kcy;", "\u043a");
        this.definedEntities.put("&kfr;", "\ud835\udd28");
        this.definedEntities.put("&kgreen;", "\u0138");
        this.definedEntities.put("&khcy;", "\u0445");
        this.definedEntities.put("&kjcy;", "\u045c");
        this.definedEntities.put("&kopf;", "\ud835\udd5c");
        this.definedEntities.put("&kscr;", "\ud835\udcc0");
        this.definedEntities.put("&lAarr;", "\u21da");
        this.definedEntities.put("&lArr;", "\u21d0");
        this.definedEntities.put("&lAtail;", "\u291b");
        this.definedEntities.put("&lBarr;", "\u290e");
        this.definedEntities.put("&lE;", "\u2266");
        this.definedEntities.put("&lEg;", "\u2a8b");
        this.definedEntities.put("&lHar;", "\u2962");
        this.definedEntities.put("&lacute;", "\u013a");
        this.definedEntities.put("&laemptyv;", "\u29b4");
        this.definedEntities.put("&lagran;", "\u2112");
        this.definedEntities.put("&lambda;", "\u03bb");
        this.definedEntities.put("&lang;", "\u27e8");
        this.definedEntities.put("&langd;", "\u2991");
        this.definedEntities.put("&langle;", "\u27e8");
        this.definedEntities.put("&lap;", "\u2a85");
        this.definedEntities.put("&laquo;", "\u00ab");
        this.definedEntities.put("&larr;", "\u2190");
        this.definedEntities.put("&larrb;", "\u21e4");
        this.definedEntities.put("&larrbfs;", "\u291f");
        this.definedEntities.put("&larrfs;", "\u291d");
        this.definedEntities.put("&larrhk;", "\u21a9");
        this.definedEntities.put("&larrlp;", "\u21ab");
        this.definedEntities.put("&larrpl;", "\u2939");
        this.definedEntities.put("&larrsim;", "\u2973");
        this.definedEntities.put("&larrtl;", "\u21a2");
        this.definedEntities.put("&lat;", "\u2aab");
        this.definedEntities.put("&latail;", "\u2919");
        this.definedEntities.put("&late;", "\u2aad");
        this.definedEntities.put("&lates;", "\u2aad\ufe00");
        this.definedEntities.put("&lbarr;", "\u290c");
        this.definedEntities.put("&lbbrk;", "\u2772");
        this.definedEntities.put("&lbrace;", "{");
        this.definedEntities.put("&lbrack;", "[");
        this.definedEntities.put("&lbrke;", "\u298b");
        this.definedEntities.put("&lbrksld;", "\u298f");
        this.definedEntities.put("&lbrkslu;", "\u298d");
        this.definedEntities.put("&lcaron;", "\u013e");
        this.definedEntities.put("&lcedil;", "\u013c");
        this.definedEntities.put("&lceil;", "\u2308");
        this.definedEntities.put("&lcub;", "{");
        this.definedEntities.put("&lcy;", "\u043b");
        this.definedEntities.put("&ldca;", "\u2936");
        this.definedEntities.put("&ldquo;", "\u201c");
        this.definedEntities.put("&ldquor;", "\u201e");
        this.definedEntities.put("&ldrdhar;", "\u2967");
        this.definedEntities.put("&ldrushar;", "\u294b");
        this.definedEntities.put("&ldsh;", "\u21b2");
        this.definedEntities.put("&le;", "\u2264");
        this.definedEntities.put("&leftarrow;", "\u2190");
        this.definedEntities.put("&leftarrowtail;", "\u21a2");
        this.definedEntities.put("&leftharpoondown;", "\u21bd");
        this.definedEntities.put("&leftharpoonup;", "\u21bc");
        this.definedEntities.put("&leftleftarrows;", "\u21c7");
        this.definedEntities.put("&leftrightarrow;", "\u2194");
        this.definedEntities.put("&leftrightarrows;", "\u21c6");
        this.definedEntities.put("&leftrightharpoons;", "\u21cb");
        this.definedEntities.put("&leftrightsquigarrow;", "\u21ad");
        this.definedEntities.put("&leftthreetimes;", "\u22cb");
        this.definedEntities.put("&leg;", "\u22da");
        this.definedEntities.put("&leq;", "\u2264");
        this.definedEntities.put("&leqq;", "\u2266");
        this.definedEntities.put("&leqslant;", "\u2a7d");
        this.definedEntities.put("&les;", "\u2a7d");
        this.definedEntities.put("&lescc;", "\u2aa8");
        this.definedEntities.put("&lesdot;", "\u2a7f");
        this.definedEntities.put("&lesdoto;", "\u2a81");
        this.definedEntities.put("&lesdotor;", "\u2a83");
        this.definedEntities.put("&lesg;", "\u22da\ufe00");
        this.definedEntities.put("&lesges;", "\u2a93");
        this.definedEntities.put("&lessapprox;", "\u2a85");
        this.definedEntities.put("&lessdot;", "\u22d6");
        this.definedEntities.put("&lesseqgtr;", "\u22da");
        this.definedEntities.put("&lesseqqgtr;", "\u2a8b");
        this.definedEntities.put("&lessgtr;", "\u2276");
        this.definedEntities.put("&lesssim;", "\u2272");
        this.definedEntities.put("&lfisht;", "\u297c");
        this.definedEntities.put("&lfloor;", "\u230a");
        this.definedEntities.put("&lfr;", "\ud835\udd29");
        this.definedEntities.put("&lg;", "\u2276");
        this.definedEntities.put("&lgE;", "\u2a91");
        this.definedEntities.put("&lhard;", "\u21bd");
        this.definedEntities.put("&lharu;", "\u21bc");
        this.definedEntities.put("&lharul;", "\u296a");
        this.definedEntities.put("&lhblk;", "\u2584");
        this.definedEntities.put("&ljcy;", "\u0459");
        this.definedEntities.put("&ll;", "\u226a");
        this.definedEntities.put("&llarr;", "\u21c7");
        this.definedEntities.put("&llcorner;", "\u231e");
        this.definedEntities.put("&llhard;", "\u296b");
        this.definedEntities.put("&lltri;", "\u25fa");
        this.definedEntities.put("&lmidot;", "\u0140");
        this.definedEntities.put("&lmoust;", "\u23b0");
        this.definedEntities.put("&lmoustache;", "\u23b0");
        this.definedEntities.put("&lnE;", "\u2268");
        this.definedEntities.put("&lnap;", "\u2a89");
        this.definedEntities.put("&lnapprox;", "\u2a89");
        this.definedEntities.put("&lne;", "\u2a87");
        this.definedEntities.put("&lneq;", "\u2a87");
        this.definedEntities.put("&lneqq;", "\u2268");
        this.definedEntities.put("&lnsim;", "\u22e6");
        this.definedEntities.put("&loang;", "\u27ec");
        this.definedEntities.put("&loarr;", "\u21fd");
        this.definedEntities.put("&lobrk;", "\u27e6");
        this.definedEntities.put("&longleftarrow;", "\u27f5");
        this.definedEntities.put("&longleftrightarrow;", "\u27f7");
        this.definedEntities.put("&longmapsto;", "\u27fc");
        this.definedEntities.put("&longrightarrow;", "\u27f6");
        this.definedEntities.put("&looparrowleft;", "\u21ab");
        this.definedEntities.put("&looparrowright;", "\u21ac");
        this.definedEntities.put("&lopar;", "\u2985");
        this.definedEntities.put("&lopf;", "\ud835\udd5d");
        this.definedEntities.put("&loplus;", "\u2a2d");
        this.definedEntities.put("&lotimes;", "\u2a34");
        this.definedEntities.put("&lowast;", "\u2217");
        this.definedEntities.put("&lowbar;", "_");
        this.definedEntities.put("&loz;", "\u25ca");
        this.definedEntities.put("&lozenge;", "\u25ca");
        this.definedEntities.put("&lozf;", "\u29eb");
        this.definedEntities.put("&lpar;", "(");
        this.definedEntities.put("&lparlt;", "\u2993");
        this.definedEntities.put("&lrarr;", "\u21c6");
        this.definedEntities.put("&lrcorner;", "\u231f");
        this.definedEntities.put("&lrhar;", "\u21cb");
        this.definedEntities.put("&lrhard;", "\u296d");
        this.definedEntities.put("&lrm;", "\u200e");
        this.definedEntities.put("&lrtri;", "\u22bf");
        this.definedEntities.put("&lsaquo;", "\u2039");
        this.definedEntities.put("&lscr;", "\ud835\udcc1");
        this.definedEntities.put("&lsh;", "\u21b0");
        this.definedEntities.put("&lsim;", "\u2272");
        this.definedEntities.put("&lsime;", "\u2a8d");
        this.definedEntities.put("&lsimg;", "\u2a8f");
        this.definedEntities.put("&lsqb;", "[");
        this.definedEntities.put("&lsquo;", "\u2018");
        this.definedEntities.put("&lsquor;", "\u201a");
        this.definedEntities.put("&lstrok;", "\u0142");
        this.definedEntities.put("&lt;", "<");
        this.definedEntities.put("&ltcc;", "\u2aa6");
        this.definedEntities.put("&ltcir;", "\u2a79");
        this.definedEntities.put("&ltdot;", "\u22d6");
        this.definedEntities.put("&lthree;", "\u22cb");
        this.definedEntities.put("&ltimes;", "\u22c9");
        this.definedEntities.put("&ltlarr;", "\u2976");
        this.definedEntities.put("&ltquest;", "\u2a7b");
        this.definedEntities.put("&ltrPar;", "\u2996");
        this.definedEntities.put("&ltri;", "\u25c3");
        this.definedEntities.put("&ltrie;", "\u22b4");
        this.definedEntities.put("&ltrif;", "\u25c2");
        this.definedEntities.put("&lurdshar;", "\u294a");
        this.definedEntities.put("&luruhar;", "\u2966");
        this.definedEntities.put("&lvertneqq;", "\u2268\ufe00");
        this.definedEntities.put("&lvnE;", "\u2268\ufe00");
        this.definedEntities.put("&mDDot;", "\u223a");
        this.definedEntities.put("&macr;", "\u00af");
        this.definedEntities.put("&male;", "\u2642");
        this.definedEntities.put("&malt;", "\u2720");
        this.definedEntities.put("&maltese;", "\u2720");
        this.definedEntities.put("&map;", "\u21a6");
        this.definedEntities.put("&mapsto;", "\u21a6");
        this.definedEntities.put("&mapstodown;", "\u21a7");
        this.definedEntities.put("&mapstoleft;", "\u21a4");
        this.definedEntities.put("&mapstoup;", "\u21a5");
        this.definedEntities.put("&marker;", "\u25ae");
        this.definedEntities.put("&mcomma;", "\u2a29");
        this.definedEntities.put("&mcy;", "\u043c");
        this.definedEntities.put("&mdash;", "\u2014");
        this.definedEntities.put("&measuredangle;", "\u2221");
        this.definedEntities.put("&mfr;", "\ud835\udd2a");
        this.definedEntities.put("&mho;", "\u2127");
        this.definedEntities.put("&micro;", "\u00b5");
        this.definedEntities.put("&mid;", "\u2223");
        this.definedEntities.put("&midast;", "*");
        this.definedEntities.put("&midcir;", "\u2af0");
        this.definedEntities.put("&middot;", "\u00b7");
        this.definedEntities.put("&minus;", "\u2212");
        this.definedEntities.put("&minusb;", "\u229f");
        this.definedEntities.put("&minusd;", "\u2238");
        this.definedEntities.put("&minusdu;", "\u2a2a");
        this.definedEntities.put("&mlcp;", "\u2adb");
        this.definedEntities.put("&mldr;", "\u2026");
        this.definedEntities.put("&mnplus;", "\u2213");
        this.definedEntities.put("&models;", "\u22a7");
        this.definedEntities.put("&mopf;", "\ud835\udd5e");
        this.definedEntities.put("&mp;", "\u2213");
        this.definedEntities.put("&mscr;", "\ud835\udcc2");
        this.definedEntities.put("&mstpos;", "\u223e");
        this.definedEntities.put("&mu;", "\u03bc");
        this.definedEntities.put("&multimap;", "\u22b8");
        this.definedEntities.put("&mumap;", "\u22b8");
        this.definedEntities.put("&nGg;", "\u22d9\u0338");
        this.definedEntities.put("&nGt;", "\u226b\u20d2");
        this.definedEntities.put("&nGtv;", "\u226b\u0338");
        this.definedEntities.put("&nLeftarrow;", "\u21cd");
        this.definedEntities.put("&nLeftrightarrow;", "\u21ce");
        this.definedEntities.put("&nLl;", "\u22d8\u0338");
        this.definedEntities.put("&nLt;", "\u226a\u20d2");
        this.definedEntities.put("&nLtv;", "\u226a\u0338");
        this.definedEntities.put("&nRightarrow;", "\u21cf");
        this.definedEntities.put("&nVDash;", "\u22af");
        this.definedEntities.put("&nVdash;", "\u22ae");
        this.definedEntities.put("&nabla;", "\u2207");
        this.definedEntities.put("&nacute;", "\u0144");
        this.definedEntities.put("&nang;", "\u2220\u20d2");
        this.definedEntities.put("&nap;", "\u2249");
        this.definedEntities.put("&napE;", "\u2a70\u0338");
        this.definedEntities.put("&napid;", "\u224b\u0338");
        this.definedEntities.put("&napos;", "\u0149");
        this.definedEntities.put("&napprox;", "\u2249");
        this.definedEntities.put("&natur;", "\u266e");
        this.definedEntities.put("&natural;", "\u266e");
        this.definedEntities.put("&naturals;", "\u2115");
        this.definedEntities.put("&nbsp;", "\u00a0");
        this.definedEntities.put("&nbump;", "\u224e\u0338");
        this.definedEntities.put("&nbumpe;", "\u224f\u0338");
        this.definedEntities.put("&ncap;", "\u2a43");
        this.definedEntities.put("&ncaron;", "\u0148");
        this.definedEntities.put("&ncedil;", "\u0146");
        this.definedEntities.put("&ncong;", "\u2247");
        this.definedEntities.put("&ncongdot;", "\u2a6d\u0338");
        this.definedEntities.put("&ncup;", "\u2a42");
        this.definedEntities.put("&ncy;", "\u043d");
        this.definedEntities.put("&ndash;", "\u2013");
        this.definedEntities.put("&ne;", "\u2260");
        this.definedEntities.put("&neArr;", "\u21d7");
        this.definedEntities.put("&nearhk;", "\u2924");
        this.definedEntities.put("&nearr;", "\u2197");
        this.definedEntities.put("&nearrow;", "\u2197");
        this.definedEntities.put("&nedot;", "\u2250\u0338");
        this.definedEntities.put("&nequiv;", "\u2262");
        this.definedEntities.put("&nesear;", "\u2928");
        this.definedEntities.put("&nesim;", "\u2242\u0338");
        this.definedEntities.put("&nexist;", "\u2204");
        this.definedEntities.put("&nexists;", "\u2204");
        this.definedEntities.put("&nfr;", "\ud835\udd2b");
        this.definedEntities.put("&ngE;", "\u2267\u0338");
        this.definedEntities.put("&nge;", "\u2271");
        this.definedEntities.put("&ngeq;", "\u2271");
        this.definedEntities.put("&ngeqq;", "\u2267\u0338");
        this.definedEntities.put("&ngeqslant;", "\u2a7e\u0338");
        this.definedEntities.put("&nges;", "\u2a7e\u0338");
        this.definedEntities.put("&ngsim;", "\u2275");
        this.definedEntities.put("&ngt;", "\u226f");
        this.definedEntities.put("&ngtr;", "\u226f");
        this.definedEntities.put("&nhArr;", "\u21ce");
        this.definedEntities.put("&nharr;", "\u21ae");
        this.definedEntities.put("&nhpar;", "\u2af2");
        this.definedEntities.put("&ni;", "\u220b");
        this.definedEntities.put("&nis;", "\u22fc");
        this.definedEntities.put("&nisd;", "\u22fa");
        this.definedEntities.put("&niv;", "\u220b");
        this.definedEntities.put("&njcy;", "\u045a");
        this.definedEntities.put("&nlArr;", "\u21cd");
        this.definedEntities.put("&nlE;", "\u2266\u0338");
        this.definedEntities.put("&nlarr;", "\u219a");
        this.definedEntities.put("&nldr;", "\u2025");
        this.definedEntities.put("&nle;", "\u2270");
        this.definedEntities.put("&nleftarrow;", "\u219a");
        this.definedEntities.put("&nleftrightarrow;", "\u21ae");
        this.definedEntities.put("&nleq;", "\u2270");
        this.definedEntities.put("&nleqq;", "\u2266\u0338");
        this.definedEntities.put("&nleqslant;", "\u2a7d\u0338");
        this.definedEntities.put("&nles;", "\u2a7d\u0338");
        this.definedEntities.put("&nless;", "\u226e");
        this.definedEntities.put("&nlsim;", "\u2274");
        this.definedEntities.put("&nlt;", "\u226e");
        this.definedEntities.put("&nltri;", "\u22ea");
        this.definedEntities.put("&nltrie;", "\u22ec");
        this.definedEntities.put("&nmid;", "\u2224");
        this.definedEntities.put("&nopf;", "\ud835\udd5f");
        this.definedEntities.put("&not;", "\u00ac");
        this.definedEntities.put("&notin;", "\u2209");
        this.definedEntities.put("&notinE;", "\u22f9\u0338");
        this.definedEntities.put("&notindot;", "\u22f5\u0338");
        this.definedEntities.put("&notinva;", "\u2209");
        this.definedEntities.put("&notinvb;", "\u22f7");
        this.definedEntities.put("&notinvc;", "\u22f6");
        this.definedEntities.put("&notni;", "\u220c");
        this.definedEntities.put("&notniva;", "\u220c");
        this.definedEntities.put("&notnivb;", "\u22fe");
        this.definedEntities.put("&notnivc;", "\u22fd");
        this.definedEntities.put("&npar;", "\u2226");
        this.definedEntities.put("&nparallel;", "\u2226");
        this.definedEntities.put("&nparsl;", "\u2afd\u20e5");
        this.definedEntities.put("&npart;", "\u2202\u0338");
        this.definedEntities.put("&npolint;", "\u2a14");
        this.definedEntities.put("&npr;", "\u2280");
        this.definedEntities.put("&nprcue;", "\u22e0");
        this.definedEntities.put("&npre;", "\u2aaf\u0338");
        this.definedEntities.put("&nprec;", "\u2280");
        this.definedEntities.put("&npreceq;", "\u2aaf\u0338");
        this.definedEntities.put("&nrArr;", "\u21cf");
        this.definedEntities.put("&nrarr;", "\u219b");
        this.definedEntities.put("&nrarrc;", "\u2933\u0338");
        this.definedEntities.put("&nrarrw;", "\u219d\u0338");
        this.definedEntities.put("&nrightarrow;", "\u219b");
        this.definedEntities.put("&nrtri;", "\u22eb");
        this.definedEntities.put("&nrtrie;", "\u22ed");
        this.definedEntities.put("&nsc;", "\u2281");
        this.definedEntities.put("&nsccue;", "\u22e1");
        this.definedEntities.put("&nsce;", "\u2ab0\u0338");
        this.definedEntities.put("&nscr;", "\ud835\udcc3");
        this.definedEntities.put("&nshortmid;", "\u2224");
        this.definedEntities.put("&nshortparallel;", "\u2226");
        this.definedEntities.put("&nsim;", "\u2241");
        this.definedEntities.put("&nsime;", "\u2244");
        this.definedEntities.put("&nsimeq;", "\u2244");
        this.definedEntities.put("&nsmid;", "\u2224");
        this.definedEntities.put("&nspar;", "\u2226");
        this.definedEntities.put("&nsqsube;", "\u22e2");
        this.definedEntities.put("&nsqsupe;", "\u22e3");
        this.definedEntities.put("&nsub;", "\u2284");
        this.definedEntities.put("&nsubE;", "\u2ac5\u0338");
        this.definedEntities.put("&nsube;", "\u2288");
        this.definedEntities.put("&nsubset;", "\u2282\u20d2");
        this.definedEntities.put("&nsubseteq;", "\u2288");
        this.definedEntities.put("&nsubseteqq;", "\u2ac5\u0338");
        this.definedEntities.put("&nsucc;", "\u2281");
        this.definedEntities.put("&nsucceq;", "\u2ab0\u0338");
        this.definedEntities.put("&nsup;", "\u2285");
        this.definedEntities.put("&nsupE;", "\u2ac6\u0338");
        this.definedEntities.put("&nsupe;", "\u2289");
        this.definedEntities.put("&nsupset;", "\u2283\u20d2");
        this.definedEntities.put("&nsupseteq;", "\u2289");
        this.definedEntities.put("&nsupseteqq;", "\u2ac6\u0338");
        this.definedEntities.put("&ntgl;", "\u2279");
        this.definedEntities.put("&ntilde;", "\u00f1");
        this.definedEntities.put("&ntlg;", "\u2278");
        this.definedEntities.put("&ntriangleleft;", "\u22ea");
        this.definedEntities.put("&ntrianglelefteq;", "\u22ec");
        this.definedEntities.put("&ntriangleright;", "\u22eb");
        this.definedEntities.put("&ntrianglerighteq;", "\u22ed");
        this.definedEntities.put("&nu;", "\u03bd");
        this.definedEntities.put("&num;", "#");
        this.definedEntities.put("&numero;", "\u2116");
        this.definedEntities.put("&numsp;", "\u2007");
        this.definedEntities.put("&nvDash;", "\u22ad");
        this.definedEntities.put("&nvHarr;", "\u2904");
        this.definedEntities.put("&nvap;", "\u224d\u20d2");
        this.definedEntities.put("&nvdash;", "\u22ac");
        this.definedEntities.put("&nvge;", "\u2265\u20d2");
        this.definedEntities.put("&nvgt;", ">\u20d2");
        this.definedEntities.put("&nvinfin;", "\u29de");
        this.definedEntities.put("&nvlArr;", "\u2902");
        this.definedEntities.put("&nvle;", "\u2264\u20d2");
        this.definedEntities.put("&nvlt;", "<\u20d2");
        this.definedEntities.put("&nvltrie;", "\u22b4\u20d2");
        this.definedEntities.put("&nvrArr;", "\u2903");
        this.definedEntities.put("&nvrtrie;", "\u22b5\u20d2");
        this.definedEntities.put("&nvsim;", "\u223c\u20d2");
        this.definedEntities.put("&nwArr;", "\u21d6");
        this.definedEntities.put("&nwarhk;", "\u2923");
        this.definedEntities.put("&nwarr;", "\u2196");
        this.definedEntities.put("&nwarrow;", "\u2196");
        this.definedEntities.put("&nwnear;", "\u2927");
        this.definedEntities.put("&oS;", "\u24c8");
        this.definedEntities.put("&oacute;", "\u00f3");
        this.definedEntities.put("&oast;", "\u229b");
        this.definedEntities.put("&ocir;", "\u229a");
        this.definedEntities.put("&ocirc;", "\u00f4");
        this.definedEntities.put("&ocy;", "\u043e");
        this.definedEntities.put("&odash;", "\u229d");
        this.definedEntities.put("&odblac;", "\u0151");
        this.definedEntities.put("&odiv;", "\u2a38");
        this.definedEntities.put("&odot;", "\u2299");
        this.definedEntities.put("&odsold;", "\u29bc");
        this.definedEntities.put("&oelig;", "\u0153");
        this.definedEntities.put("&ofcir;", "\u29bf");
        this.definedEntities.put("&ofr;", "\ud835\udd2c");
        this.definedEntities.put("&ogon;", "\u02db");
        this.definedEntities.put("&ograve;", "\u00f2");
        this.definedEntities.put("&ogt;", "\u29c1");
        this.definedEntities.put("&ohbar;", "\u29b5");
        this.definedEntities.put("&ohm;", "\u03a9");
        this.definedEntities.put("&oint;", "\u222e");
        this.definedEntities.put("&olarr;", "\u21ba");
        this.definedEntities.put("&olcir;", "\u29be");
        this.definedEntities.put("&olcross;", "\u29bb");
        this.definedEntities.put("&oline;", "\u203e");
        this.definedEntities.put("&olt;", "\u29c0");
        this.definedEntities.put("&omacr;", "\u014d");
        this.definedEntities.put("&omega;", "\u03c9");
        this.definedEntities.put("&omicron;", "\u03bf");
        this.definedEntities.put("&omid;", "\u29b6");
        this.definedEntities.put("&ominus;", "\u2296");
        this.definedEntities.put("&oopf;", "\ud835\udd60");
        this.definedEntities.put("&opar;", "\u29b7");
        this.definedEntities.put("&operp;", "\u29b9");
        this.definedEntities.put("&oplus;", "\u2295");
        this.definedEntities.put("&or;", "\u2228");
        this.definedEntities.put("&orarr;", "\u21bb");
        this.definedEntities.put("&ord;", "\u2a5d");
        this.definedEntities.put("&order;", "\u2134");
        this.definedEntities.put("&orderof;", "\u2134");
        this.definedEntities.put("&ordf;", "\u00aa");
        this.definedEntities.put("&ordm;", "\u00ba");
        this.definedEntities.put("&origof;", "\u22b6");
        this.definedEntities.put("&oror;", "\u2a56");
        this.definedEntities.put("&orslope;", "\u2a57");
        this.definedEntities.put("&orv;", "\u2a5b");
        this.definedEntities.put("&oscr;", "\u2134");
        this.definedEntities.put("&oslash;", "\u00f8");
        this.definedEntities.put("&osol;", "\u2298");
        this.definedEntities.put("&otilde;", "\u00f5");
        this.definedEntities.put("&otimes;", "\u2297");
        this.definedEntities.put("&otimesas;", "\u2a36");
        this.definedEntities.put("&ouml;", "\u00f6");
        this.definedEntities.put("&ovbar;", "\u233d");
        this.definedEntities.put("&par;", "\u2225");
        this.definedEntities.put("&para;", "\u00b6");
        this.definedEntities.put("&parallel;", "\u2225");
        this.definedEntities.put("&parsim;", "\u2af3");
        this.definedEntities.put("&parsl;", "\u2afd");
        this.definedEntities.put("&part;", "\u2202");
        this.definedEntities.put("&pcy;", "\u043f");
        this.definedEntities.put("&percnt;", "%");
        this.definedEntities.put("&period;", ".");
        this.definedEntities.put("&permil;", "\u2030");
        this.definedEntities.put("&perp;", "\u22a5");
        this.definedEntities.put("&pertenk;", "\u2031");
        this.definedEntities.put("&pfr;", "\ud835\udd2d");
        this.definedEntities.put("&phi;", "\u03c6");
        this.definedEntities.put("&phiv;", "\u03d5");
        this.definedEntities.put("&phmmat;", "\u2133");
        this.definedEntities.put("&phone;", "\u260e");
        this.definedEntities.put("&pi;", "\u03c0");
        this.definedEntities.put("&pitchfork;", "\u22d4");
        this.definedEntities.put("&piv;", "\u03d6");
        this.definedEntities.put("&planck;", "\u210f");
        this.definedEntities.put("&planckh;", "\u210e");
        this.definedEntities.put("&plankv;", "\u210f");
        this.definedEntities.put("&plus;", "+");
        this.definedEntities.put("&plusacir;", "\u2a23");
        this.definedEntities.put("&plusb;", "\u229e");
        this.definedEntities.put("&pluscir;", "\u2a22");
        this.definedEntities.put("&plusdo;", "\u2214");
        this.definedEntities.put("&plusdu;", "\u2a25");
        this.definedEntities.put("&pluse;", "\u2a72");
        this.definedEntities.put("&plusmn;", "\u00b1");
        this.definedEntities.put("&plussim;", "\u2a26");
        this.definedEntities.put("&plustwo;", "\u2a27");
        this.definedEntities.put("&pm;", "\u00b1");
        this.definedEntities.put("&pointint;", "\u2a15");
        this.definedEntities.put("&popf;", "\ud835\udd61");
        this.definedEntities.put("&pound;", "\u00a3");
        this.definedEntities.put("&pr;", "\u227a");
        this.definedEntities.put("&prE;", "\u2ab3");
        this.definedEntities.put("&prap;", "\u2ab7");
        this.definedEntities.put("&prcue;", "\u227c");
        this.definedEntities.put("&pre;", "\u2aaf");
        this.definedEntities.put("&prec;", "\u227a");
        this.definedEntities.put("&precapprox;", "\u2ab7");
        this.definedEntities.put("&preccurlyeq;", "\u227c");
        this.definedEntities.put("&preceq;", "\u2aaf");
        this.definedEntities.put("&precnapprox;", "\u2ab9");
        this.definedEntities.put("&precneqq;", "\u2ab5");
        this.definedEntities.put("&precnsim;", "\u22e8");
        this.definedEntities.put("&precsim;", "\u227e");
        this.definedEntities.put("&prime;", "\u2032");
        this.definedEntities.put("&primes;", "\u2119");
        this.definedEntities.put("&prnE;", "\u2ab5");
        this.definedEntities.put("&prnap;", "\u2ab9");
        this.definedEntities.put("&prnsim;", "\u22e8");
        this.definedEntities.put("&prod;", "\u220f");
        this.definedEntities.put("&profalar;", "\u232e");
        this.definedEntities.put("&profline;", "\u2312");
        this.definedEntities.put("&profsurf;", "\u2313");
        this.definedEntities.put("&prop;", "\u221d");
        this.definedEntities.put("&propto;", "\u221d");
        this.definedEntities.put("&prsim;", "\u227e");
        this.definedEntities.put("&prurel;", "\u22b0");
        this.definedEntities.put("&pscr;", "\ud835\udcc5");
        this.definedEntities.put("&psi;", "\u03c8");
        this.definedEntities.put("&puncsp;", "\u2008");
        this.definedEntities.put("&qfr;", "\ud835\udd2e");
        this.definedEntities.put("&qint;", "\u2a0c");
        this.definedEntities.put("&qopf;", "\ud835\udd62");
        this.definedEntities.put("&qprime;", "\u2057");
        this.definedEntities.put("&qscr;", "\ud835\udcc6");
        this.definedEntities.put("&quaternions;", "\u210d");
        this.definedEntities.put("&quatint;", "\u2a16");
        this.definedEntities.put("&quest;", "?");
        this.definedEntities.put("&questeq;", "\u225f");
        this.definedEntities.put("&quot;", "\\u0022");
        this.definedEntities.put("&rAarr;", "\u21db");
        this.definedEntities.put("&rArr;", "\u21d2");
        this.definedEntities.put("&rAtail;", "\u291c");
        this.definedEntities.put("&rBarr;", "\u290f");
        this.definedEntities.put("&rHar;", "\u2964");
        this.definedEntities.put("&race;", "\u223d\u0331");
        this.definedEntities.put("&racute;", "\u0155");
        this.definedEntities.put("&radic;", "\u221a");
        this.definedEntities.put("&raemptyv;", "\u29b3");
        this.definedEntities.put("&rang;", "\u27e9");
        this.definedEntities.put("&rangd;", "\u2992");
        this.definedEntities.put("&range;", "\u29a5");
        this.definedEntities.put("&rangle;", "\u27e9");
        this.definedEntities.put("&raquo;", "\u00bb");
        this.definedEntities.put("&rarr;", "\u2192");
        this.definedEntities.put("&rarrap;", "\u2975");
        this.definedEntities.put("&rarrb;", "\u21e5");
        this.definedEntities.put("&rarrbfs;", "\u2920");
        this.definedEntities.put("&rarrc;", "\u2933");
        this.definedEntities.put("&rarrfs;", "\u291e");
        this.definedEntities.put("&rarrhk;", "\u21aa");
        this.definedEntities.put("&rarrlp;", "\u21ac");
        this.definedEntities.put("&rarrpl;", "\u2945");
        this.definedEntities.put("&rarrsim;", "\u2974");
        this.definedEntities.put("&rarrtl;", "\u21a3");
        this.definedEntities.put("&rarrw;", "\u219d");
        this.definedEntities.put("&ratail;", "\u291a");
        this.definedEntities.put("&ratio;", "\u2236");
        this.definedEntities.put("&rationals;", "\u211a");
        this.definedEntities.put("&rbarr;", "\u290d");
        this.definedEntities.put("&rbbrk;", "\u2773");
        this.definedEntities.put("&rbrace;", "}");
        this.definedEntities.put("&rbrack;", "]");
        this.definedEntities.put("&rbrke;", "\u298c");
        this.definedEntities.put("&rbrksld;", "\u298e");
        this.definedEntities.put("&rbrkslu;", "\u2990");
        this.definedEntities.put("&rcaron;", "\u0159");
        this.definedEntities.put("&rcedil;", "\u0157");
        this.definedEntities.put("&rceil;", "\u2309");
        this.definedEntities.put("&rcub;", "}");
        this.definedEntities.put("&rcy;", "\u0440");
        this.definedEntities.put("&rdca;", "\u2937");
        this.definedEntities.put("&rdldhar;", "\u2969");
        this.definedEntities.put("&rdquo;", "\u201d");
        this.definedEntities.put("&rdquor;", "\u201d");
        this.definedEntities.put("&rdsh;", "\u21b3");
        this.definedEntities.put("&real;", "\u211c");
        this.definedEntities.put("&realine;", "\u211b");
        this.definedEntities.put("&realpart;", "\u211c");
        this.definedEntities.put("&reals;", "\u211d");
        this.definedEntities.put("&rect;", "\u25ad");
        this.definedEntities.put("&reg;", "\u00ae");
        this.definedEntities.put("&rfisht;", "\u297d");
        this.definedEntities.put("&rfloor;", "\u230b");
        this.definedEntities.put("&rfr;", "\ud835\udd2f");
        this.definedEntities.put("&rhard;", "\u21c1");
        this.definedEntities.put("&rharu;", "\u21c0");
        this.definedEntities.put("&rharul;", "\u296c");
        this.definedEntities.put("&rho;", "\u03c1");
        this.definedEntities.put("&rhov;", "\u03f1");
        this.definedEntities.put("&rightarrow;", "\u2192");
        this.definedEntities.put("&rightarrowtail;", "\u21a3");
        this.definedEntities.put("&rightharpoondown;", "\u21c1");
        this.definedEntities.put("&rightharpoonup;", "\u21c0");
        this.definedEntities.put("&rightleftarrows;", "\u21c4");
        this.definedEntities.put("&rightleftharpoons;", "\u21cc");
        this.definedEntities.put("&rightrightarrows;", "\u21c9");
        this.definedEntities.put("&rightsquigarrow;", "\u219d");
        this.definedEntities.put("&rightthreetimes;", "\u22cc");
        this.definedEntities.put("&ring;", "\u02da");
        this.definedEntities.put("&risingdotseq;", "\u2253");
        this.definedEntities.put("&rlarr;", "\u21c4");
        this.definedEntities.put("&rlhar;", "\u21cc");
        this.definedEntities.put("&rlm;", "\u200f");
        this.definedEntities.put("&rmoust;", "\u23b1");
        this.definedEntities.put("&rmoustache;", "\u23b1");
        this.definedEntities.put("&rnmid;", "\u2aee");
        this.definedEntities.put("&roang;", "\u27ed");
        this.definedEntities.put("&roarr;", "\u21fe");
        this.definedEntities.put("&robrk;", "\u27e7");
        this.definedEntities.put("&ropar;", "\u2986");
        this.definedEntities.put("&ropf;", "\ud835\udd63");
        this.definedEntities.put("&roplus;", "\u2a2e");
        this.definedEntities.put("&rotimes;", "\u2a35");
        this.definedEntities.put("&rpar;", ")");
        this.definedEntities.put("&rpargt;", "\u2994");
        this.definedEntities.put("&rppolint;", "\u2a12");
        this.definedEntities.put("&rrarr;", "\u21c9");
        this.definedEntities.put("&rsaquo;", "\u203a");
        this.definedEntities.put("&rscr;", "\ud835\udcc7");
        this.definedEntities.put("&rsh;", "\u21b1");
        this.definedEntities.put("&rsqb;", "]");
        this.definedEntities.put("&rsquo;", "\u2019");
        this.definedEntities.put("&rsquor;", "\u2019");
        this.definedEntities.put("&rthree;", "\u22cc");
        this.definedEntities.put("&rtimes;", "\u22ca");
        this.definedEntities.put("&rtri;", "\u25b9");
        this.definedEntities.put("&rtrie;", "\u22b5");
        this.definedEntities.put("&rtrif;", "\u25b8");
        this.definedEntities.put("&rtriltri;", "\u29ce");
        this.definedEntities.put("&ruluhar;", "\u2968");
        this.definedEntities.put("&rx;", "\u211e");
        this.definedEntities.put("&sacute;", "\u015b");
        this.definedEntities.put("&sbquo;", "\u201a");
        this.definedEntities.put("&sc;", "\u227b");
        this.definedEntities.put("&scE;", "\u2ab4");
        this.definedEntities.put("&scap;", "\u2ab8");
        this.definedEntities.put("&scaron;", "\u0161");
        this.definedEntities.put("&sccue;", "\u227d");
        this.definedEntities.put("&sce;", "\u2ab0");
        this.definedEntities.put("&scedil;", "\u015f");
        this.definedEntities.put("&scirc;", "\u015d");
        this.definedEntities.put("&scnE;", "\u2ab6");
        this.definedEntities.put("&scnap;", "\u2aba");
        this.definedEntities.put("&scnsim;", "\u22e9");
        this.definedEntities.put("&scpolint;", "\u2a13");
        this.definedEntities.put("&scsim;", "\u227f");
        this.definedEntities.put("&scy;", "\u0441");
        this.definedEntities.put("&sdot;", "\u22c5");
        this.definedEntities.put("&sdotb;", "\u22a1");
        this.definedEntities.put("&sdote;", "\u2a66");
        this.definedEntities.put("&seArr;", "\u21d8");
        this.definedEntities.put("&searhk;", "\u2925");
        this.definedEntities.put("&searr;", "\u2198");
        this.definedEntities.put("&searrow;", "\u2198");
        this.definedEntities.put("&sect;", "\u00a7");
        this.definedEntities.put("&semi;", ";");
        this.definedEntities.put("&seswar;", "\u2929");
        this.definedEntities.put("&setminus;", "\u2216");
        this.definedEntities.put("&setmn;", "\u2216");
        this.definedEntities.put("&sext;", "\u2736");
        this.definedEntities.put("&sfr;", "\ud835\udd30");
        this.definedEntities.put("&sfrown;", "\u2322");
        this.definedEntities.put("&sharp;", "\u266f");
        this.definedEntities.put("&shchcy;", "\u0449");
        this.definedEntities.put("&shcy;", "\u0448");
        this.definedEntities.put("&shortmid;", "\u2223");
        this.definedEntities.put("&shortparallel;", "\u2225");
        this.definedEntities.put("&shy;", "\u00ad");
        this.definedEntities.put("&sigma;", "\u03c3");
        this.definedEntities.put("&sigmaf;", "\u03c2");
        this.definedEntities.put("&sigmav;", "\u03c2");
        this.definedEntities.put("&sim;", "\u223c");
        this.definedEntities.put("&simdot;", "\u2a6a");
        this.definedEntities.put("&sime;", "\u2243");
        this.definedEntities.put("&simeq;", "\u2243");
        this.definedEntities.put("&simg;", "\u2a9e");
        this.definedEntities.put("&simgE;", "\u2aa0");
        this.definedEntities.put("&siml;", "\u2a9d");
        this.definedEntities.put("&simlE;", "\u2a9f");
        this.definedEntities.put("&simne;", "\u2246");
        this.definedEntities.put("&simplus;", "\u2a24");
        this.definedEntities.put("&simrarr;", "\u2972");
        this.definedEntities.put("&slarr;", "\u2190");
        this.definedEntities.put("&smallsetminus;", "\u2216");
        this.definedEntities.put("&smashp;", "\u2a33");
        this.definedEntities.put("&smeparsl;", "\u29e4");
        this.definedEntities.put("&smid;", "\u2223");
        this.definedEntities.put("&smile;", "\u2323");
        this.definedEntities.put("&smt;", "\u2aaa");
        this.definedEntities.put("&smte;", "\u2aac");
        this.definedEntities.put("&smtes;", "\u2aac\ufe00");
        this.definedEntities.put("&softcy;", "\u044c");
        this.definedEntities.put("&sol;", "/");
        this.definedEntities.put("&solb;", "\u29c4");
        this.definedEntities.put("&solbar;", "\u233f");
        this.definedEntities.put("&sopf;", "\ud835\udd64");
        this.definedEntities.put("&spades;", "\u2660");
        this.definedEntities.put("&spadesuit;", "\u2660");
        this.definedEntities.put("&spar;", "\u2225");
        this.definedEntities.put("&sqcap;", "\u2293");
        this.definedEntities.put("&sqcaps;", "\u2293\ufe00");
        this.definedEntities.put("&sqcup;", "\u2294");
        this.definedEntities.put("&sqcups;", "\u2294\ufe00");
        this.definedEntities.put("&sqsub;", "\u228f");
        this.definedEntities.put("&sqsube;", "\u2291");
        this.definedEntities.put("&sqsubset;", "\u228f");
        this.definedEntities.put("&sqsubseteq;", "\u2291");
        this.definedEntities.put("&sqsup;", "\u2290");
        this.definedEntities.put("&sqsupe;", "\u2292");
        this.definedEntities.put("&sqsupset;", "\u2290");
        this.definedEntities.put("&sqsupseteq;", "\u2292");
        this.definedEntities.put("&squ;", "\u25a1");
        this.definedEntities.put("&square;", "\u25a1");
        this.definedEntities.put("&squarf;", "\u25aa");
        this.definedEntities.put("&squf;", "\u25aa");
        this.definedEntities.put("&srarr;", "\u2192");
        this.definedEntities.put("&sscr;", "\ud835\udcc8");
        this.definedEntities.put("&ssetmn;", "\u2216");
        this.definedEntities.put("&ssmile;", "\u2323");
        this.definedEntities.put("&sstarf;", "\u22c6");
        this.definedEntities.put("&star;", "\u2606");
        this.definedEntities.put("&starf;", "\u2605");
        this.definedEntities.put("&straightepsilon;", "\u03f5");
        this.definedEntities.put("&straightphi;", "\u03d5");
        this.definedEntities.put("&strns;", "\u00af");
        this.definedEntities.put("&sub;", "\u2282");
        this.definedEntities.put("&subE;", "\u2ac5");
        this.definedEntities.put("&subdot;", "\u2abd");
        this.definedEntities.put("&sube;", "\u2286");
        this.definedEntities.put("&subedot;", "\u2ac3");
        this.definedEntities.put("&submult;", "\u2ac1");
        this.definedEntities.put("&subnE;", "\u2acb");
        this.definedEntities.put("&subne;", "\u228a");
        this.definedEntities.put("&subplus;", "\u2abf");
        this.definedEntities.put("&subrarr;", "\u2979");
        this.definedEntities.put("&subset;", "\u2282");
        this.definedEntities.put("&subseteq;", "\u2286");
        this.definedEntities.put("&subseteqq;", "\u2ac5");
        this.definedEntities.put("&subsetneq;", "\u228a");
        this.definedEntities.put("&subsetneqq;", "\u2acb");
        this.definedEntities.put("&subsim;", "\u2ac7");
        this.definedEntities.put("&subsub;", "\u2ad5");
        this.definedEntities.put("&subsup;", "\u2ad3");
        this.definedEntities.put("&succ;", "\u227b");
        this.definedEntities.put("&succapprox;", "\u2ab8");
        this.definedEntities.put("&succcurlyeq;", "\u227d");
        this.definedEntities.put("&succeq;", "\u2ab0");
        this.definedEntities.put("&succnapprox;", "\u2aba");
        this.definedEntities.put("&succneqq;", "\u2ab6");
        this.definedEntities.put("&succnsim;", "\u22e9");
        this.definedEntities.put("&succsim;", "\u227f");
        this.definedEntities.put("&sum;", "\u2211");
        this.definedEntities.put("&sung;", "\u266a");
        this.definedEntities.put("&sup1;", "\u00b9");
        this.definedEntities.put("&sup2;", "\u00b2");
        this.definedEntities.put("&sup3;", "\u00b3");
        this.definedEntities.put("&sup;", "\u2283");
        this.definedEntities.put("&supE;", "\u2ac6");
        this.definedEntities.put("&supdot;", "\u2abe");
        this.definedEntities.put("&supdsub;", "\u2ad8");
        this.definedEntities.put("&supe;", "\u2287");
        this.definedEntities.put("&supedot;", "\u2ac4");
        this.definedEntities.put("&suphsol;", "\u27c9");
        this.definedEntities.put("&suphsub;", "\u2ad7");
        this.definedEntities.put("&suplarr;", "\u297b");
        this.definedEntities.put("&supmult;", "\u2ac2");
        this.definedEntities.put("&supnE;", "\u2acc");
        this.definedEntities.put("&supne;", "\u228b");
        this.definedEntities.put("&supplus;", "\u2ac0");
        this.definedEntities.put("&supset;", "\u2283");
        this.definedEntities.put("&supseteq;", "\u2287");
        this.definedEntities.put("&supseteqq;", "\u2ac6");
        this.definedEntities.put("&supsetneq;", "\u228b");
        this.definedEntities.put("&supsetneqq;", "\u2acc");
        this.definedEntities.put("&supsim;", "\u2ac8");
        this.definedEntities.put("&supsub;", "\u2ad4");
        this.definedEntities.put("&supsup;", "\u2ad6");
        this.definedEntities.put("&swArr;", "\u21d9");
        this.definedEntities.put("&swarhk;", "\u2926");
        this.definedEntities.put("&swarr;", "\u2199");
        this.definedEntities.put("&swarrow;", "\u2199");
        this.definedEntities.put("&swnwar;", "\u292a");
        this.definedEntities.put("&szlig;", "\u00df");
        this.definedEntities.put("&target;", "\u2316");
        this.definedEntities.put("&tau;", "\u03c4");
        this.definedEntities.put("&tbrk;", "\u23b4");
        this.definedEntities.put("&tcaron;", "\u0165");
        this.definedEntities.put("&tcedil;", "\u0163");
        this.definedEntities.put("&tcy;", "\u0442");
        this.definedEntities.put("&tdot;", "\u20db");
        this.definedEntities.put("&telrec;", "\u2315");
        this.definedEntities.put("&tfr;", "\ud835\udd31");
        this.definedEntities.put("&there4;", "\u2234");
        this.definedEntities.put("&therefore;", "\u2234");
        this.definedEntities.put("&theta;", "\u03b8");
        this.definedEntities.put("&thetasym;", "\u03d1");
        this.definedEntities.put("&thetav;", "\u03d1");
        this.definedEntities.put("&thickapprox;", "\u2248");
        this.definedEntities.put("&thicksim;", "\u223c");
        this.definedEntities.put("&thinsp;", "\u2009");
        this.definedEntities.put("&thkap;", "\u2248");
        this.definedEntities.put("&thksim;", "\u223c");
        this.definedEntities.put("&thorn;", "\u00fe");
        this.definedEntities.put("&tilde;", "\u02dc");
        this.definedEntities.put("&times;", "\u00d7");
        this.definedEntities.put("&timesb;", "\u22a0");
        this.definedEntities.put("&timesbar;", "\u2a31");
        this.definedEntities.put("&timesd;", "\u2a30");
        this.definedEntities.put("&tint;", "\u222d");
        this.definedEntities.put("&toea;", "\u2928");
        this.definedEntities.put("&top;", "\u22a4");
        this.definedEntities.put("&topbot;", "\u2336");
        this.definedEntities.put("&topcir;", "\u2af1");
        this.definedEntities.put("&topf;", "\ud835\udd65");
        this.definedEntities.put("&topfork;", "\u2ada");
        this.definedEntities.put("&tosa;", "\u2929");
        this.definedEntities.put("&tprime;", "\u2034");
        this.definedEntities.put("&trade;", "\u2122");
        this.definedEntities.put("&triangle;", "\u25b5");
        this.definedEntities.put("&triangledown;", "\u25bf");
        this.definedEntities.put("&triangleleft;", "\u25c3");
        this.definedEntities.put("&trianglelefteq;", "\u22b4");
        this.definedEntities.put("&triangleq;", "\u225c");
        this.definedEntities.put("&triangleright;", "\u25b9");
        this.definedEntities.put("&trianglerighteq;", "\u22b5");
        this.definedEntities.put("&tridot;", "\u25ec");
        this.definedEntities.put("&trie;", "\u225c");
        this.definedEntities.put("&triminus;", "\u2a3a");
        this.definedEntities.put("&triplus;", "\u2a39");
        this.definedEntities.put("&trisb;", "\u29cd");
        this.definedEntities.put("&tritime;", "\u2a3b");
        this.definedEntities.put("&trpezium;", "\u23e2");
        this.definedEntities.put("&tscr;", "\ud835\udcc9");
        this.definedEntities.put("&tscy;", "\u0446");
        this.definedEntities.put("&tshcy;", "\u045b");
        this.definedEntities.put("&tstrok;", "\u0167");
        this.definedEntities.put("&twixt;", "\u226c");
        this.definedEntities.put("&twoheadleftarrow;", "\u219e");
        this.definedEntities.put("&twoheadrightarrow;", "\u21a0");
        this.definedEntities.put("&uArr;", "\u21d1");
        this.definedEntities.put("&uHar;", "\u2963");
        this.definedEntities.put("&uacute;", "\u00fa");
        this.definedEntities.put("&uarr;", "\u2191");
        this.definedEntities.put("&ubrcy;", "\u045e");
        this.definedEntities.put("&ubreve;", "\u016d");
        this.definedEntities.put("&ucirc;", "\u00fb");
        this.definedEntities.put("&ucy;", "\u0443");
        this.definedEntities.put("&udarr;", "\u21c5");
        this.definedEntities.put("&udblac;", "\u0171");
        this.definedEntities.put("&udhar;", "\u296e");
        this.definedEntities.put("&ufisht;", "\u297e");
        this.definedEntities.put("&ufr;", "\ud835\udd32");
        this.definedEntities.put("&ugrave;", "\u00f9");
        this.definedEntities.put("&uharl;", "\u21bf");
        this.definedEntities.put("&uharr;", "\u21be");
        this.definedEntities.put("&uhblk;", "\u2580");
        this.definedEntities.put("&ulcorn;", "\u231c");
        this.definedEntities.put("&ulcorner;", "\u231c");
        this.definedEntities.put("&ulcrop;", "\u230f");
        this.definedEntities.put("&ultri;", "\u25f8");
        this.definedEntities.put("&umacr;", "\u016b");
        this.definedEntities.put("&uml;", "\u00a8");
        this.definedEntities.put("&uogon;", "\u0173");
        this.definedEntities.put("&uopf;", "\ud835\udd66");
        this.definedEntities.put("&uparrow;", "\u2191");
        this.definedEntities.put("&updownarrow;", "\u2195");
        this.definedEntities.put("&upharpoonleft;", "\u21bf");
        this.definedEntities.put("&upharpoonright;", "\u21be");
        this.definedEntities.put("&uplus;", "\u228e");
        this.definedEntities.put("&upsi;", "\u03c5");
        this.definedEntities.put("&upsih;", "\u03d2");
        this.definedEntities.put("&upsilon;", "\u03c5");
        this.definedEntities.put("&upuparrows;", "\u21c8");
        this.definedEntities.put("&urcorn;", "\u231d");
        this.definedEntities.put("&urcorner;", "\u231d");
        this.definedEntities.put("&urcrop;", "\u230e");
        this.definedEntities.put("&uring;", "\u016f");
        this.definedEntities.put("&urtri;", "\u25f9");
        this.definedEntities.put("&uscr;", "\ud835\udcca");
        this.definedEntities.put("&utdot;", "\u22f0");
        this.definedEntities.put("&utilde;", "\u0169");
        this.definedEntities.put("&utri;", "\u25b5");
        this.definedEntities.put("&utrif;", "\u25b4");
        this.definedEntities.put("&uuarr;", "\u21c8");
        this.definedEntities.put("&uuml;", "\u00fc");
        this.definedEntities.put("&uwangle;", "\u29a7");
        this.definedEntities.put("&vArr;", "\u21d5");
        this.definedEntities.put("&vBar;", "\u2ae8");
        this.definedEntities.put("&vBarv;", "\u2ae9");
        this.definedEntities.put("&vDash;", "\u22a8");
        this.definedEntities.put("&vangrt;", "\u299c");
        this.definedEntities.put("&varepsilon;", "\u03f5");
        this.definedEntities.put("&varkappa;", "\u03f0");
        this.definedEntities.put("&varnothing;", "\u2205");
        this.definedEntities.put("&varphi;", "\u03d5");
        this.definedEntities.put("&varpi;", "\u03d6");
        this.definedEntities.put("&varpropto;", "\u221d");
        this.definedEntities.put("&varr;", "\u2195");
        this.definedEntities.put("&varrho;", "\u03f1");
        this.definedEntities.put("&varsigma;", "\u03c2");
        this.definedEntities.put("&varsubsetneq;", "\u228a\ufe00");
        this.definedEntities.put("&varsubsetneqq;", "\u2acb\ufe00");
        this.definedEntities.put("&varsupsetneq;", "\u228b\ufe00");
        this.definedEntities.put("&varsupsetneqq;", "\u2acc\ufe00");
        this.definedEntities.put("&vartheta;", "\u03d1");
        this.definedEntities.put("&vartriangleleft;", "\u22b2");
        this.definedEntities.put("&vartriangleright;", "\u22b3");
        this.definedEntities.put("&vcy;", "\u0432");
        this.definedEntities.put("&vdash;", "\u22a2");
        this.definedEntities.put("&vee;", "\u2228");
        this.definedEntities.put("&veebar;", "\u22bb");
        this.definedEntities.put("&veeeq;", "\u225a");
        this.definedEntities.put("&vellip;", "\u22ee");
        this.definedEntities.put("&verbar;", "|");
        this.definedEntities.put("&vert;", "|");
        this.definedEntities.put("&vfr;", "\ud835\udd33");
        this.definedEntities.put("&vltri;", "\u22b2");
        this.definedEntities.put("&vnsub;", "\u2282\u20d2");
        this.definedEntities.put("&vnsup;", "\u2283\u20d2");
        this.definedEntities.put("&vopf;", "\ud835\udd67");
        this.definedEntities.put("&vprop;", "\u221d");
        this.definedEntities.put("&vrtri;", "\u22b3");
        this.definedEntities.put("&vscr;", "\ud835\udccb");
        this.definedEntities.put("&vsubnE;", "\u2acb\ufe00");
        this.definedEntities.put("&vsubne;", "\u228a\ufe00");
        this.definedEntities.put("&vsupnE;", "\u2acc\ufe00");
        this.definedEntities.put("&vsupne;", "\u228b\ufe00");
        this.definedEntities.put("&vzigzag;", "\u299a");
        this.definedEntities.put("&wcirc;", "\u0175");
        this.definedEntities.put("&wedbar;", "\u2a5f");
        this.definedEntities.put("&wedge;", "\u2227");
        this.definedEntities.put("&wedgeq;", "\u2259");
        this.definedEntities.put("&weierp;", "\u2118");
        this.definedEntities.put("&wfr;", "\ud835\udd34");
        this.definedEntities.put("&wopf;", "\ud835\udd68");
        this.definedEntities.put("&wp;", "\u2118");
        this.definedEntities.put("&wr;", "\u2240");
        this.definedEntities.put("&wreath;", "\u2240");
        this.definedEntities.put("&wscr;", "\ud835\udccc");
        this.definedEntities.put("&xcap;", "\u22c2");
        this.definedEntities.put("&xcirc;", "\u25ef");
        this.definedEntities.put("&xcup;", "\u22c3");
        this.definedEntities.put("&xdtri;", "\u25bd");
        this.definedEntities.put("&xfr;", "\ud835\udd35");
        this.definedEntities.put("&xhArr;", "\u27fa");
        this.definedEntities.put("&xharr;", "\u27f7");
        this.definedEntities.put("&xi;", "\u03be");
        this.definedEntities.put("&xlArr;", "\u27f8");
        this.definedEntities.put("&xlarr;", "\u27f5");
        this.definedEntities.put("&xmap;", "\u27fc");
        this.definedEntities.put("&xnis;", "\u22fb");
        this.definedEntities.put("&xodot;", "\u2a00");
        this.definedEntities.put("&xopf;", "\ud835\udd69");
        this.definedEntities.put("&xoplus;", "\u2a01");
        this.definedEntities.put("&xotime;", "\u2a02");
        this.definedEntities.put("&xrArr;", "\u27f9");
        this.definedEntities.put("&xrarr;", "\u27f6");
        this.definedEntities.put("&xscr;", "\ud835\udccd");
        this.definedEntities.put("&xsqcup;", "\u2a06");
        this.definedEntities.put("&xuplus;", "\u2a04");
        this.definedEntities.put("&xutri;", "\u25b3");
        this.definedEntities.put("&xvee;", "\u22c1");
        this.definedEntities.put("&xwedge;", "\u22c0");
        this.definedEntities.put("&yacute;", "\u00fd");
        this.definedEntities.put("&yacy;", "\u044f");
        this.definedEntities.put("&ycirc;", "\u0177");
        this.definedEntities.put("&ycy;", "\u044b");
        this.definedEntities.put("&yen;", "\u00a5");
        this.definedEntities.put("&yfr;", "\ud835\udd36");
        this.definedEntities.put("&yicy;", "\u0457");
        this.definedEntities.put("&yopf;", "\ud835\udd6a");
        this.definedEntities.put("&yscr;", "\ud835\udcce");
        this.definedEntities.put("&yucy;", "\u044e");
        this.definedEntities.put("&yuml;", "\u00ff");
        this.definedEntities.put("&zacute;", "\u017a");
        this.definedEntities.put("&zcaron;", "\u017e");
        this.definedEntities.put("&zcy;", "\u0437");
        this.definedEntities.put("&zdot;", "\u017c");
        this.definedEntities.put("&zeetrf;", "\u2128");
        this.definedEntities.put("&zeta;", "\u03b6");
        this.definedEntities.put("&zfr;", "\ud835\udd37");
        this.definedEntities.put("&zhcy;", "\u0436");
        this.definedEntities.put("&zigrarr;", "\u21dd");
        this.definedEntities.put("&zopf;", "\ud835\udd6b");
        this.definedEntities.put("&zscr;", "\ud835\udccf");
        this.definedEntities.put("&zwj;", "\u200d");
        this.definedEntities.put("&zwnj;", "\u200c");
    }

    public static enum ParserSecurityPolicy {
        Accept,
        Drop,
        Reject;

    }

    public class ElementName {
        private String namespace;
        private String name;

        public ElementName(String src) {
            if (src.contains(":")) {
                this.namespace = src.substring(0, src.indexOf(":"));
                this.name = src.substring(src.indexOf(":") + 1);
            } else {
                this.namespace = null;
                this.name = src;
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean hasNamespace() {
            return this.namespace != null;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String toString() {
            return this.namespace + "::" + this.name;
        }
    }

    public class NamespaceNormalizationMap {
        private String defaultNamespace;
        private String originalNamespacePrefix;
        private Map<String, String> map = new HashMap<String, String>();

        public NamespaceNormalizationMap(NamespaceNormalizationMap namespaceMap) {
            if (namespaceMap != null) {
                this.map.putAll(namespaceMap.map);
                this.defaultNamespace = namespaceMap.defaultNamespace;
                this.originalNamespacePrefix = namespaceMap.originalNamespacePrefix;
            }
        }

        public void setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        public void setOriginalNamespacePrefix(String originalNamespacePrefix) {
            this.originalNamespacePrefix = originalNamespacePrefix;
        }

        public void putNamespacePrefix(String prefix, String namespace) {
            this.map.put(prefix, namespace);
        }

        public String getDefaultNamespace() {
            return this.defaultNamespace;
        }

        public boolean hasDefaultNamespace() {
            return this.defaultNamespace != null;
        }

        public String getNamespaceForPrefix(String prefix) {
            if (this.originalNamespacePrefix != null && this.originalNamespacePrefix.equals(prefix)) {
                return this.defaultNamespace;
            }
            return this.map.containsKey(prefix) ? this.map.get(prefix) : "http://error/undefined-namespace";
        }

        public Set<Map.Entry<String, String>> getPrefixNamespaceEntrySet() {
            return this.map.entrySet();
        }
    }
}

