/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4b.model.Annotation;
import org.hl7.fhir.r4b.model.BackboneType;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.DecimalType;
import org.hl7.fhir.r4b.model.Element;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.EvidenceVariable;
import org.hl7.fhir.r4b.model.Group;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Quantity;
import org.hl7.fhir.r4b.model.Range;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UnsignedIntType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Statistic")
public class Statistic
extends BackboneType
implements ICompositeType {
    @Child(name="description", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Description of content", formalDefinition="A description of the content value of the statistic.")
    protected StringType description;
    @Child(name="note", type={Annotation.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Footnotes and/or explanatory notes", formalDefinition="Footnotes and/or explanatory notes.")
    protected List<Annotation> note;
    @Child(name="statisticType", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of statistic, eg relative risk", formalDefinition="Type of statistic, eg relative risk.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/statistic-type")
    protected CodeableConcept statisticType;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Associated category for categorical variable\"", formalDefinition="When the measured variable is handled categorically, the category element is used to define which category the statistic is reporting.")
    protected CodeableConcept category;
    @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Statistic value", formalDefinition="Statistic value.")
    protected Quantity quantity;
    @Child(name="numberOfEvents", type={UnsignedIntType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The number of events associated with the statistic", formalDefinition="The number of events associated with the statistic, where the unit of analysis is different from numberAffected, sampleSize.knownDataCount and sampleSize.numberOfParticipants.")
    protected UnsignedIntType numberOfEvents;
    @Child(name="numberAffected", type={UnsignedIntType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The number of participants affected", formalDefinition="The number of participants affected where the unit of analysis is the same as sampleSize.knownDataCount and sampleSize.numberOfParticipants.")
    protected UnsignedIntType numberAffected;
    @Child(name="sampleSize", type={}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of samples in the statistic", formalDefinition="Number of samples in the statistic.")
    protected StatisticSampleSizeComponent sampleSize;
    @Child(name="attributeEstimate", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An attribute of the Statistic", formalDefinition="A statistical attribute of the statistic such as a measure of heterogeneity.")
    protected List<StatisticAttributeEstimateComponent> attributeEstimate;
    @Child(name="modelCharacteristic", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Model characteristic", formalDefinition="A component of the method to generate the statistic.")
    protected List<StatisticModelCharacteristicComponent> modelCharacteristic;
    private static final long serialVersionUID = -1861373489L;

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Statistic setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Statistic setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Statistic setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Statistic addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public CodeableConcept getStatisticType() {
        if (this.statisticType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.statisticType");
            }
            if (Configuration.doAutoCreate()) {
                this.statisticType = new CodeableConcept();
            }
        }
        return this.statisticType;
    }

    public boolean hasStatisticType() {
        return this.statisticType != null && !this.statisticType.isEmpty();
    }

    public Statistic setStatisticType(CodeableConcept value) {
        this.statisticType = value;
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public Statistic setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public Statistic setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public UnsignedIntType getNumberOfEventsElement() {
        if (this.numberOfEvents == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.numberOfEvents");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfEvents = new UnsignedIntType();
            }
        }
        return this.numberOfEvents;
    }

    public boolean hasNumberOfEventsElement() {
        return this.numberOfEvents != null && !this.numberOfEvents.isEmpty();
    }

    public boolean hasNumberOfEvents() {
        return this.numberOfEvents != null && !this.numberOfEvents.isEmpty();
    }

    public Statistic setNumberOfEventsElement(UnsignedIntType value) {
        this.numberOfEvents = value;
        return this;
    }

    public int getNumberOfEvents() {
        return this.numberOfEvents == null || this.numberOfEvents.isEmpty() ? 0 : (Integer)this.numberOfEvents.getValue();
    }

    public Statistic setNumberOfEvents(int value) {
        if (this.numberOfEvents == null) {
            this.numberOfEvents = new UnsignedIntType();
        }
        this.numberOfEvents.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getNumberAffectedElement() {
        if (this.numberAffected == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.numberAffected");
            }
            if (Configuration.doAutoCreate()) {
                this.numberAffected = new UnsignedIntType();
            }
        }
        return this.numberAffected;
    }

    public boolean hasNumberAffectedElement() {
        return this.numberAffected != null && !this.numberAffected.isEmpty();
    }

    public boolean hasNumberAffected() {
        return this.numberAffected != null && !this.numberAffected.isEmpty();
    }

    public Statistic setNumberAffectedElement(UnsignedIntType value) {
        this.numberAffected = value;
        return this;
    }

    public int getNumberAffected() {
        return this.numberAffected == null || this.numberAffected.isEmpty() ? 0 : (Integer)this.numberAffected.getValue();
    }

    public Statistic setNumberAffected(int value) {
        if (this.numberAffected == null) {
            this.numberAffected = new UnsignedIntType();
        }
        this.numberAffected.setValue((Object)value);
        return this;
    }

    public StatisticSampleSizeComponent getSampleSize() {
        if (this.sampleSize == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Statistic.sampleSize");
            }
            if (Configuration.doAutoCreate()) {
                this.sampleSize = new StatisticSampleSizeComponent();
            }
        }
        return this.sampleSize;
    }

    public boolean hasSampleSize() {
        return this.sampleSize != null && !this.sampleSize.isEmpty();
    }

    public Statistic setSampleSize(StatisticSampleSizeComponent value) {
        this.sampleSize = value;
        return this;
    }

    public List<StatisticAttributeEstimateComponent> getAttributeEstimate() {
        if (this.attributeEstimate == null) {
            this.attributeEstimate = new ArrayList<StatisticAttributeEstimateComponent>();
        }
        return this.attributeEstimate;
    }

    public Statistic setAttributeEstimate(List<StatisticAttributeEstimateComponent> theAttributeEstimate) {
        this.attributeEstimate = theAttributeEstimate;
        return this;
    }

    public boolean hasAttributeEstimate() {
        if (this.attributeEstimate == null) {
            return false;
        }
        for (StatisticAttributeEstimateComponent item : this.attributeEstimate) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StatisticAttributeEstimateComponent addAttributeEstimate() {
        StatisticAttributeEstimateComponent t = new StatisticAttributeEstimateComponent();
        if (this.attributeEstimate == null) {
            this.attributeEstimate = new ArrayList<StatisticAttributeEstimateComponent>();
        }
        this.attributeEstimate.add(t);
        return t;
    }

    public Statistic addAttributeEstimate(StatisticAttributeEstimateComponent t) {
        if (t == null) {
            return this;
        }
        if (this.attributeEstimate == null) {
            this.attributeEstimate = new ArrayList<StatisticAttributeEstimateComponent>();
        }
        this.attributeEstimate.add(t);
        return this;
    }

    public StatisticAttributeEstimateComponent getAttributeEstimateFirstRep() {
        if (this.getAttributeEstimate().isEmpty()) {
            this.addAttributeEstimate();
        }
        return this.getAttributeEstimate().get(0);
    }

    public List<StatisticModelCharacteristicComponent> getModelCharacteristic() {
        if (this.modelCharacteristic == null) {
            this.modelCharacteristic = new ArrayList<StatisticModelCharacteristicComponent>();
        }
        return this.modelCharacteristic;
    }

    public Statistic setModelCharacteristic(List<StatisticModelCharacteristicComponent> theModelCharacteristic) {
        this.modelCharacteristic = theModelCharacteristic;
        return this;
    }

    public boolean hasModelCharacteristic() {
        if (this.modelCharacteristic == null) {
            return false;
        }
        for (StatisticModelCharacteristicComponent item : this.modelCharacteristic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StatisticModelCharacteristicComponent addModelCharacteristic() {
        StatisticModelCharacteristicComponent t = new StatisticModelCharacteristicComponent();
        if (this.modelCharacteristic == null) {
            this.modelCharacteristic = new ArrayList<StatisticModelCharacteristicComponent>();
        }
        this.modelCharacteristic.add(t);
        return t;
    }

    public Statistic addModelCharacteristic(StatisticModelCharacteristicComponent t) {
        if (t == null) {
            return this;
        }
        if (this.modelCharacteristic == null) {
            this.modelCharacteristic = new ArrayList<StatisticModelCharacteristicComponent>();
        }
        this.modelCharacteristic.add(t);
        return this;
    }

    public StatisticModelCharacteristicComponent getModelCharacteristicFirstRep() {
        if (this.getModelCharacteristic().isEmpty()) {
            this.addModelCharacteristic();
        }
        return this.getModelCharacteristic().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("description", "string", "A description of the content value of the statistic.", 0, 1, this.description));
        children.add(new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("statisticType", "CodeableConcept", "Type of statistic, eg relative risk.", 0, 1, this.statisticType));
        children.add(new Property("category", "CodeableConcept", "When the measured variable is handled categorically, the category element is used to define which category the statistic is reporting.", 0, 1, this.category));
        children.add(new Property("quantity", "Quantity", "Statistic value.", 0, 1, this.quantity));
        children.add(new Property("numberOfEvents", "unsignedInt", "The number of events associated with the statistic, where the unit of analysis is different from numberAffected, sampleSize.knownDataCount and sampleSize.numberOfParticipants.", 0, 1, this.numberOfEvents));
        children.add(new Property("numberAffected", "unsignedInt", "The number of participants affected where the unit of analysis is the same as sampleSize.knownDataCount and sampleSize.numberOfParticipants.", 0, 1, this.numberAffected));
        children.add(new Property("sampleSize", "", "Number of samples in the statistic.", 0, 1, this.sampleSize));
        children.add(new Property("attributeEstimate", "", "A statistical attribute of the statistic such as a measure of heterogeneity.", 0, Integer.MAX_VALUE, this.attributeEstimate));
        children.add(new Property("modelCharacteristic", "", "A component of the method to generate the statistic.", 0, Integer.MAX_VALUE, this.modelCharacteristic));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1724546052: {
                return new Property("description", "string", "A description of the content value of the statistic.", 0, 1, this.description);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Footnotes and/or explanatory notes.", 0, Integer.MAX_VALUE, this.note);
            }
            case -392342358: {
                return new Property("statisticType", "CodeableConcept", "Type of statistic, eg relative risk.", 0, 1, this.statisticType);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "When the measured variable is handled categorically, the category element is used to define which category the statistic is reporting.", 0, 1, this.category);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "Statistic value.", 0, 1, this.quantity);
            }
            case 1534510137: {
                return new Property("numberOfEvents", "unsignedInt", "The number of events associated with the statistic, where the unit of analysis is different from numberAffected, sampleSize.knownDataCount and sampleSize.numberOfParticipants.", 0, 1, this.numberOfEvents);
            }
            case -460990243: {
                return new Property("numberAffected", "unsignedInt", "The number of participants affected where the unit of analysis is the same as sampleSize.knownDataCount and sampleSize.numberOfParticipants.", 0, 1, this.numberAffected);
            }
            case 143123659: {
                return new Property("sampleSize", "", "Number of samples in the statistic.", 0, 1, this.sampleSize);
            }
            case -1539581980: {
                return new Property("attributeEstimate", "", "A statistical attribute of the statistic such as a measure of heterogeneity.", 0, Integer.MAX_VALUE, this.attributeEstimate);
            }
            case 274795812: {
                return new Property("modelCharacteristic", "", "A component of the method to generate the statistic.", 0, Integer.MAX_VALUE, this.modelCharacteristic);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.description;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -392342358: {
                Base[] baseArray;
                if (this.statisticType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.statisticType;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.category;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.quantity;
                }
                return baseArray;
            }
            case 1534510137: {
                Base[] baseArray;
                if (this.numberOfEvents == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.numberOfEvents;
                }
                return baseArray;
            }
            case -460990243: {
                Base[] baseArray;
                if (this.numberAffected == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.numberAffected;
                }
                return baseArray;
            }
            case 143123659: {
                Base[] baseArray;
                if (this.sampleSize == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.sampleSize;
                }
                return baseArray;
            }
            case -1539581980: {
                return this.attributeEstimate == null ? new Base[]{} : this.attributeEstimate.toArray(new Base[this.attributeEstimate.size()]);
            }
            case 274795812: {
                return this.modelCharacteristic == null ? new Base[]{} : this.modelCharacteristic.toArray(new Base[this.modelCharacteristic.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -392342358: {
                this.statisticType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.category = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToQuantity(value);
                return value;
            }
            case 1534510137: {
                this.numberOfEvents = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -460990243: {
                this.numberAffected = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case 143123659: {
                this.sampleSize = (StatisticSampleSizeComponent)value;
                return value;
            }
            case -1539581980: {
                this.getAttributeEstimate().add((StatisticAttributeEstimateComponent)value);
                return value;
            }
            case 274795812: {
                this.getModelCharacteristic().add((StatisticModelCharacteristicComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("statisticType")) {
            this.statisticType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("category")) {
            this.category = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("quantity")) {
            this.quantity = TypeConvertor.castToQuantity(value);
        } else if (name.equals("numberOfEvents")) {
            this.numberOfEvents = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("numberAffected")) {
            this.numberAffected = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("sampleSize")) {
            this.sampleSize = (StatisticSampleSizeComponent)value;
        } else if (name.equals("attributeEstimate")) {
            this.getAttributeEstimate().add((StatisticAttributeEstimateComponent)value);
        } else if (name.equals("modelCharacteristic")) {
            this.getModelCharacteristic().add((StatisticModelCharacteristicComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -392342358: {
                return this.getStatisticType();
            }
            case 50511102: {
                return this.getCategory();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case 1534510137: {
                return this.getNumberOfEventsElement();
            }
            case -460990243: {
                return this.getNumberAffectedElement();
            }
            case 143123659: {
                return this.getSampleSize();
            }
            case -1539581980: {
                return this.addAttributeEstimate();
            }
            case 274795812: {
                return this.addModelCharacteristic();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return new String[]{"string"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -392342358: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case 1534510137: {
                return new String[]{"unsignedInt"};
            }
            case -460990243: {
                return new String[]{"unsignedInt"};
            }
            case 143123659: {
                return new String[0];
            }
            case -1539581980: {
                return new String[0];
            }
            case 274795812: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Statistic.description");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("statisticType")) {
            this.statisticType = new CodeableConcept();
            return this.statisticType;
        }
        if (name.equals("category")) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("numberOfEvents")) {
            throw new FHIRException("Cannot call addChild on a primitive type Statistic.numberOfEvents");
        }
        if (name.equals("numberAffected")) {
            throw new FHIRException("Cannot call addChild on a primitive type Statistic.numberAffected");
        }
        if (name.equals("sampleSize")) {
            this.sampleSize = new StatisticSampleSizeComponent();
            return this.sampleSize;
        }
        if (name.equals("attributeEstimate")) {
            return this.addAttributeEstimate();
        }
        if (name.equals("modelCharacteristic")) {
            return this.addModelCharacteristic();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Statistic";
    }

    @Override
    public Statistic copy() {
        Statistic dst = new Statistic();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Statistic dst) {
        super.copyValues(dst);
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.statisticType = this.statisticType == null ? null : this.statisticType.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.quantity = this.quantity == null ? null : this.quantity.copy();
        dst.numberOfEvents = this.numberOfEvents == null ? null : this.numberOfEvents.copy();
        dst.numberAffected = this.numberAffected == null ? null : this.numberAffected.copy();
        StatisticSampleSizeComponent statisticSampleSizeComponent = dst.sampleSize = this.sampleSize == null ? null : this.sampleSize.copy();
        if (this.attributeEstimate != null) {
            dst.attributeEstimate = new ArrayList<StatisticAttributeEstimateComponent>();
            for (StatisticAttributeEstimateComponent statisticAttributeEstimateComponent : this.attributeEstimate) {
                dst.attributeEstimate.add(statisticAttributeEstimateComponent.copy());
            }
        }
        if (this.modelCharacteristic != null) {
            dst.modelCharacteristic = new ArrayList<StatisticModelCharacteristicComponent>();
            for (StatisticModelCharacteristicComponent statisticModelCharacteristicComponent : this.modelCharacteristic) {
                dst.modelCharacteristic.add(statisticModelCharacteristicComponent.copy());
            }
        }
    }

    protected Statistic typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Statistic)) {
            return false;
        }
        Statistic o = (Statistic)other_;
        return Statistic.compareDeep(this.description, o.description, true) && Statistic.compareDeep(this.note, o.note, true) && Statistic.compareDeep(this.statisticType, o.statisticType, true) && Statistic.compareDeep(this.category, o.category, true) && Statistic.compareDeep(this.quantity, o.quantity, true) && Statistic.compareDeep(this.numberOfEvents, o.numberOfEvents, true) && Statistic.compareDeep(this.numberAffected, o.numberAffected, true) && Statistic.compareDeep(this.sampleSize, o.sampleSize, true) && Statistic.compareDeep(this.attributeEstimate, o.attributeEstimate, true) && Statistic.compareDeep(this.modelCharacteristic, o.modelCharacteristic, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Statistic)) {
            return false;
        }
        Statistic o = (Statistic)other_;
        return Statistic.compareValues(this.description, o.description, true) && Statistic.compareValues(this.numberOfEvents, o.numberOfEvents, true) && Statistic.compareValues(this.numberAffected, o.numberAffected, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.statisticType, this.category, this.quantity, this.numberOfEvents, this.numberAffected, this.sampleSize, this.attributeEstimate, this.modelCharacteristic});
    }

    @Block
    public static class StatisticModelCharacteristicVariableComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="variableDefinition", type={Group.class, EvidenceVariable.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of the variable", formalDefinition="Description of the variable.")
        protected Reference variableDefinition;
        @Child(name="handling", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="continuous | dichotomous | ordinal | polychotomous", formalDefinition="How the variable is classified for use in adjusted analysis.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/variable-handling")
        protected Enumeration<Enumerations.EvidenceVariableHandling> handling;
        @Child(name="valueCategory", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Description for grouping of ordinal or polychotomous variables", formalDefinition="Description for grouping of ordinal or polychotomous variables.")
        protected List<CodeableConcept> valueCategory;
        @Child(name="valueQuantity", type={Quantity.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Discrete value for grouping of ordinal or polychotomous variables", formalDefinition="Discrete value for grouping of ordinal or polychotomous variables.")
        protected List<Quantity> valueQuantity;
        @Child(name="valueRange", type={Range.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Range of values for grouping of ordinal or polychotomous variables", formalDefinition="Range of values for grouping of ordinal or polychotomous variables.")
        protected List<Range> valueRange;
        private static final long serialVersionUID = 1516174900L;

        public StatisticModelCharacteristicVariableComponent() {
        }

        public StatisticModelCharacteristicVariableComponent(Reference variableDefinition) {
            this.setVariableDefinition(variableDefinition);
        }

        public Reference getVariableDefinition() {
            if (this.variableDefinition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticModelCharacteristicVariableComponent.variableDefinition");
                }
                if (Configuration.doAutoCreate()) {
                    this.variableDefinition = new Reference();
                }
            }
            return this.variableDefinition;
        }

        public boolean hasVariableDefinition() {
            return this.variableDefinition != null && !this.variableDefinition.isEmpty();
        }

        public StatisticModelCharacteristicVariableComponent setVariableDefinition(Reference value) {
            this.variableDefinition = value;
            return this;
        }

        public Enumeration<Enumerations.EvidenceVariableHandling> getHandlingElement() {
            if (this.handling == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticModelCharacteristicVariableComponent.handling");
                }
                if (Configuration.doAutoCreate()) {
                    this.handling = new Enumeration<Enumerations.EvidenceVariableHandling>(new Enumerations.EvidenceVariableHandlingEnumFactory());
                }
            }
            return this.handling;
        }

        public boolean hasHandlingElement() {
            return this.handling != null && !this.handling.isEmpty();
        }

        public boolean hasHandling() {
            return this.handling != null && !this.handling.isEmpty();
        }

        public StatisticModelCharacteristicVariableComponent setHandlingElement(Enumeration<Enumerations.EvidenceVariableHandling> value) {
            this.handling = value;
            return this;
        }

        public Enumerations.EvidenceVariableHandling getHandling() {
            return this.handling == null ? null : (Enumerations.EvidenceVariableHandling)((Object)this.handling.getValue());
        }

        public StatisticModelCharacteristicVariableComponent setHandling(Enumerations.EvidenceVariableHandling value) {
            if (value == null) {
                this.handling = null;
            } else {
                if (this.handling == null) {
                    this.handling = new Enumeration<Enumerations.EvidenceVariableHandling>(new Enumerations.EvidenceVariableHandlingEnumFactory());
                }
                this.handling.setValue((Object)value);
            }
            return this;
        }

        public List<CodeableConcept> getValueCategory() {
            if (this.valueCategory == null) {
                this.valueCategory = new ArrayList<CodeableConcept>();
            }
            return this.valueCategory;
        }

        public StatisticModelCharacteristicVariableComponent setValueCategory(List<CodeableConcept> theValueCategory) {
            this.valueCategory = theValueCategory;
            return this;
        }

        public boolean hasValueCategory() {
            if (this.valueCategory == null) {
                return false;
            }
            for (CodeableConcept item : this.valueCategory) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addValueCategory() {
            CodeableConcept t = new CodeableConcept();
            if (this.valueCategory == null) {
                this.valueCategory = new ArrayList<CodeableConcept>();
            }
            this.valueCategory.add(t);
            return t;
        }

        public StatisticModelCharacteristicVariableComponent addValueCategory(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.valueCategory == null) {
                this.valueCategory = new ArrayList<CodeableConcept>();
            }
            this.valueCategory.add(t);
            return this;
        }

        public CodeableConcept getValueCategoryFirstRep() {
            if (this.getValueCategory().isEmpty()) {
                this.addValueCategory();
            }
            return this.getValueCategory().get(0);
        }

        public List<Quantity> getValueQuantity() {
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            return this.valueQuantity;
        }

        public StatisticModelCharacteristicVariableComponent setValueQuantity(List<Quantity> theValueQuantity) {
            this.valueQuantity = theValueQuantity;
            return this;
        }

        public boolean hasValueQuantity() {
            if (this.valueQuantity == null) {
                return false;
            }
            for (Quantity item : this.valueQuantity) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Quantity addValueQuantity() {
            Quantity t = new Quantity();
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return t;
        }

        public StatisticModelCharacteristicVariableComponent addValueQuantity(Quantity t) {
            if (t == null) {
                return this;
            }
            if (this.valueQuantity == null) {
                this.valueQuantity = new ArrayList<Quantity>();
            }
            this.valueQuantity.add(t);
            return this;
        }

        public Quantity getValueQuantityFirstRep() {
            if (this.getValueQuantity().isEmpty()) {
                this.addValueQuantity();
            }
            return this.getValueQuantity().get(0);
        }

        public List<Range> getValueRange() {
            if (this.valueRange == null) {
                this.valueRange = new ArrayList<Range>();
            }
            return this.valueRange;
        }

        public StatisticModelCharacteristicVariableComponent setValueRange(List<Range> theValueRange) {
            this.valueRange = theValueRange;
            return this;
        }

        public boolean hasValueRange() {
            if (this.valueRange == null) {
                return false;
            }
            for (Range item : this.valueRange) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Range addValueRange() {
            Range t = new Range();
            if (this.valueRange == null) {
                this.valueRange = new ArrayList<Range>();
            }
            this.valueRange.add(t);
            return t;
        }

        public StatisticModelCharacteristicVariableComponent addValueRange(Range t) {
            if (t == null) {
                return this;
            }
            if (this.valueRange == null) {
                this.valueRange = new ArrayList<Range>();
            }
            this.valueRange.add(t);
            return this;
        }

        public Range getValueRangeFirstRep() {
            if (this.getValueRange().isEmpty()) {
                this.addValueRange();
            }
            return this.getValueRange().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("variableDefinition", "Reference(Group|EvidenceVariable)", "Description of the variable.", 0, 1, this.variableDefinition));
            children.add(new Property("handling", "code", "How the variable is classified for use in adjusted analysis.", 0, 1, this.handling));
            children.add(new Property("valueCategory", "CodeableConcept", "Description for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueCategory));
            children.add(new Property("valueQuantity", "Quantity", "Discrete value for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueQuantity));
            children.add(new Property("valueRange", "Range", "Range of values for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueRange));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1807222545: {
                    return new Property("variableDefinition", "Reference(Group|EvidenceVariable)", "Description of the variable.", 0, 1, this.variableDefinition);
                }
                case 2072805: {
                    return new Property("handling", "code", "How the variable is classified for use in adjusted analysis.", 0, 1, this.handling);
                }
                case -694308465: {
                    return new Property("valueCategory", "CodeableConcept", "Description for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueCategory);
                }
                case -2029823716: {
                    return new Property("valueQuantity", "Quantity", "Discrete value for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueQuantity);
                }
                case 2030761548: {
                    return new Property("valueRange", "Range", "Range of values for grouping of ordinal or polychotomous variables.", 0, Integer.MAX_VALUE, this.valueRange);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1807222545: {
                    Base[] baseArray;
                    if (this.variableDefinition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.variableDefinition;
                    }
                    return baseArray;
                }
                case 2072805: {
                    Base[] baseArray;
                    if (this.handling == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.handling;
                    }
                    return baseArray;
                }
                case -694308465: {
                    return this.valueCategory == null ? new Base[]{} : this.valueCategory.toArray(new Base[this.valueCategory.size()]);
                }
                case -2029823716: {
                    return this.valueQuantity == null ? new Base[]{} : this.valueQuantity.toArray(new Base[this.valueQuantity.size()]);
                }
                case 2030761548: {
                    return this.valueRange == null ? new Base[]{} : this.valueRange.toArray(new Base[this.valueRange.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1807222545: {
                    this.variableDefinition = TypeConvertor.castToReference(value);
                    return value;
                }
                case 2072805: {
                    value = new Enumerations.EvidenceVariableHandlingEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.handling = value;
                    return value;
                }
                case -694308465: {
                    this.getValueCategory().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -2029823716: {
                    this.getValueQuantity().add(TypeConvertor.castToQuantity(value));
                    return value;
                }
                case 2030761548: {
                    this.getValueRange().add(TypeConvertor.castToRange(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("variableDefinition")) {
                this.variableDefinition = TypeConvertor.castToReference(value);
            } else if (name.equals("handling")) {
                value = new Enumerations.EvidenceVariableHandlingEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.handling = value;
            } else if (name.equals("valueCategory")) {
                this.getValueCategory().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("valueQuantity")) {
                this.getValueQuantity().add(TypeConvertor.castToQuantity(value));
            } else if (name.equals("valueRange")) {
                this.getValueRange().add(TypeConvertor.castToRange(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1807222545: {
                    return this.getVariableDefinition();
                }
                case 2072805: {
                    return this.getHandlingElement();
                }
                case -694308465: {
                    return this.addValueCategory();
                }
                case -2029823716: {
                    return this.addValueQuantity();
                }
                case 2030761548: {
                    return this.addValueRange();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1807222545: {
                    return new String[]{"Reference"};
                }
                case 2072805: {
                    return new String[]{"code"};
                }
                case -694308465: {
                    return new String[]{"CodeableConcept"};
                }
                case -2029823716: {
                    return new String[]{"Quantity"};
                }
                case 2030761548: {
                    return new String[]{"Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("variableDefinition")) {
                this.variableDefinition = new Reference();
                return this.variableDefinition;
            }
            if (name.equals("handling")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.modelCharacteristic.variable.handling");
            }
            if (name.equals("valueCategory")) {
                return this.addValueCategory();
            }
            if (name.equals("valueQuantity")) {
                return this.addValueQuantity();
            }
            if (name.equals("valueRange")) {
                return this.addValueRange();
            }
            return super.addChild(name);
        }

        @Override
        public StatisticModelCharacteristicVariableComponent copy() {
            StatisticModelCharacteristicVariableComponent dst = new StatisticModelCharacteristicVariableComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatisticModelCharacteristicVariableComponent dst) {
            super.copyValues(dst);
            dst.variableDefinition = this.variableDefinition == null ? null : this.variableDefinition.copy();
            Enumeration<Enumerations.EvidenceVariableHandling> enumeration = dst.handling = this.handling == null ? null : this.handling.copy();
            if (this.valueCategory != null) {
                dst.valueCategory = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.valueCategory) {
                    dst.valueCategory.add(codeableConcept.copy());
                }
            }
            if (this.valueQuantity != null) {
                dst.valueQuantity = new ArrayList<Quantity>();
                for (Quantity quantity : this.valueQuantity) {
                    dst.valueQuantity.add(quantity.copy());
                }
            }
            if (this.valueRange != null) {
                dst.valueRange = new ArrayList<Range>();
                for (Range range : this.valueRange) {
                    dst.valueRange.add(range.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticModelCharacteristicVariableComponent)) {
                return false;
            }
            StatisticModelCharacteristicVariableComponent o = (StatisticModelCharacteristicVariableComponent)other_;
            return StatisticModelCharacteristicVariableComponent.compareDeep(this.variableDefinition, o.variableDefinition, true) && StatisticModelCharacteristicVariableComponent.compareDeep(this.handling, o.handling, true) && StatisticModelCharacteristicVariableComponent.compareDeep(this.valueCategory, o.valueCategory, true) && StatisticModelCharacteristicVariableComponent.compareDeep(this.valueQuantity, o.valueQuantity, true) && StatisticModelCharacteristicVariableComponent.compareDeep(this.valueRange, o.valueRange, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticModelCharacteristicVariableComponent)) {
                return false;
            }
            StatisticModelCharacteristicVariableComponent o = (StatisticModelCharacteristicVariableComponent)other_;
            return StatisticModelCharacteristicVariableComponent.compareValues(this.handling, o.handling, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.variableDefinition, this.handling, this.valueCategory, this.valueQuantity, this.valueRange});
        }

        @Override
        public String fhirType() {
            return "Statistic.modelCharacteristic.variable";
        }
    }

    @Block
    public static class StatisticModelCharacteristicComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Model specification", formalDefinition="Description of a component of the method to generate the statistic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/statistic-model-code")
        protected CodeableConcept code;
        @Child(name="value", type={Quantity.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Numerical value to complete model specification", formalDefinition="Further specification of the quantified value of the component of the method to generate the statistic.")
        protected Quantity value;
        @Child(name="variable", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A variable adjusted for in the adjusted analysis", formalDefinition="A variable adjusted for in the adjusted analysis.")
        protected List<StatisticModelCharacteristicVariableComponent> variable;
        private static final long serialVersionUID = 1539071113L;

        public StatisticModelCharacteristicComponent() {
        }

        public StatisticModelCharacteristicComponent(CodeableConcept code) {
            this.setCode(code);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticModelCharacteristicComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public StatisticModelCharacteristicComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Quantity getValue() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticModelCharacteristicComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new Quantity();
                }
            }
            return this.value;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public StatisticModelCharacteristicComponent setValue(Quantity value) {
            this.value = value;
            return this;
        }

        public List<StatisticModelCharacteristicVariableComponent> getVariable() {
            if (this.variable == null) {
                this.variable = new ArrayList<StatisticModelCharacteristicVariableComponent>();
            }
            return this.variable;
        }

        public StatisticModelCharacteristicComponent setVariable(List<StatisticModelCharacteristicVariableComponent> theVariable) {
            this.variable = theVariable;
            return this;
        }

        public boolean hasVariable() {
            if (this.variable == null) {
                return false;
            }
            for (StatisticModelCharacteristicVariableComponent item : this.variable) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StatisticModelCharacteristicVariableComponent addVariable() {
            StatisticModelCharacteristicVariableComponent t = new StatisticModelCharacteristicVariableComponent();
            if (this.variable == null) {
                this.variable = new ArrayList<StatisticModelCharacteristicVariableComponent>();
            }
            this.variable.add(t);
            return t;
        }

        public StatisticModelCharacteristicComponent addVariable(StatisticModelCharacteristicVariableComponent t) {
            if (t == null) {
                return this;
            }
            if (this.variable == null) {
                this.variable = new ArrayList<StatisticModelCharacteristicVariableComponent>();
            }
            this.variable.add(t);
            return this;
        }

        public StatisticModelCharacteristicVariableComponent getVariableFirstRep() {
            if (this.getVariable().isEmpty()) {
                this.addVariable();
            }
            return this.getVariable().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Description of a component of the method to generate the statistic.", 0, 1, this.code));
            children.add(new Property("value", "Quantity", "Further specification of the quantified value of the component of the method to generate the statistic.", 0, 1, this.value));
            children.add(new Property("variable", "", "A variable adjusted for in the adjusted analysis.", 0, Integer.MAX_VALUE, this.variable));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Description of a component of the method to generate the statistic.", 0, 1, this.code);
                }
                case 111972721: {
                    return new Property("value", "Quantity", "Further specification of the quantified value of the component of the method to generate the statistic.", 0, 1, this.value);
                }
                case -1249586564: {
                    return new Property("variable", "", "A variable adjusted for in the adjusted analysis.", 0, Integer.MAX_VALUE, this.variable);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case -1249586564: {
                    return this.variable == null ? new Base[]{} : this.variable.toArray(new Base[this.variable.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1249586564: {
                    this.getVariable().add((StatisticModelCharacteristicVariableComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToQuantity(value);
            } else if (name.equals("variable")) {
                this.getVariable().add((StatisticModelCharacteristicVariableComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case 111972721: {
                    return this.getValue();
                }
                case -1249586564: {
                    return this.addVariable();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity"};
                }
                case -1249586564: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("value")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("variable")) {
                return this.addVariable();
            }
            return super.addChild(name);
        }

        @Override
        public StatisticModelCharacteristicComponent copy() {
            StatisticModelCharacteristicComponent dst = new StatisticModelCharacteristicComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatisticModelCharacteristicComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            Quantity quantity = dst.value = this.value == null ? null : this.value.copy();
            if (this.variable != null) {
                dst.variable = new ArrayList<StatisticModelCharacteristicVariableComponent>();
                for (StatisticModelCharacteristicVariableComponent i : this.variable) {
                    dst.variable.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticModelCharacteristicComponent)) {
                return false;
            }
            StatisticModelCharacteristicComponent o = (StatisticModelCharacteristicComponent)other_;
            return StatisticModelCharacteristicComponent.compareDeep(this.code, o.code, true) && StatisticModelCharacteristicComponent.compareDeep(this.value, o.value, true) && StatisticModelCharacteristicComponent.compareDeep(this.variable, o.variable, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticModelCharacteristicComponent)) {
                return false;
            }
            StatisticModelCharacteristicComponent o = (StatisticModelCharacteristicComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.code, this.value, this.variable});
        }

        @Override
        public String fhirType() {
            return "Statistic.modelCharacteristic";
        }
    }

    @Block
    public static class StatisticAttributeEstimateAttributeEstimateComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual description of the attribute estimate", formalDefinition="Human-readable summary of the estimate.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Footnote or explanatory note about the estimate", formalDefinition="Footnote or explanatory note about the estimate.")
        protected List<Annotation> note;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of attribute estimate, eg confidence interval or p value", formalDefinition="The type of attribute estimate, eg confidence interval or p value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/attribute-estimate-type")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure", formalDefinition="The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.")
        protected Quantity quantity;
        @Child(name="level", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Level of confidence interval, eg 0.95 for 95% confidence interval", formalDefinition="Use 95 for a 95% confidence interval.")
        protected DecimalType level;
        @Child(name="range", type={Range.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lower and upper bound values of the attribute estimate", formalDefinition="Lower bound of confidence interval.")
        protected Range range;
        private static final long serialVersionUID = 1873606362L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateAttributeEstimateComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public StatisticAttributeEstimateAttributeEstimateComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateAttributeEstimateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateAttributeEstimateComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public DecimalType getLevelElement() {
            if (this.level == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateAttributeEstimateComponent.level");
                }
                if (Configuration.doAutoCreate()) {
                    this.level = new DecimalType();
                }
            }
            return this.level;
        }

        public boolean hasLevelElement() {
            return this.level != null && !this.level.isEmpty();
        }

        public boolean hasLevel() {
            return this.level != null && !this.level.isEmpty();
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setLevelElement(DecimalType value) {
            this.level = value;
            return this;
        }

        public BigDecimal getLevel() {
            return this.level == null ? null : (BigDecimal)this.level.getValue();
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setLevel(BigDecimal value) {
            if (value == null) {
                this.level = null;
            } else {
                if (this.level == null) {
                    this.level = new DecimalType();
                }
                this.level.setValue(value);
            }
            return this;
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setLevel(long value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setLevel(double value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public Range getRange() {
            if (this.range == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateAttributeEstimateComponent.range");
                }
                if (Configuration.doAutoCreate()) {
                    this.range = new Range();
                }
            }
            return this.range;
        }

        public boolean hasRange() {
            return this.range != null && !this.range.isEmpty();
        }

        public StatisticAttributeEstimateAttributeEstimateComponent setRange(Range value) {
            this.range = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Human-readable summary of the estimate.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("type", "CodeableConcept", "The type of attribute estimate, eg confidence interval or p value.", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity));
            children.add(new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level));
            children.add(new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Human-readable summary of the estimate.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of attribute estimate, eg confidence interval or p value.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity);
                }
                case 102865796: {
                    return new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level);
                }
                case 108280125: {
                    return new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 102865796: {
                    Base[] baseArray;
                    if (this.level == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.level;
                    }
                    return baseArray;
                }
                case 108280125: {
                    Base[] baseArray;
                    if (this.range == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.range;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 102865796: {
                    this.level = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 108280125: {
                    this.range = TypeConvertor.castToRange(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("level")) {
                this.level = TypeConvertor.castToDecimal(value);
            } else if (name.equals("range")) {
                this.range = TypeConvertor.castToRange(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 102865796: {
                    return this.getLevelElement();
                }
                case 108280125: {
                    return this.getRange();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 102865796: {
                    return new String[]{"decimal"};
                }
                case 108280125: {
                    return new String[]{"Range"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.attributeEstimate.attributeEstimate.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("level")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.attributeEstimate.attributeEstimate.level");
            }
            if (name.equals("range")) {
                this.range = new Range();
                return this.range;
            }
            return super.addChild(name);
        }

        @Override
        public StatisticAttributeEstimateAttributeEstimateComponent copy() {
            StatisticAttributeEstimateAttributeEstimateComponent dst = new StatisticAttributeEstimateAttributeEstimateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatisticAttributeEstimateAttributeEstimateComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.level = this.level == null ? null : this.level.copy();
            dst.range = this.range == null ? null : this.range.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticAttributeEstimateAttributeEstimateComponent)) {
                return false;
            }
            StatisticAttributeEstimateAttributeEstimateComponent o = (StatisticAttributeEstimateAttributeEstimateComponent)other_;
            return StatisticAttributeEstimateAttributeEstimateComponent.compareDeep(this.description, o.description, true) && StatisticAttributeEstimateAttributeEstimateComponent.compareDeep(this.note, o.note, true) && StatisticAttributeEstimateAttributeEstimateComponent.compareDeep(this.type, o.type, true) && StatisticAttributeEstimateAttributeEstimateComponent.compareDeep(this.quantity, o.quantity, true) && StatisticAttributeEstimateAttributeEstimateComponent.compareDeep(this.level, o.level, true) && StatisticAttributeEstimateAttributeEstimateComponent.compareDeep(this.range, o.range, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticAttributeEstimateAttributeEstimateComponent)) {
                return false;
            }
            StatisticAttributeEstimateAttributeEstimateComponent o = (StatisticAttributeEstimateAttributeEstimateComponent)other_;
            return StatisticAttributeEstimateAttributeEstimateComponent.compareValues(this.description, o.description, true) && StatisticAttributeEstimateAttributeEstimateComponent.compareValues(this.level, o.level, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.type, this.quantity, this.level, this.range});
        }

        @Override
        public String fhirType() {
            return "Statistic.attributeEstimate.attributeEstimate";
        }
    }

    @Block
    public static class StatisticAttributeEstimateComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual description of the attribute estimate", formalDefinition="Human-readable summary of the estimate.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Footnote or explanatory note about the estimate", formalDefinition="Footnote or explanatory note about the estimate.")
        protected List<Annotation> note;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The type of attribute estimate, eg confidence interval or p value", formalDefinition="The type of attribute estimate, eg confidence interval or p value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/attribute-estimate-type")
        protected CodeableConcept type;
        @Child(name="quantity", type={Quantity.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure", formalDefinition="The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.")
        protected Quantity quantity;
        @Child(name="level", type={DecimalType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Level of confidence interval, eg 0.95 for 95% confidence interval", formalDefinition="Use 95 for a 95% confidence interval.")
        protected DecimalType level;
        @Child(name="range", type={Range.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Lower and upper bound values of the attribute estimate", formalDefinition="Lower bound of confidence interval.")
        protected Range range;
        @Child(name="attributeEstimate", type={}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A nested attribute estimate; which is the attribute estimate of an attribute estimate", formalDefinition="A nested attribute estimate; which is the attribute estimate of an attribute estimate.")
        protected List<StatisticAttributeEstimateAttributeEstimateComponent> attributeEstimate;
        private static final long serialVersionUID = 2062805621L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public StatisticAttributeEstimateComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public StatisticAttributeEstimateComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public StatisticAttributeEstimateComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public StatisticAttributeEstimateComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public StatisticAttributeEstimateComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public StatisticAttributeEstimateComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public DecimalType getLevelElement() {
            if (this.level == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.level");
                }
                if (Configuration.doAutoCreate()) {
                    this.level = new DecimalType();
                }
            }
            return this.level;
        }

        public boolean hasLevelElement() {
            return this.level != null && !this.level.isEmpty();
        }

        public boolean hasLevel() {
            return this.level != null && !this.level.isEmpty();
        }

        public StatisticAttributeEstimateComponent setLevelElement(DecimalType value) {
            this.level = value;
            return this;
        }

        public BigDecimal getLevel() {
            return this.level == null ? null : (BigDecimal)this.level.getValue();
        }

        public StatisticAttributeEstimateComponent setLevel(BigDecimal value) {
            if (value == null) {
                this.level = null;
            } else {
                if (this.level == null) {
                    this.level = new DecimalType();
                }
                this.level.setValue(value);
            }
            return this;
        }

        public StatisticAttributeEstimateComponent setLevel(long value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public StatisticAttributeEstimateComponent setLevel(double value) {
            this.level = new DecimalType();
            this.level.setValue(value);
            return this;
        }

        public Range getRange() {
            if (this.range == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticAttributeEstimateComponent.range");
                }
                if (Configuration.doAutoCreate()) {
                    this.range = new Range();
                }
            }
            return this.range;
        }

        public boolean hasRange() {
            return this.range != null && !this.range.isEmpty();
        }

        public StatisticAttributeEstimateComponent setRange(Range value) {
            this.range = value;
            return this;
        }

        public List<StatisticAttributeEstimateAttributeEstimateComponent> getAttributeEstimate() {
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<StatisticAttributeEstimateAttributeEstimateComponent>();
            }
            return this.attributeEstimate;
        }

        public StatisticAttributeEstimateComponent setAttributeEstimate(List<StatisticAttributeEstimateAttributeEstimateComponent> theAttributeEstimate) {
            this.attributeEstimate = theAttributeEstimate;
            return this;
        }

        public boolean hasAttributeEstimate() {
            if (this.attributeEstimate == null) {
                return false;
            }
            for (StatisticAttributeEstimateAttributeEstimateComponent item : this.attributeEstimate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StatisticAttributeEstimateAttributeEstimateComponent addAttributeEstimate() {
            StatisticAttributeEstimateAttributeEstimateComponent t = new StatisticAttributeEstimateAttributeEstimateComponent();
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<StatisticAttributeEstimateAttributeEstimateComponent>();
            }
            this.attributeEstimate.add(t);
            return t;
        }

        public StatisticAttributeEstimateComponent addAttributeEstimate(StatisticAttributeEstimateAttributeEstimateComponent t) {
            if (t == null) {
                return this;
            }
            if (this.attributeEstimate == null) {
                this.attributeEstimate = new ArrayList<StatisticAttributeEstimateAttributeEstimateComponent>();
            }
            this.attributeEstimate.add(t);
            return this;
        }

        public StatisticAttributeEstimateAttributeEstimateComponent getAttributeEstimateFirstRep() {
            if (this.getAttributeEstimate().isEmpty()) {
                this.addAttributeEstimate();
            }
            return this.getAttributeEstimate().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Human-readable summary of the estimate.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("type", "CodeableConcept", "The type of attribute estimate, eg confidence interval or p value.", 0, 1, this.type));
            children.add(new Property("quantity", "Quantity", "The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity));
            children.add(new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level));
            children.add(new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range));
            children.add(new Property("attributeEstimate", "", "A nested attribute estimate; which is the attribute estimate of an attribute estimate.", 0, Integer.MAX_VALUE, this.attributeEstimate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Human-readable summary of the estimate.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnote or explanatory note about the estimate.", 0, Integer.MAX_VALUE, this.note);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of attribute estimate, eg confidence interval or p value.", 0, 1, this.type);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The singular quantity of the attribute estimate, for attribute estimates represented as single values; also used to report unit of measure.", 0, 1, this.quantity);
                }
                case 102865796: {
                    return new Property("level", "decimal", "Use 95 for a 95% confidence interval.", 0, 1, this.level);
                }
                case 108280125: {
                    return new Property("range", "Range", "Lower bound of confidence interval.", 0, 1, this.range);
                }
                case -1539581980: {
                    return new Property("attributeEstimate", "", "A nested attribute estimate; which is the attribute estimate of an attribute estimate.", 0, Integer.MAX_VALUE, this.attributeEstimate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 102865796: {
                    Base[] baseArray;
                    if (this.level == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.level;
                    }
                    return baseArray;
                }
                case 108280125: {
                    Base[] baseArray;
                    if (this.range == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.range;
                    }
                    return baseArray;
                }
                case -1539581980: {
                    return this.attributeEstimate == null ? new Base[]{} : this.attributeEstimate.toArray(new Base[this.attributeEstimate.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 102865796: {
                    this.level = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 108280125: {
                    this.range = TypeConvertor.castToRange(value);
                    return value;
                }
                case -1539581980: {
                    this.getAttributeEstimate().add((StatisticAttributeEstimateAttributeEstimateComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("level")) {
                this.level = TypeConvertor.castToDecimal(value);
            } else if (name.equals("range")) {
                this.range = TypeConvertor.castToRange(value);
            } else if (name.equals("attributeEstimate")) {
                this.getAttributeEstimate().add((StatisticAttributeEstimateAttributeEstimateComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 102865796: {
                    return this.getLevelElement();
                }
                case 108280125: {
                    return this.getRange();
                }
                case -1539581980: {
                    return this.addAttributeEstimate();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 102865796: {
                    return new String[]{"decimal"};
                }
                case 108280125: {
                    return new String[]{"Range"};
                }
                case -1539581980: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.attributeEstimate.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals("level")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.attributeEstimate.level");
            }
            if (name.equals("range")) {
                this.range = new Range();
                return this.range;
            }
            if (name.equals("attributeEstimate")) {
                return this.addAttributeEstimate();
            }
            return super.addChild(name);
        }

        @Override
        public StatisticAttributeEstimateComponent copy() {
            StatisticAttributeEstimateComponent dst = new StatisticAttributeEstimateComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatisticAttributeEstimateComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            dst.type = this.type == null ? null : this.type.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.level = this.level == null ? null : this.level.copy();
            Range range = dst.range = this.range == null ? null : this.range.copy();
            if (this.attributeEstimate != null) {
                dst.attributeEstimate = new ArrayList<StatisticAttributeEstimateAttributeEstimateComponent>();
                for (StatisticAttributeEstimateAttributeEstimateComponent statisticAttributeEstimateAttributeEstimateComponent : this.attributeEstimate) {
                    dst.attributeEstimate.add(statisticAttributeEstimateAttributeEstimateComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticAttributeEstimateComponent)) {
                return false;
            }
            StatisticAttributeEstimateComponent o = (StatisticAttributeEstimateComponent)other_;
            return StatisticAttributeEstimateComponent.compareDeep(this.description, o.description, true) && StatisticAttributeEstimateComponent.compareDeep(this.note, o.note, true) && StatisticAttributeEstimateComponent.compareDeep(this.type, o.type, true) && StatisticAttributeEstimateComponent.compareDeep(this.quantity, o.quantity, true) && StatisticAttributeEstimateComponent.compareDeep(this.level, o.level, true) && StatisticAttributeEstimateComponent.compareDeep(this.range, o.range, true) && StatisticAttributeEstimateComponent.compareDeep(this.attributeEstimate, o.attributeEstimate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticAttributeEstimateComponent)) {
                return false;
            }
            StatisticAttributeEstimateComponent o = (StatisticAttributeEstimateComponent)other_;
            return StatisticAttributeEstimateComponent.compareValues(this.description, o.description, true) && StatisticAttributeEstimateComponent.compareValues(this.level, o.level, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.type, this.quantity, this.level, this.range, this.attributeEstimate});
        }

        @Override
        public String fhirType() {
            return "Statistic.attributeEstimate";
        }
    }

    @Block
    public static class StatisticSampleSizeComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Textual description of sample size for statistic", formalDefinition="Human-readable summary of population sample size.")
        protected StringType description;
        @Child(name="note", type={Annotation.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Footnote or explanatory note about the sample size", formalDefinition="Footnote or explanatory note about the sample size.")
        protected List<Annotation> note;
        @Child(name="numberOfStudies", type={UnsignedIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of contributing studies", formalDefinition="Number of participants in the population.")
        protected UnsignedIntType numberOfStudies;
        @Child(name="numberOfParticipants", type={UnsignedIntType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Cumulative number of participants", formalDefinition="A human-readable string to clarify or explain concepts about the sample size.")
        protected UnsignedIntType numberOfParticipants;
        @Child(name="knownDataCount", type={UnsignedIntType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of participants with known results for measured variables", formalDefinition="Number of participants with known results for measured variables.")
        protected UnsignedIntType knownDataCount;
        private static final long serialVersionUID = -1870635979L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public StatisticSampleSizeComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public StatisticSampleSizeComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public StatisticSampleSizeComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public StatisticSampleSizeComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public UnsignedIntType getNumberOfStudiesElement() {
            if (this.numberOfStudies == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.numberOfStudies");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfStudies = new UnsignedIntType();
                }
            }
            return this.numberOfStudies;
        }

        public boolean hasNumberOfStudiesElement() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public boolean hasNumberOfStudies() {
            return this.numberOfStudies != null && !this.numberOfStudies.isEmpty();
        }

        public StatisticSampleSizeComponent setNumberOfStudiesElement(UnsignedIntType value) {
            this.numberOfStudies = value;
            return this;
        }

        public int getNumberOfStudies() {
            return this.numberOfStudies == null || this.numberOfStudies.isEmpty() ? 0 : (Integer)this.numberOfStudies.getValue();
        }

        public StatisticSampleSizeComponent setNumberOfStudies(int value) {
            if (this.numberOfStudies == null) {
                this.numberOfStudies = new UnsignedIntType();
            }
            this.numberOfStudies.setValue((Object)value);
            return this;
        }

        public UnsignedIntType getNumberOfParticipantsElement() {
            if (this.numberOfParticipants == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.numberOfParticipants");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfParticipants = new UnsignedIntType();
                }
            }
            return this.numberOfParticipants;
        }

        public boolean hasNumberOfParticipantsElement() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public boolean hasNumberOfParticipants() {
            return this.numberOfParticipants != null && !this.numberOfParticipants.isEmpty();
        }

        public StatisticSampleSizeComponent setNumberOfParticipantsElement(UnsignedIntType value) {
            this.numberOfParticipants = value;
            return this;
        }

        public int getNumberOfParticipants() {
            return this.numberOfParticipants == null || this.numberOfParticipants.isEmpty() ? 0 : (Integer)this.numberOfParticipants.getValue();
        }

        public StatisticSampleSizeComponent setNumberOfParticipants(int value) {
            if (this.numberOfParticipants == null) {
                this.numberOfParticipants = new UnsignedIntType();
            }
            this.numberOfParticipants.setValue((Object)value);
            return this;
        }

        public UnsignedIntType getKnownDataCountElement() {
            if (this.knownDataCount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatisticSampleSizeComponent.knownDataCount");
                }
                if (Configuration.doAutoCreate()) {
                    this.knownDataCount = new UnsignedIntType();
                }
            }
            return this.knownDataCount;
        }

        public boolean hasKnownDataCountElement() {
            return this.knownDataCount != null && !this.knownDataCount.isEmpty();
        }

        public boolean hasKnownDataCount() {
            return this.knownDataCount != null && !this.knownDataCount.isEmpty();
        }

        public StatisticSampleSizeComponent setKnownDataCountElement(UnsignedIntType value) {
            this.knownDataCount = value;
            return this;
        }

        public int getKnownDataCount() {
            return this.knownDataCount == null || this.knownDataCount.isEmpty() ? 0 : (Integer)this.knownDataCount.getValue();
        }

        public StatisticSampleSizeComponent setKnownDataCount(int value) {
            if (this.knownDataCount == null) {
                this.knownDataCount = new UnsignedIntType();
            }
            this.knownDataCount.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Human-readable summary of population sample size.", 0, 1, this.description));
            children.add(new Property("note", "Annotation", "Footnote or explanatory note about the sample size.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("numberOfStudies", "unsignedInt", "Number of participants in the population.", 0, 1, this.numberOfStudies));
            children.add(new Property("numberOfParticipants", "unsignedInt", "A human-readable string to clarify or explain concepts about the sample size.", 0, 1, this.numberOfParticipants));
            children.add(new Property("knownDataCount", "unsignedInt", "Number of participants with known results for measured variables.", 0, 1, this.knownDataCount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Human-readable summary of population sample size.", 0, 1, this.description);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Footnote or explanatory note about the sample size.", 0, Integer.MAX_VALUE, this.note);
                }
                case -177467129: {
                    return new Property("numberOfStudies", "unsignedInt", "Number of participants in the population.", 0, 1, this.numberOfStudies);
                }
                case 1799357120: {
                    return new Property("numberOfParticipants", "unsignedInt", "A human-readable string to clarify or explain concepts about the sample size.", 0, 1, this.numberOfParticipants);
                }
                case -937344126: {
                    return new Property("knownDataCount", "unsignedInt", "Number of participants with known results for measured variables.", 0, 1, this.knownDataCount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -177467129: {
                    Base[] baseArray;
                    if (this.numberOfStudies == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.numberOfStudies;
                    }
                    return baseArray;
                }
                case 1799357120: {
                    Base[] baseArray;
                    if (this.numberOfParticipants == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.numberOfParticipants;
                    }
                    return baseArray;
                }
                case -937344126: {
                    Base[] baseArray;
                    if (this.knownDataCount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.knownDataCount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -177467129: {
                    this.numberOfStudies = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case 1799357120: {
                    this.numberOfParticipants = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case -937344126: {
                    this.knownDataCount = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("numberOfStudies")) {
                this.numberOfStudies = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("numberOfParticipants")) {
                this.numberOfParticipants = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("knownDataCount")) {
                this.knownDataCount = TypeConvertor.castToUnsignedInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -177467129: {
                    return this.getNumberOfStudiesElement();
                }
                case 1799357120: {
                    return this.getNumberOfParticipantsElement();
                }
                case -937344126: {
                    return this.getKnownDataCountElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -177467129: {
                    return new String[]{"unsignedInt"};
                }
                case 1799357120: {
                    return new String[]{"unsignedInt"};
                }
                case -937344126: {
                    return new String[]{"unsignedInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.description");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("numberOfStudies")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.numberOfStudies");
            }
            if (name.equals("numberOfParticipants")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.numberOfParticipants");
            }
            if (name.equals("knownDataCount")) {
                throw new FHIRException("Cannot call addChild on a primitive type Statistic.sampleSize.knownDataCount");
            }
            return super.addChild(name);
        }

        @Override
        public StatisticSampleSizeComponent copy() {
            StatisticSampleSizeComponent dst = new StatisticSampleSizeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatisticSampleSizeComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation i : this.note) {
                    dst.note.add(i.copy());
                }
            }
            dst.numberOfStudies = this.numberOfStudies == null ? null : this.numberOfStudies.copy();
            dst.numberOfParticipants = this.numberOfParticipants == null ? null : this.numberOfParticipants.copy();
            dst.knownDataCount = this.knownDataCount == null ? null : this.knownDataCount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticSampleSizeComponent)) {
                return false;
            }
            StatisticSampleSizeComponent o = (StatisticSampleSizeComponent)other_;
            return StatisticSampleSizeComponent.compareDeep(this.description, o.description, true) && StatisticSampleSizeComponent.compareDeep(this.note, o.note, true) && StatisticSampleSizeComponent.compareDeep(this.numberOfStudies, o.numberOfStudies, true) && StatisticSampleSizeComponent.compareDeep(this.numberOfParticipants, o.numberOfParticipants, true) && StatisticSampleSizeComponent.compareDeep(this.knownDataCount, o.knownDataCount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatisticSampleSizeComponent)) {
                return false;
            }
            StatisticSampleSizeComponent o = (StatisticSampleSizeComponent)other_;
            return StatisticSampleSizeComponent.compareValues(this.description, o.description, true) && StatisticSampleSizeComponent.compareValues(this.numberOfStudies, o.numberOfStudies, true) && StatisticSampleSizeComponent.compareValues(this.numberOfParticipants, o.numberOfParticipants, true) && StatisticSampleSizeComponent.compareValues(this.knownDataCount, o.knownDataCount, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.note, this.numberOfStudies, this.numberOfParticipants, this.knownDataCount});
        }

        @Override
        public String fhirType() {
            return "Statistic.sampleSize";
        }
    }
}

