/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.Coding;
import org.hl7.fhir.r4b.model.Configuration;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.EnumFactory;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.ImplementationGuide;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.Organization;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Reference;
import org.hl7.fhir.r4b.model.ResourceType;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.TypeConvertor;
import org.hl7.fhir.r4b.model.UnsignedIntType;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UrlType;
import org.hl7.fhir.r4b.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="CapabilityStatement", profile="http://hl7.org/fhir/StructureDefinition/CapabilityStatement")
public class CapabilityStatement
extends CanonicalResource
implements IBaseConformance {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this capability statement, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this capability statement when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this capability statement is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the capability statement is stored on different servers.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the capability statement", formalDefinition="The identifier that is used to identify this version of the capability statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the capability statement author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this capability statement (computer friendly)", formalDefinition="A natural language name identifying the capability statement. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this capability statement (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the capability statement.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this capability statement. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this capability statement is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the capability statement was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the capability statement changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the capability statement.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the capability statement", formalDefinition="A free text natural language description of the capability statement from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate capability statement instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for capability statement (if applicable)", formalDefinition="A legal or geographic region in which the capability statement is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this capability statement is defined", formalDefinition="Explanation of why this capability statement is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the capability statement and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the capability statement.")
    protected MarkdownType copyright;
    @Child(name="kind", type={CodeType.class}, order=14, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="instance | capability | requirements", formalDefinition="The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/capability-statement-kind")
    protected Enumeration<Enumerations.CapabilityStatementKind> kind;
    @Child(name="instantiates", type={CanonicalType.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical URL of another capability statement this implements", formalDefinition="Reference to a canonical URL of another CapabilityStatement that this software implements. This capability statement is a published API description that corresponds to a business service. The server may actually implement a subset of the capability statement it claims to implement, so the capability statement must specify the full capability details.")
    protected List<CanonicalType> instantiates;
    @Child(name="imports", type={CanonicalType.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical URL of another capability statement this adds to", formalDefinition="Reference to a canonical URL of another CapabilityStatement that this software adds to. The capability statement automatically includes everything in the other statement, and it is not duplicated, though the server may repeat the same resources, interactions and operations to add additional details to them.")
    protected List<CanonicalType> imports;
    @Child(name="software", type={}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Software that is covered by this capability statement", formalDefinition="Software that is covered by this capability statement.  It is used when the capability statement describes the capabilities of a particular software version, independent of an installation.")
    protected CapabilityStatementSoftwareComponent software;
    @Child(name="implementation", type={}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If this describes a specific instance", formalDefinition="Identifies a specific implementation instance that is described by the capability statement - i.e. a particular installation, rather than the capabilities of a software program.")
    protected CapabilityStatementImplementationComponent implementation;
    @Child(name="fhirVersion", type={CodeType.class}, order=19, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version the system supports", formalDefinition="The version of the FHIR specification that this CapabilityStatement describes (which SHALL be the same as the FHIR version of the CapabilityStatement itself). There is no default value.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/FHIR-version")
    protected Enumeration<Enumerations.FHIRVersion> fhirVersion;
    @Child(name="format", type={CodeType.class}, order=20, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="formats supported (xml | json | ttl | mime type)", formalDefinition="A list of the formats supported by this implementation using their content types.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected List<CodeType> format;
    @Child(name="patchFormat", type={CodeType.class}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Patch formats supported", formalDefinition="A list of the patch formats supported by this implementation using their content types.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected List<CodeType> patchFormat;
    @Child(name="implementationGuide", type={CanonicalType.class}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Implementation guides supported", formalDefinition="A list of implementation guides that the server does (or should) support in their entirety.")
    protected List<CanonicalType> implementationGuide;
    @Child(name="rest", type={}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="If the endpoint is a RESTful one", formalDefinition="A definition of the restful capabilities of the solution, if any.")
    protected List<CapabilityStatementRestComponent> rest;
    @Child(name="messaging", type={}, order=24, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="If messaging is supported", formalDefinition="A description of the messaging capabilities of the solution.")
    protected List<CapabilityStatementMessagingComponent> messaging;
    @Child(name="document", type={}, order=25, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Document definition", formalDefinition="A document definition.")
    protected List<CapabilityStatementDocumentComponent> document;
    private static final long serialVersionUID = 1554492069L;
    @SearchParamDefinition(name="fhirversion", path="CapabilityStatement.version", description="The version of FHIR", type="token")
    public static final String SP_FHIRVERSION = "fhirversion";
    public static final TokenClientParam FHIRVERSION = new TokenClientParam("fhirversion");
    @SearchParamDefinition(name="format", path="CapabilityStatement.format", description="formats supported (xml | json | ttl | mime type)", type="token")
    public static final String SP_FORMAT = "format";
    public static final TokenClientParam FORMAT = new TokenClientParam("format");
    @SearchParamDefinition(name="guide", path="CapabilityStatement.implementationGuide", description="Implementation guides supported", type="reference", target={ImplementationGuide.class})
    public static final String SP_GUIDE = "guide";
    public static final ReferenceClientParam GUIDE = new ReferenceClientParam("guide");
    public static final Include INCLUDE_GUIDE = new Include("CapabilityStatement:guide").toLocked();
    @SearchParamDefinition(name="mode", path="CapabilityStatement.rest.mode", description="Mode - restful (server/client) or messaging (sender/receiver)", type="token")
    public static final String SP_MODE = "mode";
    public static final TokenClientParam MODE = new TokenClientParam("mode");
    @SearchParamDefinition(name="resource-profile", path="CapabilityStatement.rest.resource.profile", description="A profile id invoked in a capability statement", type="reference", target={StructureDefinition.class})
    public static final String SP_RESOURCE_PROFILE = "resource-profile";
    public static final ReferenceClientParam RESOURCE_PROFILE = new ReferenceClientParam("resource-profile");
    public static final Include INCLUDE_RESOURCE_PROFILE = new Include("CapabilityStatement:resource-profile").toLocked();
    @SearchParamDefinition(name="resource", path="CapabilityStatement.rest.resource.type", description="Name of a resource mentioned in a capability statement", type="token")
    public static final String SP_RESOURCE = "resource";
    public static final TokenClientParam RESOURCE = new TokenClientParam("resource");
    @SearchParamDefinition(name="security-service", path="CapabilityStatement.rest.security.service", description="OAuth | SMART-on-FHIR | NTLM | Basic | Kerberos | Certificates", type="token")
    public static final String SP_SECURITY_SERVICE = "security-service";
    public static final TokenClientParam SECURITY_SERVICE = new TokenClientParam("security-service");
    @SearchParamDefinition(name="software", path="CapabilityStatement.software.name", description="Part of the name of a software application", type="string")
    public static final String SP_SOFTWARE = "software";
    public static final StringClientParam SOFTWARE = new StringClientParam("software");
    @SearchParamDefinition(name="supported-profile", path="CapabilityStatement.rest.resource.supportedProfile", description="Profiles for use cases supported", type="reference", target={StructureDefinition.class})
    public static final String SP_SUPPORTED_PROFILE = "supported-profile";
    public static final ReferenceClientParam SUPPORTED_PROFILE = new ReferenceClientParam("supported-profile");
    public static final Include INCLUDE_SUPPORTED_PROFILE = new Include("CapabilityStatement:supported-profile").toLocked();
    @SearchParamDefinition(name="context-quantity", path="(CapabilityStatement.useContext.value as Quantity) | (CapabilityStatement.useContext.value as Range) | (CodeSystem.useContext.value as Quantity) | (CodeSystem.useContext.value as Range) | (CompartmentDefinition.useContext.value as Quantity) | (CompartmentDefinition.useContext.value as Range) | (ConceptMap.useContext.value as Quantity) | (ConceptMap.useContext.value as Range) | (GraphDefinition.useContext.value as Quantity) | (GraphDefinition.useContext.value as Range) | (ImplementationGuide.useContext.value as Quantity) | (ImplementationGuide.useContext.value as Range) | (MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range) | (NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range) | (OperationDefinition.useContext.value as Quantity) | (OperationDefinition.useContext.value as Range) | (SearchParameter.useContext.value as Quantity) | (SearchParameter.useContext.value as Range) | (StructureDefinition.useContext.value as Quantity) | (StructureDefinition.useContext.value as Range) | (StructureMap.useContext.value as Quantity) | (StructureMap.useContext.value as Range) | (TerminologyCapabilities.useContext.value as Quantity) | (TerminologyCapabilities.useContext.value as Range) | (ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="CapabilityStatement.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(CapabilityStatement.useContext.value as CodeableConcept) | (CodeSystem.useContext.value as CodeableConcept) | (CompartmentDefinition.useContext.value as CodeableConcept) | (ConceptMap.useContext.value as CodeableConcept) | (GraphDefinition.useContext.value as CodeableConcept) | (ImplementationGuide.useContext.value as CodeableConcept) | (MessageDefinition.useContext.value as CodeableConcept) | (NamingSystem.useContext.value as CodeableConcept) | (OperationDefinition.useContext.value as CodeableConcept) | (SearchParameter.useContext.value as CodeableConcept) | (StructureDefinition.useContext.value as CodeableConcept) | (StructureMap.useContext.value as CodeableConcept) | (TerminologyCapabilities.useContext.value as CodeableConcept) | (ValueSet.useContext.value as CodeableConcept)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="CapabilityStatement.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | GraphDefinition.date | ImplementationGuide.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | TerminologyCapabilities.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="CapabilityStatement.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | GraphDefinition.description | ImplementationGuide.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="jurisdiction", path="CapabilityStatement.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="CapabilityStatement.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | GraphDefinition.name | ImplementationGuide.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="CapabilityStatement.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="CapabilityStatement.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | GraphDefinition.status | ImplementationGuide.status | MessageDefinition.status | NamingSystem.status | OperationDefinition.status | SearchParameter.status | StructureDefinition.status | StructureMap.status | TerminologyCapabilities.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="CapabilityStatement.title | CodeSystem.title | ConceptMap.title | ImplementationGuide.title | MessageDefinition.title | OperationDefinition.title | StructureDefinition.title | StructureMap.title | TerminologyCapabilities.title | ValueSet.title", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The human-friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): The human-friendly name of the code system\r\n* [ConceptMap](conceptmap.html): The human-friendly name of the concept map\r\n* [ImplementationGuide](implementationguide.html): The human-friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The human-friendly name of the message definition\r\n* [OperationDefinition](operationdefinition.html): The human-friendly name of the operation definition\r\n* [StructureDefinition](structuredefinition.html): The human-friendly name of the structure definition\r\n* [StructureMap](structuremap.html): The human-friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The human-friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): The human-friendly name of the value set\r\n", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="CapabilityStatement.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | GraphDefinition.url | ImplementationGuide.url | MessageDefinition.url | OperationDefinition.url | SearchParameter.url | StructureDefinition.url | StructureMap.url | TerminologyCapabilities.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The uri that identifies the concept map\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="CapabilityStatement.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | GraphDefinition.version | ImplementationGuide.version | MessageDefinition.version | OperationDefinition.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | TerminologyCapabilities.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");

    public CapabilityStatement() {
    }

    public CapabilityStatement(Enumerations.PublicationStatus status, Date date, Enumerations.CapabilityStatementKind kind, Enumerations.FHIRVersion fhirVersion, String format) {
        this.setStatus(status);
        this.setDate(date);
        this.setKind(kind);
        this.setFhirVersion(fhirVersion);
        this.addFormat(format);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public CapabilityStatement setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public CapabilityStatement setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public CapabilityStatement setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public CapabilityStatement setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public CapabilityStatement setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public CapabilityStatement setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public CapabilityStatement setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public CapabilityStatement setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public CapabilityStatement setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public CapabilityStatement setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public CapabilityStatement setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public CapabilityStatement setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public CapabilityStatement setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public CapabilityStatement setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public CapabilityStatement setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public CapabilityStatement setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public CapabilityStatement setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public CapabilityStatement addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public CapabilityStatement setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public CapabilityStatement setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public CapabilityStatement setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public CapabilityStatement addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public CapabilityStatement setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public CapabilityStatement addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public CapabilityStatement setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public CapabilityStatement setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    @Override
    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    @Override
    public CapabilityStatement setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    @Override
    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    @Override
    public CapabilityStatement setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.CapabilityStatementKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<Enumerations.CapabilityStatementKind>(new Enumerations.CapabilityStatementKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public CapabilityStatement setKindElement(Enumeration<Enumerations.CapabilityStatementKind> value) {
        this.kind = value;
        return this;
    }

    public Enumerations.CapabilityStatementKind getKind() {
        return this.kind == null ? null : (Enumerations.CapabilityStatementKind)((Object)this.kind.getValue());
    }

    public CapabilityStatement setKind(Enumerations.CapabilityStatementKind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<Enumerations.CapabilityStatementKind>(new Enumerations.CapabilityStatementKindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public List<CanonicalType> getInstantiates() {
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<CanonicalType>();
        }
        return this.instantiates;
    }

    public CapabilityStatement setInstantiates(List<CanonicalType> theInstantiates) {
        this.instantiates = theInstantiates;
        return this;
    }

    public boolean hasInstantiates() {
        if (this.instantiates == null) {
            return false;
        }
        for (CanonicalType item : this.instantiates) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addInstantiatesElement() {
        CanonicalType t = new CanonicalType();
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<CanonicalType>();
        }
        this.instantiates.add(t);
        return t;
    }

    public CapabilityStatement addInstantiates(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.instantiates == null) {
            this.instantiates = new ArrayList<CanonicalType>();
        }
        this.instantiates.add(t);
        return this;
    }

    public boolean hasInstantiates(String value) {
        if (this.instantiates == null) {
            return false;
        }
        for (CanonicalType v : this.instantiates) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<CanonicalType>();
        }
        return this.imports;
    }

    public CapabilityStatement setImports(List<CanonicalType> theImports) {
        this.imports = theImports;
        return this;
    }

    public boolean hasImports() {
        if (this.imports == null) {
            return false;
        }
        for (CanonicalType item : this.imports) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addImportsElement() {
        CanonicalType t = new CanonicalType();
        if (this.imports == null) {
            this.imports = new ArrayList<CanonicalType>();
        }
        this.imports.add(t);
        return t;
    }

    public CapabilityStatement addImports(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.imports == null) {
            this.imports = new ArrayList<CanonicalType>();
        }
        this.imports.add(t);
        return this;
    }

    public boolean hasImports(String value) {
        if (this.imports == null) {
            return false;
        }
        for (CanonicalType v : this.imports) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public CapabilityStatementSoftwareComponent getSoftware() {
        if (this.software == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.software");
            }
            if (Configuration.doAutoCreate()) {
                this.software = new CapabilityStatementSoftwareComponent();
            }
        }
        return this.software;
    }

    public boolean hasSoftware() {
        return this.software != null && !this.software.isEmpty();
    }

    public CapabilityStatement setSoftware(CapabilityStatementSoftwareComponent value) {
        this.software = value;
        return this;
    }

    public CapabilityStatementImplementationComponent getImplementation() {
        if (this.implementation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.implementation");
            }
            if (Configuration.doAutoCreate()) {
                this.implementation = new CapabilityStatementImplementationComponent();
            }
        }
        return this.implementation;
    }

    public boolean hasImplementation() {
        return this.implementation != null && !this.implementation.isEmpty();
    }

    public CapabilityStatement setImplementation(CapabilityStatementImplementationComponent value) {
        this.implementation = value;
        return this;
    }

    public Enumeration<Enumerations.FHIRVersion> getFhirVersionElement() {
        if (this.fhirVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CapabilityStatement.fhirVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirVersion = new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory());
            }
        }
        return this.fhirVersion;
    }

    public boolean hasFhirVersionElement() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public boolean hasFhirVersion() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public CapabilityStatement setFhirVersionElement(Enumeration<Enumerations.FHIRVersion> value) {
        this.fhirVersion = value;
        return this;
    }

    public Enumerations.FHIRVersion getFhirVersion() {
        return this.fhirVersion == null ? null : (Enumerations.FHIRVersion)((Object)this.fhirVersion.getValue());
    }

    public CapabilityStatement setFhirVersion(Enumerations.FHIRVersion value) {
        if (this.fhirVersion == null) {
            this.fhirVersion = new Enumeration<Enumerations.FHIRVersion>(new Enumerations.FHIRVersionEnumFactory());
        }
        this.fhirVersion.setValue((Object)value);
        return this;
    }

    public List<CodeType> getFormat() {
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        return this.format;
    }

    public CapabilityStatement setFormat(List<CodeType> theFormat) {
        this.format = theFormat;
        return this;
    }

    public boolean hasFormat() {
        if (this.format == null) {
            return false;
        }
        for (CodeType item : this.format) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addFormatElement() {
        CodeType t = new CodeType();
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        this.format.add(t);
        return t;
    }

    public CapabilityStatement addFormat(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.format == null) {
            this.format = new ArrayList<CodeType>();
        }
        this.format.add(t);
        return this;
    }

    public boolean hasFormat(String value) {
        if (this.format == null) {
            return false;
        }
        for (CodeType v : this.format) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CodeType> getPatchFormat() {
        if (this.patchFormat == null) {
            this.patchFormat = new ArrayList<CodeType>();
        }
        return this.patchFormat;
    }

    public CapabilityStatement setPatchFormat(List<CodeType> thePatchFormat) {
        this.patchFormat = thePatchFormat;
        return this;
    }

    public boolean hasPatchFormat() {
        if (this.patchFormat == null) {
            return false;
        }
        for (CodeType item : this.patchFormat) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addPatchFormatElement() {
        CodeType t = new CodeType();
        if (this.patchFormat == null) {
            this.patchFormat = new ArrayList<CodeType>();
        }
        this.patchFormat.add(t);
        return t;
    }

    public CapabilityStatement addPatchFormat(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.patchFormat == null) {
            this.patchFormat = new ArrayList<CodeType>();
        }
        this.patchFormat.add(t);
        return this;
    }

    public boolean hasPatchFormat(String value) {
        if (this.patchFormat == null) {
            return false;
        }
        for (CodeType v : this.patchFormat) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CanonicalType> getImplementationGuide() {
        if (this.implementationGuide == null) {
            this.implementationGuide = new ArrayList<CanonicalType>();
        }
        return this.implementationGuide;
    }

    public CapabilityStatement setImplementationGuide(List<CanonicalType> theImplementationGuide) {
        this.implementationGuide = theImplementationGuide;
        return this;
    }

    public boolean hasImplementationGuide() {
        if (this.implementationGuide == null) {
            return false;
        }
        for (CanonicalType item : this.implementationGuide) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addImplementationGuideElement() {
        CanonicalType t = new CanonicalType();
        if (this.implementationGuide == null) {
            this.implementationGuide = new ArrayList<CanonicalType>();
        }
        this.implementationGuide.add(t);
        return t;
    }

    public CapabilityStatement addImplementationGuide(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.implementationGuide == null) {
            this.implementationGuide = new ArrayList<CanonicalType>();
        }
        this.implementationGuide.add(t);
        return this;
    }

    public boolean hasImplementationGuide(String value) {
        if (this.implementationGuide == null) {
            return false;
        }
        for (CanonicalType v : this.implementationGuide) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CapabilityStatementRestComponent> getRest() {
        if (this.rest == null) {
            this.rest = new ArrayList<CapabilityStatementRestComponent>();
        }
        return this.rest;
    }

    public CapabilityStatement setRest(List<CapabilityStatementRestComponent> theRest) {
        this.rest = theRest;
        return this;
    }

    public boolean hasRest() {
        if (this.rest == null) {
            return false;
        }
        for (CapabilityStatementRestComponent item : this.rest) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CapabilityStatementRestComponent addRest() {
        CapabilityStatementRestComponent t = new CapabilityStatementRestComponent();
        if (this.rest == null) {
            this.rest = new ArrayList<CapabilityStatementRestComponent>();
        }
        this.rest.add(t);
        return t;
    }

    public CapabilityStatement addRest(CapabilityStatementRestComponent t) {
        if (t == null) {
            return this;
        }
        if (this.rest == null) {
            this.rest = new ArrayList<CapabilityStatementRestComponent>();
        }
        this.rest.add(t);
        return this;
    }

    public CapabilityStatementRestComponent getRestFirstRep() {
        if (this.getRest().isEmpty()) {
            this.addRest();
        }
        return this.getRest().get(0);
    }

    public List<CapabilityStatementMessagingComponent> getMessaging() {
        if (this.messaging == null) {
            this.messaging = new ArrayList<CapabilityStatementMessagingComponent>();
        }
        return this.messaging;
    }

    public CapabilityStatement setMessaging(List<CapabilityStatementMessagingComponent> theMessaging) {
        this.messaging = theMessaging;
        return this;
    }

    public boolean hasMessaging() {
        if (this.messaging == null) {
            return false;
        }
        for (CapabilityStatementMessagingComponent item : this.messaging) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CapabilityStatementMessagingComponent addMessaging() {
        CapabilityStatementMessagingComponent t = new CapabilityStatementMessagingComponent();
        if (this.messaging == null) {
            this.messaging = new ArrayList<CapabilityStatementMessagingComponent>();
        }
        this.messaging.add(t);
        return t;
    }

    public CapabilityStatement addMessaging(CapabilityStatementMessagingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.messaging == null) {
            this.messaging = new ArrayList<CapabilityStatementMessagingComponent>();
        }
        this.messaging.add(t);
        return this;
    }

    public CapabilityStatementMessagingComponent getMessagingFirstRep() {
        if (this.getMessaging().isEmpty()) {
            this.addMessaging();
        }
        return this.getMessaging().get(0);
    }

    public List<CapabilityStatementDocumentComponent> getDocument() {
        if (this.document == null) {
            this.document = new ArrayList<CapabilityStatementDocumentComponent>();
        }
        return this.document;
    }

    public CapabilityStatement setDocument(List<CapabilityStatementDocumentComponent> theDocument) {
        this.document = theDocument;
        return this;
    }

    public boolean hasDocument() {
        if (this.document == null) {
            return false;
        }
        for (CapabilityStatementDocumentComponent item : this.document) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CapabilityStatementDocumentComponent addDocument() {
        CapabilityStatementDocumentComponent t = new CapabilityStatementDocumentComponent();
        if (this.document == null) {
            this.document = new ArrayList<CapabilityStatementDocumentComponent>();
        }
        this.document.add(t);
        return t;
    }

    public CapabilityStatement addDocument(CapabilityStatementDocumentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.document == null) {
            this.document = new ArrayList<CapabilityStatementDocumentComponent>();
        }
        this.document.add(t);
        return this;
    }

    public CapabilityStatementDocumentComponent getDocumentFirstRep() {
        if (this.getDocument().isEmpty()) {
            this.addDocument();
        }
        return this.getDocument().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this capability statement when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this capability statement is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the capability statement is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the capability statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the capability statement author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the capability statement. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the capability statement.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this capability statement. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this capability statement is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the capability statement was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the capability statement changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the capability statement.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the capability statement from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate capability statement instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the capability statement is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this capability statement is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the capability statement and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the capability statement.", 0, 1, this.copyright));
        children.add(new Property("kind", "code", "The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).", 0, 1, this.kind));
        children.add(new Property("instantiates", "canonical(CapabilityStatement)", "Reference to a canonical URL of another CapabilityStatement that this software implements. This capability statement is a published API description that corresponds to a business service. The server may actually implement a subset of the capability statement it claims to implement, so the capability statement must specify the full capability details.", 0, Integer.MAX_VALUE, this.instantiates));
        children.add(new Property("imports", "canonical(CapabilityStatement)", "Reference to a canonical URL of another CapabilityStatement that this software adds to. The capability statement automatically includes everything in the other statement, and it is not duplicated, though the server may repeat the same resources, interactions and operations to add additional details to them.", 0, Integer.MAX_VALUE, this.imports));
        children.add(new Property(SP_SOFTWARE, "", "Software that is covered by this capability statement.  It is used when the capability statement describes the capabilities of a particular software version, independent of an installation.", 0, 1, this.software));
        children.add(new Property("implementation", "", "Identifies a specific implementation instance that is described by the capability statement - i.e. a particular installation, rather than the capabilities of a software program.", 0, 1, this.implementation));
        children.add(new Property("fhirVersion", "code", "The version of the FHIR specification that this CapabilityStatement describes (which SHALL be the same as the FHIR version of the CapabilityStatement itself). There is no default value.", 0, 1, this.fhirVersion));
        children.add(new Property(SP_FORMAT, "code", "A list of the formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.format));
        children.add(new Property("patchFormat", "code", "A list of the patch formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.patchFormat));
        children.add(new Property("implementationGuide", "canonical(ImplementationGuide)", "A list of implementation guides that the server does (or should) support in their entirety.", 0, Integer.MAX_VALUE, this.implementationGuide));
        children.add(new Property("rest", "", "A definition of the restful capabilities of the solution, if any.", 0, Integer.MAX_VALUE, this.rest));
        children.add(new Property("messaging", "", "A description of the messaging capabilities of the solution.", 0, Integer.MAX_VALUE, this.messaging));
        children.add(new Property("document", "", "A document definition.", 0, Integer.MAX_VALUE, this.document));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this capability statement when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this capability statement is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the capability statement is stored on different servers.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the capability statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the capability statement author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the capability statement. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the capability statement.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this capability statement. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this capability statement is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the capability statement was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the capability statement changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the capability statement.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the capability statement from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate capability statement instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the capability statement is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this capability statement is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the capability statement and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the capability statement.", 0, 1, this.copyright);
            }
            case 3292052: {
                return new Property("kind", "code", "The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).", 0, 1, this.kind);
            }
            case -246883639: {
                return new Property("instantiates", "canonical(CapabilityStatement)", "Reference to a canonical URL of another CapabilityStatement that this software implements. This capability statement is a published API description that corresponds to a business service. The server may actually implement a subset of the capability statement it claims to implement, so the capability statement must specify the full capability details.", 0, Integer.MAX_VALUE, this.instantiates);
            }
            case 1926037870: {
                return new Property("imports", "canonical(CapabilityStatement)", "Reference to a canonical URL of another CapabilityStatement that this software adds to. The capability statement automatically includes everything in the other statement, and it is not duplicated, though the server may repeat the same resources, interactions and operations to add additional details to them.", 0, Integer.MAX_VALUE, this.imports);
            }
            case 1319330215: {
                return new Property(SP_SOFTWARE, "", "Software that is covered by this capability statement.  It is used when the capability statement describes the capabilities of a particular software version, independent of an installation.", 0, 1, this.software);
            }
            case 1683336114: {
                return new Property("implementation", "", "Identifies a specific implementation instance that is described by the capability statement - i.e. a particular installation, rather than the capabilities of a software program.", 0, 1, this.implementation);
            }
            case 461006061: {
                return new Property("fhirVersion", "code", "The version of the FHIR specification that this CapabilityStatement describes (which SHALL be the same as the FHIR version of the CapabilityStatement itself). There is no default value.", 0, 1, this.fhirVersion);
            }
            case -1268779017: {
                return new Property(SP_FORMAT, "code", "A list of the formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.format);
            }
            case 172338783: {
                return new Property("patchFormat", "code", "A list of the patch formats supported by this implementation using their content types.", 0, Integer.MAX_VALUE, this.patchFormat);
            }
            case 156966506: {
                return new Property("implementationGuide", "canonical(ImplementationGuide)", "A list of implementation guides that the server does (or should) support in their entirety.", 0, Integer.MAX_VALUE, this.implementationGuide);
            }
            case 3496916: {
                return new Property("rest", "", "A definition of the restful capabilities of the solution, if any.", 0, Integer.MAX_VALUE, this.rest);
            }
            case -1440008444: {
                return new Property("messaging", "", "A description of the messaging capabilities of the solution.", 0, Integer.MAX_VALUE, this.messaging);
            }
            case 861720859: {
                return new Property("document", "", "A document definition.", 0, Integer.MAX_VALUE, this.document);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.kind;
                }
                return baseArray;
            }
            case -246883639: {
                return this.instantiates == null ? new Base[]{} : this.instantiates.toArray(new Base[this.instantiates.size()]);
            }
            case 1926037870: {
                return this.imports == null ? new Base[]{} : this.imports.toArray(new Base[this.imports.size()]);
            }
            case 1319330215: {
                Base[] baseArray;
                if (this.software == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.software;
                }
                return baseArray;
            }
            case 1683336114: {
                Base[] baseArray;
                if (this.implementation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.implementation;
                }
                return baseArray;
            }
            case 461006061: {
                Base[] baseArray;
                if (this.fhirVersion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.fhirVersion;
                }
                return baseArray;
            }
            case -1268779017: {
                return this.format == null ? new Base[]{} : this.format.toArray(new Base[this.format.size()]);
            }
            case 172338783: {
                return this.patchFormat == null ? new Base[]{} : this.patchFormat.toArray(new Base[this.patchFormat.size()]);
            }
            case 156966506: {
                return this.implementationGuide == null ? new Base[]{} : this.implementationGuide.toArray(new Base[this.implementationGuide.size()]);
            }
            case 3496916: {
                return this.rest == null ? new Base[]{} : this.rest.toArray(new Base[this.rest.size()]);
            }
            case -1440008444: {
                return this.messaging == null ? new Base[]{} : this.messaging.toArray(new Base[this.messaging.size()]);
            }
            case 861720859: {
                return this.document == null ? new Base[]{} : this.document.toArray(new Base[this.document.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 3292052: {
                value = new Enumerations.CapabilityStatementKindEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.kind = value;
                return value;
            }
            case -246883639: {
                this.getInstantiates().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case 1926037870: {
                this.getImports().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case 1319330215: {
                this.software = (CapabilityStatementSoftwareComponent)((Object)value);
                return value;
            }
            case 1683336114: {
                this.implementation = (CapabilityStatementImplementationComponent)((Object)value);
                return value;
            }
            case 461006061: {
                value = new Enumerations.FHIRVersionEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.fhirVersion = value;
                return value;
            }
            case -1268779017: {
                this.getFormat().add(TypeConvertor.castToCode(value));
                return value;
            }
            case 172338783: {
                this.getPatchFormat().add(TypeConvertor.castToCode(value));
                return value;
            }
            case 156966506: {
                this.getImplementationGuide().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case 3496916: {
                this.getRest().add((CapabilityStatementRestComponent)((Object)value));
                return value;
            }
            case -1440008444: {
                this.getMessaging().add((CapabilityStatementMessagingComponent)((Object)value));
                return value;
            }
            case 861720859: {
                this.getDocument().add((CapabilityStatementDocumentComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("kind")) {
            value = new Enumerations.CapabilityStatementKindEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.kind = value;
        } else if (name.equals("instantiates")) {
            this.getInstantiates().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("imports")) {
            this.getImports().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals(SP_SOFTWARE)) {
            this.software = (CapabilityStatementSoftwareComponent)((Object)value);
        } else if (name.equals("implementation")) {
            this.implementation = (CapabilityStatementImplementationComponent)((Object)value);
        } else if (name.equals("fhirVersion")) {
            value = new Enumerations.FHIRVersionEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.fhirVersion = value;
        } else if (name.equals(SP_FORMAT)) {
            this.getFormat().add(TypeConvertor.castToCode(value));
        } else if (name.equals("patchFormat")) {
            this.getPatchFormat().add(TypeConvertor.castToCode(value));
        } else if (name.equals("implementationGuide")) {
            this.getImplementationGuide().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("rest")) {
            this.getRest().add((CapabilityStatementRestComponent)((Object)value));
        } else if (name.equals("messaging")) {
            this.getMessaging().add((CapabilityStatementMessagingComponent)((Object)value));
        } else if (name.equals("document")) {
            this.getDocument().add((CapabilityStatementDocumentComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case -246883639: {
                return this.addInstantiatesElement();
            }
            case 1926037870: {
                return this.addImportsElement();
            }
            case 1319330215: {
                return this.getSoftware();
            }
            case 1683336114: {
                return this.getImplementation();
            }
            case 461006061: {
                return this.getFhirVersionElement();
            }
            case -1268779017: {
                return this.addFormatElement();
            }
            case 172338783: {
                return this.addPatchFormatElement();
            }
            case 156966506: {
                return this.addImplementationGuideElement();
            }
            case 3496916: {
                return this.addRest();
            }
            case -1440008444: {
                return this.addMessaging();
            }
            case 861720859: {
                return this.addDocument();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 3292052: {
                return new String[]{"code"};
            }
            case -246883639: {
                return new String[]{"canonical"};
            }
            case 1926037870: {
                return new String[]{"canonical"};
            }
            case 1319330215: {
                return new String[0];
            }
            case 1683336114: {
                return new String[0];
            }
            case 461006061: {
                return new String[]{"code"};
            }
            case -1268779017: {
                return new String[]{"code"};
            }
            case 172338783: {
                return new String[]{"code"};
            }
            case 156966506: {
                return new String[]{"canonical"};
            }
            case 3496916: {
                return new String[0];
            }
            case -1440008444: {
                return new String[0];
            }
            case 861720859: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.copyright");
        }
        if (name.equals("kind")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.kind");
        }
        if (name.equals("instantiates")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.instantiates");
        }
        if (name.equals("imports")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.imports");
        }
        if (name.equals(SP_SOFTWARE)) {
            this.software = new CapabilityStatementSoftwareComponent();
            return this.software;
        }
        if (name.equals("implementation")) {
            this.implementation = new CapabilityStatementImplementationComponent();
            return this.implementation;
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.fhirVersion");
        }
        if (name.equals(SP_FORMAT)) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.format");
        }
        if (name.equals("patchFormat")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.patchFormat");
        }
        if (name.equals("implementationGuide")) {
            throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.implementationGuide");
        }
        if (name.equals("rest")) {
            return this.addRest();
        }
        if (name.equals("messaging")) {
            return this.addMessaging();
        }
        if (name.equals("document")) {
            return this.addDocument();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CapabilityStatement";
    }

    @Override
    public CapabilityStatement copy() {
        CapabilityStatement dst = new CapabilityStatement();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CapabilityStatement dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        Enumeration<Enumerations.CapabilityStatementKind> enumeration = dst.kind = this.kind == null ? null : this.kind.copy();
        if (this.instantiates != null) {
            dst.instantiates = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.instantiates) {
                dst.instantiates.add(canonicalType.copy());
            }
        }
        if (this.imports != null) {
            dst.imports = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.imports) {
                dst.imports.add(canonicalType.copy());
            }
        }
        dst.software = this.software == null ? null : this.software.copy();
        dst.implementation = this.implementation == null ? null : this.implementation.copy();
        Enumeration<Enumerations.FHIRVersion> enumeration2 = dst.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        if (this.format != null) {
            dst.format = new ArrayList<CodeType>();
            for (CodeType codeType : this.format) {
                dst.format.add(codeType.copy());
            }
        }
        if (this.patchFormat != null) {
            dst.patchFormat = new ArrayList<CodeType>();
            for (CodeType codeType : this.patchFormat) {
                dst.patchFormat.add(codeType.copy());
            }
        }
        if (this.implementationGuide != null) {
            dst.implementationGuide = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.implementationGuide) {
                dst.implementationGuide.add(canonicalType.copy());
            }
        }
        if (this.rest != null) {
            dst.rest = new ArrayList<CapabilityStatementRestComponent>();
            for (CapabilityStatementRestComponent capabilityStatementRestComponent : this.rest) {
                dst.rest.add(capabilityStatementRestComponent.copy());
            }
        }
        if (this.messaging != null) {
            dst.messaging = new ArrayList<CapabilityStatementMessagingComponent>();
            for (CapabilityStatementMessagingComponent capabilityStatementMessagingComponent : this.messaging) {
                dst.messaging.add(capabilityStatementMessagingComponent.copy());
            }
        }
        if (this.document != null) {
            dst.document = new ArrayList<CapabilityStatementDocumentComponent>();
            for (CapabilityStatementDocumentComponent capabilityStatementDocumentComponent : this.document) {
                dst.document.add(capabilityStatementDocumentComponent.copy());
            }
        }
    }

    protected CapabilityStatement typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CapabilityStatement)) {
            return false;
        }
        CapabilityStatement o = (CapabilityStatement)other_;
        return CapabilityStatement.compareDeep(this.url, o.url, true) && CapabilityStatement.compareDeep(this.version, o.version, true) && CapabilityStatement.compareDeep(this.name, o.name, true) && CapabilityStatement.compareDeep(this.title, o.title, true) && CapabilityStatement.compareDeep(this.status, o.status, true) && CapabilityStatement.compareDeep(this.experimental, o.experimental, true) && CapabilityStatement.compareDeep(this.date, o.date, true) && CapabilityStatement.compareDeep(this.publisher, o.publisher, true) && CapabilityStatement.compareDeep(this.contact, o.contact, true) && CapabilityStatement.compareDeep(this.description, o.description, true) && CapabilityStatement.compareDeep(this.useContext, o.useContext, true) && CapabilityStatement.compareDeep(this.jurisdiction, o.jurisdiction, true) && CapabilityStatement.compareDeep(this.purpose, o.purpose, true) && CapabilityStatement.compareDeep(this.copyright, o.copyright, true) && CapabilityStatement.compareDeep(this.kind, o.kind, true) && CapabilityStatement.compareDeep(this.instantiates, o.instantiates, true) && CapabilityStatement.compareDeep(this.imports, o.imports, true) && CapabilityStatement.compareDeep(this.software, o.software, true) && CapabilityStatement.compareDeep(this.implementation, o.implementation, true) && CapabilityStatement.compareDeep(this.fhirVersion, o.fhirVersion, true) && CapabilityStatement.compareDeep(this.format, o.format, true) && CapabilityStatement.compareDeep(this.patchFormat, o.patchFormat, true) && CapabilityStatement.compareDeep(this.implementationGuide, o.implementationGuide, true) && CapabilityStatement.compareDeep(this.rest, o.rest, true) && CapabilityStatement.compareDeep(this.messaging, o.messaging, true) && CapabilityStatement.compareDeep(this.document, o.document, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CapabilityStatement)) {
            return false;
        }
        CapabilityStatement o = (CapabilityStatement)other_;
        return CapabilityStatement.compareValues(this.url, o.url, true) && CapabilityStatement.compareValues(this.version, o.version, true) && CapabilityStatement.compareValues(this.name, o.name, true) && CapabilityStatement.compareValues(this.title, o.title, true) && CapabilityStatement.compareValues(this.status, o.status, true) && CapabilityStatement.compareValues(this.experimental, o.experimental, true) && CapabilityStatement.compareValues(this.date, o.date, true) && CapabilityStatement.compareValues(this.publisher, o.publisher, true) && CapabilityStatement.compareValues(this.description, o.description, true) && CapabilityStatement.compareValues(this.purpose, o.purpose, true) && CapabilityStatement.compareValues(this.copyright, o.copyright, true) && CapabilityStatement.compareValues(this.kind, o.kind, true) && CapabilityStatement.compareValues(this.instantiates, o.instantiates, true) && CapabilityStatement.compareValues(this.imports, o.imports, true) && CapabilityStatement.compareValues(this.fhirVersion, o.fhirVersion, true) && CapabilityStatement.compareValues(this.format, o.format, true) && CapabilityStatement.compareValues(this.patchFormat, o.patchFormat, true) && CapabilityStatement.compareValues(this.implementationGuide, o.implementationGuide, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.kind, this.instantiates, this.imports, this.software, this.implementation, this.fhirVersion, this.format, this.patchFormat, this.implementationGuide, this.rest, this.messaging, this.document});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.CapabilityStatement;
    }

    @Override
    public List<Identifier> getIdentifier() {
        return new ArrayList<Identifier>();
    }

    @Override
    public CanonicalResource setIdentifier(List<Identifier> theIdentifier) {
        return this;
    }

    @Override
    public boolean hasIdentifier() {
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        return null;
    }

    @Override
    public CanonicalResource addIdentifier(Identifier t) {
        return null;
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        return null;
    }

    @Block
    public static class CapabilityStatementDocumentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="producer | consumer", formalDefinition="Mode of this document declaration - whether an application is a producer or consumer.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/document-mode")
        protected Enumeration<DocumentMode> mode;
        @Child(name="documentation", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of document support", formalDefinition="A description of how the application supports or uses the specified document profile.  For example, when documents are created, what action is taken with consumed documents, etc.")
        protected MarkdownType documentation;
        @Child(name="profile", type={CanonicalType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Constraint on the resources used in the document", formalDefinition="A profile on the document Bundle that constrains which resources are present, and their contents.")
        protected CanonicalType profile;
        private static final long serialVersionUID = 18026632L;

        public CapabilityStatementDocumentComponent() {
        }

        public CapabilityStatementDocumentComponent(DocumentMode mode, String profile) {
            this.setMode(mode);
            this.setProfile(profile);
        }

        public Enumeration<DocumentMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementDocumentComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<DocumentMode>(new DocumentModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public CapabilityStatementDocumentComponent setModeElement(Enumeration<DocumentMode> value) {
            this.mode = value;
            return this;
        }

        public DocumentMode getMode() {
            return this.mode == null ? null : (DocumentMode)((Object)this.mode.getValue());
        }

        public CapabilityStatementDocumentComponent setMode(DocumentMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<DocumentMode>(new DocumentModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementDocumentComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatementDocumentComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatementDocumentComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public CanonicalType getProfileElement() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementDocumentComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new CanonicalType();
                }
            }
            return this.profile;
        }

        public boolean hasProfileElement() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public CapabilityStatementDocumentComponent setProfileElement(CanonicalType value) {
            this.profile = value;
            return this;
        }

        public String getProfile() {
            return this.profile == null ? null : (String)this.profile.getValue();
        }

        public CapabilityStatementDocumentComponent setProfile(String value) {
            if (this.profile == null) {
                this.profile = new CanonicalType();
            }
            this.profile.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement.SP_MODE, "code", "Mode of this document declaration - whether an application is a producer or consumer.", 0, 1, this.mode));
            children.add(new Property("documentation", "markdown", "A description of how the application supports or uses the specified document profile.  For example, when documents are created, what action is taken with consumed documents, etc.", 0, 1, this.documentation));
            children.add(new Property("profile", "canonical(StructureDefinition)", "A profile on the document Bundle that constrains which resources are present, and their contents.", 0, 1, this.profile));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property(CapabilityStatement.SP_MODE, "code", "Mode of this document declaration - whether an application is a producer or consumer.", 0, 1, this.mode);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "A description of how the application supports or uses the specified document profile.  For example, when documents are created, what action is taken with consumed documents, etc.", 0, 1, this.documentation);
                }
                case -309425751: {
                    return new Property("profile", "canonical(StructureDefinition)", "A profile on the document Bundle that constrains which resources are present, and their contents.", 0, 1, this.profile);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new DocumentModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -309425751: {
                    this.profile = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_MODE)) {
                value = new DocumentModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("profile")) {
                this.profile = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case -309425751: {
                    return this.getProfileElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_MODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.document.mode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.document.documentation");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.document.profile");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementDocumentComponent copy() {
            CapabilityStatementDocumentComponent dst = new CapabilityStatementDocumentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementDocumentComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementDocumentComponent)) {
                return false;
            }
            CapabilityStatementDocumentComponent o = (CapabilityStatementDocumentComponent)other_;
            return CapabilityStatementDocumentComponent.compareDeep(this.mode, o.mode, true) && CapabilityStatementDocumentComponent.compareDeep(this.documentation, o.documentation, true) && CapabilityStatementDocumentComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementDocumentComponent)) {
                return false;
            }
            CapabilityStatementDocumentComponent o = (CapabilityStatementDocumentComponent)other_;
            return CapabilityStatementDocumentComponent.compareValues(this.mode, o.mode, true) && CapabilityStatementDocumentComponent.compareValues(this.documentation, o.documentation, true) && CapabilityStatementDocumentComponent.compareValues(this.profile, o.profile, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.documentation, this.profile});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.document";
        }
    }

    @Block
    public static class CapabilityStatementMessagingSupportedMessageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="sender | receiver", formalDefinition="The mode of this event declaration - whether application is sender or receiver.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-capability-mode")
        protected Enumeration<EventCapabilityMode> mode;
        @Child(name="definition", type={CanonicalType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Message supported by this system", formalDefinition="Points to a message definition that identifies the messaging event, message structure, allowed responses, etc.")
        protected CanonicalType definition;
        private static final long serialVersionUID = -1172840676L;

        public CapabilityStatementMessagingSupportedMessageComponent() {
        }

        public CapabilityStatementMessagingSupportedMessageComponent(EventCapabilityMode mode, String definition) {
            this.setMode(mode);
            this.setDefinition(definition);
        }

        public Enumeration<EventCapabilityMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementMessagingSupportedMessageComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<EventCapabilityMode>(new EventCapabilityModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public CapabilityStatementMessagingSupportedMessageComponent setModeElement(Enumeration<EventCapabilityMode> value) {
            this.mode = value;
            return this;
        }

        public EventCapabilityMode getMode() {
            return this.mode == null ? null : (EventCapabilityMode)((Object)this.mode.getValue());
        }

        public CapabilityStatementMessagingSupportedMessageComponent setMode(EventCapabilityMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<EventCapabilityMode>(new EventCapabilityModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public CanonicalType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementMessagingSupportedMessageComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new CanonicalType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public CapabilityStatementMessagingSupportedMessageComponent setDefinitionElement(CanonicalType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public CapabilityStatementMessagingSupportedMessageComponent setDefinition(String value) {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            this.definition.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement.SP_MODE, "code", "The mode of this event declaration - whether application is sender or receiver.", 0, 1, this.mode));
            children.add(new Property("definition", "canonical(MessageDefinition)", "Points to a message definition that identifies the messaging event, message structure, allowed responses, etc.", 0, 1, this.definition));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property(CapabilityStatement.SP_MODE, "code", "The mode of this event declaration - whether application is sender or receiver.", 0, 1, this.mode);
                }
                case -1014418093: {
                    return new Property("definition", "canonical(MessageDefinition)", "Points to a message definition that identifies the messaging event, message structure, allowed responses, etc.", 0, 1, this.definition);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new EventCapabilityModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case -1014418093: {
                    this.definition = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_MODE)) {
                value = new EventCapabilityModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("definition")) {
                this.definition = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case -1014418093: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_MODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.messaging.supportedMessage.mode");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.messaging.supportedMessage.definition");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementMessagingSupportedMessageComponent copy() {
            CapabilityStatementMessagingSupportedMessageComponent dst = new CapabilityStatementMessagingSupportedMessageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementMessagingSupportedMessageComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementMessagingSupportedMessageComponent)) {
                return false;
            }
            CapabilityStatementMessagingSupportedMessageComponent o = (CapabilityStatementMessagingSupportedMessageComponent)other_;
            return CapabilityStatementMessagingSupportedMessageComponent.compareDeep(this.mode, o.mode, true) && CapabilityStatementMessagingSupportedMessageComponent.compareDeep(this.definition, o.definition, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementMessagingSupportedMessageComponent)) {
                return false;
            }
            CapabilityStatementMessagingSupportedMessageComponent o = (CapabilityStatementMessagingSupportedMessageComponent)other_;
            return CapabilityStatementMessagingSupportedMessageComponent.compareValues(this.mode, o.mode, true) && CapabilityStatementMessagingSupportedMessageComponent.compareValues(this.definition, o.definition, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.definition});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.messaging.supportedMessage";
        }
    }

    @Block
    public static class CapabilityStatementMessagingEndpointComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="protocol", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="http | ftp | mllp +", formalDefinition="A list of the messaging transport protocol(s) identifiers, supported by this endpoint.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/message-transport")
        protected Coding protocol;
        @Child(name="address", type={UrlType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Network address or identifier of the end-point", formalDefinition="The network address of the endpoint. For solutions that do not use network addresses for routing, it can be just an identifier.")
        protected UrlType address;
        private static final long serialVersionUID = -236946103L;

        public CapabilityStatementMessagingEndpointComponent() {
        }

        public CapabilityStatementMessagingEndpointComponent(Coding protocol, String address) {
            this.setProtocol(protocol);
            this.setAddress(address);
        }

        public Coding getProtocol() {
            if (this.protocol == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementMessagingEndpointComponent.protocol");
                }
                if (Configuration.doAutoCreate()) {
                    this.protocol = new Coding();
                }
            }
            return this.protocol;
        }

        public boolean hasProtocol() {
            return this.protocol != null && !this.protocol.isEmpty();
        }

        public CapabilityStatementMessagingEndpointComponent setProtocol(Coding value) {
            this.protocol = value;
            return this;
        }

        public UrlType getAddressElement() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementMessagingEndpointComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new UrlType();
                }
            }
            return this.address;
        }

        public boolean hasAddressElement() {
            return this.address != null && !this.address.isEmpty();
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public CapabilityStatementMessagingEndpointComponent setAddressElement(UrlType value) {
            this.address = value;
            return this;
        }

        public String getAddress() {
            return this.address == null ? null : (String)this.address.getValue();
        }

        public CapabilityStatementMessagingEndpointComponent setAddress(String value) {
            if (this.address == null) {
                this.address = new UrlType();
            }
            this.address.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("protocol", "Coding", "A list of the messaging transport protocol(s) identifiers, supported by this endpoint.", 0, 1, this.protocol));
            children.add(new Property("address", CapabilityStatement.SP_URL, "The network address of the endpoint. For solutions that do not use network addresses for routing, it can be just an identifier.", 0, 1, this.address));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -989163880: {
                    return new Property("protocol", "Coding", "A list of the messaging transport protocol(s) identifiers, supported by this endpoint.", 0, 1, this.protocol);
                }
                case -1147692044: {
                    return new Property("address", CapabilityStatement.SP_URL, "The network address of the endpoint. For solutions that do not use network addresses for routing, it can be just an identifier.", 0, 1, this.address);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -989163880: {
                    Base[] baseArray;
                    if (this.protocol == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.protocol;
                    }
                    return baseArray;
                }
                case -1147692044: {
                    Base[] baseArray;
                    if (this.address == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.address;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -989163880: {
                    this.protocol = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -1147692044: {
                    this.address = TypeConvertor.castToUrl(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("protocol")) {
                this.protocol = TypeConvertor.castToCoding(value);
            } else if (name.equals("address")) {
                this.address = TypeConvertor.castToUrl(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -989163880: {
                    return this.getProtocol();
                }
                case -1147692044: {
                    return this.getAddressElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -989163880: {
                    return new String[]{"Coding"};
                }
                case -1147692044: {
                    return new String[]{CapabilityStatement.SP_URL};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("protocol")) {
                this.protocol = new Coding();
                return this.protocol;
            }
            if (name.equals("address")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.messaging.endpoint.address");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementMessagingEndpointComponent copy() {
            CapabilityStatementMessagingEndpointComponent dst = new CapabilityStatementMessagingEndpointComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementMessagingEndpointComponent dst) {
            super.copyValues(dst);
            dst.protocol = this.protocol == null ? null : this.protocol.copy();
            dst.address = this.address == null ? null : this.address.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementMessagingEndpointComponent)) {
                return false;
            }
            CapabilityStatementMessagingEndpointComponent o = (CapabilityStatementMessagingEndpointComponent)other_;
            return CapabilityStatementMessagingEndpointComponent.compareDeep(this.protocol, o.protocol, true) && CapabilityStatementMessagingEndpointComponent.compareDeep(this.address, o.address, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementMessagingEndpointComponent)) {
                return false;
            }
            CapabilityStatementMessagingEndpointComponent o = (CapabilityStatementMessagingEndpointComponent)other_;
            return CapabilityStatementMessagingEndpointComponent.compareValues(this.address, o.address, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.protocol, this.address});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.messaging.endpoint";
        }
    }

    @Block
    public static class CapabilityStatementMessagingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="endpoint", type={}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Where messages should be sent", formalDefinition="An endpoint (network accessible address) to which messages and/or replies are to be sent.")
        protected List<CapabilityStatementMessagingEndpointComponent> endpoint;
        @Child(name="reliableCache", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reliable Message Cache Length (min)", formalDefinition="Length if the receiver's reliable messaging cache in minutes (if a receiver) or how long the cache length on the receiver should be (if a sender).")
        protected UnsignedIntType reliableCache;
        @Child(name="documentation", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Messaging interface behavior details", formalDefinition="Documentation about the system's messaging capabilities for this endpoint not otherwise documented by the capability statement.  For example, the process for becoming an authorized messaging exchange partner.")
        protected MarkdownType documentation;
        @Child(name="supportedMessage", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Messages supported by this system", formalDefinition="References to message definitions for messages this system can send or receive.")
        protected List<CapabilityStatementMessagingSupportedMessageComponent> supportedMessage;
        private static final long serialVersionUID = 300411231L;

        public List<CapabilityStatementMessagingEndpointComponent> getEndpoint() {
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<CapabilityStatementMessagingEndpointComponent>();
            }
            return this.endpoint;
        }

        public CapabilityStatementMessagingComponent setEndpoint(List<CapabilityStatementMessagingEndpointComponent> theEndpoint) {
            this.endpoint = theEndpoint;
            return this;
        }

        public boolean hasEndpoint() {
            if (this.endpoint == null) {
                return false;
            }
            for (CapabilityStatementMessagingEndpointComponent item : this.endpoint) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatementMessagingEndpointComponent addEndpoint() {
            CapabilityStatementMessagingEndpointComponent t = new CapabilityStatementMessagingEndpointComponent();
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<CapabilityStatementMessagingEndpointComponent>();
            }
            this.endpoint.add(t);
            return t;
        }

        public CapabilityStatementMessagingComponent addEndpoint(CapabilityStatementMessagingEndpointComponent t) {
            if (t == null) {
                return this;
            }
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<CapabilityStatementMessagingEndpointComponent>();
            }
            this.endpoint.add(t);
            return this;
        }

        public CapabilityStatementMessagingEndpointComponent getEndpointFirstRep() {
            if (this.getEndpoint().isEmpty()) {
                this.addEndpoint();
            }
            return this.getEndpoint().get(0);
        }

        public UnsignedIntType getReliableCacheElement() {
            if (this.reliableCache == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementMessagingComponent.reliableCache");
                }
                if (Configuration.doAutoCreate()) {
                    this.reliableCache = new UnsignedIntType();
                }
            }
            return this.reliableCache;
        }

        public boolean hasReliableCacheElement() {
            return this.reliableCache != null && !this.reliableCache.isEmpty();
        }

        public boolean hasReliableCache() {
            return this.reliableCache != null && !this.reliableCache.isEmpty();
        }

        public CapabilityStatementMessagingComponent setReliableCacheElement(UnsignedIntType value) {
            this.reliableCache = value;
            return this;
        }

        public int getReliableCache() {
            return this.reliableCache == null || this.reliableCache.isEmpty() ? 0 : (Integer)this.reliableCache.getValue();
        }

        public CapabilityStatementMessagingComponent setReliableCache(int value) {
            if (this.reliableCache == null) {
                this.reliableCache = new UnsignedIntType();
            }
            this.reliableCache.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementMessagingComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatementMessagingComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatementMessagingComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public List<CapabilityStatementMessagingSupportedMessageComponent> getSupportedMessage() {
            if (this.supportedMessage == null) {
                this.supportedMessage = new ArrayList<CapabilityStatementMessagingSupportedMessageComponent>();
            }
            return this.supportedMessage;
        }

        public CapabilityStatementMessagingComponent setSupportedMessage(List<CapabilityStatementMessagingSupportedMessageComponent> theSupportedMessage) {
            this.supportedMessage = theSupportedMessage;
            return this;
        }

        public boolean hasSupportedMessage() {
            if (this.supportedMessage == null) {
                return false;
            }
            for (CapabilityStatementMessagingSupportedMessageComponent item : this.supportedMessage) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatementMessagingSupportedMessageComponent addSupportedMessage() {
            CapabilityStatementMessagingSupportedMessageComponent t = new CapabilityStatementMessagingSupportedMessageComponent();
            if (this.supportedMessage == null) {
                this.supportedMessage = new ArrayList<CapabilityStatementMessagingSupportedMessageComponent>();
            }
            this.supportedMessage.add(t);
            return t;
        }

        public CapabilityStatementMessagingComponent addSupportedMessage(CapabilityStatementMessagingSupportedMessageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.supportedMessage == null) {
                this.supportedMessage = new ArrayList<CapabilityStatementMessagingSupportedMessageComponent>();
            }
            this.supportedMessage.add(t);
            return this;
        }

        public CapabilityStatementMessagingSupportedMessageComponent getSupportedMessageFirstRep() {
            if (this.getSupportedMessage().isEmpty()) {
                this.addSupportedMessage();
            }
            return this.getSupportedMessage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("endpoint", "", "An endpoint (network accessible address) to which messages and/or replies are to be sent.", 0, Integer.MAX_VALUE, this.endpoint));
            children.add(new Property("reliableCache", "unsignedInt", "Length if the receiver's reliable messaging cache in minutes (if a receiver) or how long the cache length on the receiver should be (if a sender).", 0, 1, this.reliableCache));
            children.add(new Property("documentation", "markdown", "Documentation about the system's messaging capabilities for this endpoint not otherwise documented by the capability statement.  For example, the process for becoming an authorized messaging exchange partner.", 0, 1, this.documentation));
            children.add(new Property("supportedMessage", "", "References to message definitions for messages this system can send or receive.", 0, Integer.MAX_VALUE, this.supportedMessage));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1741102485: {
                    return new Property("endpoint", "", "An endpoint (network accessible address) to which messages and/or replies are to be sent.", 0, Integer.MAX_VALUE, this.endpoint);
                }
                case 897803608: {
                    return new Property("reliableCache", "unsignedInt", "Length if the receiver's reliable messaging cache in minutes (if a receiver) or how long the cache length on the receiver should be (if a sender).", 0, 1, this.reliableCache);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Documentation about the system's messaging capabilities for this endpoint not otherwise documented by the capability statement.  For example, the process for becoming an authorized messaging exchange partner.", 0, 1, this.documentation);
                }
                case -1805139079: {
                    return new Property("supportedMessage", "", "References to message definitions for messages this system can send or receive.", 0, Integer.MAX_VALUE, this.supportedMessage);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1741102485: {
                    return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
                }
                case 897803608: {
                    Base[] baseArray;
                    if (this.reliableCache == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reliableCache;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
                case -1805139079: {
                    return this.supportedMessage == null ? new Base[]{} : this.supportedMessage.toArray(new Base[this.supportedMessage.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1741102485: {
                    this.getEndpoint().add((CapabilityStatementMessagingEndpointComponent)value);
                    return value;
                }
                case 897803608: {
                    this.reliableCache = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case -1805139079: {
                    this.getSupportedMessage().add((CapabilityStatementMessagingSupportedMessageComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("endpoint")) {
                this.getEndpoint().add((CapabilityStatementMessagingEndpointComponent)value);
            } else if (name.equals("reliableCache")) {
                this.reliableCache = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("supportedMessage")) {
                this.getSupportedMessage().add((CapabilityStatementMessagingSupportedMessageComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1741102485: {
                    return this.addEndpoint();
                }
                case 897803608: {
                    return this.getReliableCacheElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case -1805139079: {
                    return this.addSupportedMessage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1741102485: {
                    return new String[0];
                }
                case 897803608: {
                    return new String[]{"unsignedInt"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
                case -1805139079: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("endpoint")) {
                return this.addEndpoint();
            }
            if (name.equals("reliableCache")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.messaging.reliableCache");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.messaging.documentation");
            }
            if (name.equals("supportedMessage")) {
                return this.addSupportedMessage();
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementMessagingComponent copy() {
            CapabilityStatementMessagingComponent dst = new CapabilityStatementMessagingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementMessagingComponent dst) {
            super.copyValues(dst);
            if (this.endpoint != null) {
                dst.endpoint = new ArrayList<CapabilityStatementMessagingEndpointComponent>();
                for (CapabilityStatementMessagingEndpointComponent capabilityStatementMessagingEndpointComponent : this.endpoint) {
                    dst.endpoint.add(capabilityStatementMessagingEndpointComponent.copy());
                }
            }
            dst.reliableCache = this.reliableCache == null ? null : this.reliableCache.copy();
            MarkdownType markdownType = dst.documentation = this.documentation == null ? null : this.documentation.copy();
            if (this.supportedMessage != null) {
                dst.supportedMessage = new ArrayList<CapabilityStatementMessagingSupportedMessageComponent>();
                for (CapabilityStatementMessagingSupportedMessageComponent capabilityStatementMessagingSupportedMessageComponent : this.supportedMessage) {
                    dst.supportedMessage.add(capabilityStatementMessagingSupportedMessageComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementMessagingComponent)) {
                return false;
            }
            CapabilityStatementMessagingComponent o = (CapabilityStatementMessagingComponent)other_;
            return CapabilityStatementMessagingComponent.compareDeep(this.endpoint, o.endpoint, true) && CapabilityStatementMessagingComponent.compareDeep(this.reliableCache, o.reliableCache, true) && CapabilityStatementMessagingComponent.compareDeep(this.documentation, o.documentation, true) && CapabilityStatementMessagingComponent.compareDeep(this.supportedMessage, o.supportedMessage, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementMessagingComponent)) {
                return false;
            }
            CapabilityStatementMessagingComponent o = (CapabilityStatementMessagingComponent)other_;
            return CapabilityStatementMessagingComponent.compareValues(this.reliableCache, o.reliableCache, true) && CapabilityStatementMessagingComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.endpoint, this.reliableCache, this.documentation, this.supportedMessage});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.messaging";
        }
    }

    @Block
    public static class SystemInteractionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="transaction | batch | search-system | history-system", formalDefinition="A coded identifier of the operation, supported by the system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/system-restful-interaction")
        protected Enumeration<SystemRestfulInteraction> code;
        @Child(name="documentation", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anything special about operation behavior", formalDefinition="Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = -1495143879L;

        public SystemInteractionComponent() {
        }

        public SystemInteractionComponent(SystemRestfulInteraction code) {
            this.setCode(code);
        }

        public Enumeration<SystemRestfulInteraction> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SystemInteractionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<SystemRestfulInteraction>(new SystemRestfulInteractionEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SystemInteractionComponent setCodeElement(Enumeration<SystemRestfulInteraction> value) {
            this.code = value;
            return this;
        }

        public SystemRestfulInteraction getCode() {
            return this.code == null ? null : (SystemRestfulInteraction)((Object)this.code.getValue());
        }

        public SystemInteractionComponent setCode(SystemRestfulInteraction value) {
            if (this.code == null) {
                this.code = new Enumeration<SystemRestfulInteraction>(new SystemRestfulInteractionEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SystemInteractionComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public SystemInteractionComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public SystemInteractionComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "A coded identifier of the operation, supported by the system.", 0, 1, this.code));
            children.add(new Property("documentation", "markdown", "Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "A coded identifier of the operation, supported by the system.", 0, 1, this.code);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Guidance specific to the implementation of this operation, such as limitations on the kind of transactions allowed, or information about system wide search is implemented.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new SystemRestfulInteractionEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.code = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new SystemRestfulInteractionEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.code = value;
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.interaction.code");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.interaction.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public SystemInteractionComponent copy() {
            SystemInteractionComponent dst = new SystemInteractionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SystemInteractionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SystemInteractionComponent)) {
                return false;
            }
            SystemInteractionComponent o = (SystemInteractionComponent)other_;
            return SystemInteractionComponent.compareDeep(this.code, o.code, true) && SystemInteractionComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SystemInteractionComponent)) {
                return false;
            }
            SystemInteractionComponent o = (SystemInteractionComponent)other_;
            return SystemInteractionComponent.compareValues(this.code, o.code, true) && SystemInteractionComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.documentation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.rest.interaction";
        }
    }

    @Block
    public static class CapabilityStatementRestResourceOperationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name by which the operation/query is invoked", formalDefinition="The name of the operation or query. For an operation, this is the name  prefixed with $ and used in the URL. For a query, this is the name used in the _query parameter when the query is called.")
        protected StringType name;
        @Child(name="definition", type={CanonicalType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The defined operation/query", formalDefinition="Where the formal definition can be found. If a server references the base definition of an Operation (i.e. from the specification itself such as ```http://hl7.org/fhir/OperationDefinition/ValueSet-expand```), that means it supports the full capabilities of the operation - e.g. both GET and POST invocation.  If it only supports a subset, it must define its own custom [OperationDefinition](operationdefinition.html#) with a 'base' of the original OperationDefinition.  The custom definition would describe the specific subset of functionality supported.")
        protected CanonicalType definition;
        @Child(name="documentation", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific details about operation behavior", formalDefinition="Documentation that describes anything special about the operation behavior, possibly detailing different behavior for system, type and instance-level invocation of the operation.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = -388608084L;

        public CapabilityStatementRestResourceOperationComponent() {
        }

        public CapabilityStatementRestResourceOperationComponent(String name, String definition) {
            this.setName(name);
            this.setDefinition(definition);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceOperationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CapabilityStatementRestResourceOperationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public CapabilityStatementRestResourceOperationComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CanonicalType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceOperationComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new CanonicalType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public CapabilityStatementRestResourceOperationComponent setDefinitionElement(CanonicalType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public CapabilityStatementRestResourceOperationComponent setDefinition(String value) {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            this.definition.setValue(value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceOperationComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatementRestResourceOperationComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatementRestResourceOperationComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement.SP_NAME, "string", "The name of the operation or query. For an operation, this is the name  prefixed with $ and used in the URL. For a query, this is the name used in the _query parameter when the query is called.", 0, 1, this.name));
            children.add(new Property("definition", "canonical(OperationDefinition)", "Where the formal definition can be found. If a server references the base definition of an Operation (i.e. from the specification itself such as ```http://hl7.org/fhir/OperationDefinition/ValueSet-expand```), that means it supports the full capabilities of the operation - e.g. both GET and POST invocation.  If it only supports a subset, it must define its own custom [OperationDefinition](operationdefinition.html#) with a 'base' of the original OperationDefinition.  The custom definition would describe the specific subset of functionality supported.", 0, 1, this.definition));
            children.add(new Property("documentation", "markdown", "Documentation that describes anything special about the operation behavior, possibly detailing different behavior for system, type and instance-level invocation of the operation.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(CapabilityStatement.SP_NAME, "string", "The name of the operation or query. For an operation, this is the name  prefixed with $ and used in the URL. For a query, this is the name used in the _query parameter when the query is called.", 0, 1, this.name);
                }
                case -1014418093: {
                    return new Property("definition", "canonical(OperationDefinition)", "Where the formal definition can be found. If a server references the base definition of an Operation (i.e. from the specification itself such as ```http://hl7.org/fhir/OperationDefinition/ValueSet-expand```), that means it supports the full capabilities of the operation - e.g. both GET and POST invocation.  If it only supports a subset, it must define its own custom [OperationDefinition](operationdefinition.html#) with a 'base' of the original OperationDefinition.  The custom definition would describe the specific subset of functionality supported.", 0, 1, this.definition);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Documentation that describes anything special about the operation behavior, possibly detailing different behavior for system, type and instance-level invocation of the operation.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = TypeConvertor.castToCanonical(value);
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1014418093: {
                    return new String[]{"canonical"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.operation.name");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.operation.definition");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.operation.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementRestResourceOperationComponent copy() {
            CapabilityStatementRestResourceOperationComponent dst = new CapabilityStatementRestResourceOperationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementRestResourceOperationComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestResourceOperationComponent)) {
                return false;
            }
            CapabilityStatementRestResourceOperationComponent o = (CapabilityStatementRestResourceOperationComponent)other_;
            return CapabilityStatementRestResourceOperationComponent.compareDeep(this.name, o.name, true) && CapabilityStatementRestResourceOperationComponent.compareDeep(this.definition, o.definition, true) && CapabilityStatementRestResourceOperationComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestResourceOperationComponent)) {
                return false;
            }
            CapabilityStatementRestResourceOperationComponent o = (CapabilityStatementRestResourceOperationComponent)other_;
            return CapabilityStatementRestResourceOperationComponent.compareValues(this.name, o.name, true) && CapabilityStatementRestResourceOperationComponent.compareValues(this.definition, o.definition, true) && CapabilityStatementRestResourceOperationComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.definition, this.documentation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.rest.resource.operation";
        }
    }

    @Block
    public static class CapabilityStatementRestResourceSearchParamComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of search parameter", formalDefinition="The name of the search parameter used in the interface.")
        protected StringType name;
        @Child(name="definition", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source of definition for parameter", formalDefinition="An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [SearchParameter.url](searchparameter-definitions.html#SearchParameter.url)). This element SHALL be populated if the search parameter refers to a SearchParameter defined by the FHIR core specification or externally defined IGs.")
        protected CanonicalType definition;
        @Child(name="type", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri | special", formalDefinition="The type of value a search parameter refers to, and how the content is interpreted.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-param-type")
        protected Enumeration<Enumerations.SearchParamType> type;
        @Child(name="documentation", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Server-specific usage", formalDefinition="This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = -171123928L;

        public CapabilityStatementRestResourceSearchParamComponent() {
        }

        public CapabilityStatementRestResourceSearchParamComponent(String name, Enumerations.SearchParamType type) {
            this.setName(name);
            this.setType(type);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceSearchParamComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CapabilityStatementRestResourceSearchParamComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public CapabilityStatementRestResourceSearchParamComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public CanonicalType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceSearchParamComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new CanonicalType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public CapabilityStatementRestResourceSearchParamComponent setDefinitionElement(CanonicalType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public CapabilityStatementRestResourceSearchParamComponent setDefinition(String value) {
            if (Utilities.noString((String)value)) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new CanonicalType();
                }
                this.definition.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.SearchParamType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceSearchParamComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CapabilityStatementRestResourceSearchParamComponent setTypeElement(Enumeration<Enumerations.SearchParamType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.SearchParamType getType() {
            return this.type == null ? null : (Enumerations.SearchParamType)((Object)this.type.getValue());
        }

        public CapabilityStatementRestResourceSearchParamComponent setType(Enumerations.SearchParamType value) {
            if (this.type == null) {
                this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceSearchParamComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatementRestResourceSearchParamComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatementRestResourceSearchParamComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement.SP_NAME, "string", "The name of the search parameter used in the interface.", 0, 1, this.name));
            children.add(new Property("definition", "canonical(SearchParameter)", "An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [SearchParameter.url](searchparameter-definitions.html#SearchParameter.url)). This element SHALL be populated if the search parameter refers to a SearchParameter defined by the FHIR core specification or externally defined IGs.", 0, 1, this.definition));
            children.add(new Property("type", "code", "The type of value a search parameter refers to, and how the content is interpreted.", 0, 1, this.type));
            children.add(new Property("documentation", "markdown", "This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(CapabilityStatement.SP_NAME, "string", "The name of the search parameter used in the interface.", 0, 1, this.name);
                }
                case -1014418093: {
                    return new Property("definition", "canonical(SearchParameter)", "An absolute URI that is a formal reference to where this parameter was first defined, so that a client can be confident of the meaning of the search parameter (a reference to [SearchParameter.url](searchparameter-definitions.html#SearchParameter.url)). This element SHALL be populated if the search parameter refers to a SearchParameter defined by the FHIR core specification or externally defined IGs.", 0, 1, this.definition);
                }
                case 3575610: {
                    return new Property("type", "code", "The type of value a search parameter refers to, and how the content is interpreted.", 0, 1, this.type);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "This allows documentation of any distinct behaviors about how the search parameter is used.  For example, text matching algorithms.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.definition;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1014418093: {
                    this.definition = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.SearchParamTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("definition")) {
                this.definition = TypeConvertor.castToCanonical(value);
            } else if (name.equals("type")) {
                value = new Enumerations.SearchParamTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1014418093: {
                    return new String[]{"canonical"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.searchParam.name");
            }
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.searchParam.definition");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.searchParam.type");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.searchParam.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementRestResourceSearchParamComponent copy() {
            CapabilityStatementRestResourceSearchParamComponent dst = new CapabilityStatementRestResourceSearchParamComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementRestResourceSearchParamComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.definition = this.definition == null ? null : this.definition.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestResourceSearchParamComponent)) {
                return false;
            }
            CapabilityStatementRestResourceSearchParamComponent o = (CapabilityStatementRestResourceSearchParamComponent)other_;
            return CapabilityStatementRestResourceSearchParamComponent.compareDeep(this.name, o.name, true) && CapabilityStatementRestResourceSearchParamComponent.compareDeep(this.definition, o.definition, true) && CapabilityStatementRestResourceSearchParamComponent.compareDeep(this.type, o.type, true) && CapabilityStatementRestResourceSearchParamComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestResourceSearchParamComponent)) {
                return false;
            }
            CapabilityStatementRestResourceSearchParamComponent o = (CapabilityStatementRestResourceSearchParamComponent)other_;
            return CapabilityStatementRestResourceSearchParamComponent.compareValues(this.name, o.name, true) && CapabilityStatementRestResourceSearchParamComponent.compareValues(this.definition, o.definition, true) && CapabilityStatementRestResourceSearchParamComponent.compareValues(this.type, o.type, true) && CapabilityStatementRestResourceSearchParamComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.definition, this.type, this.documentation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.rest.resource.searchParam";
        }
    }

    @Block
    public static class ResourceInteractionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="read | vread | update | patch | delete | history-instance | history-type | create | search-type", formalDefinition="Coded identifier of the operation, supported by the system resource.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/type-restful-interaction")
        protected Enumeration<TypeRestfulInteraction> code;
        @Child(name="documentation", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Anything special about operation behavior", formalDefinition="Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = 2128937796L;

        public ResourceInteractionComponent() {
        }

        public ResourceInteractionComponent(TypeRestfulInteraction code) {
            this.setCode(code);
        }

        public Enumeration<TypeRestfulInteraction> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResourceInteractionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<TypeRestfulInteraction>(new TypeRestfulInteractionEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ResourceInteractionComponent setCodeElement(Enumeration<TypeRestfulInteraction> value) {
            this.code = value;
            return this;
        }

        public TypeRestfulInteraction getCode() {
            return this.code == null ? null : (TypeRestfulInteraction)((Object)this.code.getValue());
        }

        public ResourceInteractionComponent setCode(TypeRestfulInteraction value) {
            if (this.code == null) {
                this.code = new Enumeration<TypeRestfulInteraction>(new TypeRestfulInteractionEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ResourceInteractionComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public ResourceInteractionComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public ResourceInteractionComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Coded identifier of the operation, supported by the system resource.", 0, 1, this.code));
            children.add(new Property("documentation", "markdown", "Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Coded identifier of the operation, supported by the system resource.", 0, 1, this.code);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Guidance specific to the implementation of this operation, such as 'delete is a logical delete' or 'updates are only allowed with version id' or 'creates permitted from pre-authorized certificates only'.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new TypeRestfulInteractionEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.code = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new TypeRestfulInteractionEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.code = value;
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.interaction.code");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.interaction.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public ResourceInteractionComponent copy() {
            ResourceInteractionComponent dst = new ResourceInteractionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ResourceInteractionComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ResourceInteractionComponent)) {
                return false;
            }
            ResourceInteractionComponent o = (ResourceInteractionComponent)other_;
            return ResourceInteractionComponent.compareDeep(this.code, o.code, true) && ResourceInteractionComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ResourceInteractionComponent)) {
                return false;
            }
            ResourceInteractionComponent o = (ResourceInteractionComponent)other_;
            return ResourceInteractionComponent.compareValues(this.code, o.code, true) && ResourceInteractionComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.documentation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.rest.resource.interaction";
        }
    }

    @Block
    public static class CapabilityStatementRestResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A resource type that is supported", formalDefinition="A type of resource exposed via the restful interface.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected CodeType type;
        @Child(name="profile", type={CanonicalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Base System profile for all uses of resource", formalDefinition="A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles](profiling.html#profile-uses).")
        protected CanonicalType profile;
        @Child(name="supportedProfile", type={CanonicalType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Profiles for use cases supported", formalDefinition="A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles](profiling.html#profile-uses).")
        protected List<CanonicalType> supportedProfile;
        @Child(name="documentation", type={MarkdownType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional information about the use of the resource type", formalDefinition="Additional information about the resource type used by the system.")
        protected MarkdownType documentation;
        @Child(name="interaction", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What operations are supported?", formalDefinition="Identifies a restful operation supported by the solution.")
        protected List<ResourceInteractionComponent> interaction;
        @Child(name="versioning", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="no-version | versioned | versioned-update", formalDefinition="This field is set to no-version to specify that the system does not support (server) or use (client) versioning for this resource type. If this has some other value, the server must at least correctly track and populate the versionId meta-property on resources. If the value is 'versioned-update', then the server supports all the versioning features, including using e-tags for version integrity in the API.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/versioning-policy")
        protected Enumeration<ResourceVersionPolicy> versioning;
        @Child(name="readHistory", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether vRead can return past versions", formalDefinition="A flag for whether the server is able to return past versions as part of the vRead operation.")
        protected BooleanType readHistory;
        @Child(name="updateCreate", type={BooleanType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If update can commit to a new identity", formalDefinition="A flag to indicate that the server allows or needs to allow the client to create new identities on the server (that is, the client PUTs to a location where there is no existing resource). Allowing this operation means that the server allows the client to create new identities on the server.")
        protected BooleanType updateCreate;
        @Child(name="conditionalCreate", type={BooleanType.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If allows/uses conditional create", formalDefinition="A flag that indicates that the server supports conditional create.")
        protected BooleanType conditionalCreate;
        @Child(name="conditionalRead", type={CodeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="not-supported | modified-since | not-match | full-support", formalDefinition="A code that indicates how the server supports conditional read.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/conditional-read-status")
        protected Enumeration<ConditionalReadStatus> conditionalRead;
        @Child(name="conditionalUpdate", type={BooleanType.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="If allows/uses conditional update", formalDefinition="A flag that indicates that the server supports conditional update.")
        protected BooleanType conditionalUpdate;
        @Child(name="conditionalDelete", type={CodeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="not-supported | single | multiple - how conditional delete is supported", formalDefinition="A code that indicates how the server supports conditional delete.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/conditional-delete-status")
        protected Enumeration<ConditionalDeleteStatus> conditionalDelete;
        @Child(name="referencePolicy", type={CodeType.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="literal | logical | resolves | enforced | local", formalDefinition="A set of flags that defines how references are supported.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/reference-handling-policy")
        protected List<Enumeration<ReferenceHandlingPolicy>> referencePolicy;
        @Child(name="searchInclude", type={StringType.class}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="_include values supported by the server", formalDefinition="A list of _include values supported by the server.")
        protected List<StringType> searchInclude;
        @Child(name="searchRevInclude", type={StringType.class}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="_revinclude values supported by the server", formalDefinition="A list of _revinclude (reverse include) values supported by the server.")
        protected List<StringType> searchRevInclude;
        @Child(name="searchParam", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Search parameters supported by implementation", formalDefinition="Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.")
        protected List<CapabilityStatementRestResourceSearchParamComponent> searchParam;
        @Child(name="operation", type={}, order=17, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Definition of a resource operation", formalDefinition="Definition of an operation or a named query together with its parameters and their meaning and type. Consult the definition of the operation for details about how to invoke the operation, and the parameters.")
        protected List<CapabilityStatementRestResourceOperationComponent> operation;
        private static final long serialVersionUID = -1843372337L;

        public CapabilityStatementRestResourceComponent() {
        }

        public CapabilityStatementRestResourceComponent(String type) {
            this.setType(type);
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public CapabilityStatementRestResourceComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public CanonicalType getProfileElement() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new CanonicalType();
                }
            }
            return this.profile;
        }

        public boolean hasProfileElement() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setProfileElement(CanonicalType value) {
            this.profile = value;
            return this;
        }

        public String getProfile() {
            return this.profile == null ? null : (String)this.profile.getValue();
        }

        public CapabilityStatementRestResourceComponent setProfile(String value) {
            if (Utilities.noString((String)value)) {
                this.profile = null;
            } else {
                if (this.profile == null) {
                    this.profile = new CanonicalType();
                }
                this.profile.setValue(value);
            }
            return this;
        }

        public List<CanonicalType> getSupportedProfile() {
            if (this.supportedProfile == null) {
                this.supportedProfile = new ArrayList<CanonicalType>();
            }
            return this.supportedProfile;
        }

        public CapabilityStatementRestResourceComponent setSupportedProfile(List<CanonicalType> theSupportedProfile) {
            this.supportedProfile = theSupportedProfile;
            return this;
        }

        public boolean hasSupportedProfile() {
            if (this.supportedProfile == null) {
                return false;
            }
            for (CanonicalType item : this.supportedProfile) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addSupportedProfileElement() {
            CanonicalType t = new CanonicalType();
            if (this.supportedProfile == null) {
                this.supportedProfile = new ArrayList<CanonicalType>();
            }
            this.supportedProfile.add(t);
            return t;
        }

        public CapabilityStatementRestResourceComponent addSupportedProfile(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.supportedProfile == null) {
                this.supportedProfile = new ArrayList<CanonicalType>();
            }
            this.supportedProfile.add(t);
            return this;
        }

        public boolean hasSupportedProfile(String value) {
            if (this.supportedProfile == null) {
                return false;
            }
            for (CanonicalType v : this.supportedProfile) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatementRestResourceComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public List<ResourceInteractionComponent> getInteraction() {
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            return this.interaction;
        }

        public CapabilityStatementRestResourceComponent setInteraction(List<ResourceInteractionComponent> theInteraction) {
            this.interaction = theInteraction;
            return this;
        }

        public boolean hasInteraction() {
            if (this.interaction == null) {
                return false;
            }
            for (ResourceInteractionComponent item : this.interaction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ResourceInteractionComponent addInteraction() {
            ResourceInteractionComponent t = new ResourceInteractionComponent();
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            this.interaction.add(t);
            return t;
        }

        public CapabilityStatementRestResourceComponent addInteraction(ResourceInteractionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.interaction == null) {
                this.interaction = new ArrayList<ResourceInteractionComponent>();
            }
            this.interaction.add(t);
            return this;
        }

        public ResourceInteractionComponent getInteractionFirstRep() {
            if (this.getInteraction().isEmpty()) {
                this.addInteraction();
            }
            return this.getInteraction().get(0);
        }

        public Enumeration<ResourceVersionPolicy> getVersioningElement() {
            if (this.versioning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.versioning");
                }
                if (Configuration.doAutoCreate()) {
                    this.versioning = new Enumeration<ResourceVersionPolicy>(new ResourceVersionPolicyEnumFactory());
                }
            }
            return this.versioning;
        }

        public boolean hasVersioningElement() {
            return this.versioning != null && !this.versioning.isEmpty();
        }

        public boolean hasVersioning() {
            return this.versioning != null && !this.versioning.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setVersioningElement(Enumeration<ResourceVersionPolicy> value) {
            this.versioning = value;
            return this;
        }

        public ResourceVersionPolicy getVersioning() {
            return this.versioning == null ? null : (ResourceVersionPolicy)((Object)this.versioning.getValue());
        }

        public CapabilityStatementRestResourceComponent setVersioning(ResourceVersionPolicy value) {
            if (value == null) {
                this.versioning = null;
            } else {
                if (this.versioning == null) {
                    this.versioning = new Enumeration<ResourceVersionPolicy>(new ResourceVersionPolicyEnumFactory());
                }
                this.versioning.setValue((Object)value);
            }
            return this;
        }

        public BooleanType getReadHistoryElement() {
            if (this.readHistory == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.readHistory");
                }
                if (Configuration.doAutoCreate()) {
                    this.readHistory = new BooleanType();
                }
            }
            return this.readHistory;
        }

        public boolean hasReadHistoryElement() {
            return this.readHistory != null && !this.readHistory.isEmpty();
        }

        public boolean hasReadHistory() {
            return this.readHistory != null && !this.readHistory.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setReadHistoryElement(BooleanType value) {
            this.readHistory = value;
            return this;
        }

        public boolean getReadHistory() {
            return this.readHistory == null || this.readHistory.isEmpty() ? false : (Boolean)this.readHistory.getValue();
        }

        public CapabilityStatementRestResourceComponent setReadHistory(boolean value) {
            if (this.readHistory == null) {
                this.readHistory = new BooleanType();
            }
            this.readHistory.setValue((Object)value);
            return this;
        }

        public BooleanType getUpdateCreateElement() {
            if (this.updateCreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.updateCreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.updateCreate = new BooleanType();
                }
            }
            return this.updateCreate;
        }

        public boolean hasUpdateCreateElement() {
            return this.updateCreate != null && !this.updateCreate.isEmpty();
        }

        public boolean hasUpdateCreate() {
            return this.updateCreate != null && !this.updateCreate.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setUpdateCreateElement(BooleanType value) {
            this.updateCreate = value;
            return this;
        }

        public boolean getUpdateCreate() {
            return this.updateCreate == null || this.updateCreate.isEmpty() ? false : (Boolean)this.updateCreate.getValue();
        }

        public CapabilityStatementRestResourceComponent setUpdateCreate(boolean value) {
            if (this.updateCreate == null) {
                this.updateCreate = new BooleanType();
            }
            this.updateCreate.setValue((Object)value);
            return this;
        }

        public BooleanType getConditionalCreateElement() {
            if (this.conditionalCreate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.conditionalCreate");
                }
                if (Configuration.doAutoCreate()) {
                    this.conditionalCreate = new BooleanType();
                }
            }
            return this.conditionalCreate;
        }

        public boolean hasConditionalCreateElement() {
            return this.conditionalCreate != null && !this.conditionalCreate.isEmpty();
        }

        public boolean hasConditionalCreate() {
            return this.conditionalCreate != null && !this.conditionalCreate.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setConditionalCreateElement(BooleanType value) {
            this.conditionalCreate = value;
            return this;
        }

        public boolean getConditionalCreate() {
            return this.conditionalCreate == null || this.conditionalCreate.isEmpty() ? false : (Boolean)this.conditionalCreate.getValue();
        }

        public CapabilityStatementRestResourceComponent setConditionalCreate(boolean value) {
            if (this.conditionalCreate == null) {
                this.conditionalCreate = new BooleanType();
            }
            this.conditionalCreate.setValue((Object)value);
            return this;
        }

        public Enumeration<ConditionalReadStatus> getConditionalReadElement() {
            if (this.conditionalRead == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.conditionalRead");
                }
                if (Configuration.doAutoCreate()) {
                    this.conditionalRead = new Enumeration<ConditionalReadStatus>(new ConditionalReadStatusEnumFactory());
                }
            }
            return this.conditionalRead;
        }

        public boolean hasConditionalReadElement() {
            return this.conditionalRead != null && !this.conditionalRead.isEmpty();
        }

        public boolean hasConditionalRead() {
            return this.conditionalRead != null && !this.conditionalRead.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setConditionalReadElement(Enumeration<ConditionalReadStatus> value) {
            this.conditionalRead = value;
            return this;
        }

        public ConditionalReadStatus getConditionalRead() {
            return this.conditionalRead == null ? null : (ConditionalReadStatus)((Object)this.conditionalRead.getValue());
        }

        public CapabilityStatementRestResourceComponent setConditionalRead(ConditionalReadStatus value) {
            if (value == null) {
                this.conditionalRead = null;
            } else {
                if (this.conditionalRead == null) {
                    this.conditionalRead = new Enumeration<ConditionalReadStatus>(new ConditionalReadStatusEnumFactory());
                }
                this.conditionalRead.setValue((Object)value);
            }
            return this;
        }

        public BooleanType getConditionalUpdateElement() {
            if (this.conditionalUpdate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.conditionalUpdate");
                }
                if (Configuration.doAutoCreate()) {
                    this.conditionalUpdate = new BooleanType();
                }
            }
            return this.conditionalUpdate;
        }

        public boolean hasConditionalUpdateElement() {
            return this.conditionalUpdate != null && !this.conditionalUpdate.isEmpty();
        }

        public boolean hasConditionalUpdate() {
            return this.conditionalUpdate != null && !this.conditionalUpdate.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setConditionalUpdateElement(BooleanType value) {
            this.conditionalUpdate = value;
            return this;
        }

        public boolean getConditionalUpdate() {
            return this.conditionalUpdate == null || this.conditionalUpdate.isEmpty() ? false : (Boolean)this.conditionalUpdate.getValue();
        }

        public CapabilityStatementRestResourceComponent setConditionalUpdate(boolean value) {
            if (this.conditionalUpdate == null) {
                this.conditionalUpdate = new BooleanType();
            }
            this.conditionalUpdate.setValue((Object)value);
            return this;
        }

        public Enumeration<ConditionalDeleteStatus> getConditionalDeleteElement() {
            if (this.conditionalDelete == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestResourceComponent.conditionalDelete");
                }
                if (Configuration.doAutoCreate()) {
                    this.conditionalDelete = new Enumeration<ConditionalDeleteStatus>(new ConditionalDeleteStatusEnumFactory());
                }
            }
            return this.conditionalDelete;
        }

        public boolean hasConditionalDeleteElement() {
            return this.conditionalDelete != null && !this.conditionalDelete.isEmpty();
        }

        public boolean hasConditionalDelete() {
            return this.conditionalDelete != null && !this.conditionalDelete.isEmpty();
        }

        public CapabilityStatementRestResourceComponent setConditionalDeleteElement(Enumeration<ConditionalDeleteStatus> value) {
            this.conditionalDelete = value;
            return this;
        }

        public ConditionalDeleteStatus getConditionalDelete() {
            return this.conditionalDelete == null ? null : (ConditionalDeleteStatus)((Object)this.conditionalDelete.getValue());
        }

        public CapabilityStatementRestResourceComponent setConditionalDelete(ConditionalDeleteStatus value) {
            if (value == null) {
                this.conditionalDelete = null;
            } else {
                if (this.conditionalDelete == null) {
                    this.conditionalDelete = new Enumeration<ConditionalDeleteStatus>(new ConditionalDeleteStatusEnumFactory());
                }
                this.conditionalDelete.setValue((Object)value);
            }
            return this;
        }

        public List<Enumeration<ReferenceHandlingPolicy>> getReferencePolicy() {
            if (this.referencePolicy == null) {
                this.referencePolicy = new ArrayList<Enumeration<ReferenceHandlingPolicy>>();
            }
            return this.referencePolicy;
        }

        public CapabilityStatementRestResourceComponent setReferencePolicy(List<Enumeration<ReferenceHandlingPolicy>> theReferencePolicy) {
            this.referencePolicy = theReferencePolicy;
            return this;
        }

        public boolean hasReferencePolicy() {
            if (this.referencePolicy == null) {
                return false;
            }
            for (Enumeration<ReferenceHandlingPolicy> item : this.referencePolicy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<ReferenceHandlingPolicy> addReferencePolicyElement() {
            Enumeration<ReferenceHandlingPolicy> t = new Enumeration<ReferenceHandlingPolicy>(new ReferenceHandlingPolicyEnumFactory());
            if (this.referencePolicy == null) {
                this.referencePolicy = new ArrayList<Enumeration<ReferenceHandlingPolicy>>();
            }
            this.referencePolicy.add(t);
            return t;
        }

        public CapabilityStatementRestResourceComponent addReferencePolicy(ReferenceHandlingPolicy value) {
            Enumeration<ReferenceHandlingPolicy> t = new Enumeration<ReferenceHandlingPolicy>(new ReferenceHandlingPolicyEnumFactory());
            t.setValue((Object)value);
            if (this.referencePolicy == null) {
                this.referencePolicy = new ArrayList<Enumeration<ReferenceHandlingPolicy>>();
            }
            this.referencePolicy.add(t);
            return this;
        }

        public boolean hasReferencePolicy(ReferenceHandlingPolicy value) {
            if (this.referencePolicy == null) {
                return false;
            }
            for (Enumeration<ReferenceHandlingPolicy> v : this.referencePolicy) {
                if (!((ReferenceHandlingPolicy)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getSearchInclude() {
            if (this.searchInclude == null) {
                this.searchInclude = new ArrayList<StringType>();
            }
            return this.searchInclude;
        }

        public CapabilityStatementRestResourceComponent setSearchInclude(List<StringType> theSearchInclude) {
            this.searchInclude = theSearchInclude;
            return this;
        }

        public boolean hasSearchInclude() {
            if (this.searchInclude == null) {
                return false;
            }
            for (StringType item : this.searchInclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addSearchIncludeElement() {
            StringType t = new StringType();
            if (this.searchInclude == null) {
                this.searchInclude = new ArrayList<StringType>();
            }
            this.searchInclude.add(t);
            return t;
        }

        public CapabilityStatementRestResourceComponent addSearchInclude(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.searchInclude == null) {
                this.searchInclude = new ArrayList<StringType>();
            }
            this.searchInclude.add(t);
            return this;
        }

        public boolean hasSearchInclude(String value) {
            if (this.searchInclude == null) {
                return false;
            }
            for (StringType v : this.searchInclude) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getSearchRevInclude() {
            if (this.searchRevInclude == null) {
                this.searchRevInclude = new ArrayList<StringType>();
            }
            return this.searchRevInclude;
        }

        public CapabilityStatementRestResourceComponent setSearchRevInclude(List<StringType> theSearchRevInclude) {
            this.searchRevInclude = theSearchRevInclude;
            return this;
        }

        public boolean hasSearchRevInclude() {
            if (this.searchRevInclude == null) {
                return false;
            }
            for (StringType item : this.searchRevInclude) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addSearchRevIncludeElement() {
            StringType t = new StringType();
            if (this.searchRevInclude == null) {
                this.searchRevInclude = new ArrayList<StringType>();
            }
            this.searchRevInclude.add(t);
            return t;
        }

        public CapabilityStatementRestResourceComponent addSearchRevInclude(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.searchRevInclude == null) {
                this.searchRevInclude = new ArrayList<StringType>();
            }
            this.searchRevInclude.add(t);
            return this;
        }

        public boolean hasSearchRevInclude(String value) {
            if (this.searchRevInclude == null) {
                return false;
            }
            for (StringType v : this.searchRevInclude) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<CapabilityStatementRestResourceSearchParamComponent> getSearchParam() {
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatementRestResourceSearchParamComponent>();
            }
            return this.searchParam;
        }

        public CapabilityStatementRestResourceComponent setSearchParam(List<CapabilityStatementRestResourceSearchParamComponent> theSearchParam) {
            this.searchParam = theSearchParam;
            return this;
        }

        public boolean hasSearchParam() {
            if (this.searchParam == null) {
                return false;
            }
            for (CapabilityStatementRestResourceSearchParamComponent item : this.searchParam) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatementRestResourceSearchParamComponent addSearchParam() {
            CapabilityStatementRestResourceSearchParamComponent t = new CapabilityStatementRestResourceSearchParamComponent();
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatementRestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return t;
        }

        public CapabilityStatementRestResourceComponent addSearchParam(CapabilityStatementRestResourceSearchParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatementRestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return this;
        }

        public CapabilityStatementRestResourceSearchParamComponent getSearchParamFirstRep() {
            if (this.getSearchParam().isEmpty()) {
                this.addSearchParam();
            }
            return this.getSearchParam().get(0);
        }

        public List<CapabilityStatementRestResourceOperationComponent> getOperation() {
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatementRestResourceOperationComponent>();
            }
            return this.operation;
        }

        public CapabilityStatementRestResourceComponent setOperation(List<CapabilityStatementRestResourceOperationComponent> theOperation) {
            this.operation = theOperation;
            return this;
        }

        public boolean hasOperation() {
            if (this.operation == null) {
                return false;
            }
            for (CapabilityStatementRestResourceOperationComponent item : this.operation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatementRestResourceOperationComponent addOperation() {
            CapabilityStatementRestResourceOperationComponent t = new CapabilityStatementRestResourceOperationComponent();
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatementRestResourceOperationComponent>();
            }
            this.operation.add(t);
            return t;
        }

        public CapabilityStatementRestResourceComponent addOperation(CapabilityStatementRestResourceOperationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatementRestResourceOperationComponent>();
            }
            this.operation.add(t);
            return this;
        }

        public CapabilityStatementRestResourceOperationComponent getOperationFirstRep() {
            if (this.getOperation().isEmpty()) {
                this.addOperation();
            }
            return this.getOperation().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "A type of resource exposed via the restful interface.", 0, 1, this.type));
            children.add(new Property("profile", "canonical(StructureDefinition)", "A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles](profiling.html#profile-uses).", 0, 1, this.profile));
            children.add(new Property("supportedProfile", "canonical(StructureDefinition)", "A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles](profiling.html#profile-uses).", 0, Integer.MAX_VALUE, this.supportedProfile));
            children.add(new Property("documentation", "markdown", "Additional information about the resource type used by the system.", 0, 1, this.documentation));
            children.add(new Property("interaction", "", "Identifies a restful operation supported by the solution.", 0, Integer.MAX_VALUE, this.interaction));
            children.add(new Property("versioning", "code", "This field is set to no-version to specify that the system does not support (server) or use (client) versioning for this resource type. If this has some other value, the server must at least correctly track and populate the versionId meta-property on resources. If the value is 'versioned-update', then the server supports all the versioning features, including using e-tags for version integrity in the API.", 0, 1, this.versioning));
            children.add(new Property("readHistory", "boolean", "A flag for whether the server is able to return past versions as part of the vRead operation.", 0, 1, this.readHistory));
            children.add(new Property("updateCreate", "boolean", "A flag to indicate that the server allows or needs to allow the client to create new identities on the server (that is, the client PUTs to a location where there is no existing resource). Allowing this operation means that the server allows the client to create new identities on the server.", 0, 1, this.updateCreate));
            children.add(new Property("conditionalCreate", "boolean", "A flag that indicates that the server supports conditional create.", 0, 1, this.conditionalCreate));
            children.add(new Property("conditionalRead", "code", "A code that indicates how the server supports conditional read.", 0, 1, this.conditionalRead));
            children.add(new Property("conditionalUpdate", "boolean", "A flag that indicates that the server supports conditional update.", 0, 1, this.conditionalUpdate));
            children.add(new Property("conditionalDelete", "code", "A code that indicates how the server supports conditional delete.", 0, 1, this.conditionalDelete));
            children.add(new Property("referencePolicy", "code", "A set of flags that defines how references are supported.", 0, Integer.MAX_VALUE, this.referencePolicy));
            children.add(new Property("searchInclude", "string", "A list of _include values supported by the server.", 0, Integer.MAX_VALUE, this.searchInclude));
            children.add(new Property("searchRevInclude", "string", "A list of _revinclude (reverse include) values supported by the server.", 0, Integer.MAX_VALUE, this.searchRevInclude));
            children.add(new Property("searchParam", "", "Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam));
            children.add(new Property("operation", "", "Definition of an operation or a named query together with its parameters and their meaning and type. Consult the definition of the operation for details about how to invoke the operation, and the parameters.", 0, Integer.MAX_VALUE, this.operation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "A type of resource exposed via the restful interface.", 0, 1, this.type);
                }
                case -309425751: {
                    return new Property("profile", "canonical(StructureDefinition)", "A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles](profiling.html#profile-uses).", 0, 1, this.profile);
                }
                case 1225477403: {
                    return new Property("supportedProfile", "canonical(StructureDefinition)", "A list of profiles that represent different use cases supported by the system. For a server, \"supported by the system\" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles](profiling.html#profile-uses).", 0, Integer.MAX_VALUE, this.supportedProfile);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Additional information about the resource type used by the system.", 0, 1, this.documentation);
                }
                case 1844104722: {
                    return new Property("interaction", "", "Identifies a restful operation supported by the solution.", 0, Integer.MAX_VALUE, this.interaction);
                }
                case -670487542: {
                    return new Property("versioning", "code", "This field is set to no-version to specify that the system does not support (server) or use (client) versioning for this resource type. If this has some other value, the server must at least correctly track and populate the versionId meta-property on resources. If the value is 'versioned-update', then the server supports all the versioning features, including using e-tags for version integrity in the API.", 0, 1, this.versioning);
                }
                case 187518494: {
                    return new Property("readHistory", "boolean", "A flag for whether the server is able to return past versions as part of the vRead operation.", 0, 1, this.readHistory);
                }
                case -1400550619: {
                    return new Property("updateCreate", "boolean", "A flag to indicate that the server allows or needs to allow the client to create new identities on the server (that is, the client PUTs to a location where there is no existing resource). Allowing this operation means that the server allows the client to create new identities on the server.", 0, 1, this.updateCreate);
                }
                case 6401826: {
                    return new Property("conditionalCreate", "boolean", "A flag that indicates that the server supports conditional create.", 0, 1, this.conditionalCreate);
                }
                case 822786364: {
                    return new Property("conditionalRead", "code", "A code that indicates how the server supports conditional read.", 0, 1, this.conditionalRead);
                }
                case 519849711: {
                    return new Property("conditionalUpdate", "boolean", "A flag that indicates that the server supports conditional update.", 0, 1, this.conditionalUpdate);
                }
                case 23237585: {
                    return new Property("conditionalDelete", "code", "A code that indicates how the server supports conditional delete.", 0, 1, this.conditionalDelete);
                }
                case 796257373: {
                    return new Property("referencePolicy", "code", "A set of flags that defines how references are supported.", 0, Integer.MAX_VALUE, this.referencePolicy);
                }
                case -1035904544: {
                    return new Property("searchInclude", "string", "A list of _include values supported by the server.", 0, Integer.MAX_VALUE, this.searchInclude);
                }
                case -2123884979: {
                    return new Property("searchRevInclude", "string", "A list of _revinclude (reverse include) values supported by the server.", 0, Integer.MAX_VALUE, this.searchRevInclude);
                }
                case -553645115: {
                    return new Property("searchParam", "", "Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam);
                }
                case 1662702951: {
                    return new Property("operation", "", "Definition of an operation or a named query together with its parameters and their meaning and type. Consult the definition of the operation for details about how to invoke the operation, and the parameters.", 0, Integer.MAX_VALUE, this.operation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
                case 1225477403: {
                    return this.supportedProfile == null ? new Base[]{} : this.supportedProfile.toArray(new Base[this.supportedProfile.size()]);
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 1844104722: {
                    return this.interaction == null ? new Base[]{} : this.interaction.toArray(new Base[this.interaction.size()]);
                }
                case -670487542: {
                    Base[] baseArray;
                    if (this.versioning == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.versioning;
                    }
                    return baseArray;
                }
                case 187518494: {
                    Base[] baseArray;
                    if (this.readHistory == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.readHistory;
                    }
                    return baseArray;
                }
                case -1400550619: {
                    Base[] baseArray;
                    if (this.updateCreate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.updateCreate;
                    }
                    return baseArray;
                }
                case 6401826: {
                    Base[] baseArray;
                    if (this.conditionalCreate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.conditionalCreate;
                    }
                    return baseArray;
                }
                case 822786364: {
                    Base[] baseArray;
                    if (this.conditionalRead == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.conditionalRead;
                    }
                    return baseArray;
                }
                case 519849711: {
                    Base[] baseArray;
                    if (this.conditionalUpdate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.conditionalUpdate;
                    }
                    return baseArray;
                }
                case 23237585: {
                    Base[] baseArray;
                    if (this.conditionalDelete == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.conditionalDelete;
                    }
                    return baseArray;
                }
                case 796257373: {
                    return this.referencePolicy == null ? new Base[]{} : this.referencePolicy.toArray(new Base[this.referencePolicy.size()]);
                }
                case -1035904544: {
                    return this.searchInclude == null ? new Base[]{} : this.searchInclude.toArray(new Base[this.searchInclude.size()]);
                }
                case -2123884979: {
                    return this.searchRevInclude == null ? new Base[]{} : this.searchRevInclude.toArray(new Base[this.searchRevInclude.size()]);
                }
                case -553645115: {
                    return this.searchParam == null ? new Base[]{} : this.searchParam.toArray(new Base[this.searchParam.size()]);
                }
                case 1662702951: {
                    return this.operation == null ? new Base[]{} : this.operation.toArray(new Base[this.operation.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCode(value);
                    return value;
                }
                case -309425751: {
                    this.profile = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case 1225477403: {
                    this.getSupportedProfile().add(TypeConvertor.castToCanonical(value));
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 1844104722: {
                    this.getInteraction().add((ResourceInteractionComponent)((Object)value));
                    return value;
                }
                case -670487542: {
                    value = new ResourceVersionPolicyEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.versioning = value;
                    return value;
                }
                case 187518494: {
                    this.readHistory = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1400550619: {
                    this.updateCreate = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 6401826: {
                    this.conditionalCreate = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 822786364: {
                    value = new ConditionalReadStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.conditionalRead = value;
                    return value;
                }
                case 519849711: {
                    this.conditionalUpdate = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 23237585: {
                    value = new ConditionalDeleteStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.conditionalDelete = value;
                    return value;
                }
                case 796257373: {
                    value = new ReferenceHandlingPolicyEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getReferencePolicy().add(value);
                    return value;
                }
                case -1035904544: {
                    this.getSearchInclude().add(TypeConvertor.castToString(value));
                    return value;
                }
                case -2123884979: {
                    this.getSearchRevInclude().add(TypeConvertor.castToString(value));
                    return value;
                }
                case -553645115: {
                    this.getSearchParam().add((CapabilityStatementRestResourceSearchParamComponent)((Object)value));
                    return value;
                }
                case 1662702951: {
                    this.getOperation().add((CapabilityStatementRestResourceOperationComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = TypeConvertor.castToCanonical(value);
            } else if (name.equals("supportedProfile")) {
                this.getSupportedProfile().add(TypeConvertor.castToCanonical(value));
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("interaction")) {
                this.getInteraction().add((ResourceInteractionComponent)((Object)value));
            } else if (name.equals("versioning")) {
                value = new ResourceVersionPolicyEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.versioning = value;
            } else if (name.equals("readHistory")) {
                this.readHistory = TypeConvertor.castToBoolean(value);
            } else if (name.equals("updateCreate")) {
                this.updateCreate = TypeConvertor.castToBoolean(value);
            } else if (name.equals("conditionalCreate")) {
                this.conditionalCreate = TypeConvertor.castToBoolean(value);
            } else if (name.equals("conditionalRead")) {
                value = new ConditionalReadStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.conditionalRead = value;
            } else if (name.equals("conditionalUpdate")) {
                this.conditionalUpdate = TypeConvertor.castToBoolean(value);
            } else if (name.equals("conditionalDelete")) {
                value = new ConditionalDeleteStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.conditionalDelete = value;
            } else if (name.equals("referencePolicy")) {
                value = new ReferenceHandlingPolicyEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getReferencePolicy().add(value);
            } else if (name.equals("searchInclude")) {
                this.getSearchInclude().add(TypeConvertor.castToString(value));
            } else if (name.equals("searchRevInclude")) {
                this.getSearchRevInclude().add(TypeConvertor.castToString(value));
            } else if (name.equals("searchParam")) {
                this.getSearchParam().add((CapabilityStatementRestResourceSearchParamComponent)((Object)value));
            } else if (name.equals("operation")) {
                this.getOperation().add((CapabilityStatementRestResourceOperationComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -309425751: {
                    return this.getProfileElement();
                }
                case 1225477403: {
                    return this.addSupportedProfileElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case 1844104722: {
                    return this.addInteraction();
                }
                case -670487542: {
                    return this.getVersioningElement();
                }
                case 187518494: {
                    return this.getReadHistoryElement();
                }
                case -1400550619: {
                    return this.getUpdateCreateElement();
                }
                case 6401826: {
                    return this.getConditionalCreateElement();
                }
                case 822786364: {
                    return this.getConditionalReadElement();
                }
                case 519849711: {
                    return this.getConditionalUpdateElement();
                }
                case 23237585: {
                    return this.getConditionalDeleteElement();
                }
                case 796257373: {
                    return this.addReferencePolicyElement();
                }
                case -1035904544: {
                    return this.addSearchIncludeElement();
                }
                case -2123884979: {
                    return this.addSearchRevIncludeElement();
                }
                case -553645115: {
                    return this.addSearchParam();
                }
                case 1662702951: {
                    return this.addOperation();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
                case 1225477403: {
                    return new String[]{"canonical"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
                case 1844104722: {
                    return new String[0];
                }
                case -670487542: {
                    return new String[]{"code"};
                }
                case 187518494: {
                    return new String[]{"boolean"};
                }
                case -1400550619: {
                    return new String[]{"boolean"};
                }
                case 6401826: {
                    return new String[]{"boolean"};
                }
                case 822786364: {
                    return new String[]{"code"};
                }
                case 519849711: {
                    return new String[]{"boolean"};
                }
                case 23237585: {
                    return new String[]{"code"};
                }
                case 796257373: {
                    return new String[]{"code"};
                }
                case -1035904544: {
                    return new String[]{"string"};
                }
                case -2123884979: {
                    return new String[]{"string"};
                }
                case -553645115: {
                    return new String[0];
                }
                case 1662702951: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.type");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.profile");
            }
            if (name.equals("supportedProfile")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.supportedProfile");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.documentation");
            }
            if (name.equals("interaction")) {
                return this.addInteraction();
            }
            if (name.equals("versioning")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.versioning");
            }
            if (name.equals("readHistory")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.readHistory");
            }
            if (name.equals("updateCreate")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.updateCreate");
            }
            if (name.equals("conditionalCreate")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.conditionalCreate");
            }
            if (name.equals("conditionalRead")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.conditionalRead");
            }
            if (name.equals("conditionalUpdate")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.conditionalUpdate");
            }
            if (name.equals("conditionalDelete")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.conditionalDelete");
            }
            if (name.equals("referencePolicy")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.referencePolicy");
            }
            if (name.equals("searchInclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.searchInclude");
            }
            if (name.equals("searchRevInclude")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.resource.searchRevInclude");
            }
            if (name.equals("searchParam")) {
                return this.addSearchParam();
            }
            if (name.equals("operation")) {
                return this.addOperation();
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementRestResourceComponent copy() {
            CapabilityStatementRestResourceComponent dst = new CapabilityStatementRestResourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementRestResourceComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            CanonicalType canonicalType = dst.profile = this.profile == null ? null : this.profile.copy();
            if (this.supportedProfile != null) {
                dst.supportedProfile = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType2 : this.supportedProfile) {
                    dst.supportedProfile.add(canonicalType2.copy());
                }
            }
            MarkdownType markdownType = dst.documentation = this.documentation == null ? null : this.documentation.copy();
            if (this.interaction != null) {
                dst.interaction = new ArrayList<ResourceInteractionComponent>();
                for (ResourceInteractionComponent resourceInteractionComponent : this.interaction) {
                    dst.interaction.add(resourceInteractionComponent.copy());
                }
            }
            dst.versioning = this.versioning == null ? null : this.versioning.copy();
            dst.readHistory = this.readHistory == null ? null : this.readHistory.copy();
            dst.updateCreate = this.updateCreate == null ? null : this.updateCreate.copy();
            dst.conditionalCreate = this.conditionalCreate == null ? null : this.conditionalCreate.copy();
            dst.conditionalRead = this.conditionalRead == null ? null : this.conditionalRead.copy();
            dst.conditionalUpdate = this.conditionalUpdate == null ? null : this.conditionalUpdate.copy();
            Enumeration<ConditionalDeleteStatus> enumeration = dst.conditionalDelete = this.conditionalDelete == null ? null : this.conditionalDelete.copy();
            if (this.referencePolicy != null) {
                dst.referencePolicy = new ArrayList<Enumeration<ReferenceHandlingPolicy>>();
                for (Enumeration enumeration2 : this.referencePolicy) {
                    dst.referencePolicy.add((Enumeration<ReferenceHandlingPolicy>)enumeration2.copy());
                }
            }
            if (this.searchInclude != null) {
                dst.searchInclude = new ArrayList<StringType>();
                for (StringType stringType : this.searchInclude) {
                    dst.searchInclude.add(stringType.copy());
                }
            }
            if (this.searchRevInclude != null) {
                dst.searchRevInclude = new ArrayList<StringType>();
                for (StringType stringType : this.searchRevInclude) {
                    dst.searchRevInclude.add(stringType.copy());
                }
            }
            if (this.searchParam != null) {
                dst.searchParam = new ArrayList<CapabilityStatementRestResourceSearchParamComponent>();
                for (CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : this.searchParam) {
                    dst.searchParam.add(capabilityStatementRestResourceSearchParamComponent.copy());
                }
            }
            if (this.operation != null) {
                dst.operation = new ArrayList<CapabilityStatementRestResourceOperationComponent>();
                for (CapabilityStatementRestResourceOperationComponent capabilityStatementRestResourceOperationComponent : this.operation) {
                    dst.operation.add(capabilityStatementRestResourceOperationComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestResourceComponent)) {
                return false;
            }
            CapabilityStatementRestResourceComponent o = (CapabilityStatementRestResourceComponent)other_;
            return CapabilityStatementRestResourceComponent.compareDeep(this.type, o.type, true) && CapabilityStatementRestResourceComponent.compareDeep(this.profile, o.profile, true) && CapabilityStatementRestResourceComponent.compareDeep(this.supportedProfile, o.supportedProfile, true) && CapabilityStatementRestResourceComponent.compareDeep(this.documentation, o.documentation, true) && CapabilityStatementRestResourceComponent.compareDeep(this.interaction, o.interaction, true) && CapabilityStatementRestResourceComponent.compareDeep(this.versioning, o.versioning, true) && CapabilityStatementRestResourceComponent.compareDeep(this.readHistory, o.readHistory, true) && CapabilityStatementRestResourceComponent.compareDeep(this.updateCreate, o.updateCreate, true) && CapabilityStatementRestResourceComponent.compareDeep(this.conditionalCreate, o.conditionalCreate, true) && CapabilityStatementRestResourceComponent.compareDeep(this.conditionalRead, o.conditionalRead, true) && CapabilityStatementRestResourceComponent.compareDeep(this.conditionalUpdate, o.conditionalUpdate, true) && CapabilityStatementRestResourceComponent.compareDeep(this.conditionalDelete, o.conditionalDelete, true) && CapabilityStatementRestResourceComponent.compareDeep(this.referencePolicy, o.referencePolicy, true) && CapabilityStatementRestResourceComponent.compareDeep(this.searchInclude, o.searchInclude, true) && CapabilityStatementRestResourceComponent.compareDeep(this.searchRevInclude, o.searchRevInclude, true) && CapabilityStatementRestResourceComponent.compareDeep(this.searchParam, o.searchParam, true) && CapabilityStatementRestResourceComponent.compareDeep(this.operation, o.operation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestResourceComponent)) {
                return false;
            }
            CapabilityStatementRestResourceComponent o = (CapabilityStatementRestResourceComponent)other_;
            return CapabilityStatementRestResourceComponent.compareValues(this.type, o.type, true) && CapabilityStatementRestResourceComponent.compareValues(this.profile, o.profile, true) && CapabilityStatementRestResourceComponent.compareValues(this.supportedProfile, o.supportedProfile, true) && CapabilityStatementRestResourceComponent.compareValues(this.documentation, o.documentation, true) && CapabilityStatementRestResourceComponent.compareValues(this.versioning, o.versioning, true) && CapabilityStatementRestResourceComponent.compareValues(this.readHistory, o.readHistory, true) && CapabilityStatementRestResourceComponent.compareValues(this.updateCreate, o.updateCreate, true) && CapabilityStatementRestResourceComponent.compareValues(this.conditionalCreate, o.conditionalCreate, true) && CapabilityStatementRestResourceComponent.compareValues(this.conditionalRead, o.conditionalRead, true) && CapabilityStatementRestResourceComponent.compareValues(this.conditionalUpdate, o.conditionalUpdate, true) && CapabilityStatementRestResourceComponent.compareValues(this.conditionalDelete, o.conditionalDelete, true) && CapabilityStatementRestResourceComponent.compareValues(this.referencePolicy, o.referencePolicy, true) && CapabilityStatementRestResourceComponent.compareValues(this.searchInclude, o.searchInclude, true) && CapabilityStatementRestResourceComponent.compareValues(this.searchRevInclude, o.searchRevInclude, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.profile, this.supportedProfile, this.documentation, this.interaction, this.versioning, this.readHistory, this.updateCreate, this.conditionalCreate, this.conditionalRead, this.conditionalUpdate, this.conditionalDelete, this.referencePolicy, this.searchInclude, this.searchRevInclude, this.searchParam, this.operation});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.rest.resource";
        }
    }

    @Block
    public static class CapabilityStatementRestSecurityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="cors", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adds CORS Headers (http://enable-cors.org/)", formalDefinition="Server adds CORS headers when responding to requests - this enables Javascript applications to use the server.")
        protected BooleanType cors;
        @Child(name="service", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="OAuth | SMART-on-FHIR | NTLM | Basic | Kerberos | Certificates", formalDefinition="Types of security services that are supported/required by the system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/restful-security-service")
        protected List<CodeableConcept> service;
        @Child(name="description", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General description of how security works", formalDefinition="General description of how security works.")
        protected MarkdownType description;
        private static final long serialVersionUID = -1348900500L;

        public BooleanType getCorsElement() {
            if (this.cors == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestSecurityComponent.cors");
                }
                if (Configuration.doAutoCreate()) {
                    this.cors = new BooleanType();
                }
            }
            return this.cors;
        }

        public boolean hasCorsElement() {
            return this.cors != null && !this.cors.isEmpty();
        }

        public boolean hasCors() {
            return this.cors != null && !this.cors.isEmpty();
        }

        public CapabilityStatementRestSecurityComponent setCorsElement(BooleanType value) {
            this.cors = value;
            return this;
        }

        public boolean getCors() {
            return this.cors == null || this.cors.isEmpty() ? false : (Boolean)this.cors.getValue();
        }

        public CapabilityStatementRestSecurityComponent setCors(boolean value) {
            if (this.cors == null) {
                this.cors = new BooleanType();
            }
            this.cors.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getService() {
            if (this.service == null) {
                this.service = new ArrayList<CodeableConcept>();
            }
            return this.service;
        }

        public CapabilityStatementRestSecurityComponent setService(List<CodeableConcept> theService) {
            this.service = theService;
            return this;
        }

        public boolean hasService() {
            if (this.service == null) {
                return false;
            }
            for (CodeableConcept item : this.service) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addService() {
            CodeableConcept t = new CodeableConcept();
            if (this.service == null) {
                this.service = new ArrayList<CodeableConcept>();
            }
            this.service.add(t);
            return t;
        }

        public CapabilityStatementRestSecurityComponent addService(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.service == null) {
                this.service = new ArrayList<CodeableConcept>();
            }
            this.service.add(t);
            return this;
        }

        public CodeableConcept getServiceFirstRep() {
            if (this.getService().isEmpty()) {
                this.addService();
            }
            return this.getService().get(0);
        }

        public MarkdownType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestSecurityComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new MarkdownType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CapabilityStatementRestSecurityComponent setDescriptionElement(MarkdownType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CapabilityStatementRestSecurityComponent setDescription(String value) {
            if (value == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new MarkdownType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("cors", "boolean", "Server adds CORS headers when responding to requests - this enables Javascript applications to use the server.", 0, 1, this.cors));
            children.add(new Property("service", "CodeableConcept", "Types of security services that are supported/required by the system.", 0, Integer.MAX_VALUE, this.service));
            children.add(new Property(CapabilityStatement.SP_DESCRIPTION, "markdown", "General description of how security works.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059629: {
                    return new Property("cors", "boolean", "Server adds CORS headers when responding to requests - this enables Javascript applications to use the server.", 0, 1, this.cors);
                }
                case 1984153269: {
                    return new Property("service", "CodeableConcept", "Types of security services that are supported/required by the system.", 0, Integer.MAX_VALUE, this.service);
                }
                case -1724546052: {
                    return new Property(CapabilityStatement.SP_DESCRIPTION, "markdown", "General description of how security works.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059629: {
                    Base[] baseArray;
                    if (this.cors == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.cors;
                    }
                    return baseArray;
                }
                case 1984153269: {
                    return this.service == null ? new Base[]{} : this.service.toArray(new Base[this.service.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059629: {
                    this.cors = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1984153269: {
                    this.getService().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("cors")) {
                this.cors = TypeConvertor.castToBoolean(value);
            } else if (name.equals("service")) {
                this.getService().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals(CapabilityStatement.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059629: {
                    return this.getCorsElement();
                }
                case 1984153269: {
                    return this.addService();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059629: {
                    return new String[]{"boolean"};
                }
                case 1984153269: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("cors")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.security.cors");
            }
            if (name.equals("service")) {
                return this.addService();
            }
            if (name.equals(CapabilityStatement.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.security.description");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementRestSecurityComponent copy() {
            CapabilityStatementRestSecurityComponent dst = new CapabilityStatementRestSecurityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementRestSecurityComponent dst) {
            super.copyValues(dst);
            BooleanType booleanType = dst.cors = this.cors == null ? null : this.cors.copy();
            if (this.service != null) {
                dst.service = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.service) {
                    dst.service.add(i.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestSecurityComponent)) {
                return false;
            }
            CapabilityStatementRestSecurityComponent o = (CapabilityStatementRestSecurityComponent)other_;
            return CapabilityStatementRestSecurityComponent.compareDeep(this.cors, o.cors, true) && CapabilityStatementRestSecurityComponent.compareDeep(this.service, o.service, true) && CapabilityStatementRestSecurityComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestSecurityComponent)) {
                return false;
            }
            CapabilityStatementRestSecurityComponent o = (CapabilityStatementRestSecurityComponent)other_;
            return CapabilityStatementRestSecurityComponent.compareValues(this.cors, o.cors, true) && CapabilityStatementRestSecurityComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.cors, this.service, this.description});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.rest.security";
        }
    }

    @Block
    public static class CapabilityStatementRestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="client | server", formalDefinition="Identifies whether this portion of the statement is describing the ability to initiate or receive restful operations.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/restful-capability-mode")
        protected Enumeration<RestfulCapabilityMode> mode;
        @Child(name="documentation", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="General description of implementation", formalDefinition="Information about the system's restful capabilities that apply across all applications, such as security.")
        protected MarkdownType documentation;
        @Child(name="security", type={}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Information about security of implementation", formalDefinition="Information about security implementation from an interface perspective - what a client needs to know.")
        protected CapabilityStatementRestSecurityComponent security;
        @Child(name="resource", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Resource served on the REST interface", formalDefinition="A specification of the restful capabilities of the solution for a specific resource type.")
        protected List<CapabilityStatementRestResourceComponent> resource;
        @Child(name="interaction", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="What operations are supported?", formalDefinition="A specification of restful operations supported by the system.")
        protected List<SystemInteractionComponent> interaction;
        @Child(name="searchParam", type={CapabilityStatementRestResourceSearchParamComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Search parameters for searching all resources", formalDefinition="Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.")
        protected List<CapabilityStatementRestResourceSearchParamComponent> searchParam;
        @Child(name="operation", type={CapabilityStatementRestResourceOperationComponent.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Definition of a system level operation", formalDefinition="Definition of an operation or a named query together with its parameters and their meaning and type.")
        protected List<CapabilityStatementRestResourceOperationComponent> operation;
        @Child(name="compartment", type={CanonicalType.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Compartments served/used by system", formalDefinition="An absolute URI which is a reference to the definition of a compartment that the system supports. The reference is to a CompartmentDefinition resource by its canonical URL .")
        protected List<CanonicalType> compartment;
        private static final long serialVersionUID = -1442029817L;

        public CapabilityStatementRestComponent() {
        }

        public CapabilityStatementRestComponent(RestfulCapabilityMode mode) {
            this.setMode(mode);
        }

        public Enumeration<RestfulCapabilityMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<RestfulCapabilityMode>(new RestfulCapabilityModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public CapabilityStatementRestComponent setModeElement(Enumeration<RestfulCapabilityMode> value) {
            this.mode = value;
            return this;
        }

        public RestfulCapabilityMode getMode() {
            return this.mode == null ? null : (RestfulCapabilityMode)((Object)this.mode.getValue());
        }

        public CapabilityStatementRestComponent setMode(RestfulCapabilityMode value) {
            if (this.mode == null) {
                this.mode = new Enumeration<RestfulCapabilityMode>(new RestfulCapabilityModeEnumFactory());
            }
            this.mode.setValue((Object)value);
            return this;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public CapabilityStatementRestComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public CapabilityStatementRestComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        public CapabilityStatementRestSecurityComponent getSecurity() {
            if (this.security == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementRestComponent.security");
                }
                if (Configuration.doAutoCreate()) {
                    this.security = new CapabilityStatementRestSecurityComponent();
                }
            }
            return this.security;
        }

        public boolean hasSecurity() {
            return this.security != null && !this.security.isEmpty();
        }

        public CapabilityStatementRestComponent setSecurity(CapabilityStatementRestSecurityComponent value) {
            this.security = value;
            return this;
        }

        public List<CapabilityStatementRestResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<CapabilityStatementRestResourceComponent>();
            }
            return this.resource;
        }

        public CapabilityStatementRestComponent setResource(List<CapabilityStatementRestResourceComponent> theResource) {
            this.resource = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (CapabilityStatementRestResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatementRestResourceComponent addResource() {
            CapabilityStatementRestResourceComponent t = new CapabilityStatementRestResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<CapabilityStatementRestResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public CapabilityStatementRestComponent addResource(CapabilityStatementRestResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<CapabilityStatementRestResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public CapabilityStatementRestResourceComponent getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                this.addResource();
            }
            return this.getResource().get(0);
        }

        public List<SystemInteractionComponent> getInteraction() {
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            return this.interaction;
        }

        public CapabilityStatementRestComponent setInteraction(List<SystemInteractionComponent> theInteraction) {
            this.interaction = theInteraction;
            return this;
        }

        public boolean hasInteraction() {
            if (this.interaction == null) {
                return false;
            }
            for (SystemInteractionComponent item : this.interaction) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SystemInteractionComponent addInteraction() {
            SystemInteractionComponent t = new SystemInteractionComponent();
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            this.interaction.add(t);
            return t;
        }

        public CapabilityStatementRestComponent addInteraction(SystemInteractionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.interaction == null) {
                this.interaction = new ArrayList<SystemInteractionComponent>();
            }
            this.interaction.add(t);
            return this;
        }

        public SystemInteractionComponent getInteractionFirstRep() {
            if (this.getInteraction().isEmpty()) {
                this.addInteraction();
            }
            return this.getInteraction().get(0);
        }

        public List<CapabilityStatementRestResourceSearchParamComponent> getSearchParam() {
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatementRestResourceSearchParamComponent>();
            }
            return this.searchParam;
        }

        public CapabilityStatementRestComponent setSearchParam(List<CapabilityStatementRestResourceSearchParamComponent> theSearchParam) {
            this.searchParam = theSearchParam;
            return this;
        }

        public boolean hasSearchParam() {
            if (this.searchParam == null) {
                return false;
            }
            for (CapabilityStatementRestResourceSearchParamComponent item : this.searchParam) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatementRestResourceSearchParamComponent addSearchParam() {
            CapabilityStatementRestResourceSearchParamComponent t = new CapabilityStatementRestResourceSearchParamComponent();
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatementRestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return t;
        }

        public CapabilityStatementRestComponent addSearchParam(CapabilityStatementRestResourceSearchParamComponent t) {
            if (t == null) {
                return this;
            }
            if (this.searchParam == null) {
                this.searchParam = new ArrayList<CapabilityStatementRestResourceSearchParamComponent>();
            }
            this.searchParam.add(t);
            return this;
        }

        public CapabilityStatementRestResourceSearchParamComponent getSearchParamFirstRep() {
            if (this.getSearchParam().isEmpty()) {
                this.addSearchParam();
            }
            return this.getSearchParam().get(0);
        }

        public List<CapabilityStatementRestResourceOperationComponent> getOperation() {
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatementRestResourceOperationComponent>();
            }
            return this.operation;
        }

        public CapabilityStatementRestComponent setOperation(List<CapabilityStatementRestResourceOperationComponent> theOperation) {
            this.operation = theOperation;
            return this;
        }

        public boolean hasOperation() {
            if (this.operation == null) {
                return false;
            }
            for (CapabilityStatementRestResourceOperationComponent item : this.operation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CapabilityStatementRestResourceOperationComponent addOperation() {
            CapabilityStatementRestResourceOperationComponent t = new CapabilityStatementRestResourceOperationComponent();
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatementRestResourceOperationComponent>();
            }
            this.operation.add(t);
            return t;
        }

        public CapabilityStatementRestComponent addOperation(CapabilityStatementRestResourceOperationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.operation == null) {
                this.operation = new ArrayList<CapabilityStatementRestResourceOperationComponent>();
            }
            this.operation.add(t);
            return this;
        }

        public CapabilityStatementRestResourceOperationComponent getOperationFirstRep() {
            if (this.getOperation().isEmpty()) {
                this.addOperation();
            }
            return this.getOperation().get(0);
        }

        public List<CanonicalType> getCompartment() {
            if (this.compartment == null) {
                this.compartment = new ArrayList<CanonicalType>();
            }
            return this.compartment;
        }

        public CapabilityStatementRestComponent setCompartment(List<CanonicalType> theCompartment) {
            this.compartment = theCompartment;
            return this;
        }

        public boolean hasCompartment() {
            if (this.compartment == null) {
                return false;
            }
            for (CanonicalType item : this.compartment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CanonicalType addCompartmentElement() {
            CanonicalType t = new CanonicalType();
            if (this.compartment == null) {
                this.compartment = new ArrayList<CanonicalType>();
            }
            this.compartment.add(t);
            return t;
        }

        public CapabilityStatementRestComponent addCompartment(String value) {
            CanonicalType t = new CanonicalType();
            t.setValue(value);
            if (this.compartment == null) {
                this.compartment = new ArrayList<CanonicalType>();
            }
            this.compartment.add(t);
            return this;
        }

        public boolean hasCompartment(String value) {
            if (this.compartment == null) {
                return false;
            }
            for (CanonicalType v : this.compartment) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement.SP_MODE, "code", "Identifies whether this portion of the statement is describing the ability to initiate or receive restful operations.", 0, 1, this.mode));
            children.add(new Property("documentation", "markdown", "Information about the system's restful capabilities that apply across all applications, such as security.", 0, 1, this.documentation));
            children.add(new Property("security", "", "Information about security implementation from an interface perspective - what a client needs to know.", 0, 1, this.security));
            children.add(new Property(CapabilityStatement.SP_RESOURCE, "", "A specification of the restful capabilities of the solution for a specific resource type.", 0, Integer.MAX_VALUE, this.resource));
            children.add(new Property("interaction", "", "A specification of restful operations supported by the system.", 0, Integer.MAX_VALUE, this.interaction));
            children.add(new Property("searchParam", "@CapabilityStatement.rest.resource.searchParam", "Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam));
            children.add(new Property("operation", "@CapabilityStatement.rest.resource.operation", "Definition of an operation or a named query together with its parameters and their meaning and type.", 0, Integer.MAX_VALUE, this.operation));
            children.add(new Property("compartment", "canonical(CompartmentDefinition)", "An absolute URI which is a reference to the definition of a compartment that the system supports. The reference is to a CompartmentDefinition resource by its canonical URL .", 0, Integer.MAX_VALUE, this.compartment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property(CapabilityStatement.SP_MODE, "code", "Identifies whether this portion of the statement is describing the ability to initiate or receive restful operations.", 0, 1, this.mode);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Information about the system's restful capabilities that apply across all applications, such as security.", 0, 1, this.documentation);
                }
                case 949122880: {
                    return new Property("security", "", "Information about security implementation from an interface perspective - what a client needs to know.", 0, 1, this.security);
                }
                case -341064690: {
                    return new Property(CapabilityStatement.SP_RESOURCE, "", "A specification of the restful capabilities of the solution for a specific resource type.", 0, Integer.MAX_VALUE, this.resource);
                }
                case 1844104722: {
                    return new Property("interaction", "", "A specification of restful operations supported by the system.", 0, Integer.MAX_VALUE, this.interaction);
                }
                case -553645115: {
                    return new Property("searchParam", "@CapabilityStatement.rest.resource.searchParam", "Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.", 0, Integer.MAX_VALUE, this.searchParam);
                }
                case 1662702951: {
                    return new Property("operation", "@CapabilityStatement.rest.resource.operation", "Definition of an operation or a named query together with its parameters and their meaning and type.", 0, Integer.MAX_VALUE, this.operation);
                }
                case -397756334: {
                    return new Property("compartment", "canonical(CompartmentDefinition)", "An absolute URI which is a reference to the definition of a compartment that the system supports. The reference is to a CompartmentDefinition resource by its canonical URL .", 0, Integer.MAX_VALUE, this.compartment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
                case 949122880: {
                    Base[] baseArray;
                    if (this.security == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.security;
                    }
                    return baseArray;
                }
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
                case 1844104722: {
                    return this.interaction == null ? new Base[]{} : this.interaction.toArray(new Base[this.interaction.size()]);
                }
                case -553645115: {
                    return this.searchParam == null ? new Base[]{} : this.searchParam.toArray(new Base[this.searchParam.size()]);
                }
                case 1662702951: {
                    return this.operation == null ? new Base[]{} : this.operation.toArray(new Base[this.operation.size()]);
                }
                case -397756334: {
                    return this.compartment == null ? new Base[]{} : this.compartment.toArray(new Base[this.compartment.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new RestfulCapabilityModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 1587405498: {
                    this.documentation = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 949122880: {
                    this.security = (CapabilityStatementRestSecurityComponent)((Object)value);
                    return value;
                }
                case -341064690: {
                    this.getResource().add((CapabilityStatementRestResourceComponent)((Object)value));
                    return value;
                }
                case 1844104722: {
                    this.getInteraction().add((SystemInteractionComponent)((Object)value));
                    return value;
                }
                case -553645115: {
                    this.getSearchParam().add((CapabilityStatementRestResourceSearchParamComponent)((Object)value));
                    return value;
                }
                case 1662702951: {
                    this.getOperation().add((CapabilityStatementRestResourceOperationComponent)((Object)value));
                    return value;
                }
                case -397756334: {
                    this.getCompartment().add(TypeConvertor.castToCanonical(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_MODE)) {
                value = new RestfulCapabilityModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("documentation")) {
                this.documentation = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("security")) {
                this.security = (CapabilityStatementRestSecurityComponent)((Object)value);
            } else if (name.equals(CapabilityStatement.SP_RESOURCE)) {
                this.getResource().add((CapabilityStatementRestResourceComponent)((Object)value));
            } else if (name.equals("interaction")) {
                this.getInteraction().add((SystemInteractionComponent)((Object)value));
            } else if (name.equals("searchParam")) {
                this.getSearchParam().add((CapabilityStatementRestResourceSearchParamComponent)((Object)value));
            } else if (name.equals("operation")) {
                this.getOperation().add((CapabilityStatementRestResourceOperationComponent)((Object)value));
            } else if (name.equals("compartment")) {
                this.getCompartment().add(TypeConvertor.castToCanonical(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
                case 949122880: {
                    return this.getSecurity();
                }
                case -341064690: {
                    return this.addResource();
                }
                case 1844104722: {
                    return this.addInteraction();
                }
                case -553645115: {
                    return this.addSearchParam();
                }
                case 1662702951: {
                    return this.addOperation();
                }
                case -397756334: {
                    return this.addCompartmentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
                case 949122880: {
                    return new String[0];
                }
                case -341064690: {
                    return new String[0];
                }
                case 1844104722: {
                    return new String[0];
                }
                case -553645115: {
                    return new String[]{"@CapabilityStatement.rest.resource.searchParam"};
                }
                case 1662702951: {
                    return new String[]{"@CapabilityStatement.rest.resource.operation"};
                }
                case -397756334: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_MODE)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.mode");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.documentation");
            }
            if (name.equals("security")) {
                this.security = new CapabilityStatementRestSecurityComponent();
                return this.security;
            }
            if (name.equals(CapabilityStatement.SP_RESOURCE)) {
                return this.addResource();
            }
            if (name.equals("interaction")) {
                return this.addInteraction();
            }
            if (name.equals("searchParam")) {
                return this.addSearchParam();
            }
            if (name.equals("operation")) {
                return this.addOperation();
            }
            if (name.equals("compartment")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.rest.compartment");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementRestComponent copy() {
            CapabilityStatementRestComponent dst = new CapabilityStatementRestComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementRestComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
            CapabilityStatementRestSecurityComponent capabilityStatementRestSecurityComponent = dst.security = this.security == null ? null : this.security.copy();
            if (this.resource != null) {
                dst.resource = new ArrayList<CapabilityStatementRestResourceComponent>();
                for (CapabilityStatementRestResourceComponent capabilityStatementRestResourceComponent : this.resource) {
                    dst.resource.add(capabilityStatementRestResourceComponent.copy());
                }
            }
            if (this.interaction != null) {
                dst.interaction = new ArrayList<SystemInteractionComponent>();
                for (SystemInteractionComponent systemInteractionComponent : this.interaction) {
                    dst.interaction.add(systemInteractionComponent.copy());
                }
            }
            if (this.searchParam != null) {
                dst.searchParam = new ArrayList<CapabilityStatementRestResourceSearchParamComponent>();
                for (CapabilityStatementRestResourceSearchParamComponent capabilityStatementRestResourceSearchParamComponent : this.searchParam) {
                    dst.searchParam.add(capabilityStatementRestResourceSearchParamComponent.copy());
                }
            }
            if (this.operation != null) {
                dst.operation = new ArrayList<CapabilityStatementRestResourceOperationComponent>();
                for (CapabilityStatementRestResourceOperationComponent capabilityStatementRestResourceOperationComponent : this.operation) {
                    dst.operation.add(capabilityStatementRestResourceOperationComponent.copy());
                }
            }
            if (this.compartment != null) {
                dst.compartment = new ArrayList<CanonicalType>();
                for (CanonicalType canonicalType : this.compartment) {
                    dst.compartment.add(canonicalType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestComponent)) {
                return false;
            }
            CapabilityStatementRestComponent o = (CapabilityStatementRestComponent)other_;
            return CapabilityStatementRestComponent.compareDeep(this.mode, o.mode, true) && CapabilityStatementRestComponent.compareDeep(this.documentation, o.documentation, true) && CapabilityStatementRestComponent.compareDeep(this.security, o.security, true) && CapabilityStatementRestComponent.compareDeep(this.resource, o.resource, true) && CapabilityStatementRestComponent.compareDeep(this.interaction, o.interaction, true) && CapabilityStatementRestComponent.compareDeep(this.searchParam, o.searchParam, true) && CapabilityStatementRestComponent.compareDeep(this.operation, o.operation, true) && CapabilityStatementRestComponent.compareDeep(this.compartment, o.compartment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementRestComponent)) {
                return false;
            }
            CapabilityStatementRestComponent o = (CapabilityStatementRestComponent)other_;
            return CapabilityStatementRestComponent.compareValues(this.mode, o.mode, true) && CapabilityStatementRestComponent.compareValues(this.documentation, o.documentation, true) && CapabilityStatementRestComponent.compareValues(this.compartment, o.compartment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mode, this.documentation, this.security, this.resource, this.interaction, this.searchParam, this.operation, this.compartment});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.rest";
        }
    }

    @Block
    public static class CapabilityStatementImplementationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Describes this specific instance", formalDefinition="Information about the specific installation that this capability statement relates to.")
        protected StringType description;
        @Child(name="url", type={UrlType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Base URL for the installation", formalDefinition="An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.")
        protected UrlType url;
        @Child(name="custodian", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Organization that manages the data", formalDefinition="The organization responsible for the management of the instance and oversight of the data on the server at the specified URL.")
        protected Reference custodian;
        private static final long serialVersionUID = 1681322786L;

        public CapabilityStatementImplementationComponent() {
        }

        public CapabilityStatementImplementationComponent(String description) {
            this.setDescription(description);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementImplementationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public CapabilityStatementImplementationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public CapabilityStatementImplementationComponent setDescription(String value) {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
            return this;
        }

        public UrlType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementImplementationComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UrlType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public CapabilityStatementImplementationComponent setUrlElement(UrlType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public CapabilityStatementImplementationComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UrlType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public Reference getCustodian() {
            if (this.custodian == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementImplementationComponent.custodian");
                }
                if (Configuration.doAutoCreate()) {
                    this.custodian = new Reference();
                }
            }
            return this.custodian;
        }

        public boolean hasCustodian() {
            return this.custodian != null && !this.custodian.isEmpty();
        }

        public CapabilityStatementImplementationComponent setCustodian(Reference value) {
            this.custodian = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement.SP_DESCRIPTION, "string", "Information about the specific installation that this capability statement relates to.", 0, 1, this.description));
            children.add(new Property(CapabilityStatement.SP_URL, CapabilityStatement.SP_URL, "An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.", 0, 1, this.url));
            children.add(new Property("custodian", "Reference(Organization)", "The organization responsible for the management of the instance and oversight of the data on the server at the specified URL.", 0, 1, this.custodian));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(CapabilityStatement.SP_DESCRIPTION, "string", "Information about the specific installation that this capability statement relates to.", 0, 1, this.description);
                }
                case 116079: {
                    return new Property(CapabilityStatement.SP_URL, CapabilityStatement.SP_URL, "An absolute base URL for the implementation.  This forms the base for REST interfaces as well as the mailbox and document interfaces.", 0, 1, this.url);
                }
                case 1611297262: {
                    return new Property("custodian", "Reference(Organization)", "The organization responsible for the management of the instance and oversight of the data on the server at the specified URL.", 0, 1, this.custodian);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 1611297262: {
                    Base[] baseArray;
                    if (this.custodian == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.custodian;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUrl(value);
                    return value;
                }
                case 1611297262: {
                    this.custodian = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals(CapabilityStatement.SP_URL)) {
                this.url = TypeConvertor.castToUrl(value);
            } else if (name.equals("custodian")) {
                this.custodian = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
                case 1611297262: {
                    return this.getCustodian();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 116079: {
                    return new String[]{CapabilityStatement.SP_URL};
                }
                case 1611297262: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.implementation.description");
            }
            if (name.equals(CapabilityStatement.SP_URL)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.implementation.url");
            }
            if (name.equals("custodian")) {
                this.custodian = new Reference();
                return this.custodian;
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementImplementationComponent copy() {
            CapabilityStatementImplementationComponent dst = new CapabilityStatementImplementationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementImplementationComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.custodian = this.custodian == null ? null : this.custodian.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementImplementationComponent)) {
                return false;
            }
            CapabilityStatementImplementationComponent o = (CapabilityStatementImplementationComponent)other_;
            return CapabilityStatementImplementationComponent.compareDeep(this.description, o.description, true) && CapabilityStatementImplementationComponent.compareDeep(this.url, o.url, true) && CapabilityStatementImplementationComponent.compareDeep(this.custodian, o.custodian, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementImplementationComponent)) {
                return false;
            }
            CapabilityStatementImplementationComponent o = (CapabilityStatementImplementationComponent)other_;
            return CapabilityStatementImplementationComponent.compareValues(this.description, o.description, true) && CapabilityStatementImplementationComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.url, this.custodian});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.implementation";
        }
    }

    @Block
    public static class CapabilityStatementSoftwareComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A name the software is known by", formalDefinition="Name the software is known by.")
        protected StringType name;
        @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version covered by this statement", formalDefinition="The version identifier for the software covered by this statement.")
        protected StringType version;
        @Child(name="releaseDate", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Date this version was released", formalDefinition="Date this version of the software was released.")
        protected DateTimeType releaseDate;
        private static final long serialVersionUID = 1819769027L;

        public CapabilityStatementSoftwareComponent() {
        }

        public CapabilityStatementSoftwareComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementSoftwareComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public CapabilityStatementSoftwareComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public CapabilityStatementSoftwareComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementSoftwareComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public CapabilityStatementSoftwareComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public CapabilityStatementSoftwareComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public DateTimeType getReleaseDateElement() {
            if (this.releaseDate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CapabilityStatementSoftwareComponent.releaseDate");
                }
                if (Configuration.doAutoCreate()) {
                    this.releaseDate = new DateTimeType();
                }
            }
            return this.releaseDate;
        }

        public boolean hasReleaseDateElement() {
            return this.releaseDate != null && !this.releaseDate.isEmpty();
        }

        public boolean hasReleaseDate() {
            return this.releaseDate != null && !this.releaseDate.isEmpty();
        }

        public CapabilityStatementSoftwareComponent setReleaseDateElement(DateTimeType value) {
            this.releaseDate = value;
            return this;
        }

        public Date getReleaseDate() {
            return this.releaseDate == null ? null : (Date)this.releaseDate.getValue();
        }

        public CapabilityStatementSoftwareComponent setReleaseDate(Date value) {
            if (value == null) {
                this.releaseDate = null;
            } else {
                if (this.releaseDate == null) {
                    this.releaseDate = new DateTimeType();
                }
                this.releaseDate.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(CapabilityStatement.SP_NAME, "string", "Name the software is known by.", 0, 1, this.name));
            children.add(new Property(CapabilityStatement.SP_VERSION, "string", "The version identifier for the software covered by this statement.", 0, 1, this.version));
            children.add(new Property("releaseDate", "dateTime", "Date this version of the software was released.", 0, 1, this.releaseDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(CapabilityStatement.SP_NAME, "string", "Name the software is known by.", 0, 1, this.name);
                }
                case 351608024: {
                    return new Property(CapabilityStatement.SP_VERSION, "string", "The version identifier for the software covered by this statement.", 0, 1, this.version);
                }
                case 212873301: {
                    return new Property("releaseDate", "dateTime", "Date this version of the software was released.", 0, 1, this.releaseDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 351608024: {
                    Base[] baseArray;
                    if (this.version == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.version;
                    }
                    return baseArray;
                }
                case 212873301: {
                    Base[] baseArray;
                    if (this.releaseDate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.releaseDate;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 351608024: {
                    this.version = TypeConvertor.castToString(value);
                    return value;
                }
                case 212873301: {
                    this.releaseDate = TypeConvertor.castToDateTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_NAME)) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(CapabilityStatement.SP_VERSION)) {
                this.version = TypeConvertor.castToString(value);
            } else if (name.equals("releaseDate")) {
                this.releaseDate = TypeConvertor.castToDateTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 351608024: {
                    return this.getVersionElement();
                }
                case 212873301: {
                    return this.getReleaseDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 351608024: {
                    return new String[]{"string"};
                }
                case 212873301: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(CapabilityStatement.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.software.name");
            }
            if (name.equals(CapabilityStatement.SP_VERSION)) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.software.version");
            }
            if (name.equals("releaseDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type CapabilityStatement.software.releaseDate");
            }
            return super.addChild(name);
        }

        @Override
        public CapabilityStatementSoftwareComponent copy() {
            CapabilityStatementSoftwareComponent dst = new CapabilityStatementSoftwareComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CapabilityStatementSoftwareComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.releaseDate = this.releaseDate == null ? null : this.releaseDate.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementSoftwareComponent)) {
                return false;
            }
            CapabilityStatementSoftwareComponent o = (CapabilityStatementSoftwareComponent)other_;
            return CapabilityStatementSoftwareComponent.compareDeep(this.name, o.name, true) && CapabilityStatementSoftwareComponent.compareDeep(this.version, o.version, true) && CapabilityStatementSoftwareComponent.compareDeep(this.releaseDate, o.releaseDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CapabilityStatementSoftwareComponent)) {
                return false;
            }
            CapabilityStatementSoftwareComponent o = (CapabilityStatementSoftwareComponent)other_;
            return CapabilityStatementSoftwareComponent.compareValues(this.name, o.name, true) && CapabilityStatementSoftwareComponent.compareValues(this.version, o.version, true) && CapabilityStatementSoftwareComponent.compareValues(this.releaseDate, o.releaseDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.version, this.releaseDate});
        }

        @Override
        public String fhirType() {
            return "CapabilityStatement.software";
        }
    }

    public static class TypeRestfulInteractionEnumFactory
    implements EnumFactory<TypeRestfulInteraction> {
        @Override
        public TypeRestfulInteraction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("read".equals(codeString)) {
                return TypeRestfulInteraction.READ;
            }
            if ("vread".equals(codeString)) {
                return TypeRestfulInteraction.VREAD;
            }
            if ("update".equals(codeString)) {
                return TypeRestfulInteraction.UPDATE;
            }
            if ("patch".equals(codeString)) {
                return TypeRestfulInteraction.PATCH;
            }
            if ("delete".equals(codeString)) {
                return TypeRestfulInteraction.DELETE;
            }
            if ("history-instance".equals(codeString)) {
                return TypeRestfulInteraction.HISTORYINSTANCE;
            }
            if ("history-type".equals(codeString)) {
                return TypeRestfulInteraction.HISTORYTYPE;
            }
            if ("create".equals(codeString)) {
                return TypeRestfulInteraction.CREATE;
            }
            if ("search-type".equals(codeString)) {
                return TypeRestfulInteraction.SEARCHTYPE;
            }
            throw new IllegalArgumentException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        public Enumeration<TypeRestfulInteraction> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TypeRestfulInteraction>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("read".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.READ);
            }
            if ("vread".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.VREAD);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.UPDATE);
            }
            if ("patch".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.PATCH);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.DELETE);
            }
            if ("history-instance".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.HISTORYINSTANCE);
            }
            if ("history-type".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.HISTORYTYPE);
            }
            if ("create".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.CREATE);
            }
            if ("search-type".equals(codeString)) {
                return new Enumeration<TypeRestfulInteraction>(this, TypeRestfulInteraction.SEARCHTYPE);
            }
            throw new FHIRException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        @Override
        public String toCode(TypeRestfulInteraction code) {
            if (code == TypeRestfulInteraction.READ) {
                return "read";
            }
            if (code == TypeRestfulInteraction.VREAD) {
                return "vread";
            }
            if (code == TypeRestfulInteraction.UPDATE) {
                return "update";
            }
            if (code == TypeRestfulInteraction.PATCH) {
                return "patch";
            }
            if (code == TypeRestfulInteraction.DELETE) {
                return "delete";
            }
            if (code == TypeRestfulInteraction.HISTORYINSTANCE) {
                return "history-instance";
            }
            if (code == TypeRestfulInteraction.HISTORYTYPE) {
                return "history-type";
            }
            if (code == TypeRestfulInteraction.CREATE) {
                return "create";
            }
            if (code == TypeRestfulInteraction.SEARCHTYPE) {
                return "search-type";
            }
            return "?";
        }

        @Override
        public String toSystem(TypeRestfulInteraction code) {
            return code.getSystem();
        }
    }

    public static enum TypeRestfulInteraction {
        READ,
        VREAD,
        UPDATE,
        PATCH,
        DELETE,
        HISTORYINSTANCE,
        HISTORYTYPE,
        CREATE,
        SEARCHTYPE,
        NULL;


        public static TypeRestfulInteraction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("read".equals(codeString)) {
                return READ;
            }
            if ("vread".equals(codeString)) {
                return VREAD;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("patch".equals(codeString)) {
                return PATCH;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if ("history-instance".equals(codeString)) {
                return HISTORYINSTANCE;
            }
            if ("history-type".equals(codeString)) {
                return HISTORYTYPE;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("search-type".equals(codeString)) {
                return SEARCHTYPE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TypeRestfulInteraction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case READ: {
                    return "read";
                }
                case VREAD: {
                    return "vread";
                }
                case UPDATE: {
                    return "update";
                }
                case PATCH: {
                    return "patch";
                }
                case DELETE: {
                    return "delete";
                }
                case HISTORYINSTANCE: {
                    return "history-instance";
                }
                case HISTORYTYPE: {
                    return "history-type";
                }
                case CREATE: {
                    return "create";
                }
                case SEARCHTYPE: {
                    return "search-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case READ: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case VREAD: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case PATCH: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYINSTANCE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYTYPE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case CREATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case SEARCHTYPE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case READ: {
                    return "Read the current state of the resource.";
                }
                case VREAD: {
                    return "Read the state of a specific version of the resource.";
                }
                case UPDATE: {
                    return "Update an existing resource by its id (or create it if it is new).";
                }
                case PATCH: {
                    return "Update an existing resource by posting a set of changes to it.";
                }
                case DELETE: {
                    return "Delete a resource.";
                }
                case HISTORYINSTANCE: {
                    return "Retrieve the change history for a particular resource.";
                }
                case HISTORYTYPE: {
                    return "Retrieve the change history for all resources of a particular type.";
                }
                case CREATE: {
                    return "Create a new resource with a server assigned id.";
                }
                case SEARCHTYPE: {
                    return "Search all resources of the specified type based on some filter criteria.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case READ: {
                    return "read";
                }
                case VREAD: {
                    return "vread";
                }
                case UPDATE: {
                    return "update";
                }
                case PATCH: {
                    return "patch";
                }
                case DELETE: {
                    return "delete";
                }
                case HISTORYINSTANCE: {
                    return "history-instance";
                }
                case HISTORYTYPE: {
                    return "history-type";
                }
                case CREATE: {
                    return "create";
                }
                case SEARCHTYPE: {
                    return "search-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class SystemRestfulInteractionEnumFactory
    implements EnumFactory<SystemRestfulInteraction> {
        @Override
        public SystemRestfulInteraction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return SystemRestfulInteraction.TRANSACTION;
            }
            if ("batch".equals(codeString)) {
                return SystemRestfulInteraction.BATCH;
            }
            if ("search-system".equals(codeString)) {
                return SystemRestfulInteraction.SEARCHSYSTEM;
            }
            if ("history-system".equals(codeString)) {
                return SystemRestfulInteraction.HISTORYSYSTEM;
            }
            throw new IllegalArgumentException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        public Enumeration<SystemRestfulInteraction> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SystemRestfulInteraction>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.TRANSACTION);
            }
            if ("batch".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.BATCH);
            }
            if ("search-system".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.SEARCHSYSTEM);
            }
            if ("history-system".equals(codeString)) {
                return new Enumeration<SystemRestfulInteraction>(this, SystemRestfulInteraction.HISTORYSYSTEM);
            }
            throw new FHIRException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        @Override
        public String toCode(SystemRestfulInteraction code) {
            if (code == SystemRestfulInteraction.TRANSACTION) {
                return "transaction";
            }
            if (code == SystemRestfulInteraction.BATCH) {
                return "batch";
            }
            if (code == SystemRestfulInteraction.SEARCHSYSTEM) {
                return "search-system";
            }
            if (code == SystemRestfulInteraction.HISTORYSYSTEM) {
                return "history-system";
            }
            return "?";
        }

        @Override
        public String toSystem(SystemRestfulInteraction code) {
            return code.getSystem();
        }
    }

    public static enum SystemRestfulInteraction {
        TRANSACTION,
        BATCH,
        SEARCHSYSTEM,
        HISTORYSYSTEM,
        NULL;


        public static SystemRestfulInteraction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("transaction".equals(codeString)) {
                return TRANSACTION;
            }
            if ("batch".equals(codeString)) {
                return BATCH;
            }
            if ("search-system".equals(codeString)) {
                return SEARCHSYSTEM;
            }
            if ("history-system".equals(codeString)) {
                return HISTORYSYSTEM;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SystemRestfulInteraction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case TRANSACTION: {
                    return "transaction";
                }
                case BATCH: {
                    return "batch";
                }
                case SEARCHSYSTEM: {
                    return "search-system";
                }
                case HISTORYSYSTEM: {
                    return "history-system";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case TRANSACTION: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case BATCH: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case SEARCHSYSTEM: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case HISTORYSYSTEM: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case TRANSACTION: {
                    return "Update, create or delete a set of resources as a single transaction.";
                }
                case BATCH: {
                    return "perform a set of a separate interactions in a single http operation";
                }
                case SEARCHSYSTEM: {
                    return "Search all resources based on some filter criteria.";
                }
                case HISTORYSYSTEM: {
                    return "Retrieve the change history for all resources on a system.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case TRANSACTION: {
                    return "transaction";
                }
                case BATCH: {
                    return "batch";
                }
                case SEARCHSYSTEM: {
                    return "search-system";
                }
                case HISTORYSYSTEM: {
                    return "history-system";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class RestfulCapabilityModeEnumFactory
    implements EnumFactory<RestfulCapabilityMode> {
        @Override
        public RestfulCapabilityMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("client".equals(codeString)) {
                return RestfulCapabilityMode.CLIENT;
            }
            if ("server".equals(codeString)) {
                return RestfulCapabilityMode.SERVER;
            }
            throw new IllegalArgumentException("Unknown RestfulCapabilityMode code '" + codeString + "'");
        }

        public Enumeration<RestfulCapabilityMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RestfulCapabilityMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("client".equals(codeString)) {
                return new Enumeration<RestfulCapabilityMode>(this, RestfulCapabilityMode.CLIENT);
            }
            if ("server".equals(codeString)) {
                return new Enumeration<RestfulCapabilityMode>(this, RestfulCapabilityMode.SERVER);
            }
            throw new FHIRException("Unknown RestfulCapabilityMode code '" + codeString + "'");
        }

        @Override
        public String toCode(RestfulCapabilityMode code) {
            if (code == RestfulCapabilityMode.CLIENT) {
                return "client";
            }
            if (code == RestfulCapabilityMode.SERVER) {
                return "server";
            }
            return "?";
        }

        @Override
        public String toSystem(RestfulCapabilityMode code) {
            return code.getSystem();
        }
    }

    public static enum RestfulCapabilityMode {
        CLIENT,
        SERVER,
        NULL;


        public static RestfulCapabilityMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("client".equals(codeString)) {
                return CLIENT;
            }
            if ("server".equals(codeString)) {
                return SERVER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RestfulCapabilityMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CLIENT: {
                    return "client";
                }
                case SERVER: {
                    return "server";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CLIENT: {
                    return "http://hl7.org/fhir/restful-capability-mode";
                }
                case SERVER: {
                    return "http://hl7.org/fhir/restful-capability-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CLIENT: {
                    return "The application acts as a client for this resource.";
                }
                case SERVER: {
                    return "The application acts as a server for this resource.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CLIENT: {
                    return "Client";
                }
                case SERVER: {
                    return "Server";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ResourceVersionPolicyEnumFactory
    implements EnumFactory<ResourceVersionPolicy> {
        @Override
        public ResourceVersionPolicy fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("no-version".equals(codeString)) {
                return ResourceVersionPolicy.NOVERSION;
            }
            if ("versioned".equals(codeString)) {
                return ResourceVersionPolicy.VERSIONED;
            }
            if ("versioned-update".equals(codeString)) {
                return ResourceVersionPolicy.VERSIONEDUPDATE;
            }
            throw new IllegalArgumentException("Unknown ResourceVersionPolicy code '" + codeString + "'");
        }

        public Enumeration<ResourceVersionPolicy> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ResourceVersionPolicy>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("no-version".equals(codeString)) {
                return new Enumeration<ResourceVersionPolicy>(this, ResourceVersionPolicy.NOVERSION);
            }
            if ("versioned".equals(codeString)) {
                return new Enumeration<ResourceVersionPolicy>(this, ResourceVersionPolicy.VERSIONED);
            }
            if ("versioned-update".equals(codeString)) {
                return new Enumeration<ResourceVersionPolicy>(this, ResourceVersionPolicy.VERSIONEDUPDATE);
            }
            throw new FHIRException("Unknown ResourceVersionPolicy code '" + codeString + "'");
        }

        @Override
        public String toCode(ResourceVersionPolicy code) {
            if (code == ResourceVersionPolicy.NOVERSION) {
                return "no-version";
            }
            if (code == ResourceVersionPolicy.VERSIONED) {
                return "versioned";
            }
            if (code == ResourceVersionPolicy.VERSIONEDUPDATE) {
                return "versioned-update";
            }
            return "?";
        }

        @Override
        public String toSystem(ResourceVersionPolicy code) {
            return code.getSystem();
        }
    }

    public static enum ResourceVersionPolicy {
        NOVERSION,
        VERSIONED,
        VERSIONEDUPDATE,
        NULL;


        public static ResourceVersionPolicy fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("no-version".equals(codeString)) {
                return NOVERSION;
            }
            if ("versioned".equals(codeString)) {
                return VERSIONED;
            }
            if ("versioned-update".equals(codeString)) {
                return VERSIONEDUPDATE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ResourceVersionPolicy code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOVERSION: {
                    return "no-version";
                }
                case VERSIONED: {
                    return "versioned";
                }
                case VERSIONEDUPDATE: {
                    return "versioned-update";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOVERSION: {
                    return "http://hl7.org/fhir/versioning-policy";
                }
                case VERSIONED: {
                    return "http://hl7.org/fhir/versioning-policy";
                }
                case VERSIONEDUPDATE: {
                    return "http://hl7.org/fhir/versioning-policy";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOVERSION: {
                    return "VersionId meta-property is not supported (server) or used (client).";
                }
                case VERSIONED: {
                    return "VersionId meta-property is supported (server) or used (client).";
                }
                case VERSIONEDUPDATE: {
                    return "VersionId must be correct for updates (server) or will be specified (If-match header) for updates (client).";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOVERSION: {
                    return "No VersionId Support";
                }
                case VERSIONED: {
                    return "Versioned";
                }
                case VERSIONEDUPDATE: {
                    return "VersionId tracked fully";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ReferenceHandlingPolicyEnumFactory
    implements EnumFactory<ReferenceHandlingPolicy> {
        @Override
        public ReferenceHandlingPolicy fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("literal".equals(codeString)) {
                return ReferenceHandlingPolicy.LITERAL;
            }
            if ("logical".equals(codeString)) {
                return ReferenceHandlingPolicy.LOGICAL;
            }
            if ("resolves".equals(codeString)) {
                return ReferenceHandlingPolicy.RESOLVES;
            }
            if ("enforced".equals(codeString)) {
                return ReferenceHandlingPolicy.ENFORCED;
            }
            if ("local".equals(codeString)) {
                return ReferenceHandlingPolicy.LOCAL;
            }
            throw new IllegalArgumentException("Unknown ReferenceHandlingPolicy code '" + codeString + "'");
        }

        public Enumeration<ReferenceHandlingPolicy> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ReferenceHandlingPolicy>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("literal".equals(codeString)) {
                return new Enumeration<ReferenceHandlingPolicy>(this, ReferenceHandlingPolicy.LITERAL);
            }
            if ("logical".equals(codeString)) {
                return new Enumeration<ReferenceHandlingPolicy>(this, ReferenceHandlingPolicy.LOGICAL);
            }
            if ("resolves".equals(codeString)) {
                return new Enumeration<ReferenceHandlingPolicy>(this, ReferenceHandlingPolicy.RESOLVES);
            }
            if ("enforced".equals(codeString)) {
                return new Enumeration<ReferenceHandlingPolicy>(this, ReferenceHandlingPolicy.ENFORCED);
            }
            if ("local".equals(codeString)) {
                return new Enumeration<ReferenceHandlingPolicy>(this, ReferenceHandlingPolicy.LOCAL);
            }
            throw new FHIRException("Unknown ReferenceHandlingPolicy code '" + codeString + "'");
        }

        @Override
        public String toCode(ReferenceHandlingPolicy code) {
            if (code == ReferenceHandlingPolicy.LITERAL) {
                return "literal";
            }
            if (code == ReferenceHandlingPolicy.LOGICAL) {
                return "logical";
            }
            if (code == ReferenceHandlingPolicy.RESOLVES) {
                return "resolves";
            }
            if (code == ReferenceHandlingPolicy.ENFORCED) {
                return "enforced";
            }
            if (code == ReferenceHandlingPolicy.LOCAL) {
                return "local";
            }
            return "?";
        }

        @Override
        public String toSystem(ReferenceHandlingPolicy code) {
            return code.getSystem();
        }
    }

    public static enum ReferenceHandlingPolicy {
        LITERAL,
        LOGICAL,
        RESOLVES,
        ENFORCED,
        LOCAL,
        NULL;


        public static ReferenceHandlingPolicy fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("literal".equals(codeString)) {
                return LITERAL;
            }
            if ("logical".equals(codeString)) {
                return LOGICAL;
            }
            if ("resolves".equals(codeString)) {
                return RESOLVES;
            }
            if ("enforced".equals(codeString)) {
                return ENFORCED;
            }
            if ("local".equals(codeString)) {
                return LOCAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ReferenceHandlingPolicy code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case LITERAL: {
                    return "literal";
                }
                case LOGICAL: {
                    return "logical";
                }
                case RESOLVES: {
                    return "resolves";
                }
                case ENFORCED: {
                    return "enforced";
                }
                case LOCAL: {
                    return "local";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case LITERAL: {
                    return "http://hl7.org/fhir/reference-handling-policy";
                }
                case LOGICAL: {
                    return "http://hl7.org/fhir/reference-handling-policy";
                }
                case RESOLVES: {
                    return "http://hl7.org/fhir/reference-handling-policy";
                }
                case ENFORCED: {
                    return "http://hl7.org/fhir/reference-handling-policy";
                }
                case LOCAL: {
                    return "http://hl7.org/fhir/reference-handling-policy";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case LITERAL: {
                    return "The server supports and populates Literal references (i.e. using Reference.reference) where they are known (this code does not guarantee that all references are literal; see 'enforced').";
                }
                case LOGICAL: {
                    return "The server allows logical references (i.e. using Reference.identifier).";
                }
                case RESOLVES: {
                    return "The server will attempt to resolve logical references to literal references - i.e. converting Reference.identifier to Reference.reference (if resolution fails, the server may still accept resources; see logical).";
                }
                case ENFORCED: {
                    return "The server enforces that references have integrity - e.g. it ensures that references can always be resolved. This is typically the case for clinical record systems, but often not the case for middleware/proxy systems.";
                }
                case LOCAL: {
                    return "The server does not support references that point to other servers.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case LITERAL: {
                    return "Literal References";
                }
                case LOGICAL: {
                    return "Logical References";
                }
                case RESOLVES: {
                    return "Resolves References";
                }
                case ENFORCED: {
                    return "Reference Integrity Enforced";
                }
                case LOCAL: {
                    return "Local References Only";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class EventCapabilityModeEnumFactory
    implements EnumFactory<EventCapabilityMode> {
        @Override
        public EventCapabilityMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("sender".equals(codeString)) {
                return EventCapabilityMode.SENDER;
            }
            if ("receiver".equals(codeString)) {
                return EventCapabilityMode.RECEIVER;
            }
            throw new IllegalArgumentException("Unknown EventCapabilityMode code '" + codeString + "'");
        }

        public Enumeration<EventCapabilityMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EventCapabilityMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sender".equals(codeString)) {
                return new Enumeration<EventCapabilityMode>(this, EventCapabilityMode.SENDER);
            }
            if ("receiver".equals(codeString)) {
                return new Enumeration<EventCapabilityMode>(this, EventCapabilityMode.RECEIVER);
            }
            throw new FHIRException("Unknown EventCapabilityMode code '" + codeString + "'");
        }

        @Override
        public String toCode(EventCapabilityMode code) {
            if (code == EventCapabilityMode.SENDER) {
                return "sender";
            }
            if (code == EventCapabilityMode.RECEIVER) {
                return "receiver";
            }
            return "?";
        }

        @Override
        public String toSystem(EventCapabilityMode code) {
            return code.getSystem();
        }
    }

    public static enum EventCapabilityMode {
        SENDER,
        RECEIVER,
        NULL;


        public static EventCapabilityMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("sender".equals(codeString)) {
                return SENDER;
            }
            if ("receiver".equals(codeString)) {
                return RECEIVER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EventCapabilityMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SENDER: {
                    return "sender";
                }
                case RECEIVER: {
                    return "receiver";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SENDER: {
                    return "http://hl7.org/fhir/event-capability-mode";
                }
                case RECEIVER: {
                    return "http://hl7.org/fhir/event-capability-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SENDER: {
                    return "The application sends requests and receives responses.";
                }
                case RECEIVER: {
                    return "The application receives requests and sends responses.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SENDER: {
                    return "Sender";
                }
                case RECEIVER: {
                    return "Receiver";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class DocumentModeEnumFactory
    implements EnumFactory<DocumentMode> {
        @Override
        public DocumentMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("producer".equals(codeString)) {
                return DocumentMode.PRODUCER;
            }
            if ("consumer".equals(codeString)) {
                return DocumentMode.CONSUMER;
            }
            throw new IllegalArgumentException("Unknown DocumentMode code '" + codeString + "'");
        }

        public Enumeration<DocumentMode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DocumentMode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("producer".equals(codeString)) {
                return new Enumeration<DocumentMode>(this, DocumentMode.PRODUCER);
            }
            if ("consumer".equals(codeString)) {
                return new Enumeration<DocumentMode>(this, DocumentMode.CONSUMER);
            }
            throw new FHIRException("Unknown DocumentMode code '" + codeString + "'");
        }

        @Override
        public String toCode(DocumentMode code) {
            if (code == DocumentMode.PRODUCER) {
                return "producer";
            }
            if (code == DocumentMode.CONSUMER) {
                return "consumer";
            }
            return "?";
        }

        @Override
        public String toSystem(DocumentMode code) {
            return code.getSystem();
        }
    }

    public static enum DocumentMode {
        PRODUCER,
        CONSUMER,
        NULL;


        public static DocumentMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("producer".equals(codeString)) {
                return PRODUCER;
            }
            if ("consumer".equals(codeString)) {
                return CONSUMER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DocumentMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PRODUCER: {
                    return "producer";
                }
                case CONSUMER: {
                    return "consumer";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PRODUCER: {
                    return "http://hl7.org/fhir/document-mode";
                }
                case CONSUMER: {
                    return "http://hl7.org/fhir/document-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PRODUCER: {
                    return "The application produces documents of the specified type.";
                }
                case CONSUMER: {
                    return "The application consumes documents of the specified type.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PRODUCER: {
                    return "Producer";
                }
                case CONSUMER: {
                    return "Consumer";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConditionalReadStatusEnumFactory
    implements EnumFactory<ConditionalReadStatus> {
        @Override
        public ConditionalReadStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return ConditionalReadStatus.NOTSUPPORTED;
            }
            if ("modified-since".equals(codeString)) {
                return ConditionalReadStatus.MODIFIEDSINCE;
            }
            if ("not-match".equals(codeString)) {
                return ConditionalReadStatus.NOTMATCH;
            }
            if ("full-support".equals(codeString)) {
                return ConditionalReadStatus.FULLSUPPORT;
            }
            throw new IllegalArgumentException("Unknown ConditionalReadStatus code '" + codeString + "'");
        }

        public Enumeration<ConditionalReadStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConditionalReadStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return new Enumeration<ConditionalReadStatus>(this, ConditionalReadStatus.NOTSUPPORTED);
            }
            if ("modified-since".equals(codeString)) {
                return new Enumeration<ConditionalReadStatus>(this, ConditionalReadStatus.MODIFIEDSINCE);
            }
            if ("not-match".equals(codeString)) {
                return new Enumeration<ConditionalReadStatus>(this, ConditionalReadStatus.NOTMATCH);
            }
            if ("full-support".equals(codeString)) {
                return new Enumeration<ConditionalReadStatus>(this, ConditionalReadStatus.FULLSUPPORT);
            }
            throw new FHIRException("Unknown ConditionalReadStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionalReadStatus code) {
            if (code == ConditionalReadStatus.NOTSUPPORTED) {
                return "not-supported";
            }
            if (code == ConditionalReadStatus.MODIFIEDSINCE) {
                return "modified-since";
            }
            if (code == ConditionalReadStatus.NOTMATCH) {
                return "not-match";
            }
            if (code == ConditionalReadStatus.FULLSUPPORT) {
                return "full-support";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionalReadStatus code) {
            return code.getSystem();
        }
    }

    public static enum ConditionalReadStatus {
        NOTSUPPORTED,
        MODIFIEDSINCE,
        NOTMATCH,
        FULLSUPPORT,
        NULL;


        public static ConditionalReadStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return NOTSUPPORTED;
            }
            if ("modified-since".equals(codeString)) {
                return MODIFIEDSINCE;
            }
            if ("not-match".equals(codeString)) {
                return NOTMATCH;
            }
            if ("full-support".equals(codeString)) {
                return FULLSUPPORT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConditionalReadStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "not-supported";
                }
                case MODIFIEDSINCE: {
                    return "modified-since";
                }
                case NOTMATCH: {
                    return "not-match";
                }
                case FULLSUPPORT: {
                    return "full-support";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "http://hl7.org/fhir/conditional-read-status";
                }
                case MODIFIEDSINCE: {
                    return "http://hl7.org/fhir/conditional-read-status";
                }
                case NOTMATCH: {
                    return "http://hl7.org/fhir/conditional-read-status";
                }
                case FULLSUPPORT: {
                    return "http://hl7.org/fhir/conditional-read-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "No support for conditional reads.";
                }
                case MODIFIEDSINCE: {
                    return "Conditional reads are supported, but only with the If-Modified-Since HTTP Header.";
                }
                case NOTMATCH: {
                    return "Conditional reads are supported, but only with the If-None-Match HTTP Header.";
                }
                case FULLSUPPORT: {
                    return "Conditional reads are supported, with both If-Modified-Since and If-None-Match HTTP Headers.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "Not Supported";
                }
                case MODIFIEDSINCE: {
                    return "If-Modified-Since";
                }
                case NOTMATCH: {
                    return "If-None-Match";
                }
                case FULLSUPPORT: {
                    return "Full Support";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ConditionalDeleteStatusEnumFactory
    implements EnumFactory<ConditionalDeleteStatus> {
        @Override
        public ConditionalDeleteStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return ConditionalDeleteStatus.NOTSUPPORTED;
            }
            if ("single".equals(codeString)) {
                return ConditionalDeleteStatus.SINGLE;
            }
            if ("multiple".equals(codeString)) {
                return ConditionalDeleteStatus.MULTIPLE;
            }
            throw new IllegalArgumentException("Unknown ConditionalDeleteStatus code '" + codeString + "'");
        }

        public Enumeration<ConditionalDeleteStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConditionalDeleteStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return new Enumeration<ConditionalDeleteStatus>(this, ConditionalDeleteStatus.NOTSUPPORTED);
            }
            if ("single".equals(codeString)) {
                return new Enumeration<ConditionalDeleteStatus>(this, ConditionalDeleteStatus.SINGLE);
            }
            if ("multiple".equals(codeString)) {
                return new Enumeration<ConditionalDeleteStatus>(this, ConditionalDeleteStatus.MULTIPLE);
            }
            throw new FHIRException("Unknown ConditionalDeleteStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ConditionalDeleteStatus code) {
            if (code == ConditionalDeleteStatus.NOTSUPPORTED) {
                return "not-supported";
            }
            if (code == ConditionalDeleteStatus.SINGLE) {
                return "single";
            }
            if (code == ConditionalDeleteStatus.MULTIPLE) {
                return "multiple";
            }
            return "?";
        }

        @Override
        public String toSystem(ConditionalDeleteStatus code) {
            return code.getSystem();
        }
    }

    public static enum ConditionalDeleteStatus {
        NOTSUPPORTED,
        SINGLE,
        MULTIPLE,
        NULL;


        public static ConditionalDeleteStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("not-supported".equals(codeString)) {
                return NOTSUPPORTED;
            }
            if ("single".equals(codeString)) {
                return SINGLE;
            }
            if ("multiple".equals(codeString)) {
                return MULTIPLE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConditionalDeleteStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "not-supported";
                }
                case SINGLE: {
                    return "single";
                }
                case MULTIPLE: {
                    return "multiple";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "http://hl7.org/fhir/conditional-delete-status";
                }
                case SINGLE: {
                    return "http://hl7.org/fhir/conditional-delete-status";
                }
                case MULTIPLE: {
                    return "http://hl7.org/fhir/conditional-delete-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "No support for conditional deletes.";
                }
                case SINGLE: {
                    return "Conditional deletes are supported, but only single resources at a time.";
                }
                case MULTIPLE: {
                    return "Conditional deletes are supported, and multiple resources can be deleted in a single interaction.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NOTSUPPORTED: {
                    return "Not Supported";
                }
                case SINGLE: {
                    return "Single Deletes Supported";
                }
                case MULTIPLE: {
                    return "Multiple Deletes Supported";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

