/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4b.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.BooleanType;
import org.hl7.fhir.r4b.model.CodeableConcept;
import org.hl7.fhir.r4b.model.ContactDetail;
import org.hl7.fhir.r4b.model.DateTimeType;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Enumeration;
import org.hl7.fhir.r4b.model.Enumerations;
import org.hl7.fhir.r4b.model.Identifier;
import org.hl7.fhir.r4b.model.MarkdownType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.StringType;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.UsageContext;

public abstract class CanonicalResource
extends DomainResource {
    private static final long serialVersionUID = 0L;

    public CanonicalResource() {
    }

    public CanonicalResource(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    public int getUrlMax() {
        return 1;
    }

    public abstract UriType getUrlElement();

    public abstract boolean hasUrlElement();

    public abstract boolean hasUrl();

    public abstract CanonicalResource setUrlElement(UriType var1);

    public abstract String getUrl();

    public abstract CanonicalResource setUrl(String var1);

    public int getIdentifierMax() {
        return Integer.MAX_VALUE;
    }

    public abstract List<Identifier> getIdentifier();

    public abstract CanonicalResource setIdentifier(List<Identifier> var1);

    public abstract boolean hasIdentifier();

    public abstract Identifier addIdentifier();

    public abstract CanonicalResource addIdentifier(Identifier var1);

    public abstract Identifier getIdentifierFirstRep();

    public int getVersionMax() {
        return 1;
    }

    public abstract StringType getVersionElement();

    public abstract boolean hasVersionElement();

    public abstract boolean hasVersion();

    public abstract CanonicalResource setVersionElement(StringType var1);

    public abstract String getVersion();

    public abstract CanonicalResource setVersion(String var1);

    public int getNameMax() {
        return 1;
    }

    public abstract StringType getNameElement();

    public abstract boolean hasNameElement();

    public abstract boolean hasName();

    public abstract CanonicalResource setNameElement(StringType var1);

    public abstract String getName();

    public abstract CanonicalResource setName(String var1);

    public int getTitleMax() {
        return 1;
    }

    public abstract StringType getTitleElement();

    public abstract boolean hasTitleElement();

    public abstract boolean hasTitle();

    public abstract CanonicalResource setTitleElement(StringType var1);

    public abstract String getTitle();

    public abstract CanonicalResource setTitle(String var1);

    public int getStatusMax() {
        return 1;
    }

    public abstract Enumeration<Enumerations.PublicationStatus> getStatusElement();

    public abstract boolean hasStatusElement();

    public abstract boolean hasStatus();

    public abstract CanonicalResource setStatusElement(Enumeration<Enumerations.PublicationStatus> var1);

    public abstract Enumerations.PublicationStatus getStatus();

    public abstract CanonicalResource setStatus(Enumerations.PublicationStatus var1);

    public int getExperimentalMax() {
        return 1;
    }

    public abstract BooleanType getExperimentalElement();

    public abstract boolean hasExperimentalElement();

    public abstract boolean hasExperimental();

    public abstract CanonicalResource setExperimentalElement(BooleanType var1);

    public abstract boolean getExperimental();

    public abstract CanonicalResource setExperimental(boolean var1);

    public int getDateMax() {
        return 1;
    }

    public abstract DateTimeType getDateElement();

    public abstract boolean hasDateElement();

    public abstract boolean hasDate();

    public abstract CanonicalResource setDateElement(DateTimeType var1);

    public abstract Date getDate();

    public abstract CanonicalResource setDate(Date var1);

    public int getPublisherMax() {
        return 1;
    }

    public abstract StringType getPublisherElement();

    public abstract boolean hasPublisherElement();

    public abstract boolean hasPublisher();

    public abstract CanonicalResource setPublisherElement(StringType var1);

    public abstract String getPublisher();

    public abstract CanonicalResource setPublisher(String var1);

    public int getContactMax() {
        return Integer.MAX_VALUE;
    }

    public abstract List<ContactDetail> getContact();

    public abstract CanonicalResource setContact(List<ContactDetail> var1);

    public abstract boolean hasContact();

    public abstract ContactDetail addContact();

    public abstract CanonicalResource addContact(ContactDetail var1);

    public abstract ContactDetail getContactFirstRep();

    public int getDescriptionMax() {
        return 1;
    }

    public abstract MarkdownType getDescriptionElement();

    public abstract boolean hasDescriptionElement();

    public abstract boolean hasDescription();

    public abstract CanonicalResource setDescriptionElement(MarkdownType var1);

    public abstract String getDescription();

    public abstract CanonicalResource setDescription(String var1);

    public int getUseContextMax() {
        return Integer.MAX_VALUE;
    }

    public abstract List<UsageContext> getUseContext();

    public abstract CanonicalResource setUseContext(List<UsageContext> var1);

    public abstract boolean hasUseContext();

    public abstract UsageContext addUseContext();

    public abstract CanonicalResource addUseContext(UsageContext var1);

    public abstract UsageContext getUseContextFirstRep();

    public int getJurisdictionMax() {
        return Integer.MAX_VALUE;
    }

    public abstract List<CodeableConcept> getJurisdiction();

    public abstract CanonicalResource setJurisdiction(List<CodeableConcept> var1);

    public abstract boolean hasJurisdiction();

    public abstract CodeableConcept addJurisdiction();

    public abstract CanonicalResource addJurisdiction(CodeableConcept var1);

    public abstract CodeableConcept getJurisdictionFirstRep();

    public int getPurposeMax() {
        return 1;
    }

    public abstract MarkdownType getPurposeElement();

    public abstract boolean hasPurposeElement();

    public abstract boolean hasPurpose();

    public abstract CanonicalResource setPurposeElement(MarkdownType var1);

    public abstract String getPurpose();

    public abstract CanonicalResource setPurpose(String var1);

    public int getCopyrightMax() {
        return 1;
    }

    public abstract MarkdownType getCopyrightElement();

    public abstract boolean hasCopyrightElement();

    public abstract boolean hasCopyright();

    public abstract CanonicalResource setCopyrightElement(MarkdownType var1);

    public abstract String getCopyright();

    public abstract CanonicalResource setCopyright(String var1);

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            default: 
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            default: 
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            default: 
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        return super.setProperty(name, value);
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            default: 
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            default: 
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CanonicalResource";
    }

    @Override
    public abstract CanonicalResource copy();

    public void copyValues(CanonicalResource dst) {
        super.copyValues(dst);
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CanonicalResource)) {
            return false;
        }
        CanonicalResource o = (CanonicalResource)other_;
        return true;
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CanonicalResource)) {
            return false;
        }
        CanonicalResource o = (CanonicalResource)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[0]);
    }

    public String toString() {
        return this.fhirType() + "[" + this.getUrl() + "]";
    }

    public String present() {
        if (this.hasTitle()) {
            return this.getTitle();
        }
        if (this.hasName()) {
            return this.getName();
        }
        return this.toString();
    }

    public String getVUrl() {
        return this.getUrl() + (this.hasVersion() ? "|" + this.getVersion() : "");
    }

    public boolean supportsCopyright() {
        return true;
    }

    public String getVersionedUrl() {
        return this.hasVersion() ? this.getUrl() + "|" + this.getVersion() : this.getUrl();
    }
}

