/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VerificationresultNeed {
    NONE,
    INITIAL,
    PERIODIC,
    NULL;


    public static VerificationresultNeed fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("none".equals(codeString)) {
            return NONE;
        }
        if ("initial".equals(codeString)) {
            return INITIAL;
        }
        if ("periodic".equals(codeString)) {
            return PERIODIC;
        }
        throw new FHIRException("Unknown VerificationresultNeed code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NONE: {
                return "none";
            }
            case INITIAL: {
                return "initial";
            }
            case PERIODIC: {
                return "periodic";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/need";
    }

    public String getDefinition() {
        switch (this) {
            case NONE: {
                return "***TODO***";
            }
            case INITIAL: {
                return "***TODO***";
            }
            case PERIODIC: {
                return "***TODO***";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NONE: {
                return "None";
            }
            case INITIAL: {
                return "Initial";
            }
            case PERIODIC: {
                return "Periodic";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

