/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventActuality {
    ACTUAL,
    POTENTIAL,
    NULL;


    public static AdverseEventActuality fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("actual".equals(codeString)) {
            return ACTUAL;
        }
        if ("potential".equals(codeString)) {
            return POTENTIAL;
        }
        throw new FHIRException("Unknown AdverseEventActuality code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTUAL: {
                return "actual";
            }
            case POTENTIAL: {
                return "potential";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-actuality";
    }

    public String getDefinition() {
        switch (this) {
            case ACTUAL: {
                return "The adverse event actually happened regardless of whether anyone was affected or harmed.";
            }
            case POTENTIAL: {
                return "A potential adverse event.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTUAL: {
                return "Adverse Event";
            }
            case POTENTIAL: {
                return "Potential Adverse Event";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

