/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;

@ResourceDef(name="SupplyRequest", profile="http://hl7.org/fhir/StructureDefinition/SupplyRequest")
public class SupplyRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for SupplyRequest", formalDefinition="Business identifiers assigned to this SupplyRequest by the author and/or other systems. These identifiers remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | suspended +", formalDefinition="Status of the supply request.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-status")
    protected Enumeration<SupplyRequestStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The kind of supply (central, non-stock, etc.)", formalDefinition="Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-kind")
    protected CodeableConcept category;
    @Child(name="priority", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly this SupplyRequest should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<RequestPriority> priority;
    @Child(name="item", type={CodeableConcept.class, Medication.class, Substance.class, Device.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Medication, Substance, or Device requested to be supplied", formalDefinition="The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supply-item")
    protected Type item;
    @Child(name="quantity", type={Quantity.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The requested amount of the item indicated", formalDefinition="The amount that is being ordered of the indicated item.")
    protected Quantity quantity;
    @Child(name="parameter", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Ordered item details", formalDefinition="Specific parameters for the ordered item.  For example, the size of the indicated item.")
    protected List<SupplyRequestParameterComponent> parameter;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the request should be fulfilled", formalDefinition="When the request should be fulfilled.")
    protected Type occurrence;
    @Child(name="authoredOn", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the request was made", formalDefinition="When the request was made.")
    protected DateTimeType authoredOn;
    @Child(name="requester", type={Practitioner.class, PractitionerRole.class, Organization.class, Patient.class, RelatedPerson.class, Device.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual making the request", formalDefinition="The device, practitioner, etc. who initiated the request.")
    protected Reference requester;
    protected Resource requesterTarget;
    @Child(name="supplier", type={Organization.class, HealthcareService.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is intended to fulfill the request", formalDefinition="Who is intended to fulfill the request.")
    protected List<Reference> supplier;
    protected List<Resource> supplierTarget;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The reason why the supply item was requested", formalDefinition="The reason why the supply item was requested.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/supplyrequest-reason")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class, DiagnosticReport.class, DocumentReference.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The reason why the supply item was requested", formalDefinition="The reason why the supply item was requested.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="deliverFrom", type={Organization.class, Location.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The origin of the supply", formalDefinition="Where the supply is expected to come from.")
    protected Reference deliverFrom;
    protected Resource deliverFromTarget;
    @Child(name="deliverTo", type={Organization.class, Location.class, Patient.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The destination of the supply", formalDefinition="Where the supply is destined to go.")
    protected Reference deliverTo;
    protected Resource deliverToTarget;
    private static final long serialVersionUID = 1456312151L;
    @SearchParamDefinition(name="requester", path="SupplyRequest.requester", description="Individual making the request", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("SupplyRequest:requester").toLocked();
    @SearchParamDefinition(name="date", path="SupplyRequest.authoredOn", description="When the request was made", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="SupplyRequest.identifier", description="Business Identifier for SupplyRequest", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="SupplyRequest.deliverTo", description="The destination of the supply", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Location.class, Organization.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("SupplyRequest:subject").toLocked();
    @SearchParamDefinition(name="supplier", path="SupplyRequest.supplier", description="Who is intended to fulfill the request", type="reference", target={HealthcareService.class, Organization.class})
    public static final String SP_SUPPLIER = "supplier";
    public static final ReferenceClientParam SUPPLIER = new ReferenceClientParam("supplier");
    public static final Include INCLUDE_SUPPLIER = new Include("SupplyRequest:supplier").toLocked();
    @SearchParamDefinition(name="category", path="SupplyRequest.category", description="The kind of supply (central, non-stock, etc.)", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="SupplyRequest.status", description="draft | active | suspended +", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public SupplyRequest() {
    }

    public SupplyRequest(Type item, Quantity quantity) {
        this.item = item;
        this.quantity = quantity;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public SupplyRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public SupplyRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<SupplyRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<SupplyRequestStatus>(new SupplyRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SupplyRequest setStatusElement(Enumeration<SupplyRequestStatus> value) {
        this.status = value;
        return this;
    }

    public SupplyRequestStatus getStatus() {
        return this.status == null ? null : (SupplyRequestStatus)((Object)this.status.getValue());
    }

    public SupplyRequest setStatus(SupplyRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<SupplyRequestStatus>(new SupplyRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public SupplyRequest setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public Enumeration<RequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<RequestPriority>(new RequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public SupplyRequest setPriorityElement(Enumeration<RequestPriority> value) {
        this.priority = value;
        return this;
    }

    public RequestPriority getPriority() {
        return this.priority == null ? null : (RequestPriority)((Object)this.priority.getValue());
    }

    public SupplyRequest setPriority(RequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<RequestPriority>(new RequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public Type getItem() {
        return this.item;
    }

    public CodeableConcept getItemCodeableConcept() throws FHIRException {
        if (this.item == null) {
            this.item = new CodeableConcept();
        }
        if (!(this.item instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.item.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.item;
    }

    public boolean hasItemCodeableConcept() {
        return this != null && this.item instanceof CodeableConcept;
    }

    public Reference getItemReference() throws FHIRException {
        if (this.item == null) {
            this.item = new Reference();
        }
        if (!(this.item instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.item.getClass().getName() + " was encountered");
        }
        return (Reference)this.item;
    }

    public boolean hasItemReference() {
        return this != null && this.item instanceof Reference;
    }

    public boolean hasItem() {
        return this.item != null && !this.item.isEmpty();
    }

    public SupplyRequest setItem(Type value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for SupplyRequest.item[x]: " + value.fhirType());
        }
        this.item = value;
        return this;
    }

    public Quantity getQuantity() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new Quantity();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public SupplyRequest setQuantity(Quantity value) {
        this.quantity = value;
        return this;
    }

    public List<SupplyRequestParameterComponent> getParameter() {
        if (this.parameter == null) {
            this.parameter = new ArrayList<SupplyRequestParameterComponent>();
        }
        return this.parameter;
    }

    public SupplyRequest setParameter(List<SupplyRequestParameterComponent> theParameter) {
        this.parameter = theParameter;
        return this;
    }

    public boolean hasParameter() {
        if (this.parameter == null) {
            return false;
        }
        for (SupplyRequestParameterComponent item : this.parameter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SupplyRequestParameterComponent addParameter() {
        SupplyRequestParameterComponent t = new SupplyRequestParameterComponent();
        if (this.parameter == null) {
            this.parameter = new ArrayList<SupplyRequestParameterComponent>();
        }
        this.parameter.add(t);
        return t;
    }

    public SupplyRequest addParameter(SupplyRequestParameterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.parameter == null) {
            this.parameter = new ArrayList<SupplyRequestParameterComponent>();
        }
        this.parameter.add(t);
        return this;
    }

    public SupplyRequestParameterComponent getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            this.addParameter();
        }
        return this.getParameter().get(0);
    }

    public Type getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new DateTimeType();
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Period();
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            this.occurrence = new Timing();
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public SupplyRequest setOccurrence(Type value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new Error("Not the right type for SupplyRequest.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public SupplyRequest setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public SupplyRequest setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public Reference getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new Reference();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public SupplyRequest setRequester(Reference value) {
        this.requester = value;
        return this;
    }

    public Resource getRequesterTarget() {
        return this.requesterTarget;
    }

    public SupplyRequest setRequesterTarget(Resource value) {
        this.requesterTarget = value;
        return this;
    }

    public List<Reference> getSupplier() {
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        return this.supplier;
    }

    public SupplyRequest setSupplier(List<Reference> theSupplier) {
        this.supplier = theSupplier;
        return this;
    }

    public boolean hasSupplier() {
        if (this.supplier == null) {
            return false;
        }
        for (Reference item : this.supplier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupplier() {
        Reference t = new Reference();
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        this.supplier.add(t);
        return t;
    }

    public SupplyRequest addSupplier(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supplier == null) {
            this.supplier = new ArrayList<Reference>();
        }
        this.supplier.add(t);
        return this;
    }

    public Reference getSupplierFirstRep() {
        if (this.getSupplier().isEmpty()) {
            this.addSupplier();
        }
        return this.getSupplier().get(0);
    }

    @Deprecated
    public List<Resource> getSupplierTarget() {
        if (this.supplierTarget == null) {
            this.supplierTarget = new ArrayList<Resource>();
        }
        return this.supplierTarget;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public SupplyRequest setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public SupplyRequest addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public SupplyRequest setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public SupplyRequest addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public Reference getDeliverFrom() {
        if (this.deliverFrom == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.deliverFrom");
            }
            if (Configuration.doAutoCreate()) {
                this.deliverFrom = new Reference();
            }
        }
        return this.deliverFrom;
    }

    public boolean hasDeliverFrom() {
        return this.deliverFrom != null && !this.deliverFrom.isEmpty();
    }

    public SupplyRequest setDeliverFrom(Reference value) {
        this.deliverFrom = value;
        return this;
    }

    public Resource getDeliverFromTarget() {
        return this.deliverFromTarget;
    }

    public SupplyRequest setDeliverFromTarget(Resource value) {
        this.deliverFromTarget = value;
        return this;
    }

    public Reference getDeliverTo() {
        if (this.deliverTo == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SupplyRequest.deliverTo");
            }
            if (Configuration.doAutoCreate()) {
                this.deliverTo = new Reference();
            }
        }
        return this.deliverTo;
    }

    public boolean hasDeliverTo() {
        return this.deliverTo != null && !this.deliverTo.isEmpty();
    }

    public SupplyRequest setDeliverTo(Reference value) {
        this.deliverTo = value;
        return this;
    }

    public Resource getDeliverToTarget() {
        return this.deliverToTarget;
    }

    public SupplyRequest setDeliverToTarget(Resource value) {
        this.deliverToTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this SupplyRequest by the author and/or other systems. These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Status of the supply request.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.", 0, 1, this.category));
        children.add(new Property("priority", "code", "Indicates how quickly this SupplyRequest should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item));
        children.add(new Property("quantity", "Quantity", "The amount that is being ordered of the indicated item.", 0, 1, this.quantity));
        children.add(new Property("parameter", "", "Specific parameters for the ordered item.  For example, the size of the indicated item.", 0, Integer.MAX_VALUE, this.parameter));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence));
        children.add(new Property("authoredOn", "dateTime", "When the request was made.", 0, 1, this.authoredOn));
        children.add(new Property(SP_REQUESTER, "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson|Device)", "The device, practitioner, etc. who initiated the request.", 0, 1, this.requester));
        children.add(new Property(SP_SUPPLIER, "Reference(Organization|HealthcareService)", "Who is intended to fulfill the request.", 0, Integer.MAX_VALUE, this.supplier));
        children.add(new Property("reasonCode", "CodeableConcept", "The reason why the supply item was requested.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport|DocumentReference)", "The reason why the supply item was requested.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("deliverFrom", "Reference(Organization|Location)", "Where the supply is expected to come from.", 0, 1, this.deliverFrom));
        children.add(new Property("deliverTo", "Reference(Organization|Location|Patient)", "Where the supply is destined to go.", 0, 1, this.deliverTo));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this SupplyRequest by the author and/or other systems. These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Status of the supply request.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.", 0, 1, this.category);
            }
            case -1165461084: {
                return new Property("priority", "code", "Indicates how quickly this SupplyRequest should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case 2116201613: {
                return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
            }
            case 3242771: {
                return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
            }
            case 106644494: {
                return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
            }
            case 1376364920: {
                return new Property("item[x]", "CodeableConcept|Reference(Medication|Substance|Device)", "The item that is requested to be supplied. This is either a link to a resource representing the details of the item or a code that identifies the item from a known list.", 0, 1, this.item);
            }
            case -1285004149: {
                return new Property("quantity", "Quantity", "The amount that is being ordered of the indicated item.", 0, 1, this.quantity);
            }
            case 1954460585: {
                return new Property("parameter", "", "Specific parameters for the ordered item.  For example, the size of the indicated item.", 0, Integer.MAX_VALUE, this.parameter);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "When the request should be fulfilled.", 0, 1, this.occurrence);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "When the request was made.", 0, 1, this.authoredOn);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "Reference(Practitioner|PractitionerRole|Organization|Patient|RelatedPerson|Device)", "The device, practitioner, etc. who initiated the request.", 0, 1, this.requester);
            }
            case -1663305268: {
                return new Property(SP_SUPPLIER, "Reference(Organization|HealthcareService)", "Who is intended to fulfill the request.", 0, Integer.MAX_VALUE, this.supplier);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "The reason why the supply item was requested.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation|DiagnosticReport|DocumentReference)", "The reason why the supply item was requested.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case -949323153: {
                return new Property("deliverFrom", "Reference(Organization|Location)", "Where the supply is expected to come from.", 0, 1, this.deliverFrom);
            }
            case -242327936: {
                return new Property("deliverTo", "Reference(Organization|Location|Patient)", "Where the supply is destined to go.", 0, 1, this.deliverTo);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.category;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.priority;
                }
                return baseArray;
            }
            case 3242771: {
                Base[] baseArray;
                if (this.item == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.item;
                }
                return baseArray;
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.quantity;
                }
                return baseArray;
            }
            case 1954460585: {
                return this.parameter == null ? new Base[]{} : this.parameter.toArray(new Base[this.parameter.size()]);
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.occurrence;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.requester;
                }
                return baseArray;
            }
            case -1663305268: {
                return this.supplier == null ? new Base[]{} : this.supplier.toArray(new Base[this.supplier.size()]);
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case -949323153: {
                Base[] baseArray;
                if (this.deliverFrom == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.deliverFrom;
                }
                return baseArray;
            }
            case -242327936: {
                Base[] baseArray;
                if (this.deliverTo == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.deliverTo;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new SupplyRequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case -1165461084: {
                value = new RequestPriorityEnumFactory().fromType(this.castToCode(value));
                this.priority = value;
                return value;
            }
            case 3242771: {
                this.item = this.castToType(value);
                return value;
            }
            case -1285004149: {
                this.quantity = this.castToQuantity(value);
                return value;
            }
            case 1954460585: {
                this.getParameter().add((SupplyRequestParameterComponent)((Object)value));
                return value;
            }
            case 1687874001: {
                this.occurrence = this.castToType(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = this.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = this.castToReference(value);
                return value;
            }
            case -1663305268: {
                this.getSupplier().add(this.castToReference(value));
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case -949323153: {
                this.deliverFrom = this.castToReference(value);
                return value;
            }
            case -242327936: {
                this.deliverTo = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new SupplyRequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals("priority")) {
            value = new RequestPriorityEnumFactory().fromType(this.castToCode(value));
            this.priority = value;
        } else if (name.equals("item[x]")) {
            this.item = this.castToType(value);
        } else if (name.equals("quantity")) {
            this.quantity = this.castToQuantity(value);
        } else if (name.equals("parameter")) {
            this.getParameter().add((SupplyRequestParameterComponent)((Object)value));
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = this.castToType(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = this.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = this.castToReference(value);
        } else if (name.equals(SP_SUPPLIER)) {
            this.getSupplier().add(this.castToReference(value));
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("deliverFrom")) {
            this.deliverFrom = this.castToReference(value);
        } else if (name.equals("deliverTo")) {
            this.deliverTo = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.getCategory();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case 2116201613: {
                return this.getItem();
            }
            case 3242771: {
                return this.getItem();
            }
            case -1285004149: {
                return this.getQuantity();
            }
            case 1954460585: {
                return this.addParameter();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -1663305268: {
                return this.addSupplier();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case -949323153: {
                return this.getDeliverFrom();
            }
            case -242327936: {
                return this.getDeliverTo();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{"code"};
            }
            case 3242771: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case -1285004149: {
                return new String[]{"Quantity"};
            }
            case 1954460585: {
                return new String[0];
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[]{"Reference"};
            }
            case -1663305268: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case -949323153: {
                return new String[]{"Reference"};
            }
            case -242327936: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyRequest.status");
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyRequest.priority");
        }
        if (name.equals("itemCodeableConcept")) {
            this.item = new CodeableConcept();
            return this.item;
        }
        if (name.equals("itemReference")) {
            this.item = new Reference();
            return this.item;
        }
        if (name.equals("quantity")) {
            this.quantity = new Quantity();
            return this.quantity;
        }
        if (name.equals("parameter")) {
            return this.addParameter();
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type SupplyRequest.authoredOn");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new Reference();
            return this.requester;
        }
        if (name.equals(SP_SUPPLIER)) {
            return this.addSupplier();
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("deliverFrom")) {
            this.deliverFrom = new Reference();
            return this.deliverFrom;
        }
        if (name.equals("deliverTo")) {
            this.deliverTo = new Reference();
            return this.deliverTo;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SupplyRequest";
    }

    @Override
    public SupplyRequest copy() {
        SupplyRequest dst = new SupplyRequest();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SupplyRequest dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.item = this.item == null ? null : this.item.copy();
        Quantity quantity = dst.quantity = this.quantity == null ? null : this.quantity.copy();
        if (this.parameter != null) {
            dst.parameter = new ArrayList<SupplyRequestParameterComponent>();
            for (SupplyRequestParameterComponent supplyRequestParameterComponent : this.parameter) {
                dst.parameter.add(supplyRequestParameterComponent.copy());
            }
        }
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        Reference reference = dst.requester = this.requester == null ? null : this.requester.copy();
        if (this.supplier != null) {
            dst.supplier = new ArrayList<Reference>();
            for (Reference reference2 : this.supplier) {
                dst.supplier.add(reference2.copy());
            }
        }
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference3 : this.reasonReference) {
                dst.reasonReference.add(reference3.copy());
            }
        }
        dst.deliverFrom = this.deliverFrom == null ? null : this.deliverFrom.copy();
        dst.deliverTo = this.deliverTo == null ? null : this.deliverTo.copy();
    }

    protected SupplyRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SupplyRequest)) {
            return false;
        }
        SupplyRequest o = (SupplyRequest)other_;
        return SupplyRequest.compareDeep(this.identifier, o.identifier, true) && SupplyRequest.compareDeep(this.status, o.status, true) && SupplyRequest.compareDeep(this.category, o.category, true) && SupplyRequest.compareDeep(this.priority, o.priority, true) && SupplyRequest.compareDeep(this.item, o.item, true) && SupplyRequest.compareDeep(this.quantity, o.quantity, true) && SupplyRequest.compareDeep(this.parameter, o.parameter, true) && SupplyRequest.compareDeep(this.occurrence, o.occurrence, true) && SupplyRequest.compareDeep(this.authoredOn, o.authoredOn, true) && SupplyRequest.compareDeep(this.requester, o.requester, true) && SupplyRequest.compareDeep(this.supplier, o.supplier, true) && SupplyRequest.compareDeep(this.reasonCode, o.reasonCode, true) && SupplyRequest.compareDeep(this.reasonReference, o.reasonReference, true) && SupplyRequest.compareDeep(this.deliverFrom, o.deliverFrom, true) && SupplyRequest.compareDeep(this.deliverTo, o.deliverTo, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SupplyRequest)) {
            return false;
        }
        SupplyRequest o = (SupplyRequest)other_;
        return SupplyRequest.compareValues(this.status, o.status, true) && SupplyRequest.compareValues(this.priority, o.priority, true) && SupplyRequest.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.category, this.priority, this.item, this.quantity, this.parameter, this.occurrence, this.authoredOn, this.requester, this.supplier, this.reasonCode, this.reasonReference, this.deliverFrom, this.deliverTo});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SupplyRequest;
    }

    @Block
    public static class SupplyRequestParameterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Item detail", formalDefinition="A code or string that identifies the device detail being asserted.")
        protected CodeableConcept code;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, Range.class, BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of detail", formalDefinition="The value of the device detail.")
        protected Type value;
        private static final long serialVersionUID = 884525025L;

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SupplyRequestParameterComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SupplyRequestParameterComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SupplyRequestParameterComponent setValue(Type value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof Range || value instanceof BooleanType)) {
                throw new Error("Not the right type for SupplyRequest.parameter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "A code or string that identifies the device detail being asserted.", 0, 1, this.code));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code or string that identifies the device detail being asserted.", 0, 1, this.code);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "CodeableConcept|Quantity|Range|boolean", "The value of the device detail.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = this.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "Range", "boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public SupplyRequestParameterComponent copy() {
            SupplyRequestParameterComponent dst = new SupplyRequestParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SupplyRequestParameterComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyRequestParameterComponent)) {
                return false;
            }
            SupplyRequestParameterComponent o = (SupplyRequestParameterComponent)other_;
            return SupplyRequestParameterComponent.compareDeep(this.code, o.code, true) && SupplyRequestParameterComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SupplyRequestParameterComponent)) {
                return false;
            }
            SupplyRequestParameterComponent o = (SupplyRequestParameterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
        }

        @Override
        public String fhirType() {
            return "SupplyRequest.parameter";
        }
    }

    public static class RequestPriorityEnumFactory
    implements EnumFactory<RequestPriority> {
        @Override
        public RequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return RequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return RequestPriority.URGENT;
            }
            if ("asap".equals(codeString)) {
                return RequestPriority.ASAP;
            }
            if ("stat".equals(codeString)) {
                return RequestPriority.STAT;
            }
            throw new IllegalArgumentException("Unknown RequestPriority code '" + codeString + "'");
        }

        public Enumeration<RequestPriority> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<RequestPriority>(this, RequestPriority.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.NULL, code);
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ROUTINE, code);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.URGENT, code);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.ASAP, code);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<RequestPriority>(this, RequestPriority.STAT, code);
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(RequestPriority code) {
            if (code == RequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == RequestPriority.URGENT) {
                return "urgent";
            }
            if (code == RequestPriority.ASAP) {
                return "asap";
            }
            if (code == RequestPriority.STAT) {
                return "stat";
            }
            return "?";
        }

        @Override
        public String toSystem(RequestPriority code) {
            return code.getSystem();
        }
    }

    public static enum RequestPriority {
        ROUTINE,
        URGENT,
        ASAP,
        STAT,
        NULL;


        public static RequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown RequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case ASAP: {
                    return "asap";
                }
                case STAT: {
                    return "stat";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has normal priority.";
                }
                case URGENT: {
                    return "The request should be actioned promptly - higher priority than routine.";
                }
                case ASAP: {
                    return "The request should be actioned as soon as possible - higher priority than urgent.";
                }
                case STAT: {
                    return "The request should be actioned immediately - highest possible priority.  E.g. an emergency.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case ASAP: {
                    return "ASAP";
                }
                case STAT: {
                    return "STAT";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class SupplyRequestStatusEnumFactory
    implements EnumFactory<SupplyRequestStatus> {
        @Override
        public SupplyRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return SupplyRequestStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return SupplyRequestStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SupplyRequestStatus.SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return SupplyRequestStatus.CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return SupplyRequestStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return SupplyRequestStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return SupplyRequestStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        public Enumeration<SupplyRequestStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.NULL, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.DRAFT, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.ACTIVE, code);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.SUSPENDED, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.CANCELLED, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<SupplyRequestStatus>(this, SupplyRequestStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SupplyRequestStatus code) {
            if (code == SupplyRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == SupplyRequestStatus.ACTIVE) {
                return "active";
            }
            if (code == SupplyRequestStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == SupplyRequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == SupplyRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == SupplyRequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == SupplyRequestStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(SupplyRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum SupplyRequestStatus {
        DRAFT,
        ACTIVE,
        SUSPENDED,
        CANCELLED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static SupplyRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SupplyRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/supplyrequest-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The request has been created but is not yet complete or ready for action.";
                }
                case ACTIVE: {
                    return "The request is ready to be acted upon.";
                }
                case SUSPENDED: {
                    return "The authorization/request to act has been temporarily withdrawn but is expected to resume in the future.";
                }
                case CANCELLED: {
                    return "The authorization/request to act has been terminated prior to the full completion of the intended actions.  No further activity should occur.";
                }
                case COMPLETED: {
                    return "Activity against the request has been sufficiently completed to the satisfaction of the requester.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this observation. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring/source system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

