/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.EnrollmentRequest;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="EnrollmentResponse", profile="http://hl7.org/fhir/StructureDefinition/EnrollmentResponse")
public class EnrollmentResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<EnrollmentResponseStatus> status;
    @Child(name="request", type={EnrollmentRequest.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Claim reference", formalDefinition="Original request resource reference.")
    protected Reference request;
    protected EnrollmentRequest requestTarget;
    @Child(name="outcome", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="queued | complete | error | partial", formalDefinition="Processing status: error, complete.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/remittance-outcome")
    protected Enumeration<Enumerations.RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="created", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="organization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Insurer", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="requestProvider", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestProvider;
    protected Resource requestProviderTarget;
    private static final long serialVersionUID = -1759921458L;
    @SearchParamDefinition(name="identifier", path="EnrollmentResponse.identifier", description="The business identifier of the EnrollmentResponse", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="request", path="EnrollmentResponse.request", description="The reference to the claim", type="reference", target={EnrollmentRequest.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("EnrollmentResponse:request").toLocked();
    @SearchParamDefinition(name="status", path="EnrollmentResponse.status", description="The status of the enrollment response", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public EnrollmentResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public EnrollmentResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EnrollmentResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EnrollmentResponseStatus>(new EnrollmentResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public EnrollmentResponse setStatusElement(Enumeration<EnrollmentResponseStatus> value) {
        this.status = value;
        return this;
    }

    public EnrollmentResponseStatus getStatus() {
        return this.status == null ? null : (EnrollmentResponseStatus)((Object)this.status.getValue());
    }

    public EnrollmentResponse setStatus(EnrollmentResponseStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<EnrollmentResponseStatus>(new EnrollmentResponseStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public EnrollmentResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public EnrollmentRequest getRequestTarget() {
        if (this.requestTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.requestTarget = new EnrollmentRequest();
            }
        }
        return this.requestTarget;
    }

    public EnrollmentResponse setRequestTarget(EnrollmentRequest value) {
        this.requestTarget = value;
        return this;
    }

    public Enumeration<Enumerations.RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public EnrollmentResponse setOutcomeElement(Enumeration<Enumerations.RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public Enumerations.RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (Enumerations.RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public EnrollmentResponse setOutcome(Enumerations.RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public EnrollmentResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public EnrollmentResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public EnrollmentResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public EnrollmentResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public EnrollmentResponse setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public EnrollmentResponse setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Reference getRequestProvider() {
        if (this.requestProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EnrollmentResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProvider = new Reference();
            }
        }
        return this.requestProvider;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public EnrollmentResponse setRequestProvider(Reference value) {
        this.requestProvider = value;
        return this;
    }

    public Resource getRequestProviderTarget() {
        return this.requestProviderTarget;
    }

    public EnrollmentResponse setRequestProviderTarget(Resource value) {
        this.requestProviderTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property(SP_REQUEST, "Reference(EnrollmentRequest)", "Original request resource reference.", 0, 1, this.request));
        children.add(new Property("outcome", "code", "Processing status: error, complete.", 0, 1, this.outcome));
        children.add(new Property("disposition", "string", "A description of the status of the adjudication.", 0, 1, this.disposition));
        children.add(new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created));
        children.add(new Property("organization", "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.organization));
        children.add(new Property("requestProvider", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(EnrollmentRequest)", "Original request resource reference.", 0, 1, this.request);
            }
            case -1106507950: {
                return new Property("outcome", "code", "Processing status: error, complete.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property("disposition", "string", "A description of the status of the adjudication.", 0, 1, this.disposition);
            }
            case 1028554472: {
                return new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, 1, this.created);
            }
            case 1178922291: {
                return new Property("organization", "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, 1, this.organization);
            }
            case 1601527200: {
                return new Property("requestProvider", "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestProvider);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.request;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.disposition;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.created;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.organization;
                }
                return baseArray;
            }
            case 1601527200: {
                Base[] baseArray;
                if (this.requestProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.requestProvider;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EnrollmentResponseStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 1095692943: {
                this.request = this.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new Enumerations.RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 583380919: {
                this.disposition = this.castToString(value);
                return value;
            }
            case 1028554472: {
                this.created = this.castToDateTime(value);
                return value;
            }
            case 1178922291: {
                this.organization = this.castToReference(value);
                return value;
            }
            case 1601527200: {
                this.requestProvider = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EnrollmentResponseStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals("outcome")) {
            value = new Enumerations.RemittanceOutcomeEnumFactory().fromType(this.castToCode(value));
            this.outcome = value;
        } else if (name.equals("disposition")) {
            this.disposition = this.castToString(value);
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("organization")) {
            this.organization = this.castToReference(value);
        } else if (name.equals("requestProvider")) {
            this.requestProvider = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 1601527200: {
                return this.getRequestProvider();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case 1601527200: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type EnrollmentResponse.status");
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("outcome")) {
            throw new FHIRException("Cannot call addChild on a primitive type EnrollmentResponse.outcome");
        }
        if (name.equals("disposition")) {
            throw new FHIRException("Cannot call addChild on a primitive type EnrollmentResponse.disposition");
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type EnrollmentResponse.created");
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("requestProvider")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EnrollmentResponse";
    }

    @Override
    public EnrollmentResponse copy() {
        EnrollmentResponse dst = new EnrollmentResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EnrollmentResponse dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
    }

    protected EnrollmentResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EnrollmentResponse)) {
            return false;
        }
        EnrollmentResponse o = (EnrollmentResponse)other_;
        return EnrollmentResponse.compareDeep(this.identifier, o.identifier, true) && EnrollmentResponse.compareDeep(this.status, o.status, true) && EnrollmentResponse.compareDeep(this.request, o.request, true) && EnrollmentResponse.compareDeep(this.outcome, o.outcome, true) && EnrollmentResponse.compareDeep(this.disposition, o.disposition, true) && EnrollmentResponse.compareDeep(this.created, o.created, true) && EnrollmentResponse.compareDeep(this.organization, o.organization, true) && EnrollmentResponse.compareDeep(this.requestProvider, o.requestProvider, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EnrollmentResponse)) {
            return false;
        }
        EnrollmentResponse o = (EnrollmentResponse)other_;
        return EnrollmentResponse.compareValues(this.status, o.status, true) && EnrollmentResponse.compareValues(this.outcome, o.outcome, true) && EnrollmentResponse.compareValues(this.disposition, o.disposition, true) && EnrollmentResponse.compareValues(this.created, o.created, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.request, this.outcome, this.disposition, this.created, this.organization, this.requestProvider});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.EnrollmentResponse;
    }

    public static class EnrollmentResponseStatusEnumFactory
    implements EnumFactory<EnrollmentResponseStatus> {
        @Override
        public EnrollmentResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return EnrollmentResponseStatus.ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return EnrollmentResponseStatus.CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return EnrollmentResponseStatus.DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return EnrollmentResponseStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown EnrollmentResponseStatus code '" + codeString + "'");
        }

        public Enumeration<EnrollmentResponseStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EnrollmentResponseStatus>(this, EnrollmentResponseStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EnrollmentResponseStatus>(this, EnrollmentResponseStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EnrollmentResponseStatus>(this, EnrollmentResponseStatus.ACTIVE, code);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EnrollmentResponseStatus>(this, EnrollmentResponseStatus.CANCELLED, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<EnrollmentResponseStatus>(this, EnrollmentResponseStatus.DRAFT, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EnrollmentResponseStatus>(this, EnrollmentResponseStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown EnrollmentResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EnrollmentResponseStatus code) {
            if (code == EnrollmentResponseStatus.ACTIVE) {
                return "active";
            }
            if (code == EnrollmentResponseStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EnrollmentResponseStatus.DRAFT) {
                return "draft";
            }
            if (code == EnrollmentResponseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(EnrollmentResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum EnrollmentResponseStatus {
        ACTIVE,
        CANCELLED,
        DRAFT,
        ENTEREDINERROR,
        NULL;


        public static EnrollmentResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EnrollmentResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case DRAFT: {
                    return "draft";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/fm-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The instance is currently in-force.";
                }
                case CANCELLED: {
                    return "The instance is withdrawn, rescinded or reversed.";
                }
                case DRAFT: {
                    return "A new instance the contents of which is not complete.";
                }
                case ENTEREDINERROR: {
                    return "The instance was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case DRAFT: {
                    return "Draft";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

