/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.jpa.search.reindex.BlockPolicy;
import jakarta.annotation.Nonnull;
import java.util.concurrent.RejectedExecutionHandler;
import org.apache.commons.lang3.Validate;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public final class ThreadPoolUtil {
    private ThreadPoolUtil() {
    }

    @Nonnull
    public static ThreadPoolTaskExecutor newThreadPool(int theCorePoolSize, int theMaxPoolSize, String theThreadNamePrefix) {
        return ThreadPoolUtil.newThreadPool(theCorePoolSize, theMaxPoolSize, theThreadNamePrefix, 0);
    }

    @Nonnull
    public static ThreadPoolTaskExecutor newThreadPool(int theCorePoolSize, int theMaxPoolSize, String theThreadNamePrefix, int theQueueCapacity) {
        return ThreadPoolUtil.newThreadPool(theCorePoolSize, theMaxPoolSize, theThreadNamePrefix, theQueueCapacity, null);
    }

    @Nonnull
    public static ThreadPoolTaskExecutor newThreadPool(int theCorePoolSize, int theMaxPoolSize, String theThreadNamePrefix, int theQueueCapacity, TaskDecorator taskDecorator) {
        Validate.isTrue((theCorePoolSize == theMaxPoolSize || theQueueCapacity == 0 ? 1 : 0) != 0, (String)"If the queue capacity is greater than 0, core pool size needs to match max pool size or the system won't grow the queue", (Object[])new Object[0]);
        Validate.isTrue((boolean)theThreadNamePrefix.endsWith("-"), (String)"Thread pool prefix name must end with a hyphen", (Object[])new Object[0]);
        ThreadPoolTaskExecutor asyncTaskExecutor = new ThreadPoolTaskExecutor();
        asyncTaskExecutor.setCorePoolSize(theCorePoolSize);
        asyncTaskExecutor.setMaxPoolSize(theMaxPoolSize);
        asyncTaskExecutor.setQueueCapacity(theQueueCapacity);
        asyncTaskExecutor.setAllowCoreThreadTimeOut(true);
        asyncTaskExecutor.setThreadNamePrefix(theThreadNamePrefix);
        asyncTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new BlockPolicy());
        asyncTaskExecutor.setTaskDecorator(taskDecorator);
        asyncTaskExecutor.initialize();
        return asyncTaskExecutor;
    }
}

