/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.util.IMetaTagSorter;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class MetaTagSorterAlphabetical
implements IMetaTagSorter {
    private final Comparator<String> nullFirstStringComparator = Comparator.nullsFirst(Comparator.naturalOrder());
    private final Comparator<IBaseCoding> myCodingAlphabeticalComparator = Comparator.comparing(IBaseCoding::getSystem, this.nullFirstStringComparator).thenComparing(IBaseCoding::getCode, this.nullFirstStringComparator);
    private final Comparator<IPrimitiveType<String>> myPrimitiveStringAlphabeticalComparator = Comparator.comparing(IPrimitiveType::getValue, this.nullFirstStringComparator);

    public void sortCodings(List<? extends IBaseCoding> theCodings) {
        theCodings.sort(this.myCodingAlphabeticalComparator);
    }

    public void sortPrimitiveStrings(List<? extends IPrimitiveType<String>> theList) {
        theList.sort(this.myPrimitiveStringAlphabeticalComparator);
    }

    @Override
    public void sort(IBaseMetaType theMeta) {
        this.sortCodings(theMeta.getTag());
        this.sortCodings(theMeta.getSecurity());
        this.sortPrimitiveStrings(theMeta.getProfile());
    }
}

