/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.storage.interceptor.balp;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.storage.interceptor.balp.BalpProfileEnum;
import ca.uhn.fhir.storage.interceptor.balp.IBalpAuditContextServices;
import ca.uhn.fhir.storage.interceptor.balp.IBalpAuditEventSink;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.UrlUtil;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.AuditEvent;

public class BalpAuditCaptureInterceptor {
    private final IBalpAuditEventSink myAuditEventSink;
    private final IBalpAuditContextServices myContextServices;
    private Set<String> myAdditionalPatientCompartmentParamNames;

    public BalpAuditCaptureInterceptor(@Nonnull IBalpAuditEventSink theAuditEventSink, @Nonnull IBalpAuditContextServices theContextServices) {
        Validate.notNull((Object)theAuditEventSink);
        Validate.notNull((Object)theContextServices);
        this.myAuditEventSink = theAuditEventSink;
        this.myContextServices = theContextServices;
    }

    private static void addEntityPatient(AuditEvent theAuditEvent, String thePatientId) {
        AuditEvent.AuditEventEntityComponent entityPatient = theAuditEvent.addEntity();
        entityPatient.getType().setSystem("http://terminology.hl7.org/CodeSystem/audit-entity-type").setCode("1").setDisplay("Person");
        entityPatient.getRole().setSystem("http://terminology.hl7.org/CodeSystem/object-role").setCode("1").setDisplay("Patient");
        entityPatient.getWhat().setReference(thePatientId);
    }

    private static void addEntityData(AuditEvent theAuditEvent, String theDataResourceId) {
        AuditEvent.AuditEventEntityComponent entityData = theAuditEvent.addEntity();
        entityData.getType().setSystem("http://terminology.hl7.org/CodeSystem/audit-entity-type").setCode("2").setDisplay("System Object");
        entityData.getRole().setSystem("http://terminology.hl7.org/CodeSystem/object-role").setCode("4").setDisplay("Domain Resource");
        entityData.getWhat().setReference(theDataResourceId);
    }

    public void setAdditionalPatientCompartmentParamNames(Set<String> theAdditionalPatientCompartmentParamNames) {
        this.myAdditionalPatientCompartmentParamNames = theAdditionalPatientCompartmentParamNames;
    }

    @Hook(value=Pointcut.STORAGE_PRESHOW_RESOURCES)
    void hookStoragePreShowResources(IPreResourceShowDetails theDetails, ServletRequestDetails theRequestDetails) {
        switch (theRequestDetails.getRestOperationType()) {
            case SEARCH_TYPE: 
            case SEARCH_SYSTEM: 
            case GET_PAGE: {
                this.handleSearch(theDetails, theRequestDetails);
                break;
            }
            case READ: 
            case VREAD: {
                this.handleReadOrVRead(theDetails, theRequestDetails);
                break;
            }
        }
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED)
    public void hookStoragePrecommitResourceCreated(IBaseResource theResource, ServletRequestDetails theRequestDetails) {
        this.handleCreateUpdateDelete(theResource, theRequestDetails, BalpProfileEnum.BASIC_CREATE, BalpProfileEnum.PATIENT_CREATE);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED)
    public void hookStoragePrecommitResourceDeleted(IBaseResource theResource, ServletRequestDetails theRequestDetails) {
        this.handleCreateUpdateDelete(theResource, theRequestDetails, BalpProfileEnum.BASIC_DELETE, BalpProfileEnum.PATIENT_DELETE);
    }

    @Hook(value=Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED)
    public void hookStoragePrecommitResourceUpdated(IBaseResource theOldResource, IBaseResource theResource, ServletRequestDetails theRequestDetails) {
        this.handleCreateUpdateDelete(theResource, theRequestDetails, BalpProfileEnum.BASIC_UPDATE, BalpProfileEnum.PATIENT_UPDATE);
    }

    private void handleCreateUpdateDelete(IBaseResource theResource, ServletRequestDetails theRequestDetails, BalpProfileEnum theBasicProfile, BalpProfileEnum thePatientProfile) {
        Set<String> patientCompartmentOwners = this.determinePatientCompartmentOwnersForResources(List.of(theResource), theRequestDetails);
        if (patientCompartmentOwners.isEmpty()) {
            AuditEvent auditEvent = this.createAuditEventBasicCreateUpdateDelete(theRequestDetails, theResource, theBasicProfile);
            this.myAuditEventSink.recordAuditEvent(auditEvent);
        } else {
            AuditEvent auditEvent = this.createAuditEventPatientCreateUpdateDelete(theRequestDetails, theResource, patientCompartmentOwners, thePatientProfile);
            this.myAuditEventSink.recordAuditEvent(auditEvent);
        }
    }

    private void handleReadOrVRead(IPreResourceShowDetails theDetails, ServletRequestDetails theRequestDetails) {
        Validate.isTrue((theDetails.size() == 1 ? 1 : 0) != 0, (String)"Unexpected number of results for read: %d", (long)theDetails.size());
        IBaseResource resource = theDetails.getResource(0);
        if (resource != null) {
            String dataResourceId = this.myContextServices.massageResourceIdForStorage((RequestDetails)theRequestDetails, resource, resource.getIdElement());
            Set<String> patientIds = this.determinePatientCompartmentOwnersForResources(List.of(resource), theRequestDetails);
            for (String patientId : patientIds) {
                AuditEvent auditEvent = this.createAuditEventPatientRead(theRequestDetails, dataResourceId, patientId);
                this.myAuditEventSink.recordAuditEvent(auditEvent);
            }
            if (patientIds.isEmpty()) {
                AuditEvent auditEvent = this.createAuditEventBasicRead(theRequestDetails, dataResourceId);
                this.myAuditEventSink.recordAuditEvent(auditEvent);
            }
        }
    }

    private void handleSearch(IPreResourceShowDetails theDetails, ServletRequestDetails theRequestDetails) {
        List resources = theDetails.getAllResources();
        Set<String> compartmentOwners = this.determinePatientCompartmentOwnersForResources(resources, theRequestDetails);
        if (!compartmentOwners.isEmpty()) {
            AuditEvent auditEvent = this.createAuditEventPatientQuery(theRequestDetails, compartmentOwners);
            this.myAuditEventSink.recordAuditEvent(auditEvent);
        } else {
            AuditEvent auditEvent = this.createAuditEventBasicQuery(theRequestDetails);
            this.myAuditEventSink.recordAuditEvent(auditEvent);
        }
    }

    @Nonnull
    private Set<String> determinePatientCompartmentOwnersForResources(List<IBaseResource> theResources, ServletRequestDetails theRequestDetails) {
        TreeSet<String> patientIds = new TreeSet<String>();
        FhirContext fhirContext = theRequestDetails.getFhirContext();
        for (IBaseResource resource : theResources) {
            RuntimeResourceDefinition resourceDef = fhirContext.getResourceDefinition(resource);
            if (resourceDef.getName().equals("Patient")) {
                patientIds.add(this.myContextServices.massageResourceIdForStorage((RequestDetails)theRequestDetails, resource, resource.getIdElement()));
                continue;
            }
            List compartmentSearchParameters = resourceDef.getSearchParamsForCompartmentName("Patient");
            if (compartmentSearchParameters.isEmpty()) continue;
            FhirTerser terser = fhirContext.newTerser();
            terser.getCompartmentOwnersForResource("Patient", resource, this.myAdditionalPatientCompartmentParamNames).stream().map(t -> this.myContextServices.massageResourceIdForStorage((RequestDetails)theRequestDetails, resource, (IIdType)t)).forEach(patientIds::add);
        }
        return patientIds;
    }

    @Nonnull
    private AuditEvent createAuditEventCommonCreate(ServletRequestDetails theRequestDetails, IBaseResource theResource, BalpProfileEnum profile) {
        AuditEvent auditEvent = this.createAuditEventCommon(theRequestDetails, profile);
        String resourceId = this.myContextServices.massageResourceIdForStorage((RequestDetails)theRequestDetails, theResource, theResource.getIdElement());
        BalpAuditCaptureInterceptor.addEntityData(auditEvent, resourceId);
        return auditEvent;
    }

    @Nonnull
    private AuditEvent createAuditEventBasicCreateUpdateDelete(ServletRequestDetails theRequestDetails, IBaseResource theResource, BalpProfileEnum theProfile) {
        return this.createAuditEventCommonCreate(theRequestDetails, theResource, theProfile);
    }

    @Nonnull
    private AuditEvent createAuditEventBasicQuery(ServletRequestDetails theRequestDetails) {
        BalpProfileEnum profile = BalpProfileEnum.BASIC_QUERY;
        AuditEvent auditEvent = this.createAuditEventCommonQuery(theRequestDetails, profile);
        return auditEvent;
    }

    @Nonnull
    private AuditEvent createAuditEventBasicRead(ServletRequestDetails theRequestDetails, String dataResourceId) {
        return this.createAuditEventCommonRead(theRequestDetails, dataResourceId, BalpProfileEnum.BASIC_READ);
    }

    @Nonnull
    private AuditEvent createAuditEventPatientCreateUpdateDelete(ServletRequestDetails theRequestDetails, IBaseResource theResource, Set<String> thePatientCompartmentOwners, BalpProfileEnum theProfile) {
        AuditEvent retVal = this.createAuditEventCommonCreate(theRequestDetails, theResource, theProfile);
        for (String next : thePatientCompartmentOwners) {
            BalpAuditCaptureInterceptor.addEntityPatient(retVal, next);
        }
        return retVal;
    }

    @Nonnull
    private AuditEvent createAuditEventPatientQuery(ServletRequestDetails theRequestDetails, Set<String> compartmentOwners) {
        BalpProfileEnum profile = BalpProfileEnum.PATIENT_QUERY;
        AuditEvent auditEvent = this.createAuditEventCommonQuery(theRequestDetails, profile);
        for (String next : compartmentOwners) {
            BalpAuditCaptureInterceptor.addEntityPatient(auditEvent, next);
        }
        return auditEvent;
    }

    @Nonnull
    private AuditEvent createAuditEventPatientRead(ServletRequestDetails theRequestDetails, String dataResourceId, String patientId) {
        BalpProfileEnum profile = BalpProfileEnum.PATIENT_READ;
        AuditEvent auditEvent = this.createAuditEventCommonRead(theRequestDetails, dataResourceId, profile);
        BalpAuditCaptureInterceptor.addEntityPatient(auditEvent, patientId);
        return auditEvent;
    }

    @Nonnull
    private AuditEvent createAuditEventCommon(ServletRequestDetails theRequestDetails, BalpProfileEnum theProfile) {
        RestOperationTypeEnum restOperationType = theRequestDetails.getRestOperationType();
        if (restOperationType == RestOperationTypeEnum.GET_PAGE) {
            restOperationType = RestOperationTypeEnum.SEARCH_TYPE;
        }
        AuditEvent auditEvent = new AuditEvent();
        auditEvent.getMeta().addProfile(theProfile.getProfileUrl());
        auditEvent.getType().setSystem("http://terminology.hl7.org/CodeSystem/audit-event-type").setCode("rest").setDisplay("Restful Operation");
        auditEvent.addSubtype().setSystem("http://hl7.org/fhir/restful-interaction").setCode(restOperationType.getCode()).setDisplay(restOperationType.getCode());
        auditEvent.setAction(theProfile.getAction());
        auditEvent.setOutcome(AuditEvent.AuditEventOutcome._0);
        auditEvent.setRecorded(new Date());
        auditEvent.getSource().getObserver().setDisplay(theRequestDetails.getFhirServerBase());
        AuditEvent.AuditEventAgentComponent clientAgent = auditEvent.addAgent();
        clientAgent.setWho(this.myContextServices.getAgentClientWho((RequestDetails)theRequestDetails));
        clientAgent.getType().addCoding(theProfile.getAgentClientTypeCoding());
        clientAgent.getWho().setDisplay(this.myContextServices.getNetworkAddress((RequestDetails)theRequestDetails));
        clientAgent.getNetwork().setAddress(this.myContextServices.getNetworkAddress((RequestDetails)theRequestDetails)).setType(this.myContextServices.getNetworkAddressType((RequestDetails)theRequestDetails));
        clientAgent.setRequestor(false);
        AuditEvent.AuditEventAgentComponent serverAgent = auditEvent.addAgent();
        serverAgent.getType().addCoding(theProfile.getAgentServerTypeCoding());
        serverAgent.getWho().setDisplay(theRequestDetails.getFhirServerBase());
        serverAgent.getNetwork().setAddress(theRequestDetails.getFhirServerBase());
        serverAgent.setRequestor(false);
        AuditEvent.AuditEventAgentComponent userAgent = auditEvent.addAgent();
        userAgent.getType().addCoding().setSystem("http://terminology.hl7.org/CodeSystem/v3-ParticipationType").setCode("IRCP").setDisplay("information recipient");
        userAgent.setWho(this.myContextServices.getAgentUserWho((RequestDetails)theRequestDetails));
        userAgent.setRequestor(true);
        AuditEvent.AuditEventEntityComponent entityTransaction = auditEvent.addEntity();
        entityTransaction.getType().setSystem("https://profiles.ihe.net/ITI/BALP/CodeSystem/BasicAuditEntityType").setCode("XrequestId");
        entityTransaction.getWhat().getIdentifier().setValue(theRequestDetails.getRequestId());
        return auditEvent;
    }

    @Nonnull
    private AuditEvent createAuditEventCommonQuery(ServletRequestDetails theRequestDetails, BalpProfileEnum profile) {
        AuditEvent auditEvent = this.createAuditEventCommon(theRequestDetails, profile);
        AuditEvent.AuditEventEntityComponent queryEntity = auditEvent.addEntity();
        queryEntity.getType().setSystem("http://terminology.hl7.org/CodeSystem/audit-entity-type").setCode("2").setDisplay("System Object");
        queryEntity.getRole().setSystem("http://terminology.hl7.org/CodeSystem/object-role").setCode("24").setDisplay("Query");
        StringBuilder description = new StringBuilder();
        description.append(theRequestDetails.getRequestType().name());
        description.append(" ");
        description.append(theRequestDetails.getCompleteUrl());
        queryEntity.setDescription(description.toString());
        StringBuilder queryString = new StringBuilder();
        queryString.append(theRequestDetails.getFhirServerBase());
        queryString.append("/");
        queryString.append(theRequestDetails.getRequestPath());
        boolean first = true;
        for (Map.Entry nextEntrySet : theRequestDetails.getParameters().entrySet()) {
            for (String nextValue : (String[])nextEntrySet.getValue()) {
                if (first) {
                    queryString.append("?");
                    first = false;
                } else {
                    queryString.append("&");
                }
                queryString.append(UrlUtil.escapeUrlParam((String)((String)nextEntrySet.getKey())));
                queryString.append("=");
                queryString.append(UrlUtil.escapeUrlParam((String)nextValue));
            }
        }
        queryEntity.getQueryElement().setValue(queryString.toString().getBytes(StandardCharsets.UTF_8));
        return auditEvent;
    }

    @Nonnull
    private AuditEvent createAuditEventCommonRead(ServletRequestDetails theRequestDetails, String theDataResourceId, BalpProfileEnum theProfile) {
        AuditEvent auditEvent = this.createAuditEventCommon(theRequestDetails, theProfile);
        BalpAuditCaptureInterceptor.addEntityData(auditEvent, theDataResourceId);
        return auditEvent;
    }
}

