/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.searchparam.extractor.BaseSearchParamExtractor;
import ca.uhn.fhir.jpa.searchparam.extractor.ISearchParamExtractor;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.IdType;

public class ResourceCompartmentUtil {
    public static Optional<String> getPatientCompartmentIdentity(IBaseResource theResource, FhirContext theFhirContext, ISearchParamExtractor theSearchParamExtractor) {
        RuntimeResourceDefinition resourceDef = theFhirContext.getResourceDefinition(theResource);
        List<RuntimeSearchParam> patientCompartmentSps = ResourceCompartmentUtil.getPatientCompartmentSearchParams(resourceDef);
        if (patientCompartmentSps.isEmpty()) {
            return Optional.empty();
        }
        if (resourceDef.getName().equals("Patient")) {
            String compartmentIdentity = theResource.getIdElement().getIdPart();
            if (StringUtils.isBlank((CharSequence)compartmentIdentity)) {
                throw new MethodNotAllowedException(Msg.code((int)2475) + "Patient resource IDs must be client-assigned in patient compartment mode");
            }
            return Optional.of(compartmentIdentity);
        }
        return ResourceCompartmentUtil.getResourceCompartment(theResource, patientCompartmentSps, theSearchParamExtractor);
    }

    public static Optional<String> getResourceCompartment(IBaseResource theResource, List<RuntimeSearchParam> theCompartmentSps, ISearchParamExtractor mySearchParamExtractor) {
        return theCompartmentSps.stream().flatMap(param -> Arrays.stream(BaseSearchParamExtractor.splitPathsR4((String)param.getPath()))).filter(StringUtils::isNotBlank).map(path -> mySearchParamExtractor.getPathValueExtractor((IBase)theResource, path).get()).filter(t -> !t.isEmpty()).map(t -> (IBase)t.get(0)).filter(t -> t instanceof IBaseReference).map(t -> (IBaseReference)t).map(t -> t.getReferenceElement().getValue()).map(t -> new IdType(t).getIdPart()).filter(StringUtils::isNotBlank).findFirst();
    }

    @Nonnull
    public static List<RuntimeSearchParam> getPatientCompartmentSearchParams(RuntimeResourceDefinition resourceDef) {
        return resourceDef.getSearchParams().stream().filter(param -> param.getParamType() == RestSearchParameterTypeEnum.REFERENCE).filter(param -> param.getProvidesMembershipInCompartments() != null && param.getProvidesMembershipInCompartments().contains("Patient")).collect(Collectors.toList());
    }
}

