/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.util.BaseCaptureQueriesListener;
import ca.uhn.fhir.jpa.util.CircularQueueCaptureQueriesListener;
import ca.uhn.fhir.jpa.util.SqlQuery;
import ca.uhn.fhir.jpa.util.SqlQueryList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentThreadCaptureQueriesListener
extends BaseCaptureQueriesListener {
    private static final ThreadLocal<Queue<SqlQuery>> ourQueues = new ThreadLocal();
    private static final ThreadLocal<AtomicInteger> ourCommits = new ThreadLocal();
    private static final ThreadLocal<AtomicInteger> ourRollbacks = new ThreadLocal();
    private static final Logger ourLog = LoggerFactory.getLogger(CurrentThreadCaptureQueriesListener.class);

    @Override
    protected Queue<SqlQuery> provideQueryList() {
        return ourQueues.get();
    }

    @Override
    protected AtomicInteger provideCommitCounter() {
        return ourCommits.get();
    }

    @Override
    protected AtomicInteger provideRollbackCounter() {
        return ourRollbacks.get();
    }

    public static SqlQueryList getCurrentQueueAndStopCapturing() {
        Queue<SqlQuery> retVal = ourQueues.get();
        ourQueues.remove();
        ourCommits.remove();
        ourRollbacks.remove();
        if (retVal == null) {
            return new SqlQueryList();
        }
        return new SqlQueryList(retVal);
    }

    public static void startCapturing() {
        ourQueues.set(new ArrayDeque());
        ourCommits.set(new AtomicInteger(0));
        ourRollbacks.set(new AtomicInteger(0));
    }

    public static int logQueriesForCurrentThreadAndStopCapturing(int ... theIndexes) {
        List queries = CurrentThreadCaptureQueriesListener.getCurrentQueueAndStopCapturing().stream().map(CircularQueueCaptureQueriesListener::formatQueryAsSql).collect(Collectors.toList());
        if (theIndexes != null && theIndexes.length > 0) {
            ArrayList newList = new ArrayList();
            for (int i = 0; i < theIndexes.length; ++i) {
                newList.add((String)queries.get(theIndexes[i]));
            }
            queries = newList;
        }
        ourLog.info("Select Queries:\n{}", (Object)String.join((CharSequence)"\n", queries));
        return queries.size();
    }
}

