/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.util.SqlQuery;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.MethodExecutionContext;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseCaptureQueriesListener
implements ProxyDataSourceBuilder.SingleQueryExecution,
ProxyDataSourceBuilder.SingleMethodExecution {
    private boolean myCaptureQueryStackTrace = false;

    public boolean isCaptureQueryStackTrace() {
        return this.myCaptureQueryStackTrace;
    }

    public void setCaptureQueryStackTrace(boolean theCaptureQueryStackTrace) {
        this.myCaptureQueryStackTrace = theCaptureQueryStackTrace;
    }

    public void execute(ExecutionInfo theExecutionInfo, List<QueryInfo> theQueryInfoList) {
        Queue<SqlQuery> queryList = this.provideQueryList();
        if (queryList == null) {
            return;
        }
        RequestPartitionId requestPartitionId = HapiTransactionService.getRequestPartitionAssociatedWithThread();
        for (QueryInfo next : theQueryInfoList) {
            List<String> params;
            int size;
            String sql = StringUtils.trim((String)next.getQuery());
            if (next.getParametersList().size() > 0 && ((List)next.getParametersList().get(0)).size() > 0) {
                size = next.getParametersList().size();
                List values = (List)next.getParametersList().get(0);
                params = values.stream().map(t -> t.getArgs()[1]).map(t -> t != null ? t.toString() : "NULL").collect(Collectors.toList());
            } else {
                params = Collections.emptyList();
                size = next.getParametersList().size();
            }
            StackTraceElement[] stackTraceElements = null;
            if (this.isCaptureQueryStackTrace()) {
                stackTraceElements = Thread.currentThread().getStackTrace();
            }
            long elapsedTime = theExecutionInfo.getElapsedTime();
            long startTime = System.currentTimeMillis() - elapsedTime;
            SqlQuery sqlQuery = new SqlQuery(sql, params, startTime, elapsedTime, stackTraceElements, size, requestPartitionId);
            queryList.add(sqlQuery);
        }
    }

    protected abstract Queue<SqlQuery> provideQueryList();

    @Nullable
    protected abstract AtomicInteger provideCommitCounter();

    @Nullable
    protected abstract AtomicInteger provideRollbackCounter();

    public void execute(MethodExecutionContext executionContext) {
        AtomicInteger counter = null;
        switch (executionContext.getMethod().getName()) {
            case "commit": {
                counter = this.provideCommitCounter();
                break;
            }
            case "rollback": {
                counter = this.provideRollbackCounter();
            }
        }
        if (counter != null) {
            counter.incrementAndGet();
        }
    }

    public int countCommits() {
        return this.provideCommitCounter().get();
    }

    public int countRollbacks() {
        return this.provideRollbackCounter().get();
    }
}

