/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.channel.api.ChannelConsumerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelProducerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.channel.subscription.BroadcastingSubscribableChannelWrapper;
import ca.uhn.fhir.jpa.subscription.model.ResourceDeliveryJsonMessage;
import ca.uhn.fhir.jpa.subscription.model.ResourceModifiedJsonMessage;
import org.apache.commons.lang3.Validate;

public class SubscriptionChannelFactory {
    private final IChannelFactory myChannelFactory;

    public SubscriptionChannelFactory(IChannelFactory theChannelFactory) {
        Validate.notNull((Object)theChannelFactory);
        this.myChannelFactory = theChannelFactory;
    }

    public IChannelProducer newDeliverySendingChannel(String theChannelName, ChannelProducerSettings theChannelSettings) {
        ChannelProducerSettings config = this.newProducerConfigForDeliveryChannel(theChannelSettings);
        config.setRetryConfiguration(theChannelSettings.getRetryConfigurationParameters());
        return this.myChannelFactory.getOrCreateProducer(theChannelName, ResourceDeliveryJsonMessage.class, config);
    }

    public IChannelReceiver newDeliveryReceivingChannel(String theChannelName, ChannelConsumerSettings theChannelSettings) {
        ChannelConsumerSettings config = this.newConsumerConfigForDeliveryChannel(theChannelSettings);
        IChannelReceiver channel = this.myChannelFactory.getOrCreateReceiver(theChannelName, ResourceDeliveryJsonMessage.class, config);
        return new BroadcastingSubscribableChannelWrapper(channel);
    }

    public IChannelProducer newMatchingSendingChannel(String theChannelName, ChannelProducerSettings theChannelSettings) {
        ChannelProducerSettings config = this.newProducerConfigForMatchingChannel(theChannelSettings);
        return this.myChannelFactory.getOrCreateProducer(theChannelName, ResourceModifiedJsonMessage.class, config);
    }

    public IChannelReceiver newMatchingReceivingChannel(String theChannelName, ChannelConsumerSettings theChannelSettings) {
        ChannelConsumerSettings config = this.newConsumerConfigForMatchingChannel(theChannelSettings);
        IChannelReceiver channel = this.myChannelFactory.getOrCreateReceiver(theChannelName, ResourceModifiedJsonMessage.class, config);
        return new BroadcastingSubscribableChannelWrapper(channel);
    }

    protected ChannelProducerSettings newProducerConfigForDeliveryChannel(ChannelProducerSettings theOptions) {
        ChannelProducerSettings config = new ChannelProducerSettings();
        config.setConcurrentConsumers(this.getDeliveryChannelConcurrentConsumers());
        config.setRetryConfiguration(theOptions.getRetryConfigurationParameters());
        return config;
    }

    protected ChannelConsumerSettings newConsumerConfigForDeliveryChannel(ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = new ChannelConsumerSettings();
        config.setConcurrentConsumers(this.getDeliveryChannelConcurrentConsumers());
        if (theOptions != null) {
            config.setRetryConfiguration(theOptions.getRetryConfigurationParameters());
        }
        return config;
    }

    protected ChannelProducerSettings newProducerConfigForMatchingChannel(ChannelProducerSettings theOptions) {
        ChannelProducerSettings config = new ChannelProducerSettings();
        if (theOptions != null) {
            config.setRetryConfiguration(theOptions.getRetryConfigurationParameters());
            config.setQualifyChannelName(theOptions.isQualifyChannelName());
        }
        config.setConcurrentConsumers(this.getMatchingChannelConcurrentConsumers());
        return config;
    }

    protected ChannelConsumerSettings newConsumerConfigForMatchingChannel(ChannelConsumerSettings theOptions) {
        ChannelConsumerSettings config = new ChannelConsumerSettings();
        config.setConcurrentConsumers(this.getMatchingChannelConcurrentConsumers());
        if (theOptions != null) {
            config.setQualifyChannelName(theOptions.isQualifyChannelName());
            config.setRetryConfiguration(theOptions.getRetryConfigurationParameters());
        }
        return config;
    }

    public int getDeliveryChannelConcurrentConsumers() {
        return 2;
    }

    public int getMatchingChannelConcurrentConsumers() {
        return 5;
    }

    public IChannelFactory getChannelFactory() {
        return this.myChannelFactory;
    }
}

