/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.impl;

import ca.uhn.fhir.jpa.subscription.channel.api.ChannelConsumerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.ChannelProducerSettings;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelFactory;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelSettings;
import ca.uhn.fhir.jpa.subscription.channel.impl.LinkedBlockingChannel;
import ca.uhn.fhir.jpa.subscription.channel.subscription.IChannelNamer;
import ca.uhn.fhir.util.ThreadPoolUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PreDestroy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class LinkedBlockingChannelFactory
implements IChannelFactory {
    private final IChannelNamer myChannelNamer;
    private final Map<String, LinkedBlockingChannel> myChannels = Collections.synchronizedMap(new HashMap());

    public LinkedBlockingChannelFactory(IChannelNamer theChannelNamer) {
        this.myChannelNamer = theChannelNamer;
    }

    @Override
    public IChannelReceiver getOrCreateReceiver(String theChannelName, Class<?> theMessageType, ChannelConsumerSettings theChannelSettings) {
        return this.getOrCreateChannel(theChannelName, theChannelSettings.getConcurrentConsumers(), theChannelSettings);
    }

    @Override
    public IChannelProducer getOrCreateProducer(String theChannelName, Class<?> theMessageType, ChannelProducerSettings theChannelSettings) {
        return this.getOrCreateChannel(theChannelName, theChannelSettings.getConcurrentConsumers(), theChannelSettings);
    }

    @Override
    public IChannelNamer getChannelNamer() {
        return this.myChannelNamer;
    }

    private LinkedBlockingChannel getOrCreateChannel(String theChannelName, int theConcurrentConsumers, IChannelSettings theChannelSettings) {
        String channelName = this.myChannelNamer.getChannelName(theChannelName, theChannelSettings);
        return this.myChannels.computeIfAbsent(channelName, t -> this.buildLinkedBlockingChannel(theConcurrentConsumers, channelName));
    }

    @Nonnull
    private LinkedBlockingChannel buildLinkedBlockingChannel(int theConcurrentConsumers, String theChannelName) {
        String threadNamePrefix = theChannelName + "-";
        ThreadPoolTaskExecutor threadPoolExecutor = ThreadPoolUtil.newThreadPool(theConcurrentConsumers, theConcurrentConsumers, threadNamePrefix, 1000);
        return new LinkedBlockingChannel(theChannelName, (Executor)threadPoolExecutor, () -> ((ThreadPoolTaskExecutor)threadPoolExecutor).getQueueSize());
    }

    @PreDestroy
    public void stop() {
        this.myChannels.clear();
    }
}

