/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.impl;

import ca.uhn.fhir.jpa.subscription.channel.api.IChannelProducer;
import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import ca.uhn.fhir.jpa.subscription.channel.impl.RetryingMessageHandlerWrapper;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ExecutorSubscribableChannel;

public class LinkedBlockingChannel
extends ExecutorSubscribableChannel
implements IChannelProducer,
IChannelReceiver {
    private final String myName;
    private final Supplier<Integer> myQueueSizeSupplier;

    public LinkedBlockingChannel(String theName, Executor theExecutor, Supplier<Integer> theQueueSizeSupplier) {
        super(theExecutor);
        this.myName = theName;
        this.myQueueSizeSupplier = theQueueSizeSupplier;
    }

    public int getQueueSizeForUnitTest() {
        return (Integer)ObjectUtils.defaultIfNull((Object)this.myQueueSizeSupplier.get(), (Object)0);
    }

    public void clearInterceptorsForUnitTest() {
        this.setInterceptors(new ArrayList());
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public boolean hasSubscription(@Nonnull MessageHandler handler) {
        return this.getSubscribers().stream().map(t -> (RetryingMessageHandlerWrapper)t).anyMatch(t -> t.getWrappedHandler() == handler);
    }

    public boolean subscribe(@Nonnull MessageHandler theHandler) {
        return super.subscribe((MessageHandler)new RetryingMessageHandlerWrapper(theHandler, this.getName()));
    }

    public boolean unsubscribe(@Nonnull MessageHandler handler) {
        Optional<RetryingMessageHandlerWrapper> match = this.getSubscribers().stream().map(t -> (RetryingMessageHandlerWrapper)t).filter(t -> t.getWrappedHandler() == handler).findFirst();
        match.ifPresent(x$0 -> super.unsubscribe(x$0));
        return match.isPresent();
    }

    public void destroy() {
    }

    public static LinkedBlockingChannel newSynchronous(String theName) {
        return new LinkedBlockingChannel(theName, null, () -> 0);
    }
}

