/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.searchparam.submit.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.registry.SearchParameterCanonicalizer;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

@Interceptor
public class SearchParamValidatingInterceptor {
    public static final String SEARCH_PARAM = "SearchParameter";
    private FhirContext myFhirContext;
    private SearchParameterCanonicalizer mySearchParameterCanonicalizer;
    private DaoRegistry myDaoRegistry;
    private IIdHelperService myIdHelperService;

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    public void resourcePreCreate(IBaseResource theResource, RequestDetails theRequestDetails) {
        this.validateSearchParamOnCreate(theResource, theRequestDetails);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    public void resourcePreUpdate(IBaseResource theOldResource, IBaseResource theNewResource, RequestDetails theRequestDetails) {
        this.validateSearchParamOnUpdate(theNewResource, theRequestDetails);
    }

    public void validateSearchParamOnCreate(IBaseResource theResource, RequestDetails theRequestDetails) {
        if (this.isNotSearchParameterResource(theResource)) {
            return;
        }
        RuntimeSearchParam runtimeSearchParam = this.mySearchParameterCanonicalizer.canonicalizeSearchParameter(theResource);
        if (runtimeSearchParam == null) {
            return;
        }
        this.validateSearchParamOnCreateAndUpdate(runtimeSearchParam);
        SearchParameterMap searchParameterMap = this.extractSearchParameterMap(runtimeSearchParam);
        if (searchParameterMap != null) {
            this.validateStandardSpOnCreate(theRequestDetails, searchParameterMap);
        }
    }

    private void validateSearchParamOnCreateAndUpdate(RuntimeSearchParam theRuntimeSearchParam) {
        List refChainExtensions = theRuntimeSearchParam.getExtensions("https://smilecdr.com/fhir/ns/StructureDefinition/searchparameter-uplift-refchain");
        for (IBaseExtension nextExtension : refChainExtensions) {
            List codeExtensions = nextExtension.getExtension().stream().map(t -> (IBaseExtension)t).filter(t -> "code".equals(t.getUrl())).collect(Collectors.toList());
            if (codeExtensions.size() != 1) {
                throw new UnprocessableEntityException(Msg.code((int)2283) + "Extension with URL https://smilecdr.com/fhir/ns/StructureDefinition/searchparameter-uplift-refchain must have exactly one child extension with URL code");
            }
            if (((IBaseExtension)codeExtensions.get(0)).getValue() != null && "code".equals(this.myFhirContext.getElementDefinition(((IBaseExtension)codeExtensions.get(0)).getValue().getClass()).getName())) continue;
            throw new UnprocessableEntityException(Msg.code((int)2284) + "Extension with URL code must have a value of type 'code'");
        }
    }

    private void validateStandardSpOnCreate(RequestDetails theRequestDetails, SearchParameterMap searchParameterMap) {
        List persistedIdList = this.getDao().searchForIds(searchParameterMap, theRequestDetails);
        if (CollectionUtils.isNotEmpty(persistedIdList)) {
            throw new UnprocessableEntityException(Msg.code((int)2196) + "Can't process submitted SearchParameter as it is overlapping an existing one.");
        }
    }

    public void validateSearchParamOnUpdate(IBaseResource theResource, RequestDetails theRequestDetails) {
        if (this.isNotSearchParameterResource(theResource)) {
            return;
        }
        RuntimeSearchParam runtimeSearchParam = this.mySearchParameterCanonicalizer.canonicalizeSearchParameter(theResource);
        if (runtimeSearchParam == null) {
            return;
        }
        this.validateSearchParamOnCreateAndUpdate(runtimeSearchParam);
        SearchParameterMap searchParameterMap = this.extractSearchParameterMap(runtimeSearchParam);
        if (searchParameterMap != null) {
            this.validateStandardSpOnUpdate(theRequestDetails, runtimeSearchParam, searchParameterMap);
        }
    }

    private boolean isNewSearchParam(RuntimeSearchParam theSearchParam, Set<String> theExistingIds) {
        return theExistingIds.stream().noneMatch(resId -> resId.substring(resId.indexOf("/") + 1).equals(theSearchParam.getId().getIdPart()));
    }

    private void validateStandardSpOnUpdate(RequestDetails theRequestDetails, RuntimeSearchParam runtimeSearchParam, SearchParameterMap searchParameterMap) {
        Set<String> resolvedResourceIds;
        List pidList = this.getDao().searchForIds(searchParameterMap, theRequestDetails);
        if (CollectionUtils.isNotEmpty(pidList) && this.isNewSearchParam(runtimeSearchParam, resolvedResourceIds = this.myIdHelperService.translatePidsToFhirResourceIds(new HashSet(pidList)))) {
            this.throwDuplicateError();
        }
    }

    private void throwDuplicateError() {
        throw new UnprocessableEntityException(Msg.code((int)2125) + "Can't process submitted SearchParameter as it is overlapping an existing one.");
    }

    private boolean isNotSearchParameterResource(IBaseResource theResource) {
        return !SEARCH_PARAM.equalsIgnoreCase(this.myFhirContext.getResourceType(theResource));
    }

    @Nullable
    private SearchParameterMap extractSearchParameterMap(RuntimeSearchParam theRuntimeSearchParam) {
        SearchParameterMap retVal = new SearchParameterMap();
        String code = theRuntimeSearchParam.getName();
        List<String> theBases = List.copyOf(theRuntimeSearchParam.getBase());
        if (StringUtils.isBlank((CharSequence)code) || theBases.isEmpty()) {
            return null;
        }
        TokenAndListParam codeParam = new TokenAndListParam().addAnd(new TokenParam[]{new TokenParam(code)});
        TokenAndListParam basesParam = this.toTokenAndList(theBases);
        retVal.add("code", (IQueryParameterAnd)codeParam);
        retVal.add("base", (IQueryParameterAnd)basesParam);
        return retVal;
    }

    @Autowired
    public void setFhirContext(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    @Autowired
    public void setSearchParameterCanonicalizer(SearchParameterCanonicalizer theSearchParameterCanonicalizer) {
        this.mySearchParameterCanonicalizer = theSearchParameterCanonicalizer;
    }

    @Autowired
    public void setDaoRegistry(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    @Autowired
    public void setIIDHelperService(IIdHelperService theIdHelperService) {
        this.myIdHelperService = theIdHelperService;
    }

    private IFhirResourceDao getDao() {
        return this.myDaoRegistry.getResourceDao(SEARCH_PARAM);
    }

    private TokenAndListParam toTokenAndList(List<String> theBases) {
        TokenAndListParam retVal = new TokenAndListParam();
        if (theBases != null) {
            TokenOrListParam tokenOrListParam = new TokenOrListParam();
            retVal.addAnd(tokenOrListParam);
            for (String next : theBases) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                tokenOrListParam.addOr(new TokenParam(next));
            }
        }
        if (retVal.getValuesAsQueryTokens().isEmpty()) {
            return null;
        }
        return retVal;
    }
}

