/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.partition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.ReadPartitionIdRequestDetails;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseRequestPartitionHelperSvc
implements IRequestPartitionHelperSvc {
    private final HashSet<Object> myNonPartitionableResourceNames = new HashSet();
    @Autowired
    protected FhirContext myFhirContext;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private PartitionSettings myPartitionSettings;

    public BaseRequestPartitionHelperSvc() {
        this.myNonPartitionableResourceNames.add("SearchParameter");
        this.myNonPartitionableResourceNames.add("StructureDefinition");
        this.myNonPartitionableResourceNames.add("Questionnaire");
        this.myNonPartitionableResourceNames.add("CapabilityStatement");
        this.myNonPartitionableResourceNames.add("CompartmentDefinition");
        this.myNonPartitionableResourceNames.add("OperationDefinition");
        this.myNonPartitionableResourceNames.add("Library");
        this.myNonPartitionableResourceNames.add("ConceptMap");
        this.myNonPartitionableResourceNames.add("CodeSystem");
        this.myNonPartitionableResourceNames.add("ValueSet");
        this.myNonPartitionableResourceNames.add("NamingSystem");
        this.myNonPartitionableResourceNames.add("StructureMap");
    }

    @Nonnull
    public RequestPartitionId determineReadPartitionForRequest(@Nullable RequestDetails theRequest, ReadPartitionIdRequestDetails theDetails) {
        boolean nonPartitionableResource;
        String resourceType = theDetails != null ? theDetails.getResourceType() : null;
        boolean bl = nonPartitionableResource = !this.isResourcePartitionable(resourceType);
        if (this.myPartitionSettings.isPartitioningEnabled()) {
            RequestPartitionId requestPartitionId;
            RequestDetails requestDetails = theRequest;
            if (requestDetails == null) {
                requestDetails = new SystemRequestDetails();
            }
            if (requestDetails instanceof SystemRequestDetails && this.systemRequestHasExplicitPartition((SystemRequestDetails)requestDetails) && !nonPartitionableResource) {
                requestPartitionId = this.getSystemRequestPartitionId((SystemRequestDetails)requestDetails, nonPartitionableResource);
            } else {
                if (requestDetails instanceof SystemRequestDetails && nonPartitionableResource) {
                    return RequestPartitionId.fromPartitionId((Integer)this.myPartitionSettings.getDefaultPartitionId());
                }
                if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)requestDetails)) {
                    HookParams params = new HookParams().add(RequestDetails.class, (Object)requestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)requestDetails);
                    requestPartitionId = (RequestPartitionId)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)requestDetails, (Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY, (HookParams)params);
                } else if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_READ, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)requestDetails)) {
                    HookParams params = new HookParams().add(RequestDetails.class, (Object)requestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)requestDetails).add(ReadPartitionIdRequestDetails.class, (Object)theDetails);
                    requestPartitionId = (RequestPartitionId)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)requestDetails, (Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_READ, (HookParams)params);
                } else {
                    requestPartitionId = null;
                }
            }
            this.validateRequestPartitionNotNull(requestPartitionId, Pointcut.STORAGE_PARTITION_IDENTIFY_READ);
            return this.validateNormalizeAndNotifyHooksForRead(requestPartitionId, requestDetails, resourceType);
        }
        return RequestPartitionId.allPartitions();
    }

    public RequestPartitionId determineGenericPartitionForRequest(RequestDetails theRequestDetails) {
        HookParams params;
        RequestPartitionId retVal = null;
        if (this.myPartitionSettings.isPartitioningEnabled() && theRequestDetails instanceof SystemRequestDetails) {
            SystemRequestDetails systemRequestDetails = (SystemRequestDetails)theRequestDetails;
            retVal = systemRequestDetails.getRequestPartitionId();
        }
        if (retVal == null && CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails) && (retVal = (RequestPartitionId)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY, (HookParams)(params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails)))) != null) {
            retVal = this.validateNormalizeAndNotifyHooksForRead(retVal, theRequestDetails, null);
        }
        return retVal;
    }

    private RequestPartitionId getSystemRequestPartitionId(SystemRequestDetails theRequest, boolean theNonPartitionableResource) {
        RequestPartitionId requestPartitionId = this.getSystemRequestPartitionId(theRequest);
        if (theNonPartitionableResource && !requestPartitionId.isDefaultPartition()) {
            throw new InternalErrorException(Msg.code((int)1315) + "System call is attempting to write a non-partitionable resource to a partition! This is a bug!");
        }
        return requestPartitionId;
    }

    @Nonnull
    private RequestPartitionId getSystemRequestPartitionId(@Nonnull SystemRequestDetails theRequest) {
        if (theRequest.getRequestPartitionId() != null) {
            return theRequest.getRequestPartitionId();
        }
        if (theRequest.getTenantId() != null) {
            return RequestPartitionId.fromPartitionName((String)theRequest.getTenantId());
        }
        return RequestPartitionId.defaultPartition();
    }

    @Nonnull
    public RequestPartitionId determineCreatePartitionForRequest(@Nullable RequestDetails theRequest, @Nonnull IBaseResource theResource, @Nonnull String theResourceType) {
        RequestPartitionId requestPartitionId;
        if (!this.myPartitionSettings.isPartitioningEnabled()) {
            return RequestPartitionId.allPartitions();
        }
        boolean nonPartitionableResource = this.myNonPartitionableResourceNames.contains(theResourceType);
        if ((theRequest == null || theRequest instanceof SystemRequestDetails) && nonPartitionableResource) {
            return RequestPartitionId.defaultPartition();
        }
        if (theRequest instanceof SystemRequestDetails && this.systemRequestHasExplicitPartition((SystemRequestDetails)theRequest)) {
            requestPartitionId = this.getSystemRequestPartitionId((SystemRequestDetails)theRequest, nonPartitionableResource);
        } else {
            HookParams params;
            if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest)) {
                params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                requestPartitionId = (RequestPartitionId)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_ANY, (HookParams)params);
            } else {
                params = new HookParams().add(IBaseResource.class, (Object)theResource).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
                requestPartitionId = (RequestPartitionId)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE, (HookParams)params);
            }
            if (nonPartitionableResource && requestPartitionId == null) {
                requestPartitionId = RequestPartitionId.defaultPartition();
            }
        }
        String resourceName = this.myFhirContext.getResourceType(theResource);
        this.validateSinglePartitionForCreate(requestPartitionId, resourceName, Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE);
        return this.validateNormalizeAndNotifyHooksForRead(requestPartitionId, theRequest, theResourceType);
    }

    private boolean systemRequestHasExplicitPartition(@Nonnull SystemRequestDetails theRequest) {
        return theRequest.getRequestPartitionId() != null || theRequest.getTenantId() != null;
    }

    @Nonnull
    public Set<Integer> toReadPartitions(@Nonnull RequestPartitionId theRequestPartitionId) {
        return theRequestPartitionId.getPartitionIds().stream().map(t -> t == null ? this.myPartitionSettings.getDefaultPartitionId() : t).collect(Collectors.toSet());
    }

    @Nonnull
    private RequestPartitionId validateNormalizeAndNotifyHooksForRead(@Nonnull RequestPartitionId theRequestPartitionId, RequestDetails theRequest, @Nullable String theResourceType) {
        RequestPartitionId retVal = theRequestPartitionId;
        if (!this.myPartitionSettings.isUnnamedPartitionMode()) {
            if (retVal.getPartitionNames() != null) {
                retVal = this.validateAndNormalizePartitionNames(retVal);
            } else if (retVal.hasPartitionIds()) {
                retVal = this.validateAndNormalizePartitionIds(retVal);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)theResourceType)) {
            this.validateHasPartitionPermissions(theRequest, theResourceType, retVal);
        }
        return retVal;
    }

    public void validateHasPartitionPermissions(RequestDetails theRequest, String theResourceType, RequestPartitionId theRequestPartitionId) {
        if (this.myInterceptorBroadcaster.hasHooks((IPointcut)Pointcut.STORAGE_PARTITION_SELECTED)) {
            RuntimeResourceDefinition runtimeResourceDefinition = null;
            if (theResourceType != null) {
                runtimeResourceDefinition = this.myFhirContext.getResourceDefinition(theResourceType);
            }
            HookParams params = new HookParams().add(RequestPartitionId.class, (Object)theRequestPartitionId).add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(RuntimeResourceDefinition.class, (Object)runtimeResourceDefinition);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_PARTITION_SELECTED, (HookParams)params);
        }
    }

    public boolean isResourcePartitionable(String theResourceType) {
        return !this.myNonPartitionableResourceNames.contains(theResourceType);
    }

    protected abstract RequestPartitionId validateAndNormalizePartitionIds(RequestPartitionId var1);

    protected abstract RequestPartitionId validateAndNormalizePartitionNames(RequestPartitionId var1);

    private void validateSinglePartitionForCreate(RequestPartitionId theRequestPartitionId, @Nonnull String theResourceName, Pointcut thePointcut) {
        this.validateRequestPartitionNotNull(theRequestPartitionId, thePointcut);
        if (theRequestPartitionId.hasPartitionIds()) {
            this.validateSinglePartitionIdOrNameForCreate(theRequestPartitionId.getPartitionIds());
        }
        this.validateSinglePartitionIdOrNameForCreate(theRequestPartitionId.getPartitionNames());
        if ((theRequestPartitionId.hasPartitionIds() && !theRequestPartitionId.getPartitionIds().contains(null) || theRequestPartitionId.hasPartitionNames() && !theRequestPartitionId.getPartitionNames().contains("DEFAULT")) && !this.isResourcePartitionable(theResourceName)) {
            String msg = this.myFhirContext.getLocalizer().getMessageSanitized(BaseRequestPartitionHelperSvc.class, "nonDefaultPartitionSelectedForNonPartitionable", new Object[]{theResourceName});
            throw new UnprocessableEntityException(Msg.code((int)1318) + msg);
        }
    }

    private void validateRequestPartitionNotNull(RequestPartitionId theRequestPartitionId, Pointcut theThePointcut) {
        if (theRequestPartitionId == null) {
            throw new InternalErrorException(Msg.code((int)1319) + "No interceptor provided a value for pointcut: " + theThePointcut);
        }
    }

    private void validateSinglePartitionIdOrNameForCreate(@Nullable List<?> thePartitionIds) {
        if (thePartitionIds != null && thePartitionIds.size() != 1) {
            throw new InternalErrorException(Msg.code((int)1320) + "RequestPartitionId must contain a single partition for create operations, found: " + thePartitionIds);
        }
    }
}

