/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.api.model.ResourceVersionConflictResolutionStrategy;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import org.apache.commons.lang3.Validate;

@Interceptor
public class UserRequestRetryVersionConflictsInterceptor {
    @Deprecated
    public static final String HEADER_NAME = "X-Retry-On-Version-Conflict";
    @Deprecated
    public static final String MAX_RETRIES = "max-retries";
    @Deprecated
    public static final String RETRY = "retry";

    @Hook(value=Pointcut.STORAGE_VERSION_CONFLICT, order=100)
    public ResourceVersionConflictResolutionStrategy check(RequestDetails theRequestDetails) {
        boolean shouldSetRetries;
        ResourceVersionConflictResolutionStrategy retVal = new ResourceVersionConflictResolutionStrategy();
        boolean bl = shouldSetRetries = theRequestDetails != null && theRequestDetails.isRetry();
        if (shouldSetRetries) {
            retVal.setRetry(true);
            int maxRetries = Math.min(100, theRequestDetails.getMaxRetries());
            retVal.setMaxRetries(maxRetries);
        }
        return retVal;
    }

    public static void addRetryHeader(SystemRequestDetails theRequestDetails, int theMaxRetries) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)theMaxRetries, (String)"Max retries must be > 0");
        theRequestDetails.setRetry(true);
        theRequestDetails.setMaxRetries(theMaxRetries);
    }
}

