/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.delete;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.model.DeleteConflict;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IIdType;

public final class DeleteConflictUtil {
    private DeleteConflictUtil() {
    }

    public static void validateDeleteConflictsEmptyOrThrowException(FhirContext theFhirContext, DeleteConflictList theDeleteConflicts) {
        IBaseOperationOutcome oo = null;
        String firstMsg = null;
        for (DeleteConflict next : theDeleteConflicts) {
            if (theDeleteConflicts.isResourceIdToIgnoreConflict((IIdType)next.getTargetId())) continue;
            String msg = "Unable to delete " + next.getTargetId().toUnqualifiedVersionless().getValue() + " because at least one resource has a reference to this resource. First reference found was resource " + next.getSourceId().toUnqualifiedVersionless().getValue() + " in path " + next.getSourcePath();
            if (firstMsg == null) {
                firstMsg = msg;
                oo = OperationOutcomeUtil.newInstance((FhirContext)theFhirContext);
            }
            OperationOutcomeUtil.addIssue((FhirContext)theFhirContext, (IBaseOperationOutcome)oo, (String)"error", (String)msg, null, (String)"processing");
        }
        if (firstMsg == null) {
            return;
        }
        throw new ResourceVersionConflictException(Msg.code((int)515) + firstMsg, oo);
    }
}

