/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.SearchParameter;

public class SearchParameterDaoValidator {
    private static final Pattern REGEX_SP_EXPRESSION_HAS_PATH = Pattern.compile("[( ]*([A-Z][a-zA-Z]+\\.)?[a-z].*");
    private final FhirContext myFhirContext;
    private final JpaStorageSettings myStorageSettings;
    private final ISearchParamRegistry mySearchParamRegistry;

    public SearchParameterDaoValidator(FhirContext theContext, JpaStorageSettings theStorageSettings, ISearchParamRegistry theSearchParamRegistry) {
        this.myFhirContext = theContext;
        this.myStorageSettings = theStorageSettings;
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    public void validate(SearchParameter searchParameter) {
        if (!this.myStorageSettings.isDefaultSearchParamsCanBeOverridden()) {
            for (IPrimitiveType nextBaseType : searchParameter.getBase()) {
                boolean isBuiltIn;
                String nextBase = nextBaseType.getValueAsString();
                RuntimeSearchParam existingSearchParam = this.mySearchParamRegistry.getActiveSearchParam(nextBase, searchParameter.getCode());
                if (existingSearchParam == null) continue;
                boolean bl = isBuiltIn = existingSearchParam.getId() == null;
                if (!(isBuiltIn |= existingSearchParam.getUri().startsWith("http://hl7.org/fhir/SearchParameter/"))) continue;
                throw new UnprocessableEntityException(Msg.code((int)1111) + "Can not override built-in search parameter " + nextBase + ":" + searchParameter.getCode() + " because overriding is disabled on this server");
            }
        }
        if (searchParameter.getStatus() == null) {
            throw new UnprocessableEntityException(Msg.code((int)1112) + "SearchParameter.status is missing or invalid");
        }
        if (!searchParameter.getStatus().name().equals("ACTIVE")) {
            return;
        }
        if (this.isCompositeWithoutBase(searchParameter)) {
            throw new UnprocessableEntityException(Msg.code((int)1113) + "SearchParameter.base is missing");
        }
        if (!this.isCompositeWithoutExpression(searchParameter)) {
            if (StringUtils.isBlank((CharSequence)searchParameter.getExpression())) {
                throw new UnprocessableEntityException(Msg.code((int)1114) + "SearchParameter.expression is missing");
            }
            FhirVersionEnum fhirVersion = this.myFhirContext.getVersion().getVersion();
            if (!fhirVersion.isOlderThan(FhirVersionEnum.DSTU3)) {
                this.maybeValidateCompositeSpForUniqueIndexing(searchParameter);
                this.maybeValidateSearchParameterExpressionsOnSave(searchParameter);
                this.maybeValidateCompositeWithComponent(searchParameter);
            }
        }
    }

    private boolean isCompositeSp(SearchParameter theSearchParameter) {
        return theSearchParameter.getType() != null && theSearchParameter.getType().equals((Object)Enumerations.SearchParamType.COMPOSITE);
    }

    private boolean isCompositeWithoutBase(SearchParameter searchParameter) {
        return ElementUtil.isEmpty((List)searchParameter.getBase()) && ElementUtil.isEmpty((List)searchParameter.getExtensionsByUrl("http://hl7.org/fhir/tools/CustomBaseResource")) && !this.isCompositeSp(searchParameter);
    }

    private boolean isCompositeWithoutExpression(SearchParameter searchParameter) {
        return this.isCompositeSp(searchParameter) && StringUtils.isBlank((CharSequence)searchParameter.getExpression());
    }

    private boolean isCompositeWithComponent(SearchParameter theSearchParameter) {
        return this.isCompositeSp(theSearchParameter) && theSearchParameter.hasComponent();
    }

    private boolean isCompositeSpForUniqueIndexing(SearchParameter theSearchParameter) {
        return this.isCompositeSp(theSearchParameter) && this.hasAnyExtensionUniqueSetTo(theSearchParameter, true);
    }

    private void maybeValidateCompositeSpForUniqueIndexing(SearchParameter theSearchParameter) {
        if (this.isCompositeSpForUniqueIndexing(theSearchParameter)) {
            if (!theSearchParameter.hasComponent()) {
                throw new UnprocessableEntityException(Msg.code((int)1115) + "SearchParameter is marked as unique but has no components");
            }
            for (SearchParameter.SearchParameterComponentComponent next : theSearchParameter.getComponent()) {
                if (!StringUtils.isBlank((CharSequence)next.getDefinition())) continue;
                throw new UnprocessableEntityException(Msg.code((int)1116) + "SearchParameter is marked as unique but is missing component.definition");
            }
        }
    }

    private void maybeValidateSearchParameterExpressionsOnSave(SearchParameter theSearchParameter) {
        if (this.myStorageSettings.isValidateSearchParameterExpressionsOnSave()) {
            this.validateExpressionPath(theSearchParameter);
            this.validateExpressionIsParsable(theSearchParameter);
        }
    }

    private void validateExpressionPath(SearchParameter theSearchParameter) {
        String expression = this.getExpression(theSearchParameter);
        boolean isResourceOfTypeComposite = theSearchParameter.getType() == Enumerations.SearchParamType.COMPOSITE;
        boolean isResourceOfTypeSpecial = theSearchParameter.getType() == Enumerations.SearchParamType.SPECIAL;
        boolean expressionHasPath = REGEX_SP_EXPRESSION_HAS_PATH.matcher(expression).matches();
        boolean isUnique = this.hasAnyExtensionUniqueSetTo(theSearchParameter, true);
        if (!(isUnique || isResourceOfTypeComposite || isResourceOfTypeSpecial || expressionHasPath)) {
            throw new UnprocessableEntityException(Msg.code((int)1120) + "SearchParameter.expression value \"" + expression + "\" is invalid due to missing/incorrect path");
        }
    }

    private void validateExpressionIsParsable(SearchParameter theSearchParameter) {
        String expression = this.getExpression(theSearchParameter);
        try {
            this.myFhirContext.newFhirPath().parse(expression);
        }
        catch (Exception exception) {
            throw new UnprocessableEntityException(Msg.code((int)1121) + "Invalid FHIRPath format for SearchParameter.expression \"" + expression + "\": " + exception.getMessage());
        }
    }

    private String getExpression(SearchParameter theSearchParameter) {
        return theSearchParameter.getExpression().trim();
    }

    private boolean hasAnyExtensionUniqueSetTo(SearchParameter theSearchParameter, boolean theValue) {
        String theValueAsString = Boolean.toString(theValue);
        return theSearchParameter.getExtensionsByUrl("http://hapifhir.io/fhir/StructureDefinition/sp-unique").stream().anyMatch(t -> theValueAsString.equals(t.getValueAsPrimitive().getValueAsString()));
    }

    private void maybeValidateCompositeWithComponent(SearchParameter theSearchParameter) {
        if (this.isCompositeWithComponent(theSearchParameter)) {
            this.validateCompositeSearchParameterComponents(theSearchParameter);
        }
    }

    private void validateCompositeSearchParameterComponents(SearchParameter theSearchParameter) {
        theSearchParameter.getComponent().stream().filter(SearchParameter.SearchParameterComponentComponent::hasDefinition).map(SearchParameter.SearchParameterComponentComponent::getDefinition).filter(Objects::nonNull).map(arg_0 -> ((ISearchParamRegistry)this.mySearchParamRegistry).getActiveSearchParamByUrl(arg_0)).filter(Objects::nonNull).forEach(theRuntimeSp -> this.validateComponentSpTypeAgainstWhiteList((RuntimeSearchParam)theRuntimeSp, (Collection<RestSearchParameterTypeEnum>)this.getAllowedSearchParameterTypes(theSearchParameter)));
    }

    private void validateComponentSpTypeAgainstWhiteList(RuntimeSearchParam theRuntimeSearchParam, Collection<RestSearchParameterTypeEnum> theAllowedSearchParamTypes) {
        if (!theAllowedSearchParamTypes.contains(theRuntimeSearchParam.getParamType())) {
            throw new UnprocessableEntityException(String.format("%sInvalid component search parameter type: %s in component.definition: %s, supported types: %s", Msg.code((int)2347), theRuntimeSearchParam.getParamType().name(), theRuntimeSearchParam.getUri(), theAllowedSearchParamTypes.stream().map(Enum::name).collect(Collectors.joining(", "))));
        }
    }

    private Set<RestSearchParameterTypeEnum> getAllowedSearchParameterTypes(SearchParameter theSearchParameter) {
        if (this.hasAnyExtensionUniqueSetTo(theSearchParameter, true)) {
            return Set.of(RestSearchParameterTypeEnum.STRING, RestSearchParameterTypeEnum.TOKEN, RestSearchParameterTypeEnum.DATE, RestSearchParameterTypeEnum.QUANTITY, RestSearchParameterTypeEnum.URI, RestSearchParameterTypeEnum.NUMBER, RestSearchParameterTypeEnum.REFERENCE);
        }
        if (this.hasAnyExtensionUniqueSetTo(theSearchParameter, false) || this.myStorageSettings.isAdvancedHSearchIndexing()) {
            return Set.of(RestSearchParameterTypeEnum.STRING, RestSearchParameterTypeEnum.TOKEN, RestSearchParameterTypeEnum.DATE, RestSearchParameterTypeEnum.QUANTITY, RestSearchParameterTypeEnum.URI, RestSearchParameterTypeEnum.NUMBER);
        }
        return Set.of(RestSearchParameterTypeEnum.STRING, RestSearchParameterTypeEnum.TOKEN, RestSearchParameterTypeEnum.DATE, RestSearchParameterTypeEnum.QUANTITY);
    }
}

