/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.tx;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.util.ICallable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public interface IHapiTransactionService {
    public IExecutionBuilder withRequest(@Nullable RequestDetails var1);

    public IExecutionBuilder withSystemRequest();

    default public IExecutionBuilder withSystemRequestOnPartition(RequestPartitionId theRequestPartitionId) {
        return this.withSystemRequest().withRequestPartitionId(theRequestPartitionId);
    }

    default public IExecutionBuilder withSystemRequestOnDefaultPartition() {
        return this.withSystemRequestOnPartition(RequestPartitionId.defaultPartition());
    }

    @Deprecated(since="6.10")
    public <T> T withRequest(@Nullable RequestDetails var1, @Nullable TransactionDetails var2, @Nonnull Propagation var3, @Nonnull Isolation var4, @Nonnull ICallable<T> var5);

    public static interface IExecutionBuilder
    extends TransactionOperations {
        public IExecutionBuilder withIsolation(Isolation var1);

        public IExecutionBuilder withTransactionDetails(TransactionDetails var1);

        public IExecutionBuilder withPropagation(Propagation var1);

        public IExecutionBuilder withRequestPartitionId(RequestPartitionId var1);

        public IExecutionBuilder readOnly();

        public IExecutionBuilder onRollback(Runnable var1);

        public void execute(Runnable var1);

        public <T> T execute(Callable<T> var1);

        public <T> T execute(@Nonnull TransactionCallback<T> var1);

        default public <T> T read(Callable<T> theCallback) {
            return this.execute(theCallback);
        }

        default public <T> Stream<T> search(Callable<Stream<T>> theCallback) {
            return this.execute(theCallback);
        }

        default public <T> List<T> searchList(Callable<List<T>> theCallback) {
            return this.execute(theCallback);
        }
    }
}

