/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.tx;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.model.ResourceVersionConflictResolutionStrategy;
import ca.uhn.fhir.jpa.dao.DaoFailureUtil;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.config.PartitionSettings;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.ICallable;
import ca.uhn.fhir.util.SleepUtil;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class HapiTransactionService
implements IHapiTransactionService {
    public static final String XACT_USERDATA_KEY_RESOLVED_TAG_DEFINITIONS = HapiTransactionService.class.getName() + "_RESOLVED_TAG_DEFINITIONS";
    public static final String XACT_USERDATA_KEY_EXISTING_SEARCH_PARAMS = HapiTransactionService.class.getName() + "_EXISTING_SEARCH_PARAMS";
    private static final Logger ourLog = LoggerFactory.getLogger(HapiTransactionService.class);
    private static final ThreadLocal<RequestPartitionId> ourRequestPartitionThreadLocal = new ThreadLocal();
    private static final ThreadLocal<HapiTransactionService> ourExistingTransaction = new ThreadLocal();
    @Autowired
    protected IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    protected PlatformTransactionManager myTransactionManager;
    @Autowired
    protected IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    protected PartitionSettings myPartitionSettings;
    private Propagation myTransactionPropagationWhenChangingPartitions = Propagation.REQUIRED;
    private SleepUtil mySleepUtil = new SleepUtil();

    @VisibleForTesting
    public void setInterceptorBroadcaster(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setSleepUtil(SleepUtil theSleepUtil) {
        this.mySleepUtil = theSleepUtil;
    }

    @Override
    public IHapiTransactionService.IExecutionBuilder withRequest(@Nullable RequestDetails theRequestDetails) {
        return this.buildExecutionBuilder(theRequestDetails);
    }

    @Override
    public IHapiTransactionService.IExecutionBuilder withSystemRequest() {
        return this.buildExecutionBuilder(null);
    }

    protected IHapiTransactionService.IExecutionBuilder buildExecutionBuilder(@Nullable RequestDetails theRequestDetails) {
        return new ExecutionBuilder(theRequestDetails);
    }

    @Deprecated
    public <T> T execute(@Nullable RequestDetails theRequestDetails, @Nullable TransactionDetails theTransactionDetails, @Nonnull TransactionCallback<T> theCallback) {
        return this.execute(theRequestDetails, theTransactionDetails, theCallback, null);
    }

    @Deprecated
    public void execute(@Nullable RequestDetails theRequestDetails, @Nullable TransactionDetails theTransactionDetails, @Nonnull Propagation thePropagation, @Nonnull Isolation theIsolation, final @Nonnull Runnable theCallback) {
        TransactionCallbackWithoutResult callback = new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                theCallback.run();
            }
        };
        this.execute(theRequestDetails, theTransactionDetails, (TransactionCallback)callback, null, thePropagation, theIsolation);
    }

    @Override
    @Deprecated
    public <T> T withRequest(@Nullable RequestDetails theRequestDetails, @Nullable TransactionDetails theTransactionDetails, @Nonnull Propagation thePropagation, @Nonnull Isolation theIsolation, @Nonnull ICallable<T> theCallback) {
        TransactionCallback callback = tx -> theCallback.call();
        return this.execute(theRequestDetails, theTransactionDetails, callback, null, thePropagation, theIsolation);
    }

    @Deprecated
    public <T> T execute(@Nullable RequestDetails theRequestDetails, @Nullable TransactionDetails theTransactionDetails, @Nonnull TransactionCallback<T> theCallback, @Nullable Runnable theOnRollback) {
        return this.execute(theRequestDetails, theTransactionDetails, theCallback, theOnRollback, null, null);
    }

    @Deprecated
    public <T> T execute(@Nullable RequestDetails theRequestDetails, @Nullable TransactionDetails theTransactionDetails, @Nonnull TransactionCallback<T> theCallback, @Nullable Runnable theOnRollback, @Nullable Propagation thePropagation, @Nullable Isolation theIsolation) {
        return this.withRequest(theRequestDetails).withTransactionDetails(theTransactionDetails).withPropagation(thePropagation).withIsolation(theIsolation).onRollback(theOnRollback).execute(theCallback);
    }

    @Deprecated
    public <T> T execute(@Nullable RequestDetails theRequestDetails, @Nullable TransactionDetails theTransactionDetails, @Nonnull TransactionCallback<T> theCallback, @Nullable Runnable theOnRollback, @Nonnull Propagation thePropagation, @Nonnull Isolation theIsolation, RequestPartitionId theRequestPartitionId) {
        return this.withRequest(theRequestDetails).withTransactionDetails(theTransactionDetails).withPropagation(thePropagation).withIsolation(theIsolation).withRequestPartitionId(theRequestPartitionId).onRollback(theOnRollback).execute(theCallback);
    }

    public boolean isCustomIsolationSupported() {
        return false;
    }

    @VisibleForTesting
    public void setRequestPartitionSvcForUnitTest(IRequestPartitionHelperSvc theRequestPartitionHelperSvc) {
        this.myRequestPartitionHelperSvc = theRequestPartitionHelperSvc;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.myTransactionManager;
    }

    @VisibleForTesting
    public void setTransactionManager(PlatformTransactionManager theTransactionManager) {
        this.myTransactionManager = theTransactionManager;
    }

    @VisibleForTesting
    public void setPartitionSettingsForUnitTest(PartitionSettings thePartitionSettings) {
        this.myPartitionSettings = thePartitionSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected <T> T doExecute(ExecutionBuilder theExecutionBuilder, TransactionCallback<T> theCallback) {
        RequestPartitionId requestPartitionId = theExecutionBuilder.getEffectiveRequestPartitionId();
        RequestPartitionId previousRequestPartitionId = null;
        if (requestPartitionId != null) {
            previousRequestPartitionId = ourRequestPartitionThreadLocal.get();
            ourRequestPartitionThreadLocal.set(requestPartitionId);
        }
        if ((!this.myPartitionSettings.isPartitioningEnabled() || Objects.equals(previousRequestPartitionId, requestPartitionId)) && ourExistingTransaction.get() == this && HapiTransactionService.canReuseExistingTransaction(theExecutionBuilder)) {
            return HapiTransactionService.executeInExistingTransaction(theCallback);
        }
        HapiTransactionService previousExistingTransaction = ourExistingTransaction.get();
        try {
            ourExistingTransaction.set(this);
            if (this.myTransactionPropagationWhenChangingPartitions == Propagation.REQUIRES_NEW) {
                T t = this.executeInNewTransactionForPartitionChange(theExecutionBuilder, theCallback, requestPartitionId, previousRequestPartitionId);
                return t;
            }
            T t = this.doExecuteInTransaction(theExecutionBuilder, theCallback, requestPartitionId, previousRequestPartitionId);
            return t;
        }
        finally {
            ourExistingTransaction.set(previousExistingTransaction);
        }
    }

    @Nullable
    private <T> T executeInNewTransactionForPartitionChange(ExecutionBuilder theExecutionBuilder, TransactionCallback<T> theCallback, RequestPartitionId requestPartitionId, RequestPartitionId previousRequestPartitionId) {
        theExecutionBuilder.myPropagation = this.myTransactionPropagationWhenChangingPartitions;
        return this.doExecuteInTransaction(theExecutionBuilder, theCallback, requestPartitionId, previousRequestPartitionId);
    }

    private boolean isThrowableOrItsSubclassPresent(Throwable theThrowable, Class<? extends Throwable> theClass) {
        return ExceptionUtils.indexOfType((Throwable)theThrowable, theClass) != -1;
    }

    private boolean isThrowablePresent(Throwable theThrowable, Class<? extends Throwable> theClass) {
        return ExceptionUtils.indexOfThrowable((Throwable)theThrowable, theClass) != -1;
    }

    private boolean isRetriable(Throwable theThrowable) {
        return this.isThrowablePresent(theThrowable, ResourceVersionConflictException.class) || this.isThrowablePresent(theThrowable, DataIntegrityViolationException.class) || this.isThrowablePresent(theThrowable, ConstraintViolationException.class) || this.isThrowablePresent(theThrowable, ObjectOptimisticLockingFailureException.class) || this.isThrowableOrItsSubclassPresent(theThrowable, PessimisticLockingFailureException.class);
    }

    @Nullable
    private <T> T doExecuteInTransaction(ExecutionBuilder theExecutionBuilder, TransactionCallback<T> theCallback, RequestPartitionId requestPartitionId, RequestPartitionId previousRequestPartitionId) {
        try {
            int i = 0;
            while (true) {
                T t;
                try {
                    t = this.doExecuteCallback(theExecutionBuilder, theCallback);
                }
                catch (Exception e) {
                    HookParams params;
                    ResourceVersionConflictResolutionStrategy conflictResolutionStrategy;
                    if (!this.isRetriable(e)) {
                        ourLog.debug("Unexpected transaction exception. Will not be retried.", (Throwable)e);
                        throw e;
                    }
                    ourLog.debug("Version conflict detected", (Throwable)e);
                    if (theExecutionBuilder.myOnRollback != null) {
                        theExecutionBuilder.myOnRollback.run();
                    }
                    int maxRetries = 0;
                    if (DaoFailureUtil.isTagStorageFailure(e)) {
                        maxRetries = 3;
                    }
                    if (maxRetries == 0 && (conflictResolutionStrategy = (ResourceVersionConflictResolutionStrategy)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theExecutionBuilder.myRequestDetails, (Pointcut)Pointcut.STORAGE_VERSION_CONFLICT, (HookParams)(params = new HookParams().add(RequestDetails.class, (Object)theExecutionBuilder.myRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theExecutionBuilder.myRequestDetails)))) != null && conflictResolutionStrategy.isRetry()) {
                        maxRetries = conflictResolutionStrategy.getMaxRetries();
                    }
                    if (i < maxRetries) {
                        if (theExecutionBuilder.myTransactionDetails != null) {
                            theExecutionBuilder.myTransactionDetails.getRollbackUndoActions().forEach(Runnable::run);
                            theExecutionBuilder.myTransactionDetails.clearRollbackUndoActions();
                            theExecutionBuilder.myTransactionDetails.clearResolvedItems();
                            theExecutionBuilder.myTransactionDetails.clearUserData(XACT_USERDATA_KEY_RESOLVED_TAG_DEFINITIONS);
                            theExecutionBuilder.myTransactionDetails.clearUserData(XACT_USERDATA_KEY_EXISTING_SEARCH_PARAMS);
                        }
                    } else {
                        IBaseOperationOutcome oo = null;
                        if (e instanceof ResourceVersionConflictException) {
                            oo = ((ResourceVersionConflictException)e).getOperationOutcome();
                        }
                        if (maxRetries > 0) {
                            String msg = "Max retries (" + maxRetries + ") exceeded for version conflict: " + e.getMessage();
                            ourLog.info(msg, (Object)maxRetries);
                            throw new ResourceVersionConflictException(Msg.code((int)549) + msg);
                        }
                        throw new ResourceVersionConflictException(Msg.code((int)550) + e.getMessage(), (Throwable)e, oo);
                    }
                    double sleepAmount = 250.0 * (double)i * Math.random();
                    long sleepAmountLong = (long)sleepAmount;
                    this.mySleepUtil.sleepAtLeast(sleepAmountLong, false);
                    ourLog.info("About to start a transaction retry due to conflict or constraint error. Sleeping {}ms first.", (Object)sleepAmountLong);
                    ++i;
                    continue;
                }
                return t;
            }
        }
        finally {
            if (requestPartitionId != null) {
                ourRequestPartitionThreadLocal.set(previousRequestPartitionId);
            }
        }
    }

    public void setTransactionPropagationWhenChangingPartitions(Propagation theTransactionPropagationWhenChangingPartitions) {
        Validate.notNull((Object)theTransactionPropagationWhenChangingPartitions);
        this.myTransactionPropagationWhenChangingPartitions = theTransactionPropagationWhenChangingPartitions;
    }

    @Nullable
    protected <T> T doExecuteCallback(ExecutionBuilder theExecutionBuilder, TransactionCallback<T> theCallback) {
        try {
            TransactionTemplate txTemplate = new TransactionTemplate(this.myTransactionManager);
            if (theExecutionBuilder.myPropagation != null) {
                txTemplate.setPropagationBehavior(theExecutionBuilder.myPropagation.value());
            }
            if (this.isCustomIsolationSupported() && theExecutionBuilder.myIsolation != null && theExecutionBuilder.myIsolation != Isolation.DEFAULT) {
                txTemplate.setIsolationLevel(theExecutionBuilder.myIsolation.value());
            }
            if (theExecutionBuilder.myReadOnly) {
                txTemplate.setReadOnly(true);
            }
            return (T)txTemplate.execute(theCallback);
        }
        catch (MyException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalErrorException(Msg.code((int)551) + e);
        }
    }

    private static boolean canReuseExistingTransaction(ExecutionBuilder theExecutionBuilder) {
        return !(!TransactionSynchronizationManager.isActualTransactionActive() || TransactionSynchronizationManager.isCurrentTransactionReadOnly() && !theExecutionBuilder.myReadOnly || theExecutionBuilder.myPropagation != null && theExecutionBuilder.myPropagation != Propagation.REQUIRED);
    }

    @Nullable
    private static <T> T executeInExistingTransaction(@Nonnull TransactionCallback<T> theCallback) {
        return (T)theCallback.doInTransaction(null);
    }

    public static <T> T invokeCallableAndHandleAnyException(Callable<T> theTask) {
        try {
            return theTask.call();
        }
        catch (BaseServerResponseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalErrorException(Msg.code((int)2223) + e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T executeWithDefaultPartitionInContext(@Nonnull ICallable<T> theCallback) {
        RequestPartitionId previousRequestPartitionId = ourRequestPartitionThreadLocal.get();
        ourRequestPartitionThreadLocal.set(RequestPartitionId.defaultPartition());
        try {
            Object object = theCallback.call();
            return (T)object;
        }
        finally {
            ourRequestPartitionThreadLocal.set(previousRequestPartitionId);
        }
    }

    public static RequestPartitionId getRequestPartitionAssociatedWithThread() {
        return ourRequestPartitionThreadLocal.get();
    }

    public static void noTransactionAllowed() {
        Validate.isTrue((!TransactionSynchronizationManager.isActualTransactionActive() ? 1 : 0) != 0, (String)"Transaction must not be active but found an active transaction", (Object[])new Object[0]);
    }

    public static void requireTransaction() {
        Validate.isTrue((boolean)TransactionSynchronizationManager.isActualTransactionActive(), (String)"Transaction required here but no active transaction found", (Object[])new Object[0]);
    }

    protected class ExecutionBuilder
    implements IHapiTransactionService.IExecutionBuilder,
    TransactionOperations,
    Cloneable {
        private final RequestDetails myRequestDetails;
        private Isolation myIsolation;
        private Propagation myPropagation;
        private boolean myReadOnly;
        private TransactionDetails myTransactionDetails;
        private Runnable myOnRollback;
        protected RequestPartitionId myRequestPartitionId;

        protected ExecutionBuilder(RequestDetails theRequestDetails) {
            this.myRequestDetails = theRequestDetails;
        }

        @Override
        public ExecutionBuilder withIsolation(Isolation theIsolation) {
            assert (this.myIsolation == null);
            this.myIsolation = theIsolation;
            return this;
        }

        @Override
        public ExecutionBuilder withTransactionDetails(TransactionDetails theTransactionDetails) {
            assert (this.myTransactionDetails == null);
            this.myTransactionDetails = theTransactionDetails;
            return this;
        }

        @Override
        public ExecutionBuilder withPropagation(Propagation thePropagation) {
            assert (this.myPropagation == null);
            this.myPropagation = thePropagation;
            return this;
        }

        @Override
        public ExecutionBuilder withRequestPartitionId(RequestPartitionId theRequestPartitionId) {
            assert (this.myRequestPartitionId == null);
            this.myRequestPartitionId = theRequestPartitionId;
            return this;
        }

        @Override
        public ExecutionBuilder readOnly() {
            this.myReadOnly = true;
            return this;
        }

        @Override
        public ExecutionBuilder onRollback(Runnable theOnRollback) {
            assert (this.myOnRollback == null);
            this.myOnRollback = theOnRollback;
            return this;
        }

        @Override
        public void execute(Runnable theTask) {
            TransactionCallback task = tx -> {
                theTask.run();
                return null;
            };
            this.execute(task);
        }

        @Override
        public <T> T execute(Callable<T> theTask) {
            TransactionCallback callback = tx -> HapiTransactionService.invokeCallableAndHandleAnyException(theTask);
            return this.execute(callback);
        }

        @Override
        public <T> T execute(@Nonnull TransactionCallback<T> callback) {
            assert (callback != null);
            return HapiTransactionService.this.doExecute(this, callback);
        }

        @VisibleForTesting
        public RequestPartitionId getRequestPartitionIdForTesting() {
            return this.myRequestPartitionId;
        }

        @VisibleForTesting
        public RequestDetails getRequestDetailsForTesting() {
            return this.myRequestDetails;
        }

        public Propagation getPropagation() {
            return this.myPropagation;
        }

        @Nullable
        protected RequestPartitionId getEffectiveRequestPartitionId() {
            Object requestPartitionId = this.myRequestPartitionId != null ? this.myRequestPartitionId : (this.myRequestDetails != null ? HapiTransactionService.this.myRequestPartitionHelperSvc.determineGenericPartitionForRequest(this.myRequestDetails) : null);
            return requestPartitionId;
        }
    }

    static class MyException
    extends RuntimeException {
        public MyException(Throwable theThrowable) {
            super(theThrowable);
        }
    }
}

