/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao.index;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.JpaStorageSettings;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.svc.IIdHelperService;
import ca.uhn.fhir.jpa.dao.tx.IHapiTransactionService;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.cross.IResourceLookup;
import ca.uhn.fhir.jpa.searchparam.extractor.IResourceLinkResolver;
import ca.uhn.fhir.jpa.searchparam.extractor.PathAndRef;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.util.CanonicalIdentifier;
import ca.uhn.fhir.util.TerserUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DaoResourceLinkResolver<T extends IResourcePersistentId>
implements IResourceLinkResolver {
    private static final Logger ourLog = LoggerFactory.getLogger(DaoResourceLinkResolver.class);
    @Autowired
    private JpaStorageSettings myStorageSettings;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private IIdHelperService<T> myIdHelperService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private ISearchParamRegistry mySearchParamRegistry;
    @Autowired
    private IHapiTransactionService myTransactionService;

    public IResourceLookup findTargetResource(@Nonnull RequestPartitionId theRequestPartitionId, String theSourceResourceName, PathAndRef thePathAndRef, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        IResourceLookup resolvedResource;
        IResourcePersistentId resolvedResourceId;
        IBaseReference targetReference = thePathAndRef.getRef();
        String sourcePath = thePathAndRef.getPath();
        IIdType targetResourceId = targetReference.getReferenceElement();
        if (targetResourceId.isEmpty() && targetReference.getResource() != null) {
            targetResourceId = targetReference.getResource().getIdElement();
        }
        String resourceType = targetResourceId.getResourceType();
        RuntimeResourceDefinition resourceDef = this.myContext.getResourceDefinition(resourceType);
        Class type = resourceDef.getImplementingClass();
        RuntimeSearchParam searchParam = this.mySearchParamRegistry.getActiveSearchParam(theSourceResourceName, thePathAndRef.getSearchParamName());
        Object persistentId = null;
        if (theTransactionDetails != null && (resolvedResourceId = theTransactionDetails.getResolvedResourceId(targetResourceId)) != null && resolvedResourceId.getId() != null && resolvedResourceId.getAssociatedResourceId() != null) {
            persistentId = resolvedResourceId;
        }
        String idPart = targetResourceId.getIdPart();
        try {
            if (persistentId == null) {
                resolvedResource = this.myIdHelperService.resolveResourceIdentity(theRequestPartitionId, resourceType, idPart);
                ourLog.trace("Translated {}/{} to resource PID {}", new Object[]{type, idPart, resolvedResource});
            } else {
                resolvedResource = new ResourceLookupPersistentIdWrapper(persistentId);
            }
        }
        catch (ResourceNotFoundException e) {
            Optional<IBasePersistedResource> createdTableOpt = this.createPlaceholderTargetIfConfiguredToDoSo(type, targetReference, idPart, theRequest, theTransactionDetails);
            if (!createdTableOpt.isPresent()) {
                if (!this.myStorageSettings.isEnforceReferentialIntegrityOnWrite()) {
                    return null;
                }
                RuntimeResourceDefinition missingResourceDef = this.myContext.getResourceDefinition(type);
                String resName = missingResourceDef.getName();
                throw new InvalidRequestException(Msg.code((int)1094) + "Resource " + resName + "/" + idPart + " not found, specified in path: " + sourcePath);
            }
            resolvedResource = (IResourceLookup)createdTableOpt.get();
        }
        ourLog.trace("Resolved resource of type {} as PID: {}", (Object)resolvedResource.getResourceType(), (Object)resolvedResource.getPersistentId());
        if (!resourceType.equals(resolvedResource.getResourceType())) {
            ourLog.error("Resource with PID {} was of type {} and wanted {}", new Object[]{resolvedResource.getPersistentId(), resourceType, resolvedResource.getResourceType()});
            throw new UnprocessableEntityException(Msg.code((int)1095) + "Resource contains reference to unknown resource ID " + targetResourceId.getValue());
        }
        if (resolvedResource.getDeleted() != null) {
            String resName = resolvedResource.getResourceType();
            throw new InvalidRequestException(Msg.code((int)1096) + "Resource " + resName + "/" + idPart + " is deleted, specified in path: " + sourcePath);
        }
        if (persistentId == null) {
            persistentId = this.myIdHelperService.newPid(resolvedResource.getPersistentId().getId());
            persistentId.setAssociatedResourceId(targetResourceId);
            if (theTransactionDetails != null) {
                theTransactionDetails.addResolvedResourceId(targetResourceId, persistentId);
            }
        }
        if (!searchParam.hasTargets() && searchParam.getTargets().contains(resourceType)) {
            return null;
        }
        return resolvedResource;
    }

    @Nullable
    public IBaseResource loadTargetResource(@Nonnull RequestPartitionId theRequestPartitionId, String theSourceResourceName, PathAndRef thePathAndRef, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        return this.myTransactionService.withRequest(theRequest).withTransactionDetails(theTransactionDetails).withRequestPartitionId(theRequestPartitionId).execute(() -> {
            IIdType targetId = thePathAndRef.getRef().getReferenceElement();
            IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(targetId.getResourceType());
            return dao.read(targetId, theRequest);
        });
    }

    public <T extends IBaseResource> Optional<IBasePersistedResource> createPlaceholderTargetIfConfiguredToDoSo(Class<T> theType, IBaseReference theReference, @Nullable String theIdToAssignToPlaceholder, RequestDetails theRequest, TransactionDetails theTransactionDetails) {
        IBasePersistedResource valueOf = null;
        if (this.myStorageSettings.isAutoCreatePlaceholderReferenceTargets()) {
            RuntimeResourceDefinition missingResourceDef = this.myContext.getResourceDefinition(theType);
            String resName = missingResourceDef.getName();
            IBaseResource newResource = (IBaseResource)missingResourceDef.newInstance();
            this.tryToAddPlaceholderExtensionToResource(newResource);
            IFhirResourceDao<IBaseResource> placeholderResourceDao = this.myDaoRegistry.getResourceDao(theType);
            ourLog.debug("Automatically creating empty placeholder resource: {}", (Object)newResource.getIdElement().getValue());
            if (this.myStorageSettings.isPopulateIdentifierInAutoCreatedPlaceholderReferenceTargets()) {
                this.tryToCopyIdentifierFromReferenceToTargetResource(theReference, missingResourceDef, newResource);
            }
            if (theIdToAssignToPlaceholder != null) {
                if (theTransactionDetails != null) {
                    String existingId = newResource.getIdElement().getValue();
                    theTransactionDetails.addRollbackUndoAction(() -> newResource.setId(existingId));
                }
                newResource.setId(resName + "/" + theIdToAssignToPlaceholder);
                valueOf = placeholderResourceDao.update(newResource, theRequest).getEntity();
            } else {
                valueOf = placeholderResourceDao.create(newResource, theRequest).getEntity();
            }
            Object persistentId = valueOf.getPersistentId();
            persistentId = this.myIdHelperService.newPid(persistentId.getId());
            persistentId.setAssociatedResourceId(valueOf.getIdDt());
            theTransactionDetails.addResolvedResourceId(persistentId.getAssociatedResourceId(), persistentId);
        }
        return Optional.ofNullable(valueOf);
    }

    private <T extends IBaseResource> void tryToAddPlaceholderExtensionToResource(T newResource) {
        if (newResource instanceof IBaseHasExtensions) {
            IBaseExtension extension = ((IBaseHasExtensions)newResource).addExtension();
            extension.setUrl("http://hapifhir.io/fhir/StructureDefinition/resource-placeholder");
            extension.setValue((IBaseDatatype)this.myContext.getPrimitiveBoolean(Boolean.valueOf(true)));
        }
    }

    private <T extends IBaseResource> void tryToCopyIdentifierFromReferenceToTargetResource(IBaseReference theSourceReference, RuntimeResourceDefinition theTargetResourceDef, T theTargetResource) {
        CanonicalIdentifier referenceMatchUrlIdentifier = this.extractIdentifierFromUrl(theSourceReference.getReferenceElement().getValue());
        CanonicalIdentifier referenceIdentifier = this.extractIdentifierReference(theSourceReference);
        if (referenceIdentifier == null && referenceMatchUrlIdentifier != null) {
            this.addMatchUrlIdentifierToTargetResource(theTargetResourceDef, theTargetResource, referenceMatchUrlIdentifier);
        } else if (referenceIdentifier != null && referenceMatchUrlIdentifier == null) {
            this.addSubjectIdentifierToTargetResource(theSourceReference, theTargetResourceDef, theTargetResource);
        } else if (referenceIdentifier != null && referenceMatchUrlIdentifier != null) {
            if (referenceIdentifier.equals((Object)referenceMatchUrlIdentifier)) {
                this.addSubjectIdentifierToTargetResource(theSourceReference, theTargetResourceDef, theTargetResource);
            } else {
                this.addSubjectIdentifierToTargetResource(theSourceReference, theTargetResourceDef, theTargetResource);
                this.addMatchUrlIdentifierToTargetResource(theTargetResourceDef, theTargetResource, referenceMatchUrlIdentifier);
            }
        }
    }

    private <T extends IBaseResource> void addSubjectIdentifierToTargetResource(IBaseReference theSourceReference, RuntimeResourceDefinition theTargetResourceDef, T theTargetResource) {
        BaseRuntimeElementDefinition identifierElement;
        String identifierElementName;
        boolean targetHasIdentifierElement;
        BaseRuntimeChildDefinition targetIdentifier = theTargetResourceDef.getChildByName("identifier");
        if (targetIdentifier != null && (targetHasIdentifierElement = (identifierElementName = (identifierElement = targetIdentifier.getChildByName("identifier")).getName()).equals("Identifier"))) {
            BaseRuntimeElementCompositeDefinition referenceElement = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(theSourceReference.getClass());
            BaseRuntimeChildDefinition referenceIdentifierChild = referenceElement.getChildByName("identifier");
            Optional identifierOpt = referenceIdentifierChild.getAccessor().getFirstValueOrNull((IBase)theSourceReference);
            identifierOpt.ifPresent(theIBase -> targetIdentifier.getMutator().addValue((IBase)theTargetResource, theIBase));
        }
    }

    private <T extends IBaseResource> void addMatchUrlIdentifierToTargetResource(RuntimeResourceDefinition theTargetResourceDef, T theTargetResource, CanonicalIdentifier referenceMatchUrlIdentifier) {
        BaseRuntimeChildDefinition identifierDefinition = theTargetResourceDef.getChildByName("identifier");
        IBase identifierIBase = identifierDefinition.getChildByName("identifier").newInstance(identifierDefinition.getInstanceConstructorArguments());
        IBase systemIBase = TerserUtil.newElement((FhirContext)this.myContext, (String)"uri", (Object)referenceMatchUrlIdentifier.getSystemElement().getValueAsString());
        IBase valueIBase = TerserUtil.newElement((FhirContext)this.myContext, (String)"string", (Object)referenceMatchUrlIdentifier.getValueElement().getValueAsString());
        BaseRuntimeElementDefinition elementDefinition = this.myContext.getElementDefinition(identifierIBase.getClass());
        BaseRuntimeChildDefinition systemDefinition = elementDefinition.getChildByName("system");
        systemDefinition.getMutator().setValue(identifierIBase, systemIBase);
        BaseRuntimeChildDefinition valueDefinition = elementDefinition.getChildByName("value");
        valueDefinition.getMutator().setValue(identifierIBase, valueIBase);
        identifierDefinition.getMutator().addValue(theTargetResource, identifierIBase);
    }

    private CanonicalIdentifier extractIdentifierReference(IBaseReference theSourceReference) {
        Optional identifier = this.myContext.newFhirPath().evaluateFirst((IBase)theSourceReference, "identifier", IBase.class);
        if (!identifier.isPresent()) {
            return null;
        }
        CanonicalIdentifier canonicalIdentifier = new CanonicalIdentifier();
        Optional system = this.myContext.newFhirPath().evaluateFirst((IBase)identifier.get(), "system", IPrimitiveType.class);
        Optional value = this.myContext.newFhirPath().evaluateFirst((IBase)identifier.get(), "value", IPrimitiveType.class);
        system.ifPresent(theIPrimitiveType -> canonicalIdentifier.setSystem(theIPrimitiveType.getValueAsString()));
        value.ifPresent(theIPrimitiveType -> canonicalIdentifier.setValue(theIPrimitiveType.getValueAsString()));
        return canonicalIdentifier;
    }

    protected CanonicalIdentifier extractIdentifierFromUrl(String theValue) {
        int identifierIndex = theValue.indexOf("identifier=");
        if (identifierIndex == -1) {
            return null;
        }
        List params = URLEncodedUtils.parse((String)theValue.substring(identifierIndex), (Charset)StandardCharsets.UTF_8, (char[])new char[]{'&', ';'});
        Optional<NameValuePair> idOptional = params.stream().filter(p -> p.getName().equals("identifier")).findFirst();
        if (!idOptional.isPresent()) {
            return null;
        }
        NameValuePair id = idOptional.get();
        String identifierString = id.getValue();
        String[] split = identifierString.split("\\|");
        if (split.length != 2) {
            throw new IllegalArgumentException(Msg.code((int)1097) + "Can't create a placeholder reference with identifier " + theValue + ". It is not a valid identifier");
        }
        CanonicalIdentifier identifier = new CanonicalIdentifier();
        identifier.setSystem(split[0]);
        identifier.setValue(split[1]);
        return identifier;
    }

    public void validateTypeOrThrowException(Class<? extends IBaseResource> theType) {
        this.myDaoRegistry.getDaoOrThrowException(theType);
    }

    private static class ResourceLookupPersistentIdWrapper<P extends IResourcePersistentId>
    implements IResourceLookup {
        private final P myPersistentId;

        public ResourceLookupPersistentIdWrapper(P thePersistentId) {
            this.myPersistentId = thePersistentId;
        }

        public String getResourceType() {
            return this.myPersistentId.getAssociatedResourceId().getResourceType();
        }

        public Date getDeleted() {
            return null;
        }

        public P getPersistentId() {
            return this.myPersistentId;
        }
    }
}

