/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.jpa.dao.IdSubstitutionMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IIdType;

public class EntriesToProcessMap {
    private final IdentityHashMap<IBase, IIdType> myEntriesToProcess = new IdentityHashMap();
    private final Map<String, IIdType> myVersionlessIdToVersionedId = new HashMap<String, IIdType>();
    private final Map<String, IBase> myVersionlessIdToResponseBundleEntry = new HashMap<String, IBase>();

    public void put(IBase theBundleEntry, IIdType theId, IBase theResponseBundleEntry) {
        this.myEntriesToProcess.put(theBundleEntry, theId);
        String key = IdSubstitutionMap.toVersionlessValue(theId);
        this.myVersionlessIdToVersionedId.put(key, theId);
        this.myVersionlessIdToResponseBundleEntry.put(key, theResponseBundleEntry);
    }

    public IIdType getIdWithVersionlessComparison(IIdType theId) {
        return this.myVersionlessIdToVersionedId.get(IdSubstitutionMap.toVersionlessValue(theId));
    }

    public IBase getResponseBundleEntryWithVersionlessComparison(IIdType theId) {
        return this.myVersionlessIdToResponseBundleEntry.get(IdSubstitutionMap.toVersionlessValue(theId));
    }

    public Set<Map.Entry<IBase, IIdType>> entrySet() {
        return this.myEntriesToProcess.entrySet();
    }
}

