/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IJpaDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.DeleteMethodOutcome;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.IStorageResourceParser;
import ca.uhn.fhir.jpa.dao.MatchResourceUrlService;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.patch.FhirPatch;
import ca.uhn.fhir.jpa.patch.JsonPatchUtils;
import ca.uhn.fhir.jpa.patch.XmlPatchUtils;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.StrictErrorHandler;
import ca.uhn.fhir.rest.api.DeleteCascadeModeEnum;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IDeleteExpungeJobSubmitter;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class BaseStorageResourceDao<T extends IBaseResource>
extends BaseStorageDao
implements IFhirResourceDao<T>,
IJpaDao<T> {
    public static final StrictErrorHandler STRICT_ERROR_HANDLER = new StrictErrorHandler();

    @Autowired
    protected abstract HapiTransactionService getTransactionService();

    @Autowired
    protected abstract MatchResourceUrlService getMatchResourceUrlService();

    @Autowired
    protected abstract IStorageResourceParser getStorageResourceParser();

    @Autowired
    protected abstract IDeleteExpungeJobSubmitter getDeleteExpungeJobSubmitter();

    @Override
    public DaoMethodOutcome patch(IIdType theId, String theConditionalUrl, PatchTypeEnum thePatchType, String thePatchBody, IBaseParameters theFhirPatchBody, RequestDetails theRequestDetails) {
        TransactionDetails transactionDetails = new TransactionDetails();
        return (DaoMethodOutcome)((Object)this.getTransactionService().execute(theRequestDetails, transactionDetails, tx -> this.patchInTransaction(theId, theConditionalUrl, true, thePatchType, thePatchBody, theFhirPatchBody, theRequestDetails, transactionDetails)));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public DaoMethodOutcome patchInTransaction(IIdType theId, String theConditionalUrl, boolean thePerformIndexing, PatchTypeEnum thePatchType, String thePatchBody, IBaseParameters theFhirPatchBody, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails) {
        IBaseResource destination;
        IIdType resourceId;
        IBasePersistedResource entityToUpdate;
        assert (TransactionSynchronizationManager.isActualTransactionActive());
        if (StringUtils.isNotBlank((CharSequence)theConditionalUrl)) {
            Set match = this.getMatchResourceUrlService().processMatchUrl(theConditionalUrl, this.getResourceType(), theTransactionDetails, theRequestDetails);
            if (match.size() > 1) {
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "transactionOperationWithMultipleMatchFailure", new Object[]{"PATCH", theConditionalUrl, match.size()});
                throw new PreconditionFailedException(Msg.code((int)972) + msg);
            }
            if (match.size() != 1) {
                String msg = this.getContext().getLocalizer().getMessageSanitized(BaseStorageDao.class, "invalidMatchUrlNoMatches", new Object[]{theConditionalUrl});
                throw new ResourceNotFoundException(Msg.code((int)973) + msg);
            }
            IResourcePersistentId pid = (IResourcePersistentId)match.iterator().next();
            entityToUpdate = this.readEntityLatestVersion(pid, theRequestDetails, theTransactionDetails);
            resourceId = entityToUpdate.getIdDt();
        } else {
            resourceId = theId;
            entityToUpdate = this.readEntityLatestVersion(theId, theRequestDetails, theTransactionDetails);
            if (theId.hasVersionIdPart() && theId.getVersionIdPartAsLong().longValue() != entityToUpdate.getVersion()) {
                throw new ResourceVersionConflictException(Msg.code((int)974) + "Version " + theId.getVersionIdPart() + " is not the most recent version of this resource, unable to apply patch");
            }
        }
        BaseStorageResourceDao.validateResourceType(entityToUpdate, this.getResourceName());
        if (entityToUpdate.isDeleted()) {
            throw this.createResourceGoneException(entityToUpdate);
        }
        IBaseResource resourceToUpdate = this.getStorageResourceParser().toResource(entityToUpdate, false);
        if (resourceToUpdate == null) {
            resourceToUpdate = theTransactionDetails.getResolvedResource(resourceId);
        }
        switch (thePatchType) {
            case JSON_PATCH: {
                destination = JsonPatchUtils.apply(this.getContext(), resourceToUpdate, thePatchBody);
                break;
            }
            case XML_PATCH: {
                destination = XmlPatchUtils.apply(this.getContext(), resourceToUpdate, thePatchBody);
                break;
            }
            default: {
                IBaseParameters fhirPatchJson = theFhirPatchBody;
                new FhirPatch(this.getContext()).apply(resourceToUpdate, (IBaseResource)fhirPatchJson);
                destination = resourceToUpdate;
            }
        }
        IBaseResource destinationCasted = destination;
        this.myFhirContext.newJsonParser().setParserErrorHandler((IParserErrorHandler)STRICT_ERROR_HANDLER).encodeResourceToString(destinationCasted);
        this.preProcessResourceForStorage(destinationCasted, theRequestDetails, theTransactionDetails, true);
        return this.doUpdateForUpdateOrPatch(theRequestDetails, resourceId, theConditionalUrl, thePerformIndexing, false, destinationCasted, entityToUpdate, RestOperationTypeEnum.PATCH, theTransactionDetails);
    }

    @Override
    @Nonnull
    public abstract Class<T> getResourceType();

    @Override
    @Nonnull
    protected abstract String getResourceName();

    protected abstract IBasePersistedResource readEntityLatestVersion(IResourcePersistentId var1, RequestDetails var2, TransactionDetails var3);

    protected abstract IBasePersistedResource readEntityLatestVersion(IIdType var1, RequestDetails var2, TransactionDetails var3);

    protected DaoMethodOutcome doUpdateForUpdateOrPatch(RequestDetails theRequest, IIdType theResourceId, String theMatchUrl, boolean thePerformIndexing, boolean theForceUpdateVersion, T theResource, IBasePersistedResource theEntity, RestOperationTypeEnum theOperationType, TransactionDetails theTransactionDetails) {
        if (theResourceId.hasVersionIdPart() && Long.parseLong(theResourceId.getVersionIdPart()) != theEntity.getVersion()) {
            throw new ResourceVersionConflictException(Msg.code((int)989) + "Trying to update " + theResourceId + " but this is not the current version");
        }
        if (theResourceId.hasResourceType() && !theResourceId.getResourceType().equals(this.getResourceName())) {
            throw new UnprocessableEntityException(Msg.code((int)990) + "Invalid resource ID[" + theEntity.getIdDt().toUnqualifiedVersionless() + "] of type[" + theEntity.getResourceType() + "] - Does not match expected [" + this.getResourceName() + "]");
        }
        IBaseResource oldResource = this.getStorageSettings().isMassIngestionMode() ? null : this.getStorageResourceParser().toResource(theEntity, false);
        boolean wasDeleted = theEntity.isDeleted();
        theEntity.setNotDeleted();
        if (!thePerformIndexing) {
            theResource.setId(theEntity.getIdDt().getValue());
            DaoMethodOutcome outcome = this.toMethodOutcome(theRequest, theEntity, (IBaseResource)theResource, theMatchUrl, theOperationType).setCreated(wasDeleted);
            outcome.setPreviousResource(oldResource);
            if (!outcome.isNop()) {
                outcome.setId(outcome.getId().withVersion(Long.toString(outcome.getId().getVersionIdPartAsLong() + 1L)));
            }
            return outcome;
        }
        return this.updateInternal(theRequest, theResource, theMatchUrl, thePerformIndexing, theForceUpdateVersion, theEntity, theResourceId, oldResource, theOperationType, theTransactionDetails);
    }

    public static void validateResourceType(IBasePersistedResource theEntity, String theResourceName) {
        if (!theResourceName.equals(theEntity.getResourceType())) {
            throw new ResourceNotFoundException(Msg.code((int)935) + "Resource with ID " + theEntity.getIdDt().getIdPart() + " exists but it is not of type " + theResourceName + ", found resource of type " + theEntity.getResourceType());
        }
    }

    protected DeleteMethodOutcome deleteExpunge(String theUrl, RequestDetails theRequest) {
        if (!this.getStorageSettings().canDeleteExpunge()) {
            throw new MethodNotAllowedException(Msg.code((int)963) + "_expunge is not enabled on this server: " + this.getStorageSettings().cannotDeleteExpungeReason());
        }
        RestfulServerUtils.DeleteCascadeDetails cascadeDelete = RestfulServerUtils.extractDeleteCascadeParameter((RequestDetails)theRequest);
        boolean cascade = false;
        Integer cascadeMaxRounds = null;
        if (cascadeDelete.getMode() == DeleteCascadeModeEnum.DELETE) {
            cascade = true;
            cascadeMaxRounds = cascadeDelete.getMaxRounds();
            if (cascadeMaxRounds == null) {
                cascadeMaxRounds = this.myStorageSettings.getMaximumDeleteConflictQueryCount();
            } else if (this.myStorageSettings.getMaximumDeleteConflictQueryCount() != null && this.myStorageSettings.getMaximumDeleteConflictQueryCount() < cascadeMaxRounds) {
                cascadeMaxRounds = this.myStorageSettings.getMaximumDeleteConflictQueryCount();
            }
        }
        List<String> urlsToDeleteExpunge = Collections.singletonList(theUrl);
        try {
            String jobId = this.getDeleteExpungeJobSubmitter().submitJob(Integer.valueOf(this.getStorageSettings().getExpungeBatchSize()), urlsToDeleteExpunge, cascade, cascadeMaxRounds, theRequest);
            return new DeleteMethodOutcome(this.createInfoOperationOutcome("Delete job submitted with id " + jobId));
        }
        catch (InvalidRequestException e) {
            throw new InvalidRequestException(Msg.code((int)965) + "Invalid Delete Expunge Request: " + e.getMessage(), (Throwable)e);
        }
    }
}

