/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binary.svc;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.binary.api.IBinaryStorageSvc;
import ca.uhn.fhir.jpa.util.RandomTextUtils;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.PayloadTooLargeException;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.util.BinaryUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseBinaryStorageSvcImpl
implements IBinaryStorageSvc {
    public static long DEFAULT_MAXIMUM_BINARY_SIZE = 0x7FFFFFFFFFFFFFFEL;
    public static String BLOB_ID_PREFIX_APPLIED = "blob-id-prefix-applied";
    private final int ID_LENGTH = 100;
    private long myMaximumBinarySize = DEFAULT_MAXIMUM_BINARY_SIZE;
    private int myMinimumBinarySize;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;

    @Override
    public long getMaximumBinarySize() {
        return this.myMaximumBinarySize;
    }

    @Override
    public void setMaximumBinarySize(long theMaximumBinarySize) {
        Validate.inclusiveBetween((long)1L, (long)DEFAULT_MAXIMUM_BINARY_SIZE, (long)theMaximumBinarySize);
        this.myMaximumBinarySize = theMaximumBinarySize;
    }

    @Override
    public int getMinimumBinarySize() {
        return this.myMinimumBinarySize;
    }

    @Override
    public void setMinimumBinarySize(int theMinimumBinarySize) {
        this.myMinimumBinarySize = theMinimumBinarySize;
    }

    @Override
    public String newBlobId() {
        return RandomTextUtils.newSecureRandomAlphaNumericString(100);
    }

    @Override
    public boolean isValidBlobId(String theNewBlobId) {
        return true;
    }

    @Override
    public boolean shouldStoreBlob(long theSize, IIdType theResourceId, String theContentType) {
        return theSize >= (long)this.getMinimumBinarySize();
    }

    @Nonnull
    protected HashingInputStream createHashingInputStream(InputStream theInputStream) {
        HashFunction hash = Hashing.sha256();
        return new HashingInputStream(hash, theInputStream);
    }

    @Nonnull
    protected CountingInputStream createCountingInputStream(InputStream theInputStream) {
        InputStream is = ByteStreams.limit((InputStream)theInputStream, (long)(this.getMaximumBinarySize() + 1L));
        return new CountingInputStream(is){

            public long getByteCount() {
                long retVal = super.getByteCount();
                if (retVal > BaseBinaryStorageSvcImpl.this.getMaximumBinarySize()) {
                    throw new PayloadTooLargeException(Msg.code((int)1343) + "Binary size exceeds maximum: " + BaseBinaryStorageSvcImpl.this.getMaximumBinarySize());
                }
                return retVal;
            }
        };
    }

    @Deprecated(since="6.6.0 - Maintained for interface backwards compatibility. Note that invokes interceptor pointcut with empty parameters", forRemoval=true)
    protected String provideIdForNewBlob(String theBlobIdOrNull) {
        return StringUtils.isNotBlank((CharSequence)theBlobIdOrNull) ? theBlobIdOrNull : this.newBlobId();
    }

    @Nonnull
    protected String provideIdForNewBlob(String theBlobIdOrNull, byte[] theBytes, RequestDetails theRequestDetails, String theContentType) {
        String blobId;
        String string = blobId = StringUtils.isNotBlank((CharSequence)theBlobIdOrNull) ? theBlobIdOrNull : this.newBlobId();
        if (this.isBlobIdPrefixApplied(theRequestDetails)) {
            return blobId;
        }
        String blobPrefixFromHooksOrNull = this.callBlobIdPointcut(theBytes, theRequestDetails, theContentType);
        String blobIdPrefixFromHooks = blobPrefixFromHooksOrNull == null ? "" : blobPrefixFromHooksOrNull;
        return blobIdPrefixFromHooks + blobId;
    }

    protected boolean isBlobIdPrefixApplied(RequestDetails theRequestDetails) {
        return theRequestDetails.getUserData().get(BLOB_ID_PREFIX_APPLIED) == Boolean.TRUE;
    }

    public static void setBlobIdPrefixApplied(RequestDetails theRequestDetails) {
        theRequestDetails.getUserData().put(BLOB_ID_PREFIX_APPLIED, true);
    }

    @Nullable
    private String callBlobIdPointcut(byte[] theBytes, RequestDetails theRequestDetails, String theContentType) {
        IBaseBinary binary = BinaryUtil.newBinary((FhirContext)this.myFhirContext).setContent(theBytes).setContentType(theContentType);
        HookParams hookParams = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).add(IBaseResource.class, (Object)binary);
        BaseBinaryStorageSvcImpl.setBlobIdPrefixApplied(theRequestDetails);
        return (String)CompositeInterceptorBroadcaster.doCallHooksAndReturnObject((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.STORAGE_BINARY_ASSIGN_BLOB_ID_PREFIX, (HookParams)hookParams);
    }

    @Override
    public byte[] fetchDataBlobFromBinary(IBaseBinary theBaseBinary) throws IOException {
        IPrimitiveType dataElement = BinaryUtil.getOrCreateData((FhirContext)this.myFhirContext, (IBaseBinary)theBaseBinary);
        byte[] value = (byte[])dataElement.getValue();
        if (value == null) {
            Optional<String> attachmentId = this.getAttachmentId((IBaseHasExtensions)dataElement);
            if (attachmentId.isPresent()) {
                value = this.fetchBlob(theBaseBinary.getIdElement(), attachmentId.get());
            } else {
                throw new InternalErrorException(Msg.code((int)1344) + "Unable to load binary blob data for " + theBaseBinary.getIdElement());
            }
        }
        return value;
    }

    private Optional<String> getAttachmentId(IBaseHasExtensions theBaseBinary) {
        return theBaseBinary.getExtension().stream().filter(t -> "http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id".equals(t.getUrl())).filter(t -> t.getValue() instanceof IPrimitiveType).map(t -> (IPrimitiveType)t.getValue()).map(IPrimitiveType::getValue).filter(StringUtils::isNotBlank).findFirst();
    }

    @VisibleForTesting
    public void setInterceptorBroadcasterForTests(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    @VisibleForTesting
    public void setFhirContextForTests(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }
}

