/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.dao;

import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.ReindexOutcome;
import ca.uhn.fhir.jpa.api.dao.ReindexParameters;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.api.model.DeleteMethodOutcome;
import ca.uhn.fhir.jpa.api.model.ExpungeOptions;
import ca.uhn.fhir.jpa.api.model.ExpungeOutcome;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.IResourcePersistentId;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.HistorySearchDateRangeParam;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IFhirResourceDao<T extends IBaseResource>
extends IDao {
    public DaoMethodOutcome create(T var1);

    public DaoMethodOutcome create(T var1, RequestDetails var2);

    public DaoMethodOutcome create(T var1, String var2);

    public DaoMethodOutcome create(T var1, String var2, boolean var3, RequestDetails var4, @Nonnull TransactionDetails var5);

    public DaoMethodOutcome create(T var1, String var2, RequestDetails var3);

    public DaoMethodOutcome delete(IIdType var1);

    public DaoMethodOutcome delete(IIdType var1, DeleteConflictList var2, RequestDetails var3, @Nonnull TransactionDetails var4);

    public DaoMethodOutcome delete(IIdType var1, RequestDetails var2);

    public DeleteMethodOutcome deleteByUrl(String var1, DeleteConflictList var2, RequestDetails var3, @Nonnull TransactionDetails var4);

    public DeleteMethodOutcome deleteByUrl(String var1, RequestDetails var2);

    default public <P extends IResourcePersistentId> DeleteMethodOutcome deletePidList(String theUrl, Collection<P> theResourceIds, DeleteConflictList theDeleteConflicts, RequestDetails theRequest) {
        return this.deletePidList(theUrl, theResourceIds, theDeleteConflicts, theRequest, new TransactionDetails());
    }

    public <P extends IResourcePersistentId> DeleteMethodOutcome deletePidList(String var1, Collection<P> var2, DeleteConflictList var3, RequestDetails var4, TransactionDetails var5);

    public ExpungeOutcome expunge(ExpungeOptions var1, RequestDetails var2);

    public ExpungeOutcome expunge(IIdType var1, ExpungeOptions var2, RequestDetails var3);

    public <P extends IResourcePersistentId> void expunge(Collection<P> var1, RequestDetails var2);

    public ExpungeOutcome forceExpungeInExistingTransaction(IIdType var1, ExpungeOptions var2, RequestDetails var3);

    @Nonnull
    public Class<T> getResourceType();

    public IBundleProvider history(Date var1, Date var2, Integer var3, RequestDetails var4);

    @Deprecated(since="6.2")
    public IBundleProvider history(IIdType var1, Date var2, Date var3, Integer var4, RequestDetails var5);

    public IBundleProvider history(IIdType var1, HistorySearchDateRangeParam var2, RequestDetails var3);

    public <MT extends IBaseMetaType> MT metaAddOperation(IIdType var1, MT var2, RequestDetails var3);

    public <MT extends IBaseMetaType> MT metaDeleteOperation(IIdType var1, MT var2, RequestDetails var3);

    public <MT extends IBaseMetaType> MT metaGetOperation(Class<MT> var1, IIdType var2, RequestDetails var3);

    public <MT extends IBaseMetaType> MT metaGetOperation(Class<MT> var1, RequestDetails var2);

    public DaoMethodOutcome patch(IIdType var1, String var2, PatchTypeEnum var3, String var4, IBaseParameters var5, RequestDetails var6);

    public DaoMethodOutcome patchInTransaction(IIdType var1, String var2, boolean var3, PatchTypeEnum var4, String var5, IBaseParameters var6, RequestDetails var7, TransactionDetails var8);

    public T read(IIdType var1);

    public T readByPid(IResourcePersistentId var1);

    default public T readByPid(IResourcePersistentId thePid, boolean theDeletedOk) {
        throw new UnsupportedOperationException(Msg.code((int)571));
    }

    public T read(IIdType var1, RequestDetails var2);

    public T read(IIdType var1, RequestDetails var2, boolean var3);

    public IBasePersistedResource readEntity(IIdType var1, RequestDetails var2);

    @Deprecated
    public void reindex(T var1, IBasePersistedResource var2);

    public ReindexOutcome reindex(IResourcePersistentId var1, ReindexParameters var2, RequestDetails var3, TransactionDetails var4);

    public void removeTag(IIdType var1, TagTypeEnum var2, String var3, String var4, RequestDetails var5);

    public void removeTag(IIdType var1, TagTypeEnum var2, String var3, String var4);

    public IBundleProvider search(SearchParameterMap var1) throws InvalidRequestException;

    public IBundleProvider search(SearchParameterMap var1, RequestDetails var2) throws InvalidRequestException;

    public IBundleProvider search(SearchParameterMap var1, RequestDetails var2, HttpServletResponse var3) throws InvalidRequestException;

    default public <PT extends IResourcePersistentId> List<PT> searchForIds(SearchParameterMap theParams, RequestDetails theRequest) {
        return this.searchForIds(theParams, theRequest, null);
    }

    default public <PT extends IResourcePersistentId> List<PT> searchForIds(SearchParameterMap theParams, RequestDetails theRequest, @Nullable IBaseResource theConditionalOperationTargetOrNull) {
        return this.searchForIds(theParams, theRequest);
    }

    default public <PID extends IResourcePersistentId<?>> Stream<PID> searchForIdStream(SearchParameterMap theParams, RequestDetails theRequest, @Nullable IBaseResource theConditionalOperationTargetOrNull) {
        List iResourcePersistentIds = this.searchForIds(theParams, theRequest);
        return iResourcePersistentIds.stream();
    }

    default public List<T> searchForResources(SearchParameterMap theParams, RequestDetails theRequest) {
        IBundleProvider provider = this.search(theParams, theRequest);
        return provider.getAllResources();
    }

    default public List<IIdType> searchForResourceIds(SearchParameterMap theParams, RequestDetails theRequest) {
        return this.searchForResources(theParams, theRequest).stream().map(IBaseResource::getIdElement).collect(Collectors.toList());
    }

    public void translateRawParameters(Map<String, List<String>> var1, SearchParameterMap var2);

    public DaoMethodOutcome update(T var1);

    public DaoMethodOutcome update(T var1, RequestDetails var2);

    public DaoMethodOutcome update(T var1, String var2);

    public DaoMethodOutcome update(T var1, String var2, boolean var3, RequestDetails var4);

    public DaoMethodOutcome update(T var1, String var2, RequestDetails var3);

    public DaoMethodOutcome update(T var1, String var2, boolean var3, boolean var4, RequestDetails var5, @Nonnull TransactionDetails var6);

    public MethodOutcome validate(T var1, IIdType var2, String var3, EncodingEnum var4, ValidationModeEnum var5, String var6, RequestDetails var7);

    public RuntimeResourceDefinition validateCriteriaAndReturnResourceDefinition(String var1);

    default public String getCurrentVersionId(IIdType theReferenceElement) {
        return this.read(theReferenceElement.toVersionless()).getIdElement().getVersionIdPart();
    }
}

