/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cache;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.cache.IResourceChangeEvent;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerCache;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerRegistry;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.searchparam.retry.Retrier;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public abstract class BaseResourceCacheSynchronizer
implements IResourceChangeListener {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseResourceCacheSynchronizer.class);
    public static final int MAX_RETRIES = 60;
    public static final long REFRESH_INTERVAL = 60000L;
    private final String myResourceName;
    @Autowired
    private IResourceChangeListenerRegistry myResourceChangeListenerRegistry;
    @Autowired
    DaoRegistry myDaoRegistry;
    private SearchParameterMap mySearchParameterMap;
    private SystemRequestDetails mySystemRequestDetails;
    private boolean myStopping;
    private final Semaphore mySyncResourcesSemaphore = new Semaphore(1);
    private final Object mySyncResourcesLock = new Object();

    protected BaseResourceCacheSynchronizer(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    protected BaseResourceCacheSynchronizer(String theResourceName, IResourceChangeListenerRegistry theResourceChangeListenerRegistry, DaoRegistry theDaoRegistry) {
        this.myResourceName = theResourceName;
        this.myDaoRegistry = theDaoRegistry;
        this.myResourceChangeListenerRegistry = theResourceChangeListenerRegistry;
    }

    @PostConstruct
    public void registerListener() {
        if (this.myDaoRegistry.getResourceDaoOrNull(this.myResourceName) == null) {
            ourLog.info("No resource DAO found for resource type {}, not registering listener", (Object)this.myResourceName);
            return;
        }
        this.mySearchParameterMap = this.getSearchParameterMap();
        this.mySystemRequestDetails = SystemRequestDetails.forAllPartitions();
        IResourceChangeListenerCache resourceCache = this.myResourceChangeListenerRegistry.registerResourceResourceChangeListener(this.myResourceName, this.mySearchParameterMap, (IResourceChangeListener)this, 60000L);
        resourceCache.forceRefresh();
    }

    @PreDestroy
    public void unregisterListener() {
        this.myResourceChangeListenerRegistry.unregisterResourceResourceChangeListener((IResourceChangeListener)this);
    }

    private boolean resourceDaoExists() {
        return this.myDaoRegistry != null && this.myDaoRegistry.isResourceTypeSupported(this.myResourceName);
    }

    public void syncDatabaseToCache() {
        if (!this.resourceDaoExists()) {
            return;
        }
        if (!this.mySyncResourcesSemaphore.tryAcquire()) {
            return;
        }
        try {
            this.doSyncResourcesWithRetry();
        }
        finally {
            this.mySyncResourcesSemaphore.release();
        }
    }

    @VisibleForTesting
    public void acquireSemaphoreForUnitTest() throws InterruptedException {
        this.mySyncResourcesSemaphore.acquire();
    }

    @VisibleForTesting
    public int doSyncResourcesForUnitTest() {
        int first = this.doSyncResourcesWithRetry();
        int second = this.doSyncResourcesWithRetry();
        return first + second;
    }

    synchronized int doSyncResourcesWithRetry() {
        Retrier syncResourceRetrier = new Retrier(this::doSyncResources, 60);
        return (Integer)syncResourceRetrier.runWithRetry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doSyncResources() {
        if (this.isStopping()) {
            return 0;
        }
        Object object = this.mySyncResourcesLock;
        synchronized (object) {
            ourLog.debug("Starting sync {}s", (Object)this.myResourceName);
            List<IBaseResource> resourceList = this.getResourceDao().searchForResources(this.mySearchParameterMap, (RequestDetails)this.mySystemRequestDetails);
            return this.syncResourcesIntoCache(resourceList);
        }
    }

    protected abstract int syncResourcesIntoCache(List<IBaseResource> var1);

    @EventListener(value={ContextRefreshedEvent.class})
    public void start() {
        this.myStopping = false;
    }

    @EventListener(value={ContextClosedEvent.class})
    public void shutdown() {
        this.myStopping = true;
    }

    private boolean isStopping() {
        return this.myStopping;
    }

    private IFhirResourceDao<?> getResourceDao() {
        return this.myDaoRegistry.getResourceDao(this.myResourceName);
    }

    public void handleInit(Collection<IIdType> theResourceIds) {
        if (!this.resourceDaoExists()) {
            ourLog.warn("The resource type {} is enabled on this server, but there is no {} DAO configured.", (Object)this.myResourceName, (Object)this.myResourceName);
            return;
        }
        IFhirResourceDao<?> resourceDao = this.getResourceDao();
        SystemRequestDetails systemRequestDetails = SystemRequestDetails.forAllPartitions();
        List<IBaseResource> resourceList = theResourceIds.stream().map(n -> resourceDao.read((IIdType)n, (RequestDetails)systemRequestDetails)).collect(Collectors.toList());
        this.handleInit(resourceList);
    }

    protected abstract void handleInit(List<IBaseResource> var1);

    public void handleChange(IResourceChangeEvent theResourceChangeEvent) {
        this.syncDatabaseToCache();
    }

    @Nonnull
    protected abstract SearchParameterMap getSearchParameterMap();
}

