/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.tasks.api;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.tasks.api.Builder;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.Validate;
import org.flywaydb.core.api.MigrationVersion;

public class BaseMigrationTasks<T extends Enum> {
    MigrationVersion lastVersion;
    private Multimap<T, BaseTask> myTasks = MultimapBuilder.hashKeys().arrayListValues().build();

    public List<BaseTask> getTasks(@Nonnull T theFrom, @Nonnull T theTo) {
        Validate.notNull(theFrom);
        Validate.notNull(theTo);
        Validate.isTrue((((Enum)theFrom).ordinal() < ((Enum)theTo).ordinal() ? 1 : 0) != 0, (String)"From version must be lower than to version", (Object[])new Object[0]);
        ArrayList<BaseTask> retVal = new ArrayList<BaseTask>();
        for (Object nextVersion : EnumUtils.getEnumList(theFrom.getClass())) {
            Collection nextValues;
            if (((Enum)nextVersion).ordinal() <= ((Enum)theFrom).ordinal() || ((Enum)nextVersion).ordinal() > ((Enum)theTo).ordinal() || (nextValues = this.myTasks.get((Object)((Enum)nextVersion))) == null) continue;
            retVal.addAll(nextValues);
        }
        return retVal;
    }

    public Builder forVersion(T theRelease) {
        IAcceptsTasks sink = theTask -> {
            theTask.validate();
            this.myTasks.put((Object)theRelease, (Object)theTask);
        };
        return new Builder(this.toReleaseName(theRelease), sink);
    }

    @Nonnull
    protected String toReleaseName(T theRelease) {
        return ((Enum)theRelease).name();
    }

    public List<BaseTask> getAllTasks(T[] theVersionEnumValues) {
        ArrayList<BaseTask> retval = new ArrayList<BaseTask>();
        for (T nextVersion : theVersionEnumValues) {
            Collection nextValues = this.myTasks.get(nextVersion);
            if (nextValues == null) continue;
            this.validate(nextValues);
            retval.addAll(nextValues);
        }
        return retval;
    }

    protected BaseTask getTaskWithVersion(String theFlywayVersion) {
        return this.myTasks.values().stream().filter(task -> theFlywayVersion.equals(task.getFlywayVersion())).findFirst().get();
    }

    void validate(Collection<BaseTask> theTasks) {
        for (BaseTask task : theTasks) {
            task.validateVersion();
            String version = task.getFlywayVersion();
            MigrationVersion migrationVersion = MigrationVersion.fromVersion((String)version);
            if (this.lastVersion != null && migrationVersion.compareTo(this.lastVersion) <= 0) {
                throw new IllegalStateException(Msg.code((int)51) + "Migration version " + migrationVersion + " found after migration version " + this.lastVersion + ".  Migrations need to be in order by version number.");
            }
            this.lastVersion = migrationVersion;
        }
    }

    public static interface IAcceptsTasks {
        public void addTask(BaseTask var1);
    }
}

