/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropForeignKeyTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(DropForeignKeyTask.class);
    private String myConstraintName;
    private String myParentTableName;

    public DropForeignKeyTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    @Nonnull
    static List<String> generateSql(String theTableName, String theConstraintName, DriverTypeEnum theDriverType) {
        ArrayList<String> sqls = new ArrayList<String>();
        switch (theDriverType) {
            case MYSQL_5_7: 
            case MARIADB_10_1: {
                sqls.add("alter table " + theTableName + " drop foreign key " + theConstraintName);
                break;
            }
            case POSTGRES_9_4: 
            case DERBY_EMBEDDED: 
            case H2_EMBEDDED: 
            case ORACLE_12C: 
            case MSSQL_2012: {
                sqls.add("alter table " + theTableName + " drop constraint " + theConstraintName);
                break;
            }
            case COCKROACHDB_21_1: {
                sqls.add("drop index if exists " + theTableName + "@" + theConstraintName + " cascade");
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code((int)59));
            }
        }
        return sqls;
    }

    public void setConstraintName(String theConstraintName) {
        this.myConstraintName = theConstraintName;
    }

    public void setParentTableName(String theParentTableName) {
        this.myParentTableName = theParentTableName;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.myConstraintName));
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.myParentTableName));
        this.setDescription("Drop foreign key " + this.myConstraintName + " from table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> existing = JdbcUtils.getForeignKeys(this.getConnectionProperties(), this.myParentTableName, this.getTableName());
        if (!existing.contains(this.myConstraintName)) {
            this.logInfo(ourLog, "Don't have constraint named {} - No action performed", this.myConstraintName);
            return;
        }
        List<String> sqls = DropForeignKeyTask.generateSql(this.getTableName(), this.myConstraintName, this.getDriverType());
        for (String next : sqls) {
            this.executeSql(this.getTableName(), next, new Object[0]);
        }
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        DropForeignKeyTask otherObject = (DropForeignKeyTask)theOtherObject;
        super.generateEquals(theBuilder, otherObject);
        theBuilder.append((Object)this.myConstraintName, (Object)otherObject.myConstraintName);
        theBuilder.append((Object)this.myParentTableName, (Object)otherObject.myParentTableName);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myConstraintName);
        theBuilder.append((Object)this.myParentTableName);
    }
}

