/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseColumnCalculatorTask;
import ca.uhn.fhir.util.VersionEnum;
import java.sql.SQLException;
import java.util.Set;

public class CalculateHashesTask
extends BaseColumnCalculatorTask {
    public CalculateHashesTask(VersionEnum theRelease, String theVersion) {
        super(theRelease, theVersion);
        this.setDescription("Calculate resource search parameter index hashes");
        this.setPidColumnName("SP_ID");
    }

    @Override
    protected boolean shouldSkipTask() {
        try {
            Set<String> tableNames = JdbcUtils.getTableNames(this.getConnectionProperties());
            boolean shouldSkip = tableNames.contains("HFJ_RES_REINDEX_JOB");
            if (shouldSkip) {
                this.logInfo(ourLog, "The table HFJ_RES_REINDEX_JOB already exists.  Skipping calculate hashes task.", new Object[0]);
            }
            return shouldSkip;
        }
        catch (SQLException e) {
            this.logInfo(ourLog, "Error retrieving table names, skipping task", new Object[0]);
            return true;
        }
    }
}

