/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableColumnTask;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.VersionEnum;
import com.google.common.collect.ForwardingMap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.transaction.TransactionStatus;

public abstract class BaseColumnCalculatorTask
extends BaseTableColumnTask {
    protected static final Logger ourLog = LoggerFactory.getLogger(BaseColumnCalculatorTask.class);
    private int myBatchSize = 10000;
    private ThreadPoolExecutor myExecutor;
    private String myPidColumnName;

    public BaseColumnCalculatorTask(VersionEnum theRelease, String theVersion) {
        this(theRelease.toString(), theVersion);
    }

    public BaseColumnCalculatorTask(String theRelease, String theVersion) {
        super(theRelease, theVersion);
    }

    public void setBatchSize(int theBatchSize) {
        this.myBatchSize = theBatchSize;
    }

    protected abstract boolean shouldSkipTask();

    /*
     * Exception decompiling
     */
    @Override
    public synchronized void doExecute() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void destroyExecutor() {
        this.myExecutor.shutdownNow();
    }

    private void initializeExecutor() {
        int maximumPoolSize = Runtime.getRuntime().availableProcessors();
        final LinkedBlockingQueue<Runnable> executorQueue = new LinkedBlockingQueue<Runnable>(maximumPoolSize);
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("worker--%d").daemon(false).priority(5).build();
        RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable theRunnable, ThreadPoolExecutor theExecutor) {
                BaseColumnCalculatorTask.this.logInfo(ourLog, "Note: Executor queue is full ({} elements), waiting for a slot to become available!", executorQueue.size());
                StopWatch sw = new StopWatch();
                try {
                    executorQueue.put(theRunnable);
                }
                catch (InterruptedException theE) {
                    throw new RejectedExecutionException(Msg.code((int)70) + "Task " + theRunnable.toString() + " rejected from " + theE.toString());
                }
                BaseColumnCalculatorTask.this.logInfo(ourLog, "Slot become available after {}ms", sw.getMillis());
            }
        };
        this.myExecutor = new ThreadPoolExecutor(1, maximumPoolSize, 0L, TimeUnit.MILLISECONDS, executorQueue, (ThreadFactory)threadFactory, rejectedExecutionHandler);
    }

    public void setPidColumnName(String thePidColumnName) {
        this.myPidColumnName = thePidColumnName;
    }

    private Future<?> updateRows(List<Map<String, Object>> theRows) {
        Runnable task = () -> {
            StopWatch sw = new StopWatch();
            this.getTxTemplate().execute(t -> {
                assert (theRows != null);
                for (Map nextRow : theRows) {
                    HashMap newValues = new HashMap();
                    MandatoryKeyMap nextRowMandatoryKeyMap = new MandatoryKeyMap(nextRow);
                    for (Map.Entry nextCalculatorEntry : this.myCalculators.entrySet()) {
                        String nextColumn = (String)nextCalculatorEntry.getKey();
                        Function nextCalculator = (Function)nextCalculatorEntry.getValue();
                        Object value = nextCalculator.apply(nextRowMandatoryKeyMap);
                        newValues.put(nextColumn, value);
                    }
                    StringBuilder sqlBuilder = new StringBuilder();
                    ArrayList<Object> arguments = new ArrayList<Object>();
                    sqlBuilder.append("UPDATE ");
                    sqlBuilder.append(this.getTableName());
                    sqlBuilder.append(" SET ");
                    for (Map.Entry nextNewValueEntry : newValues.entrySet()) {
                        if (arguments.size() > 0) {
                            sqlBuilder.append(", ");
                        }
                        sqlBuilder.append((String)nextNewValueEntry.getKey()).append(" = ?");
                        arguments.add(nextNewValueEntry.getValue());
                    }
                    sqlBuilder.append(" WHERE " + this.myPidColumnName + " = ?");
                    arguments.add((Number)nextRow.get(this.myPidColumnName));
                    this.newJdbcTemplate().update(sqlBuilder.toString(), arguments.toArray());
                }
                return theRows.size();
            });
            this.logInfo(ourLog, "Updated {} rows on {} in {}", theRows.size(), this.getTableName(), sw.toString());
        };
        return this.myExecutor.submit(task);
    }

    private /* synthetic */ Object lambda$doExecute$0(MyRowCallbackHandler rch, TransactionStatus t) {
        JdbcTemplate jdbcTemplate = this.newJdbcTemplate();
        jdbcTemplate.setMaxRows(100000);
        String sql = "SELECT * FROM " + this.getTableName() + " WHERE " + this.getWhereClause();
        this.logInfo(ourLog, "Finding up to {} rows in {} that requires calculations, using query: {}", this.myBatchSize, this.getTableName(), sql);
        jdbcTemplate.query(sql, (RowCallbackHandler)rch);
        rch.done();
        return null;
    }

    private class MyRowCallbackHandler
    implements RowCallbackHandler {
        private List<Map<String, Object>> myRows = new ArrayList<Map<String, Object>>();
        private List<Future<?>> myFutures = new ArrayList();

        private MyRowCallbackHandler() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            Map row = new ColumnMapRowMapper().mapRow(rs, 0);
            this.myRows.add(row);
            if (this.myRows.size() >= BaseColumnCalculatorTask.this.myBatchSize) {
                this.submitNext();
            }
        }

        private void submitNext() {
            if (this.myRows.size() > 0) {
                this.myFutures.add(BaseColumnCalculatorTask.this.updateRows(this.myRows));
                this.myRows = new ArrayList<Map<String, Object>>();
            }
        }

        public List<Future<?>> getFutures() {
            return this.myFutures;
        }

        public void done() {
            if (this.myRows.size() > 0) {
                this.submitNext();
            }
        }
    }

    public static class MandatoryKeyMap<K, V>
    extends ForwardingMap<K, V> {
        private final Map<K, V> myWrap;

        public MandatoryKeyMap(Map<K, V> theWrap) {
            this.myWrap = theWrap;
        }

        public V get(Object theKey) {
            if (!this.containsKey(theKey)) {
                throw new IllegalArgumentException(Msg.code((int)71) + "No key: " + theKey);
            }
            return (V)super.get(theKey);
        }

        public String getString(String theKey) {
            return (String)this.get(theKey);
        }

        public Date getDate(String theKey) {
            return (Date)this.get(theKey);
        }

        protected Map<K, V> delegate() {
            return this.myWrap;
        }

        public String getResourceType() {
            return this.getString("RES_TYPE");
        }

        public String getParamName() {
            return this.getString("SP_NAME");
        }
    }
}

