/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate.taskdef;

import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.JdbcUtils;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTableTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.MetadataSource;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddIndexTask
extends BaseTableTask {
    private static final Logger ourLog = LoggerFactory.getLogger(AddIndexTask.class);
    private String myIndexName;
    private List<String> myColumns;
    private Boolean myUnique;
    private List<String> myIncludeColumns = Collections.emptyList();
    private boolean myOnline;
    private MetadataSource myMetadataSource = new MetadataSource();

    public AddIndexTask(String theProductVersion, String theSchemaVersion) {
        super(theProductVersion, theSchemaVersion);
    }

    public void setIndexName(String theIndexName) {
        this.myIndexName = theIndexName.toUpperCase(Locale.US);
    }

    public void setColumns(List<String> theColumns) {
        this.myColumns = theColumns;
    }

    public void setUnique(boolean theUnique) {
        this.myUnique = theUnique;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.notBlank((CharSequence)this.myIndexName, (String)"Index name not specified", (Object[])new Object[0]);
        Validate.isTrue((this.myColumns.size() > 0 ? 1 : 0) != 0, (String)("Columns not specified for AddIndexTask " + this.myIndexName + " on table " + this.getTableName()), (Object[])new Object[0]);
        Validate.notNull((Object)this.myUnique, (String)"Uniqueness not specified", (Object[])new Object[0]);
        this.setDescription("Add " + this.myIndexName + " index to table " + this.getTableName());
    }

    @Override
    public void doExecute() throws SQLException {
        Set<String> indexNames = JdbcUtils.getIndexNames(this.getConnectionProperties(), this.getTableName());
        if (indexNames.contains(this.myIndexName)) {
            this.logInfo(ourLog, "Index {} already exists on table {} - No action performed", this.myIndexName, this.getTableName());
            return;
        }
        this.logInfo(ourLog, "Going to add a {} index named {} on table {} for columns {}", this.myUnique != false ? "UNIQUE" : "NON-UNIQUE", this.myIndexName, this.getTableName(), this.myColumns);
        String sql = this.generateSql();
        String tableName = this.getTableName();
        try {
            this.executeSql(tableName, sql, new Object[0]);
        }
        catch (Exception e) {
            if (e.toString().contains("already exists")) {
                ourLog.warn("Index {} already exists", (Object)this.myIndexName);
            }
            throw e;
        }
    }

    @Nonnull
    String generateSql() {
        String unique = this.myUnique != false ? "unique " : "";
        String columns = String.join((CharSequence)", ", this.myColumns);
        Object includeClause = "";
        String mssqlWhereClause = "";
        if (!this.myIncludeColumns.isEmpty()) {
            switch (this.getDriverType()) {
                case POSTGRES_9_4: 
                case MSSQL_2012: 
                case COCKROACHDB_21_1: {
                    includeClause = " INCLUDE (" + String.join((CharSequence)", ", this.myIncludeColumns) + ")";
                    break;
                }
            }
        }
        if (this.myUnique.booleanValue() && this.getDriverType() == DriverTypeEnum.MSSQL_2012) {
            mssqlWhereClause = this.buildMSSqlNotNullWhereClause();
        }
        String postgresOnlineClause = "";
        String msSqlOracleOnlineClause = "";
        if (this.myOnline) {
            switch (this.getDriverType()) {
                case POSTGRES_9_4: 
                case COCKROACHDB_21_1: {
                    postgresOnlineClause = "CONCURRENTLY ";
                    this.setTransactional(false);
                    break;
                }
                case ORACLE_12C: {
                    if (!this.myMetadataSource.isOnlineIndexSupported(this.getConnectionProperties())) break;
                    msSqlOracleOnlineClause = " ONLINE DEFERRED INVALIDATION";
                    break;
                }
                case MSSQL_2012: {
                    if (!this.myMetadataSource.isOnlineIndexSupported(this.getConnectionProperties())) break;
                    msSqlOracleOnlineClause = " WITH (ONLINE = ON)";
                    break;
                }
            }
        }
        String sql = "create " + unique + "index " + postgresOnlineClause + this.myIndexName + " on " + this.getTableName() + "(" + columns + ")" + (String)includeClause + mssqlWhereClause + msSqlOracleOnlineClause;
        return sql;
    }

    @Nonnull
    private String buildMSSqlNotNullWhereClause() {
        Object mssqlWhereClause = " WHERE (";
        for (int i = 0; i < this.myColumns.size(); ++i) {
            mssqlWhereClause = (String)mssqlWhereClause + this.myColumns.get(i) + " IS NOT NULL ";
            if (i >= this.myColumns.size() - 1) continue;
            mssqlWhereClause = (String)mssqlWhereClause + "AND ";
        }
        mssqlWhereClause = (String)mssqlWhereClause + ")";
        return mssqlWhereClause;
    }

    public void setColumns(String ... theColumns) {
        this.setColumns(Arrays.asList(theColumns));
    }

    public void setIncludeColumns(String ... theIncludeColumns) {
        this.setIncludeColumns(Arrays.asList(theIncludeColumns));
    }

    private void setIncludeColumns(List<String> theIncludeColumns) {
        Validate.notNull(theIncludeColumns);
        this.myIncludeColumns = theIncludeColumns;
    }

    public void setOnline(boolean theFlag) {
        this.myOnline = theFlag;
    }

    @Override
    protected void generateEquals(EqualsBuilder theBuilder, BaseTask theOtherObject) {
        super.generateEquals(theBuilder, theOtherObject);
        AddIndexTask otherObject = (AddIndexTask)theOtherObject;
        theBuilder.append((Object)this.myIndexName, (Object)otherObject.myIndexName);
        theBuilder.append(this.myColumns, otherObject.myColumns);
        theBuilder.append((Object)this.myUnique, (Object)otherObject.myUnique);
        theBuilder.append(this.myIncludeColumns, otherObject.myIncludeColumns);
        theBuilder.append(this.myOnline, otherObject.myOnline);
    }

    @Override
    protected void generateHashCode(HashCodeBuilder theBuilder) {
        super.generateHashCode(theBuilder);
        theBuilder.append((Object)this.myIndexName);
        theBuilder.append(this.myColumns);
        theBuilder.append((Object)this.myUnique);
        theBuilder.append(this.myOnline);
    }

    public void setMetadataSource(MetadataSource theMetadataSource) {
        this.myMetadataSource = theMetadataSource;
    }
}

