/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.BaseMigrator;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.FlywayMigrator;
import ca.uhn.fhir.jpa.migrate.TaskOnlyMigrator;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.callback.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SchemaMigrator {
    public static final String HAPI_FHIR_MIGRATION_TABLENAME = "FLY_HFJ_MIGRATION";
    private static final Logger ourLog = LoggerFactory.getLogger(SchemaMigrator.class);
    private final String mySchemaName;
    private final DataSource myDataSource;
    private final boolean mySkipValidation;
    private final String myMigrationTableName;
    private final List<BaseTask> myMigrationTasks;
    private boolean myDontUseFlyway;
    private boolean myStrictOrder;
    private DriverTypeEnum myDriverType;
    private List<Callback> myCallbacks = Collections.emptyList();

    public SchemaMigrator(String theSchemaName, String theMigrationTableName, DataSource theDataSource, Properties jpaProperties, List<BaseTask> theMigrationTasks) {
        this.mySchemaName = theSchemaName;
        this.myDataSource = theDataSource;
        this.myMigrationTableName = theMigrationTableName;
        this.myMigrationTasks = theMigrationTasks;
        this.mySkipValidation = jpaProperties.containsKey("hibernate.hbm2ddl.auto") && "update".equals(jpaProperties.getProperty("hibernate.hbm2ddl.auto"));
    }

    public void setCallbacks(List<Callback> theCallbacks) {
        Assert.notNull(theCallbacks);
        this.myCallbacks = theCallbacks;
    }

    public void setDontUseFlyway(boolean theDontUseFlyway) {
        this.myDontUseFlyway = theDontUseFlyway;
    }

    public void setStrictOrder(boolean theStrictOrder) {
        this.myStrictOrder = theStrictOrder;
    }

    public void validate() {
        if (this.mySkipValidation) {
            ourLog.warn("Database running in hibernate auto-update mode.  Skipping schema validation.");
            return;
        }
        try (Connection connection = this.myDataSource.getConnection();){
            Optional<MigrationInfoService> migrationInfo = this.newMigrator().getMigrationInfo();
            if (migrationInfo.isPresent()) {
                if (migrationInfo.get().pending().length > 0) {
                    String url = connection.getMetaData().getURL();
                    throw new ConfigurationException(Msg.code((int)27) + "The database schema for " + url + " is out of date.  Current database schema version is " + this.getCurrentVersion(migrationInfo.get()) + ".  Schema version required by application is " + this.getLastVersion(migrationInfo.get()) + ".  Please run the database migrator.");
                }
                ourLog.info("Database schema confirmed at expected version " + this.getCurrentVersion(migrationInfo.get()));
            }
        }
        catch (SQLException e) {
            throw new ConfigurationException(Msg.code((int)28) + "Unable to connect to " + this.myDataSource, (Throwable)e);
        }
    }

    public void migrate() {
        if (this.mySkipValidation) {
            ourLog.warn("Database running in hibernate auto-update mode.  Skipping schema migration.");
            return;
        }
        try {
            ourLog.info("Migrating " + this.mySchemaName);
            this.newMigrator().migrate();
            ourLog.info(this.mySchemaName + " migrated successfully.");
        }
        catch (Exception e) {
            ourLog.error("Failed to migrate " + this.mySchemaName, (Throwable)e);
            throw e;
        }
    }

    private BaseMigrator newMigrator() {
        BaseMigrator migrator;
        if (this.myDontUseFlyway) {
            migrator = new TaskOnlyMigrator();
            migrator.setDriverType(this.myDriverType);
            migrator.setDataSource(this.myDataSource);
        } else {
            migrator = new FlywayMigrator(this.myMigrationTableName, this.myDataSource, this.myDriverType);
            migrator.setStrictOrder(this.myStrictOrder);
        }
        migrator.addTasks(this.myMigrationTasks);
        migrator.setCallbacks(this.myCallbacks);
        return migrator;
    }

    private String getCurrentVersion(MigrationInfoService theMigrationInfo) {
        MigrationInfo migrationInfo = theMigrationInfo.current();
        if (migrationInfo == null) {
            return "unknown";
        }
        return migrationInfo.getVersion().toString();
    }

    private String getLastVersion(MigrationInfoService theMigrationInfo) {
        MigrationInfo[] pending = theMigrationInfo.pending();
        if (pending.length > 0) {
            return pending[pending.length - 1].getVersion().toString();
        }
        return "unknown";
    }

    public void setDriverType(DriverTypeEnum theDriverType) {
        this.myDriverType = theDriverType;
    }
}

