/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final Logger ourLog = LoggerFactory.getLogger(Migrator.class);
    private DriverTypeEnum myDriverType;
    private String myConnectionUrl;
    private String myUsername;
    private String myPassword;
    private List<BaseTask> myTasks = new ArrayList<BaseTask>();
    private DriverTypeEnum.ConnectionProperties myConnectionProperties;
    private int myChangesCount;
    private boolean myDryRun;
    private List<BaseTask.ExecutedStatement> myExecutedStatements = new ArrayList<BaseTask.ExecutedStatement>();
    private boolean myNoColumnShrink;

    public int getChangesCount() {
        return this.myChangesCount;
    }

    public void setDriverType(DriverTypeEnum theDriverType) {
        this.myDriverType = theDriverType;
    }

    public void setConnectionUrl(String theConnectionUrl) {
        this.myConnectionUrl = theConnectionUrl;
    }

    public void setUsername(String theUsername) {
        this.myUsername = theUsername;
    }

    public void setPassword(String thePassword) {
        this.myPassword = thePassword;
    }

    public void addTask(BaseTask theTask) {
        this.myTasks.add(theTask);
    }

    public void setDryRun(boolean theDryRun) {
        this.myDryRun = theDryRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate() {
        ourLog.info("Starting migration with {} tasks", (Object)this.myTasks.size());
        this.myConnectionProperties = this.myDriverType.newConnectionProperties(this.myConnectionUrl, this.myUsername, this.myPassword);
        try {
            for (BaseTask next : this.myTasks) {
                next.setDriverType(this.myDriverType);
                next.setConnectionProperties(this.myConnectionProperties);
                next.setDryRun(this.myDryRun);
                next.setNoColumnShrink(this.myNoColumnShrink);
                try {
                    next.execute();
                }
                catch (SQLException e) {
                    String description = next.getDescription();
                    if (StringUtils.isBlank((CharSequence)description)) {
                        description = next.getClass().getSimpleName();
                    }
                    String prefix = "Failure executing task \"" + description + "\", aborting! Cause: ";
                    throw new InternalErrorException(Msg.code((int)44) + prefix + e.toString(), (Throwable)e);
                }
                this.myChangesCount += next.getChangesCount();
                this.myExecutedStatements.addAll(next.getExecutedStatements());
            }
        }
        finally {
            this.myConnectionProperties.close();
        }
        ourLog.info("Finished migration of {} tasks", (Object)this.myTasks.size());
        if (this.myDryRun) {
            StringBuilder statementBuilder = new StringBuilder();
            String lastTable = null;
            for (BaseTask.ExecutedStatement next : this.myExecutedStatements) {
                if (!Objects.equals(lastTable, next.getTableName())) {
                    statementBuilder.append("\n\n-- Table: ").append(next.getTableName()).append("\n");
                    lastTable = next.getTableName();
                }
                statementBuilder.append(next.getSql()).append(";\n");
                for (Object nextArg : next.getArguments()) {
                    statementBuilder.append("  -- Arg: ").append(nextArg).append("\n");
                }
            }
            ourLog.info("SQL that would be executed:\n\n***********************************\n{}***********************************", (Object)statementBuilder);
        }
    }

    public void addTasks(List<BaseTask> theTasks) {
        theTasks.forEach(this::addTask);
    }

    public void setNoColumnShrink(boolean theNoColumnShrink) {
        this.myNoColumnShrink = theNoColumnShrink;
    }
}

