/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.migrate;

import ca.uhn.fhir.jpa.migrate.BaseMigrator;
import ca.uhn.fhir.jpa.migrate.DriverTypeEnum;
import ca.uhn.fhir.jpa.migrate.FlywayMigrationTask;
import ca.uhn.fhir.jpa.migrate.taskdef.BaseTask;
import ca.uhn.fhir.jpa.migrate.taskdef.InitializeSchemaTask;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.migration.JavaMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlywayMigrator
extends BaseMigrator {
    private static final Logger ourLog = LoggerFactory.getLogger(FlywayMigrator.class);
    private final String myMigrationTableName;
    private final List<FlywayMigrationTask> myTasks = new ArrayList<FlywayMigrationTask>();

    public FlywayMigrator(String theMigrationTableName, DataSource theDataSource, DriverTypeEnum theDriverType) {
        this(theMigrationTableName);
        this.setDataSource(theDataSource);
        this.setDriverType(theDriverType);
    }

    public FlywayMigrator(String theMigrationTableName) {
        this.myMigrationTableName = theMigrationTableName;
    }

    public void addTask(BaseTask theTask) {
        this.myTasks.add(new FlywayMigrationTask(theTask, this));
    }

    @Override
    public void migrate() {
        try (DriverTypeEnum.ConnectionProperties connectionProperties = this.getDriverType().newConnectionProperties(this.getDataSource());){
            Flyway flyway = this.initFlyway(connectionProperties);
            flyway.repair();
            flyway.migrate();
            if (this.isDryRun()) {
                StringBuilder statementBuilder = this.buildExecutedStatementsString();
                ourLog.info("SQL that would be executed:\n\n***********************************\n{}***********************************", (Object)statementBuilder);
            }
        }
    }

    private Flyway initFlyway(DriverTypeEnum.ConnectionProperties theConnectionProperties) {
        Flyway flyway = Flyway.configure().table(this.myMigrationTableName).dataSource(theConnectionProperties.getDataSource()).baselineOnMigrate(true).outOfOrder(!this.isStrictOrder()).javaMigrations(this.myTasks.toArray(new JavaMigration[0])).callbacks(this.getCallbacks().toArray(new Callback[0])).load();
        for (FlywayMigrationTask task : this.myTasks) {
            task.setConnectionProperties(theConnectionProperties);
        }
        return flyway;
    }

    @Override
    public void addTasks(List<BaseTask> theTasks) {
        if ("true".equals(System.getProperty("unit_test_mode"))) {
            theTasks.stream().filter(task -> task instanceof InitializeSchemaTask).forEach(this::addTask);
        } else {
            theTasks.forEach(this::addTask);
        }
    }

    @Override
    public Optional<MigrationInfoService> getMigrationInfo() {
        if (this.getDriverType() == null) {
            return Optional.empty();
        }
        try (DriverTypeEnum.ConnectionProperties connectionProperties = this.getDriverType().newConnectionProperties(this.getDataSource());){
            Flyway flyway = this.initFlyway(connectionProperties);
            Optional<MigrationInfoService> optional = Optional.of(flyway.info());
            return optional;
        }
    }

    @VisibleForTesting
    public void removeAllTasksForUnitTest() {
        this.myTasks.clear();
    }
}

